/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class CachedDirURLClassLocator
extends URLClassLocator {
    private Map _packageMap;
    private boolean _built;
    private static final boolean VERBOSE_CACHE = Boolean.getBoolean("VFS.VERBOSE_CACHE");

    protected CachedDirURLClassLocator(URL dirURL, int classType) {
        super(dirURL, classType);
        this.$init$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIndex() {
        if (!this._built) {
            CachedDirURLClassLocator cachedDirURLClassLocator = this;
            synchronized (cachedDirURLClassLocator) {
                if (!this._built) {
                    this.buildIndexImpl();
                    this._built = true;
                }
            }
        }
    }

    protected void getPackages(String packagePrefix, Collection out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            out.addAll(Arrays.asList(PackageEntry.ra$_subPackageNames(entry)));
        }
    }

    protected void getClassesInPackage(String packagePrefix, Collection out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            if (this.isSourceTypeLocator()) {
                out.addAll(Arrays.asList(PackageEntry.ra$_classNames(entry)));
            } else {
                String[] classList = PackageEntry.ra$_classNames(entry);
                int classCount = classList.length;
                int i = 0;
                while (i < classCount) {
                    String className = classList[i];
                    if (className.indexOf(36) == -1) {
                        out.add(className);
                    }
                    ++i;
                }
            }
        }
    }

    protected void getAllClasses(Collection out, ClassNameFilter filter) {
        this.getClassesRecursively("", out, filter);
    }

    private void getClassesRecursively(String packagePrefix, Collection out, ClassNameFilter filter) {
        PackageEntry entry = this.findExactPackage(packagePrefix);
        if (entry != null) {
            String[] classList = PackageEntry.ra$_classNames(entry);
            int classCount = classList.length;
            int i = 0;
            while (i < classCount) {
                String className = classList[i];
                if (className.indexOf(36) == -1) {
                    boolean acceptName = true;
                    if (filter != null) {
                        acceptName = filter.acceptClassName(className, packagePrefix);
                    }
                    if (acceptName) {
                        String fqName = CachedDirURLClassLocator.buildFQName(packagePrefix, className);
                        out.add(fqName);
                    }
                }
                ++i;
            }
            String[] subList = PackageEntry.ra$_subPackageNames(entry);
            int subCount = subList.length;
            int i2 = 0;
            while (i2 < subCount) {
                String subName = subList[i2];
                String fullSubName = CachedDirURLClassLocator.buildFQName(packagePrefix, subName);
                this.getClassesRecursively(fullSubName, out, filter);
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAllPackages(Collection out, PackageNameFilter filter) {
        this.buildIndex();
        Map map = this._packageMap;
        synchronized (map) {
            for (String packagePrefix : this._packageMap.keySet()) {
                if (packagePrefix == null || packagePrefix.length() <= 0) continue;
                boolean acceptName = true;
                if (filter != null) {
                    acceptName = filter.acceptPackageName(packagePrefix);
                }
                if (!acceptName) continue;
                out.add(packagePrefix);
            }
        }
    }

    public URL getURL(String fqClassName) {
        int countCascades;
        String[] nameCascades = CachedDirURLClassLocator.getNameCascades(fqClassName);
        String[] nameParts = CachedDirURLClassLocator.getNameParts(fqClassName);
        int countParts = countCascades = nameCascades.length;
        if (countCascades > 1) {
            String packagePrefix = nameCascades[countCascades - 2];
            PackageEntry foundEntry = this.findPackage(packagePrefix);
            if (foundEntry == null) {
                return null;
            }
            String className = nameParts[countParts - 1];
            if (!Arrays.asList(PackageEntry.ra$_classNames(foundEntry)).contains(className)) {
                return null;
            }
        }
        String[] suffixes = this.isSourceTypeLocator() ? URLClassLocator.SOURCE_SUFFIXES : URLClassLocator.CLASS_SUFFIXES;
        int suffixCount = suffixes.length;
        int i = 0;
        while (i < suffixCount) {
            String suffix = suffixes[i];
            String entryPath = fqClassName.replace('.', '/') + suffix;
            URL rootURL = this.getRootURL();
            URL fileURL = URLFactory.newURL((URL)rootURL, (String)entryPath);
            if (URLFileSystem.exists((URL)fileURL)) {
                return fileURL;
            }
            ++i;
        }
        return null;
    }

    public URL getResourceURL(String resourceName) {
        URL rootURL;
        URL fileURL;
        if (this.isClassTypeLocator() && URLFileSystem.exists((URL)(fileURL = URLFactory.newURL((URL)(rootURL = this.getRootURL()), (String)resourceName)))) {
            return fileURL;
        }
        return null;
    }

    private void $init$() {
        this._packageMap = new HashMap(512);
        this._built = false;
    }

    private void buildIndexImpl() {
        this.buildPackage("");
    }

    private void buildPackage(String packagePrefix) {
        Thread.yield();
        PackageEntry entry = this.findExactPackage(packagePrefix);
        if (entry != null) {
            String[] subs = PackageEntry.ra$_subPackageNames(entry);
            int numSubs = subs.length;
            int i = 0;
            while (i < numSubs) {
                String subName = packagePrefix.length() > 0 ? packagePrefix + "." + subs[i] : subs[i];
                this.buildPackage(subName);
                ++i;
            }
        }
    }

    private boolean containsSubPackage(PackageEntry packageEntry, String subName) {
        if (packageEntry == null) {
            return false;
        }
        if (PackageEntry.ra$_subPackageNames(packageEntry).length == 0) {
            return false;
        }
        List<String> subList = Arrays.asList(PackageEntry.ra$_subPackageNames(packageEntry));
        return subList.contains(subName);
    }

    private PackageEntry findPackage(String packageName) {
        PackageEntry rootEntry = this.findExactPackage("");
        if (packageName.length() == 0) {
            return rootEntry;
        }
        String[] nameCascades = CachedDirURLClassLocator.getNameCascades(packageName);
        String[] nameParts = CachedDirURLClassLocator.getNameParts(packageName);
        PackageEntry parentEntry = rootEntry;
        int countCascades = nameCascades.length;
        PackageEntry foundEntry = null;
        int i = 0;
        while (i < countCascades) {
            String checkPackage = nameParts[i];
            if (!this.containsSubPackage(parentEntry, checkPackage)) {
                return null;
            }
            parentEntry = foundEntry = this.findExactPackage(nameCascades[i]);
            ++i;
        }
        return foundEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageEntry findExactPackage(String packageName) {
        int numInfos;
        URL dirURL;
        PackageEntry foundEntry;
        Map map = this._packageMap;
        synchronized (map) {
            foundEntry = (PackageEntry)this._packageMap.get(packageName);
        }
        URL rootURL = this.getRootURL();
        if (foundEntry != null) {
            dirURL = PackageEntry.ra$_packageURL(foundEntry);
        } else if (packageName.length() == 0) {
            dirURL = rootURL;
        } else {
            String dirName = packageName.replace('.', '/');
            dirURL = URLFactory.newDirURL((URL)rootURL, (String)dirName);
        }
        URLFileSystem.FileInfo[] infos = URLFileSystem.ls((URL)dirURL);
        int n = numInfos = infos == null ? 0 : infos.length;
        if (foundEntry != null && CachedDirURLClassLocator.equals(PackageEntry.ra$_fileInfos(foundEntry), infos)) {
            return foundEntry;
        }
        ArrayList<String> classList = new ArrayList<String>(numInfos);
        ArrayList<String> subList = new ArrayList<String>(numInfos);
        int i = 0;
        while (i < numInfos) {
            URLFileSystem.FileInfo info = infos[i];
            URL childURL = info.getURL();
            boolean isDirectory = info.isDirectory();
            String filename = URLFileSystem.getFileName((URL)childURL);
            if (isDirectory) {
                if (filename.indexOf(46) == -1 && filename.indexOf(45) == -1 && !filename.equals("CVS")) {
                    subList.add(new String(filename));
                }
            } else if (this.isMatchingFileType(filename)) {
                int lastDot = filename.lastIndexOf(46);
                classList.add(new String(filename.substring(0, lastDot)));
            }
            ++i;
        }
        String[] classes = CachedDirURLClassLocator.getStringArray(classList);
        String[] subs = CachedDirURLClassLocator.getStringArray(subList);
        foundEntry = new PackageEntry(dirURL, infos, classes, subs, null);
        Map map2 = this._packageMap;
        synchronized (map2) {
            this._packageMap.put(packageName, foundEntry);
        }
        return foundEntry;
    }

    protected static boolean supportsCache(URL rootURL) {
        URLFileSystem.FileInfo[] info1 = URLFileSystem.ls((URL)rootURL);
        URLFileSystem.FileInfo[] info2 = URLFileSystem.ls((URL)rootURL);
        boolean supported = CachedDirURLClassLocator.equals(info1, info2);
        if (VERBOSE_CACHE) {
            Assert.println((String)("Class database VFS caching " + (supported ? "supported" : "not supported") + " for: " + rootURL.toString()));
        }
        return supported;
    }

    private static boolean equals(URLFileSystem.FileInfo[] infos1, URLFileSystem.FileInfo[] infos2) {
        int count2;
        int count1 = infos1 == null ? 0 : infos1.length;
        int n = count2 = infos2 == null ? 0 : infos2.length;
        if (count1 != count2) {
            return false;
        }
        int i = 0;
        while (i < count1) {
            if (infos1[i] != infos2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final class PackageEntry {
        private URL _packageURL;
        private URLFileSystem.FileInfo[] _fileInfos;
        private String[] _classNames;
        private String[] _subPackageNames;

        private PackageEntry(URL packageURL, URLFileSystem.FileInfo[] fileInfos, String[] classNames, String[] subPackageNames) {
            this._packageURL = packageURL;
            this._fileInfos = fileInfos;
            this._classNames = classNames;
            this._subPackageNames = subPackageNames;
        }

        static URL ra$_packageURL(PackageEntry packageEntry) {
            return packageEntry._packageURL;
        }

        static URLFileSystem.FileInfo[] ra$_fileInfos(PackageEntry packageEntry) {
            return packageEntry._fileInfos;
        }

        PackageEntry(URL uRL, URLFileSystem.FileInfo[] fileInfoArray, String[] stringArray, String[] stringArray2, 1 var5_5) {
            this(uRL, fileInfoArray, stringArray, stringArray2);
        }

        static String[] ra$_subPackageNames(PackageEntry packageEntry) {
            return packageEntry._subPackageNames;
        }

        static String[] ra$_classNames(PackageEntry packageEntry) {
            return packageEntry._classNames;
        }

        public final class 1 {
        }
    }
}

