/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import oracle.ide.util.Assert;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;

public class DebugClassLocator
extends BaseClassLocator {
    private BaseClassLocator _locator;

    protected DebugClassLocator(BaseClassLocator locator) {
        this._locator = locator;
    }

    public void buildIndex() {
        this._locator.buildIndex();
    }

    protected void dumpCollection(Collection collection) {
        for (Object object : collection) {
            Assert.println((String)object.toString());
        }
    }

    protected void getPackages(String packagePrefix, Collection out) {
        ArraySortedSet packageSet = new ArraySortedSet();
        this._locator.getPackages(packagePrefix, (Collection)packageSet);
        out.addAll(packageSet);
        Assert.println((String)"----- getPackages() -----");
        Assert.println((String)("prefix = " + packagePrefix));
        this.dumpCollection((Collection)packageSet);
    }

    protected void getClassesInPackage(String packagePrefix, Collection out) {
        ArraySortedSet classSet = new ArraySortedSet();
        this._locator.getClassesInPackage(packagePrefix, (Collection)classSet);
        out.addAll(classSet);
        Assert.println((String)"----- getClassesInPackage() -----");
        Assert.println((String)("prefix = " + packagePrefix));
        this.dumpCollection((Collection)classSet);
    }

    protected void getAllClasses(Collection out, ClassNameFilter filter) {
        ArraySortedSet classSet = new ArraySortedSet();
        this._locator.getAllClasses((Collection)classSet, filter);
        out.addAll(classSet);
        Assert.println((String)"----- getAllClasses() -----");
        this.dumpCollection((Collection)classSet);
    }

    protected void getAllPackages(Collection out, PackageNameFilter filter) {
        ArraySortedSet packageSet = new ArraySortedSet();
        this._locator.getAllPackages((Collection)packageSet, filter);
        out.addAll(packageSet);
        Assert.println((String)"----- getAllPackages() -----");
        this.dumpCollection((Collection)packageSet);
    }

    public URL getURL(String fqClassName) {
        URL url = this._locator.getURL(fqClassName);
        Assert.println((String)"----- getURL() -----");
        Assert.println((String)("fqClassName = " + fqClassName));
        Assert.println((String)("url = " + url));
        return url;
    }

    public URL getSourceURL(String fqClassName) {
        URL url = this._locator.getSourceURL(fqClassName);
        Assert.println((String)"----- getSourceURL() -----");
        Assert.println((String)("fqClassName = " + fqClassName));
        Assert.println((String)("source url = " + url));
        return url;
    }

    public URL getClassURL(String fqClassName) {
        URL url = this._locator.getClassURL(fqClassName);
        Assert.println((String)"----- getClassesURL() -----");
        Assert.println((String)("fqClassName = " + fqClassName));
        Assert.println((String)("class url = " + url));
        return url;
    }

    public URL getResourceURL(String resourceName) {
        URL url = this._locator.getResourceURL(resourceName);
        Assert.println((String)"----- getResourceURL() -----");
        Assert.println((String)("resourceName = " + resourceName));
        Assert.println((String)("resource url = " + url));
        return url;
    }
}

