/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class DirURLClassLocator
extends URLClassLocator {
    private Map _packageMap;
    private boolean _built;

    protected DirURLClassLocator(URL dirURL, int classType) {
        super(dirURL, classType);
        this.$init$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIndex() {
        if (!this._built) {
            DirURLClassLocator dirURLClassLocator = this;
            synchronized (dirURLClassLocator) {
                if (!this._built) {
                    this.buildIndexImpl();
                    this._built = true;
                }
            }
        }
    }

    protected void getPackages(String packagePrefix, Collection out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            out.addAll(Arrays.asList(PackageEntry.ra$_subPackageNames(entry)));
        }
    }

    protected void getClassesInPackage(String packagePrefix, Collection out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            if (this.isSourceTypeLocator()) {
                out.addAll(Arrays.asList(PackageEntry.ra$_classNames(entry)));
            } else {
                String[] classList = PackageEntry.ra$_classNames(entry);
                int classCount = classList.length;
                int i = 0;
                while (i < classCount) {
                    String className = classList[i];
                    if (className.indexOf(36) == -1) {
                        out.add(className);
                    }
                    ++i;
                }
            }
        }
    }

    protected void getAllClasses(Collection out, ClassNameFilter filter) {
        this.getClassesRecursively("", out, filter);
    }

    private void getClassesRecursively(String packagePrefix, Collection out, ClassNameFilter filter) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            String[] classList = PackageEntry.ra$_classNames(entry);
            int classCount = classList.length;
            int i = 0;
            while (i < classCount) {
                String className = classList[i];
                if (className.indexOf(36) == -1) {
                    boolean acceptName = true;
                    if (filter != null) {
                        acceptName = filter.acceptClassName(className, packagePrefix);
                    }
                    if (acceptName) {
                        String fqName = DirURLClassLocator.buildFQName(packagePrefix, className);
                        out.add(fqName);
                    }
                }
                ++i;
            }
            String[] subList = PackageEntry.ra$_subPackageNames(entry);
            int subCount = subList.length;
            int i2 = 0;
            while (i2 < subCount) {
                String subName = subList[i2];
                String fullSubName = DirURLClassLocator.buildFQName(packagePrefix, subName);
                this.getClassesRecursively(fullSubName, out, filter);
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAllPackages(Collection out, PackageNameFilter filter) {
        this.buildIndex();
        Map map = this._packageMap;
        synchronized (map) {
            for (String packagePrefix : this._packageMap.keySet()) {
                if (packagePrefix == null || packagePrefix.length() <= 0) continue;
                boolean acceptName = true;
                if (filter != null) {
                    acceptName = filter.acceptPackageName(packagePrefix);
                }
                if (!acceptName) continue;
                out.add(packagePrefix);
            }
        }
    }

    public URL getURL(String fqClassName) {
        String[] suffixes = this.isSourceTypeLocator() ? URLClassLocator.SOURCE_SUFFIXES : URLClassLocator.CLASS_SUFFIXES;
        int suffixCount = suffixes.length;
        int i = 0;
        while (i < suffixCount) {
            String suffix = suffixes[i];
            String entryPath = fqClassName.replace('.', '/') + suffix;
            URL rootURL = this.getRootURL();
            URL fileURL = URLFactory.newURL((URL)rootURL, (String)entryPath);
            if (URLFileSystem.exists((URL)fileURL)) {
                return fileURL;
            }
            ++i;
        }
        return null;
    }

    public URL getResourceURL(String resourceName) {
        URL rootURL;
        URL fileURL;
        if (this.isClassTypeLocator() && URLFileSystem.exists((URL)(fileURL = URLFactory.newURL((URL)(rootURL = this.getRootURL()), (String)resourceName)))) {
            return fileURL;
        }
        return null;
    }

    private void $init$() {
        this._packageMap = new HashMap(512);
        this._built = false;
    }

    private void buildIndexImpl() {
        this.buildPackage("");
    }

    private void buildPackage(String packagePrefix) {
        Thread.yield();
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            String[] subs = PackageEntry.ra$_subPackageNames(entry);
            int numSubs = subs.length;
            int i = 0;
            while (i < numSubs) {
                String subName = packagePrefix.length() > 0 ? packagePrefix + "." + subs[i] : subs[i];
                this.buildPackage(subName);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageEntry findPackage(String packageName) {
        int numInfos;
        URL dirURL;
        PackageEntry foundEntry = null;
        Map map = this._packageMap;
        synchronized (map) {
            foundEntry = (PackageEntry)this._packageMap.get(packageName);
        }
        URL rootURL = this.getRootURL();
        if (foundEntry != null) {
            dirURL = PackageEntry.ra$_packageURL(foundEntry);
        } else if (packageName.length() == 0) {
            dirURL = rootURL;
        } else {
            String dirName = packageName.replace('.', '/');
            dirURL = URLFactory.newDirURL((URL)rootURL, (String)dirName);
        }
        long lastModified = URLFileSystem.lastModified((URL)dirURL);
        if (foundEntry != null && lastModified == PackageEntry.ra$_lastModified(foundEntry)) {
            return foundEntry;
        }
        URLFileSystem.FileInfo[] infos = URLFileSystem.ls((URL)dirURL);
        int n = numInfos = infos == null ? 0 : infos.length;
        if (numInfos == 0) {
            return null;
        }
        ArrayList<String> classList = new ArrayList<String>(numInfos);
        ArrayList<String> subList = new ArrayList<String>(numInfos);
        int i = 0;
        while (i < numInfos) {
            URLFileSystem.FileInfo info = infos[i];
            URL childURL = info.getURL();
            boolean isDirectory = info.isDirectory();
            String filename = URLFileSystem.getFileName((URL)childURL);
            if (isDirectory) {
                if (filename.indexOf(46) == -1 && filename.indexOf(45) == -1 && !filename.equals("CVS")) {
                    subList.add(new String(filename));
                }
            } else if (this.isMatchingFileType(filename)) {
                int lastDot = filename.lastIndexOf(46);
                classList.add(new String(filename.substring(0, lastDot)));
            }
            ++i;
        }
        String[] classes = DirURLClassLocator.getStringArray(classList);
        String[] subs = DirURLClassLocator.getStringArray(subList);
        foundEntry = new PackageEntry(dirURL, classes, subs, lastModified, null);
        Map map2 = this._packageMap;
        synchronized (map2) {
            this._packageMap.put(packageName, foundEntry);
        }
        return foundEntry;
    }

    private static final class PackageEntry {
        private URL _packageURL;
        private String[] _classNames;
        private String[] _subPackageNames;
        private long _lastModified;

        private PackageEntry(URL packageURL, String[] classNames, String[] subPackageNames, long lastModified) {
            this._packageURL = packageURL;
            this._classNames = classNames;
            this._subPackageNames = subPackageNames;
            this._lastModified = lastModified;
        }

        static URL ra$_packageURL(PackageEntry packageEntry) {
            return packageEntry._packageURL;
        }

        static long ra$_lastModified(PackageEntry packageEntry) {
            return packageEntry._lastModified;
        }

        PackageEntry(URL uRL, String[] stringArray, String[] stringArray2, long l, 1 var6_5) {
            this(uRL, stringArray, stringArray2, l);
        }

        static String[] ra$_subPackageNames(PackageEntry packageEntry) {
            return packageEntry._subPackageNames;
        }

        static String[] ra$_classNames(PackageEntry packageEntry) {
            return packageEntry._classNames;
        }

        public final class 1 {
        }
    }
}

