/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class JarURLClassLocator
extends URLClassLocator {
    private static ArrayList<JarURLClassLocator> registeredJars = new ArrayList();
    private static final int CHECK_INTERVAL = 1000;
    private long _lastCheck;
    private long _lastBuiltTimeMillis;
    private static Object mutex = new Object();
    private JarIndex _jarIndex;
    private Map _packageMap;

    private void $init$() {
        this._lastCheck = -1;
        this._lastBuiltTimeMillis = -1;
        this._jarIndex = null;
        this._packageMap = null;
    }

    public long lastJarBuilt() {
        return this._lastBuiltTimeMillis;
    }

    public void rebuildJarIndex() {
        this.buildIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lastJarChanges() {
        long latestTime = -1;
        Object object = mutex;
        synchronized (object) {
            for (JarURLClassLocator jar : registeredJars) {
                jar.rebuildJarIndex();
                if (latestTime >= jar.lastJarBuilt()) continue;
                latestTime = jar.lastJarBuilt();
            }
        }
        return latestTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JarURLClassLocator(URL jarURL, int classType) {
        super(jarURL, classType);
        this.$init$();
        Object object = mutex;
        synchronized (object) {
            registeredJars.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIndex() {
        JarURLClassLocator jarURLClassLocator = this;
        synchronized (jarURLClassLocator) {
            long current = System.currentTimeMillis();
            long elapsed = current - this._lastCheck;
            if (this._lastCheck != (long)-1 && elapsed >= 1000L) {
                JarIndex currentIndex = null;
                try {
                    currentIndex = JarUtil.getJarIndex((URL)this.getRootURL());
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (currentIndex != this._jarIndex) {
                    this._packageMap = null;
                    this._jarIndex = null;
                }
            }
            this._lastCheck = current;
            if (this._packageMap == null) {
                this.buildIndexImpl();
                this._lastBuiltTimeMillis = System.currentTimeMillis();
            }
        }
    }

    protected void getPackages(String packagePrefix, Collection out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            out.addAll(Arrays.asList(PackageEntry.ra$_subPackageList(entry)));
        }
    }

    protected void getClassesInPackage(String packagePrefix, Collection out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            if (this.isSourceTypeLocator()) {
                out.addAll(Arrays.asList(PackageEntry.ra$_classList(entry)));
            } else {
                String[] classList = PackageEntry.ra$_classList(entry);
                int classCount = classList.length;
                int i = 0;
                while (i < classCount) {
                    String className = classList[i];
                    if (className.indexOf(36) == -1) {
                        out.add(className);
                    }
                    ++i;
                }
            }
        }
    }

    protected void getAllClasses(Collection out, ClassNameFilter filter) {
        this.buildIndex();
        for (PackageEntry entry : this._packageMap.values()) {
            if (entry == null) continue;
            String packageName = PackageEntry.ra$_packageName(entry);
            String[] classList = PackageEntry.ra$_classList(entry);
            int classCount = classList.length;
            int i = 0;
            while (i < classCount) {
                String className = classList[i];
                if (className.indexOf(36) == -1) {
                    boolean acceptName = true;
                    if (filter != null) {
                        acceptName = filter.acceptClassName(className, packageName);
                    }
                    if (acceptName) {
                        String fqName = JarURLClassLocator.buildFQName(packageName, className);
                        out.add(fqName);
                    }
                }
                ++i;
            }
        }
    }

    protected void getAllPackages(Collection out, PackageNameFilter filter) {
        this.buildIndex();
        for (String packagePrefix : this._packageMap.keySet()) {
            if (packagePrefix == null || packagePrefix.length() <= 0) continue;
            boolean acceptName = true;
            if (filter != null) {
                acceptName = filter.acceptPackageName(packagePrefix);
            }
            if (!acceptName) continue;
            out.add(packagePrefix);
        }
    }

    public URL getURL(String fqClassName) {
        int countCascades;
        this.buildIndex();
        if (this._jarIndex == null) {
            return null;
        }
        String[] nameCascades = JarURLClassLocator.getNameCascades(fqClassName);
        String[] nameParts = JarURLClassLocator.getNameParts(fqClassName);
        int countParts = countCascades = nameCascades.length;
        if (countCascades > 1) {
            String packagePrefix = nameCascades[countCascades - 2];
            PackageEntry foundEntry = this.findPackage(packagePrefix);
            if (foundEntry == null) {
                return null;
            }
            String className = nameParts[countParts - 1];
            if (!Arrays.asList(PackageEntry.ra$_classList(foundEntry)).contains(className)) {
                return null;
            }
        }
        String[] suffixes = this.isSourceTypeLocator() ? URLClassLocator.SOURCE_SUFFIXES : URLClassLocator.CLASS_SUFFIXES;
        int suffixCount = suffixes.length;
        int i = 0;
        while (i < suffixCount) {
            String suffix = suffixes[i];
            String entryPath = fqClassName.replace('.', '/') + suffix;
            URL rootURL = this.getRootURL();
            String rootPrefix = JarUtil.getJarEntry((URL)rootURL);
            if (rootPrefix == null) {
                rootPrefix = "";
            }
            if (this._jarIndex.entryIndex(rootPrefix + entryPath) >= 0) {
                return URLFactory.newJarURL((URL)rootURL, (String)entryPath);
            }
            ++i;
        }
        return null;
    }

    public URL getResourceURL(String resourceName) {
        if (this.isClassTypeLocator()) {
            this.buildIndex();
            if (this._jarIndex == null) {
                return null;
            }
            URL rootURL = this.getRootURL();
            String rootPrefix = JarUtil.getJarEntry((URL)rootURL);
            if (rootPrefix == null) {
                rootPrefix = "";
            }
            if (this._jarIndex.entryIndex(rootPrefix + resourceName) >= 0) {
                return URLFactory.newJarURL((URL)rootURL, (String)resourceName);
            }
        }
        return null;
    }

    private void buildIndexImpl() {
        try {
            URL rootURL = this.getRootURL();
            this._jarIndex = JarUtil.getJarIndex((URL)rootURL);
            String[] entryList = this._jarIndex.getEntries();
            int numEntries = entryList.length;
            String rootPrefix = JarUtil.getJarEntry((URL)rootURL);
            int rootLen = rootPrefix != null ? rootPrefix.length() : 0;
            HashMap packageToClassMap = new HashMap(numEntries);
            HashMap packageToSubMap = new HashMap(numEntries);
            int i = 0;
            while (i < numEntries) {
                block9: {
                    String entry;
                    block8: {
                        entry = entryList[i];
                        if (rootLen <= 0) break block8;
                        if (!entry.startsWith(rootPrefix)) break block9;
                        entry = entry.substring(rootLen);
                    }
                    if (entry.length() != 0 && this.isMatchingFileType(entry)) {
                        JarURLClassLocator.addClassToMaps(entry, packageToClassMap, packageToSubMap);
                    }
                }
                ++i;
            }
            ArraySortedSet allKeys = new ArraySortedSet(100);
            allKeys.addAll(packageToClassMap.keySet());
            allKeys.addAll(packageToSubMap.keySet());
            HashMap<String, PackageEntry> finalPackageMap = new HashMap<String, PackageEntry>(allKeys.size());
            for (Object key : allKeys) {
                String packageName = (String)key;
                Collection classes = (Collection)packageToClassMap.get(key);
                String[] classList = URLClassLocator.getStringArray(classes);
                Collection subs = (Collection)packageToSubMap.get(key);
                String[] subList = URLClassLocator.getStringArray(subs);
                if (classList.length <= 0 && subList.length <= 0) continue;
                PackageEntry packageEntry = new PackageEntry(packageName, classList, subList, null);
                finalPackageMap.put(packageName, packageEntry);
            }
            this._packageMap = finalPackageMap;
        }
        catch (IOException e) {
            this._packageMap = new HashMap(1);
            this._jarIndex = null;
        }
    }

    private static void addClassToMaps(String classEntry, Map packageToClassMap, Map packageToSubMap) {
        int suffixDot = classEntry.lastIndexOf(46);
        String fqName = classEntry.substring(0, suffixDot).replace('/', '.');
        int lastDot = fqName.lastIndexOf(46);
        String packagePrefix = lastDot != -1 ? fqName.substring(0, lastDot) : "";
        String className = lastDot != -1 ? fqName.substring(lastDot + 1) : fqName;
        boolean existingPackage = true;
        Collection classList = (Collection)packageToClassMap.get(packagePrefix);
        if (classList == null) {
            classList = new ArraySortedSet(75);
            packageToClassMap.put(packagePrefix, classList);
            existingPackage = false;
        } else {
            className = new String(className);
        }
        classList.add(className);
        if (existingPackage) {
            return;
        }
        if (packagePrefix.length() == 0) {
            return;
        }
        JarURLClassLocator.fillPackagesInMaps(packagePrefix, packageToSubMap);
    }

    private static void fillPackagesInMaps(String packagePrefix, Map packageToSubMap) {
        String outer = "";
        int pos = 0;
        boolean done = false;
        while (!done) {
            int nextDot = packagePrefix.indexOf(46, pos);
            if (nextDot == -1) {
                done = true;
                nextDot = packagePrefix.length();
            }
            String sub = packagePrefix.substring(pos, nextDot);
            Collection subList = (Collection)packageToSubMap.get(outer);
            if (subList == null) {
                subList = new ArraySortedSet(20);
                packageToSubMap.put(outer, subList);
            }
            subList.add(sub);
            outer = packagePrefix.substring(0, nextDot);
            pos = nextDot + 1;
        }
    }

    private PackageEntry findPackage(String packageName) {
        this.buildIndex();
        return (PackageEntry)this._packageMap.get(packageName);
    }

    private static final class PackageEntry {
        private String _packageName;
        private String[] _classList;
        private String[] _subPackageList;

        private PackageEntry(String packageName, String[] classList, String[] subPackageList) {
            this._packageName = packageName;
            this._classList = classList;
            this._subPackageList = subPackageList;
        }

        PackageEntry(String string, String[] stringArray, String[] stringArray2, 1 var4_4) {
            this(string, stringArray, stringArray2);
        }

        static String[] ra$_classList(PackageEntry packageEntry) {
            return packageEntry._classList;
        }

        static String ra$_packageName(PackageEntry packageEntry) {
            return packageEntry._packageName;
        }

        static String[] ra$_subPackageList(PackageEntry packageEntry) {
            return packageEntry._subPackageList;
        }

        public final class 1 {
        }
    }
}

