/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;

public class PathClassLocator
extends BaseClassLocator {
    private BaseClassLocator _sourceLocator;
    private BaseClassLocator _classLocator;

    protected PathClassLocator(URLPath sourcePath, URLPath classPath) {
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        this._sourceLocator = PathClassLocator.ensureValid(factory.getSourceLocator(sourcePath));
        this._classLocator = PathClassLocator.ensureValid(factory.getClassLocator(classPath));
    }

    public void buildIndex() {
        this._sourceLocator.buildIndex();
        this._classLocator.buildIndex();
    }

    protected void getPackages(String packagePrefix, Collection out) {
        this._sourceLocator.getPackages(packagePrefix, out);
        this._classLocator.getPackages(packagePrefix, out);
    }

    protected void getClassesInPackage(String packagePrefix, Collection out) {
        this._sourceLocator.getClassesInPackage(packagePrefix, out);
        this._classLocator.getClassesInPackage(packagePrefix, out);
    }

    protected void getAllClasses(Collection out, ClassNameFilter filter) {
        this._sourceLocator.getAllClasses(out, filter);
        this._classLocator.getAllClasses(out, filter);
    }

    protected void getAllPackages(Collection out, PackageNameFilter filter) {
        this._sourceLocator.getAllPackages(out, filter);
        this._classLocator.getAllPackages(out, filter);
    }

    public URL getURL(String fqClassName) {
        URL classURL = this._classLocator.getClassURL(fqClassName);
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        if (classURL != null || sourceURL != null) {
            long sourceTime;
            if (classURL == null) {
                return sourceURL;
            }
            if (sourceURL == null) {
                return classURL;
            }
            long classTime = this.getClassTimestamp(classURL);
            if (classTime >= (sourceTime = this.getSourceTimestamp(sourceURL))) {
                return classURL;
            }
            return sourceURL;
        }
        return null;
    }

    public URL getSourceURL(String fqClassName) {
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        return sourceURL;
    }

    public URL getClassURL(String fqClassName) {
        URL classURL = this._classLocator.getClassURL(fqClassName);
        return classURL;
    }

    public URL getResourceURL(String resourceName) {
        return this._classLocator.getResourceURL(resourceName);
    }

    protected long getClassTimestamp(URL classURL) {
        return URLFileSystem.lastModified((URL)classURL);
    }

    protected long getSourceTimestamp(URL sourceURL) {
        return URLFileSystem.lastModified((URL)sourceURL);
    }
}

