/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import oracle.jdeveloper.java.locator.BaseClassLocator;

public abstract class URLClassLocator
extends BaseClassLocator {
    protected URL _rootURL;
    protected int _fileType;
    public static final int CLASS_TYPE = 1;
    public static final int SOURCE_TYPE = 2;
    public static final String[] CLASS_SUFFIXES = new String[]{".class"};
    public static final String[] SOURCE_SUFFIXES = new String[]{".java", ".sqlj"};

    public URLClassLocator(URL rootURL, int fileType) {
        this._rootURL = rootURL;
        this._fileType = fileType;
    }

    protected URL getRootURL() {
        return this._rootURL;
    }

    protected int getFileType() {
        return this._fileType;
    }

    protected boolean isSourceTypeLocator() {
        return this._fileType == 2;
    }

    protected boolean isClassTypeLocator() {
        return this._fileType == 1;
    }

    protected boolean isMatchingFileType(URL url) {
        String filename = url.getFile();
        return URLClassLocator.isMatchingFileType(filename, this._fileType);
    }

    protected boolean isMatchingFileType(String filename) {
        return URLClassLocator.isMatchingFileType(filename, this._fileType);
    }

    private static boolean isMatchingFileType(String filename, int fileType) {
        String[] suffixes;
        switch (fileType) {
            case 2: {
                suffixes = SOURCE_SUFFIXES;
                break;
            }
            case 1: {
                suffixes = CLASS_SUFFIXES;
                break;
            }
            default: {
                suffixes = null;
                break;
            }
        }
        if (suffixes != null) {
            int suffixCount = suffixes.length;
            int i = 0;
            while (i < suffixCount) {
                String suffix = suffixes[i];
                if (filename.endsWith(suffix)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public URL getSourceURL(String fqClassName) {
        if (this.isSourceTypeLocator()) {
            return this.getURL(fqClassName);
        }
        return null;
    }

    public URL getClassURL(String fqClassName) {
        if (this.isClassTypeLocator()) {
            return this.getURL(fqClassName);
        }
        return null;
    }
}

