/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.classfile.ClClass;
import oracle.javatools.parser.java.v2.classfile.ClFile;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.common.AbstractPackage;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.provider.ProviderConstants;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.java.util.ClassFileCache;

public abstract class BaseFileProvider
implements JavaFileProvider,
ProviderConstants {
    protected ProviderContext context;

    public abstract JavaClassLocator getClassLocator();

    protected BaseFileProvider(ProviderContext contextIn) {
        this.setConteXt(contextIn);
    }

    public ProviderContext getConteXt() {
        return this.context;
    }

    public void setConteXt(ProviderContext c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.context = c;
        this.context.setProvider(this);
    }

    protected void notifyOfChange(URL url) {
    }

    protected final int getFileType(URL url) {
        return this.context.getFileType(url);
    }

    public JavaFile getFile(URL url) {
        int fileType = this.getFileType(url);
        switch (fileType) {
            case 2: {
                return this.getSourceFileImpl(url);
            }
            case 1: {
                return this.getClassFileImpl(url);
            }
        }
        return null;
    }

    public TextBuffer getTextBuffer(URL url) {
        try {
            TextBuffer textBuffer = this.context.getTextBuffer(url);
            return textBuffer;
        }
        catch (FileNotFoundException e) {
            TextBuffer textBuffer = null;
            return textBuffer;
        }
    }

    public SourceFile getSourceFile(URL sourceURL) {
        return this.getSourceFileImpl(sourceURL);
    }

    public SourceFile getSourceFile(TextBuffer textBuffer) {
        int j2se = this.getTargetJdkVersion();
        return this.context.getSourceFile(textBuffer, j2se);
    }

    protected JavaFile getClassFileImpl(URL classURL) {
        ClassFile classFile = ClassFileCache.getClassFile(classURL);
        if (classFile != null) {
            BaseClass javaClass = new BaseClass(classFile, this);
            ClFile javaFile = new ClFile((JavaClass)javaClass, classURL);
            javaClass._javaFile = javaFile;
            return javaFile;
        }
        return null;
    }

    protected JavaFile getJavaFile(JavaClass javaClass) {
        if (javaClass instanceof SourceClass) {
            return ((SourceClass)javaClass).getOwningSourceFile();
        }
        if (javaClass instanceof BaseClass) {
            return ((BaseClass)javaClass)._javaFile;
        }
        return null;
    }

    protected SourceFile getSourceFileImpl(URL sourceURL) {
        int j2se = this.getTargetJdkVersion();
        return this.context.getSourceFile(sourceURL, j2se);
    }

    public SourceFile createSourceFile(URL sourceURL) throws IOException, IllegalArgumentException {
        int j2se = this.getTargetJdkVersion();
        return this.context.createSourceFile(sourceURL, j2se);
    }

    public JavaClass getClass(String fqName) {
        int firstAngle;
        if (fqName.startsWith(".")) {
            Assert.println((String)("Client error: initial dot in fqName = " + fqName));
            Assert.printStackTrace();
            fqName = fqName.substring(1);
        }
        if ((firstAngle = fqName.indexOf(60)) != -1) {
            TextBuffer tmpBuffer = TextBufferFactory.createArrayTextBuffer();
            SourceFile tmpFile = this.getSourceFile(tmpBuffer);
            SourceFactory factory = tmpFile.getFactory();
            SourceTypeReference type = factory.createTypeFromText(fqName);
            CallerContext context = CallerContext.createContext((SourceElement)tmpFile, (boolean)true);
            type.setContext(context);
            JavaType result = type.getResolvedType();
            if (result instanceof JavaClass) {
                return (JavaClass)result;
            }
            return null;
        }
        int firstBrackets = fqName.indexOf(91);
        if (firstBrackets != -1) {
            int dimensions = (fqName.length() - firstBrackets) / 2;
            String nonArrayName = fqName.substring(0, firstBrackets).trim();
            JavaClass foundClass = this.getClass(nonArrayName);
            if (foundClass == null) {
                return null;
            }
            return (JavaClass)this.getArrayType((JavaType)foundClass, dimensions);
        }
        JavaClass primitiveClass = this.getPrimitiveClass(fqName);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        return this.getClassLeftToRight(fqName);
    }

    protected JavaClass getClassLeftToRight(String fqName) {
        String prefix = "";
        String suffix = fqName;
        while (suffix.length() > 0) {
            JavaClass searchClass;
            int firstDot = suffix.indexOf(46);
            String className = firstDot != -1 ? suffix.substring(0, firstDot) : suffix;
            String fqOuterClassName = BaseClassLocator.buildFQName(prefix, className);
            JavaClass foundClass = this.getClassExactImpl(fqOuterClassName);
            if (foundClass != null && (searchClass = this.locateClass(foundClass, fqName)) != null) {
                return searchClass;
            }
            int prefixLength = prefix.length();
            int classLength = className.length();
            prefix = prefixLength > 0 ? fqName.substring(0, prefixLength + classLength + 1) : className;
            String string = suffix = firstDot != -1 ? suffix.substring(firstDot + 1) : "";
        }
        return null;
    }

    protected JavaClass getClassExactImpl(String fqOuterClassName) {
        JavaFile javaFile;
        if (fqOuterClassName.length() == 0) {
            return null;
        }
        JavaClassLocator locator = this.getClassLocator();
        URL url = locator.getURL(fqOuterClassName);
        if (url != null && (javaFile = this.getFile(url)) != null) {
            return this.locateClass(javaFile, fqOuterClassName);
        }
        return null;
    }

    public JavaClass getClass(String fqPrefix, String name) {
        return this.getClass(BaseClassLocator.buildFQName(fqPrefix, name));
    }

    public JavaClass getClassByVMName(String fqVMName) {
        int firstBrackets = fqVMName.indexOf(91);
        if (firstBrackets != -1) {
            int dimensions = (fqVMName.length() - firstBrackets) / 2;
            String nonArrayName = fqVMName.substring(0, firstBrackets).trim();
            JavaClass foundClass = this.getClassByVMName(nonArrayName);
            if (foundClass == null) {
                return null;
            }
            return (JavaClass)this.getArrayType((JavaType)foundClass, dimensions);
        }
        JavaClass primitiveClass = this.getPrimitiveClass(fqVMName);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        int lastSlash = fqVMName.lastIndexOf(47);
        String packagePrefix = lastSlash == -1 ? "" : fqVMName.substring(0, lastSlash);
        packagePrefix = packagePrefix.replace('/', '.');
        String className = lastSlash == -1 ? fqVMName : fqVMName.substring(lastSlash + 1);
        String checkName = "";
        int nextStartPos = 0;
        while (checkName.length() < className.length()) {
            JavaClass searchClass;
            int firstDollar = className.indexOf(36, nextStartPos);
            if (firstDollar == -1) {
                checkName = className;
            } else {
                checkName = className.substring(0, firstDollar);
                nextStartPos = firstDollar + 1;
            }
            String fqOuterClassName = BaseClassLocator.buildFQName(packagePrefix, checkName);
            JavaClass foundClass = this.getClassExactImpl(fqOuterClassName);
            if (foundClass == null || (searchClass = this.locateClassByVMName(foundClass, fqVMName)) == null) continue;
            return searchClass;
        }
        return null;
    }

    protected JavaClass getInnerClassByVMName(String fqVMName) {
        JavaFile javaFile;
        JavaClass javaClass;
        String className = fqVMName.replace('/', '.');
        JavaClassLocator locator = this.getClassLocator();
        URL classURL = locator.getClassURL(className);
        if (classURL != null && fqVMName.equals((javaClass = (javaFile = this.getFile(classURL)).getPrimaryClass()).getVMName())) {
            return javaClass;
        }
        return null;
    }

    protected JavaClass locateClass(JavaFile javaFile, String fqName) {
        Collection classes = javaFile.getClasses();
        if (classes != null) {
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                JavaClass javaClass = this.locateClass((JavaClass)iter.next(), fqName);
                if (javaClass == null) continue;
                return javaClass;
            }
        }
        return null;
    }

    protected JavaClass locateClass(JavaClass javaClass, String fqName) {
        if (javaClass == null) {
            return null;
        }
        String javaClassName = javaClass.getQualifiedName();
        if (!fqName.startsWith(javaClassName)) {
            return null;
        }
        if (fqName.length() == javaClassName.length()) {
            return javaClass;
        }
        if (fqName.charAt(javaClassName.length()) != '.') {
            return null;
        }
        Collection innerClasses = javaClass.getDeclaredClasses();
        for (JavaClass innerClass : innerClasses) {
            JavaClass foundClass;
            if (innerClass == null || (foundClass = this.locateClass(innerClass, fqName)) == null) continue;
            return foundClass;
        }
        return null;
    }

    protected JavaClass locateClassByVMName(JavaClass javaClass, String fqVMName) {
        String rawJavaClassName = javaClass.getVMName();
        if (!fqVMName.startsWith(rawJavaClassName)) {
            return null;
        }
        if (fqVMName.length() == rawJavaClassName.length()) {
            return javaClass;
        }
        if (fqVMName.charAt(rawJavaClassName.length()) != '$') {
            return null;
        }
        Collection innerClasses = javaClass.getDeclaredClasses();
        for (JavaClass innerClass : innerClasses) {
            JavaClass foundClass;
            if (innerClass == null || (foundClass = this.locateClassByVMName(innerClass, fqVMName)) == null) continue;
            return foundClass;
        }
        return null;
    }

    public SourceClass getSourceClass(String fqName) {
        JavaClass javaClass;
        if (fqName.startsWith(".")) {
            Assert.println((String)("Client error: initial dot in fqName = " + fqName));
            Assert.printStackTrace();
            fqName = fqName.substring(1);
        }
        if ((javaClass = this.getClass(fqName)) != null) {
            return (SourceClass)javaClass.getSourceElement();
        }
        return null;
    }

    protected SourceClass getSourceClassByHint(JavaClass searchClass, String sourceFileHint) {
        SourceFile sourceFile;
        String hintToUse;
        String packagePrefix = searchClass.getPackageName();
        if (sourceFileHint != null) {
            int lastDot = sourceFileHint.lastIndexOf(46);
            hintToUse = lastDot != -1 ? sourceFileHint.substring(0, lastDot) : sourceFileHint;
        } else {
            String fqName = searchClass.getQualifiedName();
            int packageLength = packagePrefix != null ? packagePrefix.length() : 0;
            String classNameToUse = packageLength > 0 ? fqName.substring(packageLength + 1) : fqName;
            int firstDot = classNameToUse.indexOf(46);
            hintToUse = firstDot == -1 ? classNameToUse : classNameToUse.substring(0, firstDot);
        }
        String fullName = BaseClassLocator.buildFQName(packagePrefix, hintToUse);
        JavaClassLocator locator = this.getClassLocator();
        URL sourceURL = locator.getSourceURL(fullName);
        if (sourceURL != null && (sourceFile = this.getSourceFile(sourceURL)) != null) {
            String searchClassName = searchClass.getQualifiedName();
            return this.locateSourceClass(sourceFile, searchClassName);
        }
        return null;
    }

    protected SourceClass locateSourceClass(SourceFile sourceFile, String fqName) {
        Collection classes = sourceFile.getClasses();
        for (SourceClass sourceClass : classes) {
            SourceClass foundClass;
            if (sourceClass == null || (foundClass = this.locateSourceClass(sourceClass, fqName)) == null) continue;
            return foundClass;
        }
        return null;
    }

    protected SourceClass locateSourceClass(SourceClass sourceClass, String fqName) {
        JavaClass foundClass = this.locateClass((JavaClass)sourceClass, fqName);
        if (foundClass == null) {
            return null;
        }
        if (foundClass instanceof SourceClass) {
            return (SourceClass)foundClass;
        }
        throw new IllegalStateException("Not a SourceClass");
    }

    protected JavaClass getPrimitiveClass(String name) {
        PrimitiveType primitive = CommonUtilities.getPrimitiveType((String)name);
        return primitive;
    }

    public JavaType getArrayType(JavaType component, int dimensions) {
        if (component == null) {
            return null;
        }
        if (dimensions == 0) {
            return component;
        }
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        String key = component.getUniqueIdentifier();
        int i = dimensions;
        while (i > 0) {
            key = key + "[]";
            --i;
        }
        return this.getArrayTypeImpl(key, component, dimensions);
    }

    protected JavaType getArrayTypeImpl(String typeKey, JavaType component, int dimensions) {
        return CommonUtilities.createArrayType((JavaProvider)this, (JavaType)component, (int)dimensions);
    }

    public JavaPackage getPackage(String fqName) {
        if (fqName.startsWith(".")) {
            Assert.println((String)("Client error: initial dot in fqName = " + fqName));
            Assert.printStackTrace();
            fqName = fqName.substring(1);
        }
        return this.getPackageImpl(fqName);
    }

    protected BasePackage getPackageImpl(String fqName) {
        return fqName != null ? new BasePackage(fqName) : null;
    }

    protected JavaPackage getPackage(String packagePrefix, String name) {
        String fqName = BaseClassLocator.buildFQName(packagePrefix, name);
        return this.getPackage(fqName);
    }

    protected int getTargetJdkVersion() {
        return 3;
    }

    protected final class BaseClass
    extends ClClass {
        protected JavaFile _javaFile;

        protected BaseClass(ClassFile classFile, BaseFileProvider provider) {
            super(classFile, (JavaProvider)provider);
        }

        protected JavaClass getInnerClassByVMName(String fqInnerVMName) {
            return BaseFileProvider.this.getInnerClassByVMName(fqInnerVMName);
        }

        protected SourceClass getSourceClass(String sourceFileNameHint) {
            return BaseFileProvider.this.getSourceClassByHint((JavaClass)this, sourceFileNameHint);
        }
    }

    protected class BasePackage
    extends AbstractPackage {
        protected String _packageName;
        protected Collection _classes;
        protected Collection _packages;

        protected BasePackage(String name) {
            this._packageName = name;
        }

        public String getQualifiedName() {
            return this._packageName;
        }

        protected synchronized void clear() {
            this._classes = null;
            this._packages = null;
        }

        public Collection getDeclaredAnnotations() {
            JavaClass c;
            String qualifiedName = this.getQualifiedName();
            if (qualifiedName.length() == 0) {
                return ProviderConstants.EMPTY_COLLECTION;
            }
            String packageInfo = qualifiedName + '.' + "package-info";
            JavaClassLocator locator = BaseFileProvider.this.getClassLocator();
            URL url = locator.getURL(packageInfo);
            if (url != null) {
                JavaFile javaFile = BaseFileProvider.this.getFile(url);
                if (javaFile instanceof SourceFile) {
                    SourceFile file = (SourceFile)javaFile;
                    SourcePackage p = file.getSourcePackage();
                    if (p != null) {
                        return p.getSourceAnnotations();
                    }
                } else {
                    Collection classes = javaFile.getClasses();
                    if (!classes.isEmpty()) {
                        JavaClass c2 = (JavaClass)classes.iterator().next();
                        return c2.getDeclaredAnnotations();
                    }
                }
            }
            if ((c = BaseFileProvider.this.getClass(packageInfo)) != null) {
                return c.getDeclaredAnnotations();
            }
            return ProviderConstants.EMPTY_COLLECTION;
        }

        public synchronized Collection getDeclaredClasses() {
            if (this._classes == null) {
                JavaClassLocator locator = BaseFileProvider.this.getClassLocator();
                Collection classNames = locator.getClassesInPackage(this._packageName);
                this._classes = new ArrayList();
                Iterator nameIterator = classNames.iterator();
                while (nameIterator.hasNext()) {
                    String className = nameIterator.next().toString();
                    JavaClass javaClass = BaseFileProvider.this.getClass(this._packageName, className);
                    if (javaClass == null) continue;
                    this._classes.add(javaClass);
                }
                if (this._classes.size() == 0) {
                    this._classes = ProviderConstants.EMPTY_COLLECTION;
                }
            }
            return this._classes;
        }

        public JavaPackage getOwningPackage() {
            if (this._packageName.length() == 0) {
                return null;
            }
            int lastDot = this._packageName.lastIndexOf(46);
            String target = lastDot == -1 ? "" : this._packageName.substring(0, lastDot);
            return BaseFileProvider.this.getPackage(target);
        }

        public JavaPackage getPackage(String name) {
            return BaseFileProvider.this.getPackage(this._packageName, name);
        }

        public synchronized Collection getPackages() {
            if (this._packages == null) {
                JavaClassLocator locator = BaseFileProvider.this.getClassLocator();
                Collection subNames = locator.getPackages(this._packageName);
                this._packages = new ArrayList();
                Iterator nameIterator = subNames.iterator();
                while (nameIterator.hasNext()) {
                    String subName = nameIterator.next().toString();
                    JavaPackage javaPackage = BaseFileProvider.this.getPackage(this._packageName, subName);
                    if (javaPackage == null) continue;
                    this._packages.add(javaPackage);
                }
                if (this._packages.size() == 0) {
                    this._packages = ProviderConstants.EMPTY_COLLECTION;
                }
            }
            return this._packages;
        }
    }
}

