/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.util.WeakCache;
import oracle.jdeveloper.java.provider.BaseFileProvider;
import oracle.jdeveloper.java.provider.ProviderConstants;

public class ProviderContext
implements ProviderConstants {
    protected static final String CLASS_SUFFIX = ".class";
    protected static final String SOURCE_SUFFIX = ".java";
    protected BaseFileProvider provider;
    private WeakCache textBufferCache;

    private void $init$() {
        this.textBufferCache = new WeakCache();
    }

    public void setProvider(BaseFileProvider providerIn) {
        this.provider = providerIn;
    }

    protected int getFileType(URL url) {
        String path = url.getFile();
        if (path.endsWith(SOURCE_SUFFIX)) {
            return 2;
        }
        if (path.endsWith(CLASS_SUFFIX)) {
            return 1;
        }
        return -1;
    }

    protected SourcePreferences getSourcePreferences() {
        return null;
    }

    public SourceFile createSourceFile(URL url, int j2se) throws IOException, IllegalArgumentException {
        if (URLFileSystem.exists((URL)url)) {
            return null;
        }
        if (!URLFileSystem.canCreate((URL)url)) {
            return null;
        }
        OutputStream os = URLFileSystem.openOutputStream((URL)url);
        os.close();
        return this.getSourceFileImpl(url, j2se);
    }

    public SourceFile getSourceFile(URL url, int j2se) throws IllegalArgumentException {
        if (URLFileSystem.exists((URL)url)) {
            return this.getSourceFileImpl(url, j2se);
        }
        return null;
    }

    protected SourceFile getSourceFileImpl(URL url, int j2se) throws IllegalArgumentException {
        TextBuffer textBuffer;
        int fileType = this.getFileType(url);
        if (fileType == -1) {
            throw new IllegalArgumentException("Not a known java suffix");
        }
        try {
            textBuffer = this.getTextBuffer(url);
            if (textBuffer == null) {
                SourceFile sourceFile = null;
                return sourceFile;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            SourceFile sourceFile = null;
            return sourceFile;
        }
        SourceFile file = this.getSourceFile(textBuffer, j2se);
        if (file == null) {
            return null;
        }
        file.setURL(url);
        return file;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeSourceFile(SourceFile file) {
        URL url = file.getURL();
        if (url == null) {
            return true;
        }
        OutputStream os = null;
        try {
            os = URLFileSystem.openOutputStream((URL)url);
            OutputStreamWriter osw = new OutputStreamWriter(os);
            TextBuffer textBuffer = file.getTextBuffer();
            textBuffer.write((Writer)osw);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl2 = false;
            try {
                if (os == null) return bl2;
                os.close();
                return bl2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl2;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected final SourceFile getSourceFile(TextBuffer textBuffer, int j2se) {
        textBuffer.readLock();
        try {
            SourceFile file = JavaParser.parse((ReadTextBuffer)textBuffer, (int)j2se);
            if (file == null) {
                SourceFile sourceFile = file;
                return sourceFile;
            }
            file.pinTextBuffer(textBuffer);
            file.setProvider((JavaProvider)this.provider);
            SourcePreferences p = this.getSourcePreferences();
            if (p != null) {
                file.setPreferences(p);
            }
            SourceFile sourceFile = file;
            return sourceFile;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TextBuffer getTextBuffer(URL url) throws FileNotFoundException {
        WeakCache weakCache = this.textBufferCache;
        synchronized (weakCache) {
            TextBuffer textBuffer = (TextBuffer)this.textBufferCache.get((Object)url);
            if (textBuffer != null) {
                TextBuffer textBuffer2 = textBuffer;
                return textBuffer2;
            }
        }
        try {
            InputStream is = URLFileSystem.openInputStream((URL)url);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
            textBuffer.read((Reader)br);
            WeakCache weakCache2 = this.textBufferCache;
            synchronized (weakCache2) {
                this.textBufferCache.put((Object)url, (Object)textBuffer);
            }
            TextBuffer textBuffer3 = textBuffer;
            return textBuffer3;
        }
        catch (IOException e) {
            TextBuffer textBuffer = null;
            return textBuffer;
        }
    }

    protected void startTracking(URL url) {
    }

    protected void clearTracking() {
    }

    public ProviderContext() {
        this.$init$();
    }
}

