/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import oracle.ide.util.FileUtilities;
import oracle.jdeveloper.java.JavaResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRLClassLoader
extends ClassLoader {
    private JavaResourceLocator _locator;

    public JRLClassLoader(ClassLoader parent, JavaResourceLocator locator) {
        super(parent);
        this._locator = locator;
    }

    public JRLClassLoader(JavaResourceLocator locator) {
        this._locator = locator;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("null");
        }
        URL classURL = this._locator.getClassURL(name);
        if (classURL != null) {
            try {
                byte[] classBytes = FileUtilities.readFile((URL)classURL);
                if (classBytes != null && classBytes.length > 0) {
                    Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
                    return clazz;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        return this._locator.getResourceURL(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return new IterableEnumeration<URL>(this._locator.getResourceURLs(name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IterableEnumeration<T>
    implements Enumeration<T> {
        Iterator<T> srcIter;

        private void $init$() {
            this.srcIter = null;
        }

        public IterableEnumeration(Iterable<T> srcColl) {
            this.$init$();
            this.srcIter = srcColl.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.srcIter.hasNext();
        }

        @Override
        public T nextElement() {
            return this.srcIter.next();
        }
    }
}

