/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.List;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;

class SourceElementPath {
    private int _index;
    private int _offset;
    private int _symbolKind;
    private String _name;
    private SourceElementPath _child;

    SourceElementPath() {
    }

    public static SourceElementPath createElement(SourceElement sourceElement) {
        return SourceElementPath.createElement(sourceElement, null);
    }

    private static SourceElementPath createElement(SourceElement sourceElement, SourceElementPath childPath) {
        SourceElementPath ret;
        SourceElement parentElement = sourceElement.getParent();
        if (parentElement != null) {
            SourceElementPath sourceElementPath = new SourceElementPath();
            List children = parentElement.getChildren();
            sourceElementPath._index = children.indexOf(sourceElement);
            sourceElementPath._offset = sourceElement.getStartOffset() - parentElement.getStartOffset();
            sourceElementPath._symbolKind = sourceElement.getSymbolKind();
            if (sourceElement instanceof SourceHasName) {
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                sourceElementPath._name = sourceHasName.getName();
            }
            sourceElementPath._child = childPath;
            ret = SourceElementPath.createElement(parentElement, sourceElementPath);
        } else {
            SourceElementPath sourceElementPath = new SourceElementPath();
            sourceElementPath._index = -1;
            sourceElementPath._offset = sourceElement.getStartOffset();
            sourceElementPath._symbolKind = sourceElement.getSymbolKind();
            sourceElementPath._child = childPath;
            ret = sourceElementPath;
        }
        return ret;
    }

    public SourceElement find(SourceFile sourceFile) {
        if (this._index < 0) {
            return this._child._find((SourceElement)sourceFile);
        }
        return this._find((SourceElement)sourceFile);
    }

    private SourceElement _find(SourceElement sourceElement) {
        SourceElement childAtOffset;
        SourceElement ret = null;
        List children = sourceElement.getChildren();
        boolean indexIsOk = false;
        boolean offsetIsOk = false;
        SourceElement childElement = this.searchChildByIndex(children);
        if (childElement != null) {
            indexIsOk = true;
            if (sourceElement.getStartOffset() + this._offset == childElement.getStartOffset()) {
                offsetIsOk = true;
            }
        }
        if (!(indexIsOk && offsetIsOk || (childAtOffset = this.searchChildByOffset(sourceElement, children)) == null)) {
            offsetIsOk = true;
            indexIsOk = false;
            childElement = childAtOffset;
        }
        if (childElement != null && (ret = this._child != null ? this._child._find(childElement) : childElement) != null) {
            if (!indexIsOk) {
                this._index = children.indexOf(childElement);
            }
            if (!offsetIsOk) {
                this._offset = childElement.getStartOffset() - sourceElement.getStartOffset();
            }
        }
        return ret;
    }

    private SourceElement searchChildByIndex(List children) {
        SourceElement childElement;
        SourceElement ret = null;
        if (this._index < children.size() && this.isRightChild(childElement = (SourceElement)children.get(this._index))) {
            ret = childElement;
        }
        return ret;
    }

    private SourceElement searchChildByOffset(SourceElement sourceElement, List children) {
        int startOffset = sourceElement.getStartOffset();
        int searchForOffset = startOffset + this._offset;
        int i = 0;
        while (i < children.size()) {
            SourceElement childElement = (SourceElement)children.get(i);
            int childOffset = childElement.getStartOffset();
            if (searchForOffset == childOffset) {
                if (this.isRightChild(childElement)) {
                    return childElement;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private boolean isRightChild(SourceElement sourceElement) {
        boolean ret = false;
        if (sourceElement != null && sourceElement.getSymbolKind() == this._symbolKind) {
            if (sourceElement instanceof SourceHasName) {
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                String name = sourceHasName.getName();
                if (this._name.equals(name)) {
                    ret = true;
                } else if (this._index != 0 && this._offset != 0) {
                    this._name = name;
                    ret = true;
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    public void updateOffsets(int offset, int count) {
        if (offset <= this._offset) {
            this._offset += count;
        } else if (this._child != null) {
            this._child.updateOffsets(offset - this._offset, count);
        }
    }

    public int getOffset() {
        if (this._child == null) {
            return this._offset;
        }
        return this._offset + this._child.getOffset();
    }
}

