/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class TimedLRUCache {
    public static final int NO_EXPIRATION = -1;
    public static final int MINIMUM_EXPIRATION = 60000;
    private static final int CHECK_INTERVAL = 5000;
    private int _maxSize;
    private int _expireTime;
    private HashMap _entryMap;
    private long _lastCheck;
    private static final Comparator ACCESS_COMPARATOR = new AccessComparator(null);

    public TimedLRUCache(int maxSize) {
        this(maxSize, -1);
    }

    public TimedLRUCache(int maxSize, int timeToLiveMillis) {
        this._maxSize = maxSize;
        this._expireTime = timeToLiveMillis;
        if (this._expireTime != -1) {
            this._expireTime = Math.max(this._expireTime, 60000);
        }
        this._lastCheck = System.currentTimeMillis();
        this._entryMap = new HashMap(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            Entry entry = (Entry)this._entryMap.get(key);
            if (entry != null) {
                Entry.wa$access(entry, System.currentTimeMillis());
                Object object = Entry.ra$value(entry);
                return object;
            }
            Object var5_5 = null;
            return var5_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        this.checkForExpiration();
        if (value != null && key != null) {
            Entry entry = new Entry(key, value, System.currentTimeMillis(), null);
            HashMap hashMap = this._entryMap;
            synchronized (hashMap) {
                this._entryMap.put(key, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            Entry entry = (Entry)this._entryMap.remove(key);
            if (entry != null) {
                Object object = Entry.ra$value(entry);
                return object;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsKey(Object key) {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            boolean bl = this._entryMap.containsKey(key);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int size() {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            int n = this._entryMap.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForExpiration() {
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            int cacheSize;
            long dueTime = this._lastCheck + 5000L;
            long nowTime = System.currentTimeMillis();
            if (nowTime < dueTime) {
                return;
            }
            this._lastCheck = nowTime;
            if (this._expireTime != -1) {
                long current = System.currentTimeMillis();
                long oldest = current - (long)this._expireTime;
                Iterator iterator = this._entryMap.values().iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    if (Entry.ra$access(entry) > oldest) continue;
                    iterator.remove();
                }
            }
            if ((cacheSize = this._entryMap.size()) > this._maxSize) {
                Object[] values = this._entryMap.values().toArray();
                Arrays.sort(values, ACCESS_COMPARATOR);
                int i = this._maxSize;
                while (i < cacheSize) {
                    Entry entry = (Entry)values[i];
                    this._entryMap.remove(Entry.ra$key(entry));
                    ++i;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            Entry entry1 = (Entry)obj1;
            Entry entry2 = (Entry)obj2;
            return (int)(Entry.ra$access(entry2) - Entry.ra$access(entry1));
        }

        private AccessComparator() {
        }

        AccessComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class Entry {
        private Object key;
        private Object value;
        private long access;

        private Entry(Object key, Object value, long access) {
            this.key = key;
            this.value = value;
            this.access = access;
        }

        static long ra$access(Entry entry) {
            return entry.access;
        }

        static Object ra$key(Entry entry) {
            return entry.key;
        }

        static Object ra$value(Entry entry) {
            return entry.value;
        }

        Entry(Object object, Object object2, long l, 1 var5_4) {
            this(object, object2, l);
        }

        static void wa$access(Entry entry, long l) {
            entry.access = l;
        }

        public final class 1 {
        }
    }
}

