/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.plugin.Sybase12Capturer;

public class Sybase12DbProvider
extends ThirdPartyDbProvider {
    private String m_label;
    private Sybase12Capturer m_capturer;

    public Sybase12DbProvider(Connection conn) {
        super(conn);
    }

    public OnlineCapturer getCapturer(MigrationStorer storer) {
        if (this.m_capturer == null) {
            this.m_capturer = new Sybase12Capturer(storer, this._conn);
        }
        return this.m_capturer;
    }

    public String getConnectionLabel() {
        if (this.m_label == null) {
            try {
                DatabaseMetaData dbmd = this.getConnection().getMetaData();
                String url = dbmd.getURL();
                String[] parts = url.split("/");
                this.m_label = "\\\\" + parts[2] + "\\" + this.getConnection().getCatalog() + " (" + dbmd.getDatabaseProductName() + ")";
            }
            catch (SQLException sqlex) {
                this.m_label = null;
            }
        }
        return this.m_label;
    }
}

