/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.Sybase12AbstractCapturer;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.GenerateDSMLFormattedFiles;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.MetadataFileParser;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.OracleDatatypeIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sybase12DoOfflineCaptureLoad
implements OracleDatatypeIdentifiers {
    private HashMap<File, ArrayList<File>> _dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String _currentTableName = null;
    private int _currentDbId = 0;
    public String currValue = "";
    private HashMap<String, String[]> m_tableTypes = new HashMap();
    private Connection m_conn = null;

    public Sybase12DoOfflineCaptureLoad(Connection inConn) {
        this.m_conn = inConn;
        this.populateTableTypes();
    }

    public void loadSourceModel(HashMap<File, ObjectStatusList> dbs) throws OfflineCaptureException {
        this.m_dSMLMap = dbs;
        Statement stmt = null;
        Connection repConnection = null;
        Object rs = null;
        try {
            repConnection = this.m_conn;
            stmt = repConnection.createStatement();
            GenerateDSMLFormattedFiles dsmlFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap);
            this._dbXMLMetadataList = dsmlFormattedFiles.getDSMLFormattedFilesTable();
            File dbFile = this.getDbFile("MASTER");
            if (dbFile == null) {
                throw new OfflineCaptureException(new Exception());
            }
            this._currentDbId = 1;
            this.populateSourceModel(repConnection, dbFile, 1);
            for (File dbFilename : this._dbXMLMetadataList.keySet()) {
                int dbId;
                if (dbFilename.getName().equalsIgnoreCase("MASTER")) continue;
                this._currentDbId = dbId = this.getDbId(repConnection, dbFilename.getName());
                Sybase12AbstractCapturer.OfflineDbId = dbId;
                if (dbId == 0) continue;
                this.populateSourceModel(repConnection, dbFilename, dbId);
            }
            this.sourceModelIndexCreate(repConnection);
            repConnection.commit();
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)e);
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException(e);
        }
    }

    private File getDbFile(String dbName) {
        File dbFile = null;
        for (File file : this.m_dSMLMap.keySet()) {
            String nextDbName = file.getName();
            if (!nextDbName.equalsIgnoreCase(dbName)) continue;
            dbFile = file;
            break;
        }
        return dbFile;
    }

    private int getDbId(Connection repConnection, String dbName) throws OfflineCaptureException {
        Statement repStatement = null;
        ResultSet rs = null;
        int dbId = 0;
        try {
            repStatement = repConnection.createStatement();
            String sql = " SELECT DBID FROM SYB12_SYSDATABASES  WHERE UPPER(NAME) = '" + dbName.toUpperCase() + "' ";
            rs = repStatement.executeQuery(sql);
            while (rs.next()) {
                dbId = rs.getInt(1);
            }
            return dbId;
        }
        catch (SQLException e) {
            throw new OfflineCaptureException((Exception)e);
        }
    }

    private void populateSourceModel(Connection repConnection, File dbName, int dbId) throws OfflineCaptureException {
        try {
            ArrayList<File> xMLMetadataFiles = this._dbXMLMetadataList.get(dbName);
            Iterator<File> i$ = xMLMetadataFiles.iterator();
            while (i$.hasNext()) {
                File f;
                File filename = f = i$.next();
                this._currentTableName = GenerateDSMLFormattedFiles.getUnqualifiedName(filename.getName());
                String[] fieldTypes = this.getFieldTypes(this._currentTableName);
                if (fieldTypes == null) continue;
                MetadataFileParser metaParser = new MetadataFileParser(this._currentDbId, Sybase12DoOfflineCaptureLoad.fileToURL(filename), this._currentTableName);
                metaParser.createPrepardStatement(repConnection, fieldTypes);
                int numRecordsLoaded = metaParser.loadData();
            }
        }
        catch (Exception excep) {
            throw new OfflineCaptureException(excep);
        }
    }

    private String[] getFieldTypes(String tableName) {
        String[] tableTypes = null;
        for (String nextElement : this.m_tableTypes.keySet()) {
            if (!tableName.equalsIgnoreCase(nextElement)) continue;
            tableTypes = this.m_tableTypes.get(nextElement.toUpperCase());
            break;
        }
        return tableTypes;
    }

    private void populateTableTypes() {
        String[] columnList1 = new String[]{"3", "1", "3", "3", "3", "3", "3", "1", "1", "3", "3", "3", "3", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SYB12_SYSDATABASES", columnList1);
        String[] columnList2 = new String[]{"3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SYB12_SYSUSERS", columnList2);
        String[] columnList3 = new String[]{"3", "1", "3", "3", "1", "3", "3", "3", "3", "3", "1", "1", "3", "3", "3", "3", "3", "3", "3", "3", "6", "1"};
        this.m_tableTypes.put("SYB12_SYSOBJECTS", columnList3);
        String[] columnList4 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "1", "3", "3", "3", "1", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SYB12_SYSCOLUMNS", columnList4);
        String[] columnList5 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "1", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SYB12_SYSTYPES", columnList5);
        String[] columnList6 = new String[]{"3", "3", "3", "3", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SYB12_SYSCOMMENTS", columnList6);
        String[] columnList7 = new String[]{"3", "3", "1", "1", "1"};
        this.m_tableTypes.put("SYB12_SYSINDEXES", columnList7);
        String[] columnList8 = new String[]{"3", "3", "1", "1"};
        this.m_tableTypes.put("SYB12_SYSCONSTRAINTS", columnList8);
    }

    private static URL fileToURL(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return new URL("file", null, path);
        }
        catch (MalformedURLException e) {
            throw new Error("Unexpected MalformedURLException");
        }
    }

    private void sourceModelIndexCreate(Connection repConn) throws OfflineCaptureException {
    }
}

