/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.Sybase12CaptureObjectsOnlineCapturer;
import oracle.dbtools.migration.workbench.plugin.Sybase15CaptureObjectsOnlineCapturer;
import oracle.dbtools.migration.workbench.plugin.Sybase15CaptureQueries;

public class Sybase15Capturer
extends AbstractOnlineCapturer {
    private String m_modelName;
    public static final String MY_LANGUAGE_ID = "STSQL";
    protected Sybase12CaptureObjectsOnlineCapturer s_CaptureObjectsOnlineCapturer = null;
    private static String s_SybaseDatabaseToUse = null;
    private static Sybase15CaptureQueries s_captureQueries;

    public Sybase15Capturer(MigrationStorer storer, Connection sourceConnection) {
        super(storer, sourceConnection);
        this.s_CaptureObjectsOnlineCapturer = new Sybase15CaptureObjectsOnlineCapturer(storer, sourceConnection);
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new Sybase15CaptureQueries();
        }
        return s_captureQueries;
    }

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        try {
            this.s_CaptureObjectsOnlineCapturer.captureObjects(objType, context, filter);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getModelName() throws CaptureException {
        if (this.m_modelName == null) {
            try {
                DatabaseMetaData dbmd = this.m_sourceConnection.getMetaData();
                String url = dbmd.getURL();
                String[] parts = url.split("/");
                this.m_modelName = dbmd.getUserName() + "\\" + this.m_sourceConnection.getCatalog() + " (" + "Sybase15" + ")";
            }
            catch (SQLException sqlex) {
                throw new CaptureException((Throwable)sqlex);
            }
        }
        return this.m_modelName;
    }
}

