/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.Sybase15CaptureObjectsOfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.Sybase15DoOfflineCaptureLoad;
import oracle.dbtools.migration.workbench.plugin.Sybase15OfflineCaptureTables;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.ObjectStatusList;
import oracle.dbtools.util.Resource;

public class Sybase15OfflineCapturer
extends AbstractOfflineCapturer {
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    protected Sybase15CaptureObjectsOfflineCapturer m_captureObjectsOfflineCapturer = null;

    protected String captureInitializeImpl(String inputDirectory, Properties props) throws OfflineCaptureException {
        this.setRepositoryConnection(MigrationAddin.getPersistenceManager().getConn());
        this.m_captureObjectsOfflineCapturer = new Sybase15CaptureObjectsOfflineCapturer(this.getStorer(), MigrationAddin.getPersistenceManager().getConn());
        HashMap<File, ObjectStatusList> dSMLMap = new HashMap<File, ObjectStatusList>();
        ObjectStatusList objStatusList = null;
        Connection conn = this.getRepositoryConnection();
        Statement stmt = null;
        try {
            String[] createTables;
            Sybase15OfflineCaptureTables syb15;
            try {
                syb15 = new Sybase15OfflineCaptureTables();
                createTables = syb15.getDropStatements();
                stmt = conn.createStatement();
                for (String drop : createTables) {
                    try {
                        stmt.executeUpdate(drop);
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException e) {
                throw new OfflineCaptureException((Exception)e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            syb15 = new Sybase15OfflineCaptureTables();
            createTables = syb15.getCreateStatements();
            stmt = conn.createStatement();
            for (String create : createTables) {
                try {
                    stmt.executeUpdate(create);
                }
                catch (SQLException e) {
                    throw new OfflineCaptureException((Exception)e);
                }
            }
        }
        catch (SQLException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
        File r = new File(inputDirectory);
        String[] first = r.list();
        for (String f : first) {
            String[] second;
            if (!new File(inputDirectory + File.separator + f).isDirectory()) continue;
            File dir = new File(inputDirectory + File.separator + f);
            objStatusList = new ObjectStatusList();
            for (String f2 : second = dir.list()) {
                if (!f2.endsWith(".dat") && !f2.endsWith(".DAT")) continue;
                objStatusList.add(new File(inputDirectory + File.separator + f + File.separator + f2), "Available");
            }
            dSMLMap.put(dir, objStatusList);
        }
        Sybase15DoOfflineCaptureLoad dsml = new Sybase15DoOfflineCaptureLoad(conn);
        try {
            dsml.loadSourceModel(dSMLMap);
        }
        catch (Exception e) {
            throw new OfflineCaptureException(e);
        }
        return "Sybase15" + inputDirectory;
    }

    public void cleanUp() throws OfflineCaptureException {
        Connection conn = this.getRepositoryConnection();
        Statement stmt = null;
        try {
            Sybase15OfflineCaptureTables syb15 = new Sybase15OfflineCaptureTables();
            String[] dropTables = syb15.getDropStatements();
            stmt = conn.createStatement();
            for (String drop : dropTables) {
                try {
                    stmt.executeUpdate(drop);
                }
                catch (SQLException e) {
                    throw new OfflineCaptureException((Exception)e);
                }
            }
        }
        catch (SQLException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public String[] generateScripts(String outputDirectory, int platformCode) throws OfflineCaptureException {
        this.writeFile(outputDirectory, "Sybase15Files", "properties.sql");
        this.writeFile(outputDirectory, "Sybase15Files", "get_indexes.sql");
        this.writeFile(outputDirectory, "Sybase15Files", "get_constraints.sql");
        this.writeFile(outputDirectory, "Sybase15Files", "sybase15.ocp");
        this.writeFile(outputDirectory, "Sybase15Files", "ROW.TXT");
        this.writeFile(outputDirectory, "Sybase15Files", "COLUMN.TXT");
        if (platformCode == 1) {
            this.writeFile(outputDirectory, "Sybase15Files", "SYB15_OFFLINE_CAPTURE.BAT");
            this.writeFile(outputDirectory, "Sybase15Files", "SYB15_BCP_SCRIPT.BAT");
            String[] stringArray = new String[]{"SYB15_OFFLINE_CAPTURE.BAT", "sybase15.ocp", "properties.sql", "SYB15_BCP_SCRIPT.BAT", "ROW.TXT", "COLUMN.TXT", "get_indexes.sql", "get_constraints.sql"};
            return stringArray;
        }
        this.writeFile(outputDirectory, "Sybase15Files", "SYB15_OFFLINE_CAPTURE.sh");
        String[] stringArray = new String[]{"SYB15_OFFLINE_CAPTURE.sh", "sybase15.ocp", "properties.sql", "ROW.TXT", "COLUMN.TXT", "get_indexes.sql", "get_constraints.sql"};
        return stringArray;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_repositoryConnection = repositoryConnection;
    }

    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public String[] getScriptFiles(int platformCode) throws OfflineCaptureException {
        return null;
    }

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_captureObjectsOfflineCapturer.captureObjects(objType, context, filter);
    }

    public String getModelName() throws CaptureException {
        return "Sybase15";
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sybase15";
    }

    public Sybase15OfflineCapturer(MigrationStorer storer, Connection sourceConnection) {
    }

    public String writeFile(String outputDirectory, String subDir, String fileName) throws OfflineCaptureException {
        InputStream stream = null;
        FilterOutputStream bOutput = null;
        try {
            String retVal;
            stream = new BufferedInputStream(Resource.getResourceAsStream(((Object)((Object)this)).getClass(), (String)(subDir + "/" + fileName)));
            File permanentFile = null;
            permanentFile = new File(outputDirectory + File.separator + fileName);
            if (!permanentFile.exists()) {
                bOutput = new BufferedOutputStream(new FileOutputStream(permanentFile));
                byte[] b = new byte[10000];
                int v = 0;
                while ((v = stream.read(b)) > -1) {
                    ((BufferedOutputStream)bOutput).write(b, 0, v);
                }
                ((BufferedOutputStream)bOutput).flush();
                stream.close();
            }
            String string = retVal = permanentFile.getPath();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        catch (IOException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
            if (bOutput != null) {
                try {
                    bOutput.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

