/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.OracleDatatypeIdentifiers;
import oracle.jdbc.OraclePreparedStatement;

public class GeneratePreparedStatement
implements OracleDatatypeIdentifiers {
    private String[] m_fieldTypes = null;
    private String m_tableName = null;
    private PreparedStatement m_pStmt = null;
    private static StringBuffer s_insertStmt = new StringBuffer();
    private static int BATCH_SIZE = 250;

    public GeneratePreparedStatement(Connection repConnection, int dbId, String[] fieldTypes, String tableName) throws SQLException {
        this.m_fieldTypes = fieldTypes;
        this.m_tableName = tableName;
        try {
            String insertStmt = this.buildPreparedStatement();
            this.m_pStmt = repConnection.prepareStatement(insertStmt);
            ((OraclePreparedStatement)this.m_pStmt).setExecuteBatch(BATCH_SIZE);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    private String buildPreparedStatement() {
        s_insertStmt.setLength(0);
        s_insertStmt.append(" INSERT INTO ").append(this.m_tableName).append(" VALUES (");
        for (int i = 0; i < this.m_fieldTypes.length; ++i) {
            if (this.m_fieldTypes[i].equalsIgnoreCase("6")) {
                s_insertStmt.append(" HEXTORAW(?),");
                continue;
            }
            if (this.m_fieldTypes[i].equalsIgnoreCase("7")) {
                s_insertStmt.append(" HEXTORAW(?),");
                continue;
            }
            if (this.m_fieldTypes[i].equalsIgnoreCase("10")) {
                s_insertStmt.append(" ?,");
                continue;
            }
            if (this.m_fieldTypes[i].equalsIgnoreCase("5")) {
                s_insertStmt.append(" TO_DATE(SUBSTR(?,1,10),'YYYY/MM/DD'),");
                continue;
            }
            s_insertStmt.append(" ?,");
        }
        s_insertStmt.deleteCharAt(s_insertStmt.length() - 1);
        s_insertStmt.append(" ) ");
        return s_insertStmt.toString();
    }

    public void setPreparedStatementValues(List fieldDataList) throws SQLException {
        for (int j = 0; j < this.m_fieldTypes.length; ++j) {
            String dataType = this.m_fieldTypes[j];
            try {
                String value;
                if (dataType.equalsIgnoreCase("1")) {
                    value = (String)fieldDataList.get(j);
                    if (value.length() == 0) {
                        this.m_pStmt.setString(j + 1, " ");
                        continue;
                    }
                    this.m_pStmt.setString(j + 1, value);
                    continue;
                }
                if (dataType.equalsIgnoreCase("2")) {
                    this.m_pStmt.setString(j + 1, (String)fieldDataList.get(j));
                    continue;
                }
                if (dataType.equalsIgnoreCase("3")) {
                    value = (String)fieldDataList.get(j);
                    if ((value = value.trim()).length() == 0) {
                        this.m_pStmt.setInt(j + 1, 0);
                        continue;
                    }
                    int intVal = Integer.parseInt(value);
                    this.m_pStmt.setInt(j + 1, intVal);
                    continue;
                }
                if (dataType.equalsIgnoreCase("4")) {
                    this.m_pStmt.setString(j + 1, (String)fieldDataList.get(j));
                    continue;
                }
                if (dataType.equalsIgnoreCase("5")) {
                    String dateStr = (String)fieldDataList.get(j);
                    this.m_pStmt.setString(j + 1, dateStr);
                    continue;
                }
                if (dataType.equalsIgnoreCase("6")) {
                    this.m_pStmt.setString(j + 1, (String)fieldDataList.get(j));
                    continue;
                }
                if (dataType.equalsIgnoreCase("7")) {
                    this.m_pStmt.setString(j + 1, (String)fieldDataList.get(j));
                    continue;
                }
                if (dataType.equalsIgnoreCase("8")) {
                    value = (String)fieldDataList.get(j);
                    if (value.length() == 0) {
                        this.m_pStmt.setString(j + 1, " ");
                        continue;
                    }
                    this.m_pStmt.setString(j + 1, value);
                    continue;
                }
                if (dataType.equalsIgnoreCase("9")) {
                    this.m_pStmt.setString(j + 1, (String)fieldDataList.get(j));
                    continue;
                }
                if (dataType.equalsIgnoreCase("10")) {
                    value = (String)fieldDataList.get(j);
                    ClobHelper clobHelper = new ClobHelper(value);
                    this.m_pStmt.setCharacterStream(j + 1, clobHelper.getReader(), (int)clobHelper.getLength());
                    continue;
                }
                if (!dataType.equalsIgnoreCase("11")) continue;
                String bytes = (String)fieldDataList.get(j);
                this.m_pStmt.setBytes(j + 1, bytes.getBytes());
                continue;
            }
            catch (SQLException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }

    public PreparedStatement getPreparedStatement() {
        return this.m_pStmt;
    }

    public String getInsertValues(List fieldDataList) {
        StringBuffer values = new StringBuffer();
        for (int j = 0; j < fieldDataList.size(); ++j) {
            values.append(fieldDataList.get(j)).append(",");
        }
        values.deleteCharAt(values.length() - 1);
        return values.toString();
    }

    public int executeUpdate() throws SQLException {
        return this.m_pStmt.executeUpdate();
    }

    public void cleanUp() {
        try {
            this.m_pStmt.close();
            this.m_pStmt = null;
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }
}

