/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sybase;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sybase.SybaseConnectionPanel;
import oracle.dbtools.thirdparty.sybase.SybaseExplorerResource;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.PlatformUtils;

class BasicPanel
extends JPanel
implements CDComponentView {
    private static final long serialVersionUID = 428751755326227573L;
    private final SybaseConnectionPanel _basicPanel;
    private JLabel _hostLbl = new JLabel();
    protected JTextField tfdHost = new JTextField(15);
    private JLabel _portLbl = new JLabel();
    protected JTextField tfdPort = new JTextField(15);
    private JComboBox _SybaseDbComboBox;
    private JButton _retrieveDatabaseButton;
    private JCheckBox _autoPasswordCheck = new JCheckBox();
    private JCheckBox _windowsAuthenticate = new JCheckBox();
    private JLabel _domainLbl = new JLabel();
    protected JTextField tfdDomain = new JTextField(15);
    private boolean isWindows = true;

    public BasicPanel(SybaseConnectionPanel sybaseConnectionPanel) {
        this._basicPanel = sybaseConnectionPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void clear() {
        this.tfdHost.setText("");
        this.tfdPort.setText("");
        this._SybaseDbComboBox.removeAllItems();
    }

    public void populateComponent(Properties properties) {
        String string = "";
        String string2 = "";
        properties.setProperty("hostname", this.tfdHost.getText());
        properties.setProperty("port", this.tfdPort.getText());
        Object object = this._SybaseDbComboBox.getSelectedItem();
        if (object != null) {
            string2 = object.toString();
        }
        string = string2.length() < 1 ? "jdbc:jtds:sybase://" + this.tfdHost.getText() + ":" + this.tfdPort.getText() + "/" : "jdbc:jtds:sybase://" + this.tfdHost.getText() + ":" + this.tfdPort.getText() + "/" + string2;
        properties.setProperty("customUrl", string);
    }

    private void jbInit() throws Exception {
        this._autoPasswordCheck.setText("Use Default Password");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this._windowsAuthenticate, (String)SybaseExplorerResource.getString(0));
        ResourceUtils.resLabel((JLabel)this._hostLbl, (Component)this.tfdHost, (String)ConnectionDialogArb.getString((int)7));
        ResourceUtils.resLabel((JLabel)this._portLbl, (Component)this.tfdPort, (String)ConnectionDialogArb.getString((int)8));
        ResourceUtils.resLabel((JLabel)this._domainLbl, (Component)this.tfdDomain, (String)SybaseExplorerResource.getString(1));
        this.tfdDomain.setEditable(false);
        this.tfdDomain.setBackground(Color.LIGHT_GRAY);
        this.isWindows = PlatformUtils.isWindows();
        this._autoPasswordCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BasicPanel.this.setDefaultPasswordSelected(itemEvent.getStateChange() == 1);
            }
        });
        this._windowsAuthenticate.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BasicPanel.this.setWindowsAuthSelected(itemEvent.getStateChange() == 1);
            }
        });
        this.add((Component)this._autoPasswordCheck, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._windowsAuthenticate, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._hostLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdHost, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._portLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdPort, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.tfdHost.setText("localhost");
        this.tfdPort.setText("5000");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridx = 0;
        this.add((Component)this.retrieveDatabaseButton(), gridBagConstraints2);
        this.add((Component)this.getSybaseDbComboBox(), gridBagConstraints);
    }

    protected JComboBox getSybaseDbComboBox() {
        if (this._SybaseDbComboBox == null) {
            this._SybaseDbComboBox = new JComboBox();
        }
        return this._SybaseDbComboBox;
    }

    protected JButton retrieveDatabaseButton() {
        if (this._retrieveDatabaseButton == null) {
            this._retrieveDatabaseButton = new JButton();
            this._retrieveDatabaseButton.setText("Retrieve database");
        }
        this._retrieveDatabaseButton.addActionListener(new ActionListener(){
            private static final String JTDS_DRIVER_CLASS = "net.sourceforge.jtds.jdbc.Driver";

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (BasicPanel.this._basicPanel.getConnectionName().length() < 1) {
                        BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + "Select the Connection Name");
                        return;
                    }
                    if (!(BasicPanel.this._basicPanel.getUserName().length() >= 1 && BasicPanel.this._basicPanel.getUserName().length() >= 1 || BasicPanel.this._windowsAuthenticate.isSelected() && (!BasicPanel.this._windowsAuthenticate.isSelected() || BasicPanel.this.isWindows))) {
                        BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + "Select the User Name / Password");
                        return;
                    }
                    if (BasicPanel.this._windowsAuthenticate.isSelected() && !BasicPanel.this.isWindows && (BasicPanel.this.tfdDomain.getText() == null || BasicPanel.this.tfdDomain.getText().length() <= 0)) {
                        BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + "Select the Domain Name");
                        return;
                    }
                    BasicPanel.this._basicPanel.setStatus("");
                    ClassLoader classLoader = RaptorClassLoader.findClassLoader((String)JTDS_DRIVER_CLASS);
                    Class<?> clazz = null;
                    if (classLoader != null) {
                        clazz = classLoader.loadClass(JTDS_DRIVER_CLASS);
                    } else {
                        Class.forName(JTDS_DRIVER_CLASS);
                    }
                    Driver driver = (Driver)clazz.newInstance();
                    Properties properties = new Properties();
                    String string = BasicPanel.this._basicPanel.getUserName();
                    String string2 = BasicPanel.this._basicPanel.getPassword();
                    String string3 = BasicPanel.this.tfdHost.getText().trim();
                    String string4 = "jdbc:jtds:sybase://" + string3 + ":" + BasicPanel.this.tfdPort.getText();
                    if (BasicPanel.this._windowsAuthenticate.isSelected() && !BasicPanel.this.isWindows) {
                        string4 = string4 + ";domain=" + BasicPanel.this.tfdDomain.getText();
                    }
                    if (null != string) {
                        properties.setProperty("user", string);
                    }
                    if (null != string2) {
                        properties.setProperty("password", string2);
                    } else if (BasicPanel.this._autoPasswordCheck.isSelected()) {
                        properties.put("password", string);
                    }
                    Connection connection = driver.connect(string4, properties);
                    PreparedStatement preparedStatement = connection.prepareStatement("select name from master..sysdatabases ORDER by name");
                    ResultSet resultSet = preparedStatement.executeQuery();
                    BasicPanel.this._SybaseDbComboBox.removeAllItems();
                    while (resultSet.next()) {
                        String string5 = resultSet.getString("name");
                        if (string5 == null) continue;
                        BasicPanel.this._SybaseDbComboBox.addItem(string5);
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {
                    BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + sQLException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + illegalAccessException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    BasicPanel.this._basicPanel.setErrorStatus(ConnectionDialogArb.getString((int)28) + classNotFoundException.getMessage());
                }
            }
        });
        return this._retrieveDatabaseButton;
    }

    protected void retrieveDatabase(Properties properties) {
        String string;
        this._SybaseDbComboBox.removeAllItems();
        String string2 = properties.getProperty("customUrl");
        if (string2 != null && (string = string2.substring(string2.lastIndexOf(47) + 1)) != null) {
            this._SybaseDbComboBox.addItem(string);
            this._SybaseDbComboBox.setSelectedItem(string);
        }
    }

    public JCheckBox get_autoPasswordCheck() {
        return this._autoPasswordCheck;
    }

    public void set_autoPasswordCheck(JCheckBox jCheckBox) {
        this._autoPasswordCheck = jCheckBox;
    }

    public JCheckBox get_windowsAuthenticate() {
        return this._windowsAuthenticate;
    }

    public void set_windowsAuthenticate(boolean bl) {
        this._windowsAuthenticate.setSelected(bl);
    }

    public boolean get_isWindows() {
        return this.isWindows;
    }

    public JTextField getTfdDomain() {
        return this.tfdDomain;
    }

    public void setDomain(String string) {
        this.tfdDomain.setText(string);
    }

    void setDefaultPasswordSelected(boolean bl) {
        this._autoPasswordCheck.setSelected(bl);
        if (bl) {
            this._basicPanel.getDialog().usePassword(false);
        } else {
            this._basicPanel.getDialog().usePassword(true);
        }
    }

    void setWindowsAuthSelected(boolean bl) {
        this.isWindows = PlatformUtils.isWindows();
        this._windowsAuthenticate.setSelected(bl);
        if (bl && !this.isWindows) {
            this._basicPanel.getDialog().useUserName(true);
            this._basicPanel.getDialog().usePassword(true);
            this._autoPasswordCheck.setEnabled(true);
            this.add((Component)this._domainLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.add((Component)this.tfdDomain, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
            this.revalidate();
            this.tfdDomain.setEditable(true);
            this.tfdDomain.setBackground(Color.WHITE);
        } else if (bl && this.isWindows) {
            this._autoPasswordCheck.setEnabled(false);
            this._basicPanel.getDialog().useUserName(false);
            this._basicPanel.getDialog().usePassword(false);
        } else {
            this._basicPanel.getDialog().useUserName(true);
            if (!this._autoPasswordCheck.isSelected()) {
                this._basicPanel.getDialog().usePassword(true);
            } else {
                this._basicPanel.getDialog().usePassword(false);
            }
            this._autoPasswordCheck.setEnabled(true);
            this.remove(this._domainLbl);
            this.remove(this.tfdDomain);
            this.revalidate();
        }
    }

    public void setDefaultPrompts() {
        this.tfdHost.setText("localhost");
        this.tfdPort.setText("5000");
        this._SybaseDbComboBox.removeAllItems();
    }
}

