/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.searchbar.addin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.searchbar.addin.SearchListCellEditor;
import oracle.dbtools.raptor.searchbar.addin.SearchListCellRenderer;
import oracle.dbtools.raptor.searchbar.addin.SearchListItem;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginComboBoxUI;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginLoader;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginMessagePage;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginOptions;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginOptionsPanel;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.ClientSetting;
import oracle.ide.controls.Toolbar;
import oracle.ide.log.Href;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.Navigable;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Copyable;

public final class SearchPlugin
implements Addin,
ChangeListener {
    public static final String EXTENSION_ID = "oracle.sqldeveloper.searchbar";
    private JComboBox _searchBox = null;
    private SearchPluginMessagePage _logPage = null;

    public void initialize() {
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void mainWindowOpened(IdeEvent ideEvent) {
                AddinManager addinManager = AddinManager.getAddinManager();
                SearchPlugin searchPlugin = (SearchPlugin)addinManager.getAddin(SearchPlugin.class);
                searchPlugin.initializeToolbar();
            }
        });
    }

    private void initializeToolbar() {
        this._searchBox = new JComboBox();
        this._searchBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this._searchBox.setUI(new SearchPluginComboBoxUI());
        Toolbar toolbar = Ide.getToolbar();
        this._searchBox.setEditable(true);
        this._updateSearchPluginsModel();
        this._searchBox.setRenderer(new SearchListCellRenderer());
        this._searchBox.setEditor(new SearchListCellEditor(this._searchBox));
        this._searchBox.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPlugin.this._executeSearchQuery(actionEvent);
            }
        });
        this._searchBox.setSize(120, toolbar.getHeight());
        this._searchBox.setMaximumSize(this._searchBox.getSize());
        this._searchBox.setPreferredSize(this._searchBox.getSize());
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add((Component)this._searchBox);
        if (this._getOptions() != null) {
            this._getOptions().addChangeListener(this);
        }
        if (this._searchBox.getModel().getSize() == 0) {
            String string = "The Search Plugin directory does not contain any search plugins.  Would you like to change it now?";
            String string2 = "No Search Plugins Found.";
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)string2, null)) {
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{"Search Plugins"});
            }
        }
    }

    private final void _initPreferencesPanels() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)EXTENSION_ID);
        if (!clientSetting.hasData("SearchPluginOptions")) {
            clientSetting.putData("SearchPluginOptions", (Copyable)new SearchPluginOptions());
        }
        ClientSetting.registerUI((Navigable)new Navigable("Search Plugins", SearchPluginOptionsPanel.class));
    }

    private SearchPluginOptions _getOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)EXTENSION_ID);
        SearchPluginOptions searchPluginOptions = (SearchPluginOptions)clientSetting.getData("SearchPluginOptions");
        return searchPluginOptions;
    }

    private void _executeSearchQuery(ActionEvent actionEvent) {
        try {
            if (this._logPage == null) {
                this._logPage = new SearchPluginMessagePage();
            }
            String string = actionEvent.getActionCommand();
            Object object = this._searchBox.getSelectedItem();
            if (object instanceof SearchListItem) {
                SearchListItem searchListItem = (SearchListItem)object;
                URL uRL = new URL(searchListItem.getURL(string));
                BrowserRunner.getBrowserRunner().runBrowserOnURL(uRL, null, (PrintWriter)new LogPrintWriter((LogPage)this._logPage));
                String string2 = MessageFormat.format("Searching \"{0}\" for \"{1}\"\n", searchListItem.getName(), string);
                this._logPage.log(string2);
                this._logPage.log((Object)new WebBrowserHref(uRL));
                this._logPage.log("\n\n");
            } else {
                this._logPage.log("Internal Error with Search: ");
                this._logPage.log("SearchItem = " + object);
                this._logPage.log("keyword = " + string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this._logPage.log("Exception running search plugin: ");
            this._logPage.log(malformedURLException);
            this._logPage.log("\n");
        }
        if (this._logPage.isVisible()) {
            this._logPage.activate();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this._updateSearchPluginsModel();
    }

    private void _updateSearchPluginsModel() {
        String string = Ide.getBinDirectory() + "/../searchengines";
        if (string != null && string.length() >= 0) {
            URL uRL = URLFactory.newDirURL((String)string);
            Vector vector = SearchPluginLoader.loadPlugins(uRL);
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
            this._searchBox.setModel(defaultComboBoxModel);
        }
    }

    class WebBrowserHref
    extends Href {
        WebBrowserHref(URL uRL) {
            super(uRL.toString(), uRL);
        }

        public void go() {
            BrowserRunner.getBrowserRunner().runBrowserOnURL(this.getURL(), null, null);
        }
    }
}

