/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.searchbar.addin;

import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import oracle.dbtools.raptor.searchbar.addin.SearchListItem;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginElement;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginParser;
import oracle.ide.log.LogManager;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;

public class SearchPluginLoader {
    private static String[] SUFFIXES = new String[]{".gif", ".png", ".jpg", ".jpeg"};

    private SearchPluginLoader() {
    }

    public static Vector loadPlugins(URL uRL) {
        Vector<SearchListItem> vector = new Vector<SearchListItem>();
        URL[] uRLArray = URLFileSystem.list((URL)uRL, (URLFilter)new DefaultURLFilter("SRC Files", ".src"));
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL2 = uRLArray[i];
            SearchPluginElement searchPluginElement = SearchPluginParser.parse(uRL2);
            ImageIcon imageIcon = null;
            URL uRL3 = SearchPluginLoader._findImageURL(uRL2);
            if (uRL3 != null) {
                try {
                    imageIcon = new ImageIcon(uRL3);
                }
                catch (Exception exception) {
                    LogManager.getLogManager().getMsgPage().log((Object)("Unable to load icon: " + uRL3));
                }
            }
            SearchListItem searchListItem = new SearchListItem(searchPluginElement);
            searchListItem.setIcon(imageIcon);
            vector.add(searchListItem);
        }
        return vector;
    }

    private static URL _findImageURL(URL uRL) {
        for (int i = 0; i < SUFFIXES.length; ++i) {
            URL uRL2 = URLFileSystem.convertSuffix((URL)uRL, (String)".src", (String)SUFFIXES[i]);
            if (!URLFileSystem.exists((URL)uRL2)) continue;
            return uRL2;
        }
        return null;
    }
}

