/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.searchbar.addin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginOptions;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public final class SearchPluginOptionsPanel
extends DefaultTraversablePanel {
    private SearchPluginOptions _options;
    private JTextField tfDir = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton btnBrowse = new JButton();
    private JLabel lblSpacer = new JLabel();
    private JLabel lblFieldTitle = new JLabel();

    public SearchPluginOptionsPanel() {
        try {
            this.jbInit();
            this._postInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        SearchPluginOptions searchPluginOptions;
        this._options = searchPluginOptions = (SearchPluginOptions)((Object)traversableContext.find("SearchPluginOptions"));
        this.load(this._options);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SearchPluginOptions searchPluginOptions = (SearchPluginOptions)((Object)traversableContext.find("SearchPluginOptions"));
        this.commit(searchPluginOptions);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.btnBrowse.setText("Browse");
        this.btnBrowse.setMnemonic('B');
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPluginOptionsPanel.this.btnBrowse_actionPerformed(actionEvent);
            }
        });
        this.lblSpacer.setText(" ");
        this.lblFieldTitle.setDisplayedMnemonic('S');
        this.lblFieldTitle.setText("Search Plugins Directory:");
        this.lblFieldTitle.setLabelFor(this.tfDir);
        this.add(this.tfDir, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.btnBrowse, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.lblSpacer, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.lblFieldTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void _postInit() throws Exception {
    }

    private void load(SearchPluginOptions searchPluginOptions) {
        this.tfDir.setText(searchPluginOptions.getDir());
    }

    private void commit(SearchPluginOptions searchPluginOptions) {
        searchPluginOptions.setDir(this.tfDir.getText());
    }

    private void btnBrowse_actionPerformed(ActionEvent actionEvent) {
        String string;
        URL uRL = null;
        try {
            string = this.tfDir.getText();
            uRL = URLFactory.newDirURL((String)string);
        }
        catch (Exception exception) {
            uRL = URLFactory.newDirURL((String)Ide.getSystemDirectory());
        }
        string = DialogUtil.newURLChooser((URL)uRL);
        string.setSelectionScope(1);
        string.setSelectionMode(0);
        int n = string.showOpenDialog((Component)Ide.getMainWindow(), "Select Search Plugins Directory");
        if (n == 0) {
            URL uRL2 = string.getSelectedURL();
            this.tfDir.setText(URLFileSystem.getPlatformPathName((URL)uRL2));
        }
    }
}

