/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.db.DefaultDBTypeRegistry;
import oracle.javatools.icons.OracleIcons;

public final class DBTypeDisplayRegistry {
    public static final String CONNECTIONS_TYPE = "Connections";
    private static List<RegistryEntry> _registries = new ArrayList<RegistryEntry>();
    private static DefaultDBTypeRegistry _defaultRegistry = new DefaultDBTypeRegistry();
    private static HashMap<String, Icon> s_generatedFolderIcons = new HashMap();

    private DBTypeDisplayRegistry() {
    }

    public static void addDBTypeRegistry(RegistryEntry registry) {
        _registries.add(registry);
    }

    public static Icon getFolderIcon(String typeName) {
        Icon icon = s_generatedFolderIcons.get(typeName);
        if (icon != null) {
            return icon;
        }
        for (RegistryEntry reg : _registries) {
            icon = reg.getFolderIcon(typeName);
            if (icon == null) continue;
            return icon;
        }
        icon = _defaultRegistry.getFolderIcon(typeName);
        if (icon != null) {
            return icon;
        }
        if (_defaultRegistry.getNodeIcon(typeName) != null) {
            icon = new FolderIcon(typeName);
            s_generatedFolderIcons.put(typeName, icon);
            return icon;
        }
        return null;
    }

    public static Icon getNodeIcon(String typeName) {
        Icon icon = null;
        for (RegistryEntry reg : _registries) {
            icon = reg.getNodeIcon(typeName);
            if (icon != null) break;
        }
        return icon != null ? icon : _defaultRegistry.getNodeIcon(typeName);
    }

    public static String getDisplayName(String typeName) {
        String name = null;
        for (RegistryEntry reg : _registries) {
            name = reg.getDisplayName(typeName);
            if (name != null) break;
        }
        return name != null ? name : _defaultRegistry.getDisplayName(typeName);
    }

    public static String getSingularDisplayName(String typeName) {
        String name = null;
        for (RegistryEntry reg : _registries) {
            name = reg.getSingularDisplayName(typeName);
            if (name != null) break;
        }
        return name != null ? name : _defaultRegistry.getSingularDisplayName(typeName);
    }

    public static interface RegistryEntry {
        public String getDisplayName(String var1);

        public String getSingularDisplayName(String var1);

        public Icon getNodeIcon(String var1);

        public Icon getFolderIcon(String var1);
    }

    public static class FolderIcon
    implements Icon {
        int m_width;
        int m_height;
        Icon m_folderIcon;

        private void $init$() {
            this.m_width = -1;
            this.m_height = -1;
            this.m_folderIcon = null;
        }

        public FolderIcon(String type) {
            this.$init$();
            Icon typeIcon = DBTypeDisplayRegistry.getNodeIcon(type);
            if (typeIcon instanceof ImageIcon) {
                Image newImg = ((ImageIcon)typeIcon).getImage().getScaledInstance(12, 12, 4);
                this.m_folderIcon = new ImageIcon(newImg);
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            OracleIcons.getIcon((String)"folder.png").paintIcon(c, g, x, y);
            if (this.m_folderIcon != null) {
                this.m_folderIcon.paintIcon(c, g, x + 4, y + 4);
            }
        }

        public int getIconWidth() {
            if (this.m_width == -1) {
                this.m_width = OracleIcons.getIcon((String)"folder.png").getIconWidth();
            }
            return this.m_width;
        }

        public int getIconHeight() {
            if (this.m_height == -1) {
                this.m_height = OracleIcons.getIcon((String)"folder.png").getIconHeight();
            }
            return this.m_height;
        }
    }
}

