/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import oracle.ideimpl.db.PropertyUI;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.Property;

public final class PropertyDisplayRegistry {
    private static Map<Property, Map<String, String>> m_DisplayValueMap = null;

    private PropertyDisplayRegistry() {
    }

    public static final String getDisplayName(String propName) {
        String prop = null;
        try {
            prop = PropertyUI.get(propName);
        }
        catch (MissingResourceException e) {
            prop = null;
        }
        if (prop == null) {
            prop = propName;
        }
        return prop;
    }

    private static void registerPropValueDisplay(Property prop, Object value, String displayKey) {
        Map<String, String> hash;
        String displayValue = null;
        try {
            displayValue = PropertyUI.get(displayKey);
        }
        catch (MissingResourceException e) {
            displayValue = null;
        }
        if (displayValue == null) {
            displayValue = value.toString();
        }
        if ((hash = m_DisplayValueMap.get(prop)) == null) {
            hash = new HashMap<String, String>();
            m_DisplayValueMap.put(prop, hash);
        }
        hash.put(value.toString(), displayValue);
    }

    private static void initialiseDisplayValueMap() {
        m_DisplayValueMap = new HashMap<Property, Map<String, String>>();
        PropertyDisplayRegistry.registerPropValueDisplay(Property.deleteMode, 0, "PROP_VALUE_DELETE_MODE_RESTRICT");
        PropertyDisplayRegistry.registerPropValueDisplay(Property.deleteMode, 1, "PROP_VALUE_DELETE_MODE_CASCADE");
        PropertyDisplayRegistry.registerPropValueDisplay(Property.deleteMode, 2, "PROP_VALUE_DELETE_MODE_SET_NULL");
        PropertyDisplayRegistry.registerPropValueDisplay(Property.TableType, Table.TableType.NORMAL, "PROP_VALUE_TABLE_TYPE_NORMAL");
        PropertyDisplayRegistry.registerPropValueDisplay(Property.TableType, Table.TableType.TRANSACTION_TEMP, "PROP_VALUE_TABLE_TYPE_TRANSACTION_TEMP");
        PropertyDisplayRegistry.registerPropValueDisplay(Property.TableType, Table.TableType.SESSION_TEMP, "PROP_VALUE_TABLE_TYPE_SESSION_TEMP");
        PropertyDisplayRegistry.registerPropValueDisplay(Property.TableType, Table.TableType.INDEX_ORGANIZED, "PROP_VALUE_TABLE_TYPE_INDEX_ORGANIZED");
        PropertyDisplayRegistry.registerPropValueDisplay(Property.TableType, Table.TableType.EXTERNAL, "PROP_VALUE_TABLE_TYPE_INDEX_EXTERNAL");
    }

    public static final String getPropValueDisplay(String propName, String value) {
        if (m_DisplayValueMap == null) {
            PropertyDisplayRegistry.initialiseDisplayValueMap();
        }
        String retVal = value;
        try {
            Map<String, String> hash;
            Property prop = Property.valueOf((String)propName);
            if (prop != null && (hash = m_DisplayValueMap.get(prop)) != null && hash.containsKey(value)) {
                retVal = hash.get(value);
            }
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        return retVal;
    }
}

