/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;

public class SchemaObjectDescriptor {
    private transient SchemaObject m_obj;
    private String m_name;
    private String m_type;
    private String m_schema;
    private String m_otherName;

    private SchemaObjectDescriptor() {
    }

    public SchemaObjectDescriptor(String name, String type, String schema) {
        this.m_name = name;
        this.m_type = type;
        this.m_schema = schema;
    }

    public SchemaObjectDescriptor(SchemaObject obj) {
        if (obj != null) {
            this.m_name = obj.getName();
            this.m_type = obj.getType();
            Schema schema = obj.getSchema();
            this.m_schema = schema.getName();
        }
        this.m_obj = obj;
    }

    public String getName() {
        if (this.m_obj == null) {
            return this.m_name;
        }
        return this.m_obj.getName();
    }

    public String getOriginalName() {
        return this.getName();
    }

    public String getType() {
        if (this.m_obj == null) {
            return this.m_type;
        }
        return this.m_obj.getType();
    }

    public String getSchema() {
        Schema schema;
        if (this.m_obj != null && (schema = this.m_obj.getSchema()) != null) {
            return schema.getName();
        }
        return this.m_schema;
    }

    public SchemaObject getObject() {
        return this.m_obj;
    }

    public String getOtherName() {
        return this.m_otherName;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOriginalName(String name) {
        this.setName(name);
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setOtherName(String name) {
        this.m_otherName = name;
    }

    public boolean equals(Object obj) {
        return obj instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)obj, false);
    }

    protected boolean equalsImpl(SchemaObjectDescriptor obj, boolean strict) {
        return ModelUtil.areEqual((Object)this.getName(), (Object)obj.getName()) && ModelUtil.areEqual((Object)this.getType(), (Object)obj.getType()) && ModelUtil.areEqual((Object)this.getSchema(), (Object)obj.getSchema()) && (!strict || ModelUtil.areEqual((Object)this.m_name, (Object)obj.m_name));
    }

    public boolean equals(Object obj, boolean strict) {
        return obj instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)obj, strict);
    }

    public Object copyTo(Object obj) {
        SchemaObjectDescriptor copy = obj == null ? new SchemaObjectDescriptor() : (SchemaObjectDescriptor)obj;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(SchemaObjectDescriptor copy) {
        copy.m_name = this.m_name;
        copy.m_schema = this.m_schema;
        copy.m_type = this.m_type;
        copy.m_otherName = this.m_otherName;
    }

    public String toString() {
        return this.getName() + " (" + this.getSchema() + ")";
    }

    public SchemaObject unwrapDescriptor(DBObjectProvider source) throws DBException {
        if (this.m_obj == null) {
            Schema dbs = source.getSchema(this.getSchema());
            this.m_obj = source.getObject(this.getType(), dbs, this.getOriginalName());
        }
        return this.m_obj;
    }

    public static SchemaObject[] unwrapDescriptors(SchemaObjectDescriptor[] descs, DBObjectProvider source) throws DBException {
        if (descs != null) {
            SchemaObject[] retval = new SchemaObject[descs.length];
            int i = 0;
            while (i < descs.length) {
                retval[i] = descs[i].unwrapDescriptor(source);
                ++i;
            }
            return retval;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(SchemaObject[] objs, boolean saveObj) {
        if (objs != null) {
            SchemaObjectDescriptor[] retval = new SchemaObjectDescriptor[objs.length];
            int i = 0;
            while (i < objs.length) {
                retval[i] = saveObj ? new SchemaObjectDescriptor(objs[i]) : new SchemaObjectDescriptor(objs[i].getName(), objs[i].getType(), objs[i].getSchema().getName());
                ++i;
            }
            return retval;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(SchemaObject[] objs) {
        if (objs != null) {
            SchemaObjectDescriptor[] retval = new SchemaObjectDescriptor[objs.length];
            int i = 0;
            while (i < objs.length) {
                retval[i] = new SchemaObjectDescriptor(objs[i]);
                ++i;
            }
            return retval;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(DBObjectID[] ids) {
        if (ids != null) {
            SchemaObjectDescriptor[] retval = new SchemaObjectDescriptor[ids.length];
            int i = 0;
            while (i < ids.length) {
                try {
                    DBObject obj = ids[i].resolveID();
                    if (obj != null && obj instanceof SchemaObject) {
                        retval[i] = new SchemaObjectDescriptor((SchemaObject)obj);
                    }
                }
                catch (DBException dbe) {
                    // empty catch block
                }
                ++i;
            }
            return retval;
        }
        return null;
    }
}

