/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.shuttle.ItemPicker;

public abstract class AbstractTreePicker
implements MouseListener,
FocusListener,
TreeSelectionListener,
ActionListener,
ItemPicker {
    private PropertyChangeSupport m_pcs;
    private ActionListener m_actionListener;
    private JTree m_tree;
    private JScrollPane m_component;

    public AbstractTreePicker() {
    }

    public AbstractTreePicker(JTree tree) {
        this.setTree(tree);
    }

    public void setTree(JTree tree) {
        this.m_tree = tree;
        this.m_component = new JScrollPane(this.m_tree);
        this.m_tree.addFocusListener(this);
        this.m_tree.addMouseListener(this);
        this.m_tree.addTreeSelectionListener(this);
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        this.m_tree.registerKeyboardAction(this, ks, 0);
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public boolean isItemSelected() {
        TreePath[] path = this.m_tree.getSelectionPaths();
        int i = 0;
        while (path != null && i < path.length) {
            if (this.createTransferable(path[i]) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void deselectAll() {
        this.m_tree.getSelectionModel().setSelectionPath(null);
    }

    public Transferable[] getSelectedItems() {
        TreePath[] selection = this.m_tree.getSelectionPaths();
        if (selection != null) {
            ArrayList<Transferable> t = new ArrayList<Transferable>();
            int i = 0;
            while (i < selection.length) {
                Transferable trans = this.createTransferable(selection[i]);
                if (trans != null) {
                    t.add(trans);
                }
                ++i;
            }
            return t.toArray(new Transferable[t.size()]);
        }
        return null;
    }

    public boolean isSelectableItemPresent() {
        return this.m_tree.getRowCount() > 0;
    }

    public JScrollPane getScrollPane() {
        return this.m_component;
    }

    public Component getComponent() {
        return this.m_component;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Transferable[] t = this.getSelectedItems();
        if (t != null) {
            DataFlavor[] df = new DataFlavor[t.length];
            int i = 0;
            while (i < t.length) {
                df[i] = t[i] == null ? null : t[i].getTransferDataFlavors()[0];
                ++i;
            }
            return df;
        }
        return null;
    }

    public boolean canAcceptFlavors(DataFlavor[] flav) {
        return true;
    }

    public abstract Transferable[] getAllSelectableItems();

    public abstract boolean addSelectedItems(Transferable[] var1);

    public abstract void removeSelectedItems();

    public abstract void removeAllSelectableItems();

    public abstract Transferable createTransferable(TreePath var1);

    public void addActionListener(ActionListener al) {
        this.m_actionListener = AWTEventMulticaster.add(this.m_actionListener, al);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.m_pcs == null) {
            this.m_pcs = new PropertyChangeSupport(this);
        }
        this.m_pcs.addPropertyChangeListener(pcl);
    }

    public void removeActionListener(ActionListener al) {
        this.m_actionListener = AWTEventMulticaster.remove(this.m_actionListener, al);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.m_pcs != null) {
            this.m_pcs.removePropertyChangeListener(pcl);
        }
    }

    protected boolean handleDefaultAction(TreePath path) {
        return false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.m_actionListener != null) {
            Transferable t;
            Object node;
            TreePath selPath;
            int selRow = this.m_tree.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1) {
                int m = e.getModifiers();
                if ((m & 2) != 2 && (m & 1) != 1) {
                    this.deselectAll();
                }
            } else if (e.getClickCount() % 2 == 0 && SwingUtilities.isLeftMouseButton(e) && !this.handleDefaultAction(selPath = this.m_tree.getPathForLocation(e.getX(), e.getY())) && (!((node = selPath.getLastPathComponent()) instanceof DefaultMutableTreeNode) || ((DefaultMutableTreeNode)node).isLeaf()) && (t = this.createTransferable(selPath)) != null) {
                this.m_actionListener.actionPerformed(new ActionEvent(this, e.getID(), null, e.getModifiers()));
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() == this.m_tree && this.handleDefaultAction(this.m_tree.getSelectionPath()) || this.m_actionListener == null)) {
            this.m_actionListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    public void focusGained(FocusEvent e) {
        if (this.m_tree.getSelectionCount() == 0 && this.m_tree.getRowCount() > 0) {
            this.m_tree.setSelectionRow(0);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.m_pcs != null) {
            this.m_pcs.firePropertyChange("selection", null, null);
        }
    }
}

