/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.javatools.db.DBObject;
import oracle.javatools.util.ModelUtil;

public class DBObjectListPicker
extends ListPicker {
    private Collection m_acceptTypes;
    private Map m_paths;
    private DefaultListModel m_model;
    private boolean m_removeOnShuttle;

    private void $init$() {
        this.m_removeOnShuttle = true;
    }

    public DBObjectListPicker() {
        this(new JList(new DefaultListModel()));
    }

    public DBObjectListPicker(JList list) {
        super(list);
        this.$init$();
        this.m_model = (DefaultListModel)list.getModel();
        list.setCellRenderer(this.getRenderer());
    }

    public void setRemoveOnShuttle(boolean remove) {
        this.m_removeOnShuttle = remove;
    }

    public void setAcceptTypes(String[] types) {
        this.m_acceptTypes = types == null ? null : Arrays.asList(types);
    }

    public void addDBObject(DBObject obj) {
        this.m_model.addElement(obj);
    }

    protected ListCellRenderer getRenderer() {
        DBObjectRenderer rend = new DBObjectRenderer();
        rend.setIncludeIcon(true);
        return rend;
    }

    protected Transferable[] filterForAdd(Transferable[] add) {
        if (this.m_acceptTypes != null) {
            ArrayList<Transferable> retval = new ArrayList<Transferable>();
            int i = 0;
            while (i < add.length) {
                DBObject obj;
                if (add[i] instanceof DBObjectTransferable && this.m_acceptTypes.contains((obj = ((DBObjectTransferable)add[i]).getDBObject()).getType())) {
                    retval.add(add[i]);
                }
                ++i;
            }
            return retval.toArray(new Transferable[retval.size()]);
        }
        return add;
    }

    public DefaultListModel getListModel() {
        return this.m_model;
    }

    public boolean canAcceptFlavors(DataFlavor[] df) {
        if (!this.m_removeOnShuttle) {
            return true;
        }
        int i = 0;
        while (i < df.length) {
            Class<?> clz;
            if (df[i] != null && ModelUtil.areEqual(clz = df[i].getRepresentationClass(), DBObjectTransferable.class)) {
                if (this.m_acceptTypes != null) {
                    String type = df[i].getHumanPresentableName();
                    if (this.m_acceptTypes.contains(type)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Object[] selected = this.getList().getSelectedValues();
        DataFlavor[] retval = new DataFlavor[selected.length];
        int i = 0;
        while (i < retval.length) {
            String type = null;
            if (selected[i] instanceof DBObject) {
                type = ((DBObject)selected[i]).getType();
            } else if (selected[i] instanceof SchemaObjectDescriptor) {
                type = ((SchemaObjectDescriptor)selected[i]).getType();
            }
            retval[i] = DBObjectTransferable.getDataFlavor(type);
            ++i;
        }
        return retval;
    }

    protected Transferable createTransferable(Object obj) {
        if (obj instanceof SchemaObjectDescriptor) {
            obj = ((SchemaObjectDescriptor)obj).getObject();
        }
        if (this.m_paths == null) {
            return new DBObjectTransferable((DBObject)obj);
        }
        return new DBObjectTransferable((DBObject)obj, (DBObject[])this.m_paths.get(obj));
    }

    public boolean addSelectedItems(Transferable[] add) {
        if (!this.m_removeOnShuttle) {
            return true;
        }
        Transferable[] toAdd = this.filterForAdd(add);
        int i = 0;
        while (i < toAdd.length) {
            if (add[i] instanceof DBObjectTransferable) {
                this.cachePath((DBObjectTransferable)add[i]);
            }
            ++i;
        }
        return super.addSelectedItems(toAdd);
    }

    protected void cachePath(DBObjectTransferable trans) {
        DBObject obj = trans.getDBObject();
        DBObject[] path = trans.getPath();
        if (this.m_paths == null) {
            this.m_paths = new HashMap();
        }
        this.m_paths.put(obj, path);
    }

    public void removeSelectedItems() {
        if (this.m_removeOnShuttle) {
            Object[] selection = this.getList().getSelectedValues();
            int i = 0;
            while (i < selection.length) {
                if (this.m_paths != null) {
                    this.m_paths.remove(selection[i]);
                }
                ++i;
            }
            super.removeSelectedItems();
        }
    }

    public void removeAllSelectableItems() {
        if (this.m_removeOnShuttle) {
            if (this.m_paths != null) {
                this.m_paths.clear();
            }
            super.removeAllSelectableItems();
        }
    }
}

