/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.controls.AbstractTreePicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.util.Assert;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.util.ModelUtil;

public class DBObjectPicker
extends AbstractTreePicker {
    protected static final Transferable[] EMPTY = new DBObjectTransferable[0];
    protected DBObjectRenderer m_dbRenderer;
    protected TreeNodeMaker m_nodeMaker;
    protected DefaultMutableTreeNode m_top;
    protected DefaultTreeModel m_treeModel;
    protected JTree m_tree;
    protected boolean m_remove;

    private void $init$() {
        this.m_dbRenderer = new DBObjectRenderer();
        this.m_nodeMaker = new TreeNodeMaker();
        this.m_top = new DefaultMutableTreeNode("DB_OBJECTS");
        this.m_treeModel = new DefaultTreeModel(this.m_top);
        this.m_tree = new JTree(this.m_treeModel);
    }

    public DBObjectPicker(boolean showChildren, boolean removeOnShuttle) {
        this.$init$();
        this.setTree(this.m_tree);
        this.m_remove = removeOnShuttle;
        this.m_nodeMaker.setShowChildren(showChildren);
        this.setupTree();
    }

    public TreeNodeMaker getNodeMaker() {
        return this.m_nodeMaker;
    }

    public void reloadTree() {
        this.m_treeModel.reload();
    }

    private void setupTree() {
        this.m_tree.setRootVisible(false);
        this.m_dbRenderer.setIncludeIcon(true);
        this.m_tree.setCellRenderer(this.m_dbRenderer);
        this.m_tree.setShowsRootHandles(this.m_nodeMaker.getShowChildren());
        this.m_tree.setScrollsOnExpand(true);
        this.m_tree.getSelectionModel().setSelectionMode(4);
    }

    public void clear() {
        this.m_tree.removeAll();
        this.m_treeModel.reload();
    }

    public void addNode(DefaultMutableTreeNode node) {
        this.m_treeModel.insertNodeInto(node, this.m_top, this.m_top.getChildCount());
    }

    public void addDBObjects(DBObject[] objs) {
        int i = 0;
        while (i < objs.length) {
            if (objs[i] != null) {
                this.findOrAddChild(this.m_top, objs[i], null);
            }
            ++i;
        }
    }

    public void addDBObjectPaths(DBObject[][] paths) {
        int i = 0;
        while (i < paths.length) {
            DefaultMutableTreeNode parent = this.m_top;
            int j = 0;
            while (j < paths[i].length) {
                parent = this.findOrAddChild(parent, paths[i][j], null);
                ++j;
            }
            ++i;
        }
    }

    protected DefaultMutableTreeNode findOrAddChild(DefaultMutableTreeNode parent, DBObject userObj, List addToSelection) {
        return this.findOrAddChild(parent, userObj, addToSelection, false);
    }

    private DefaultMutableTreeNode findOrAddChild(DefaultMutableTreeNode parent, DBObject userObj, List addToSelection, boolean replaceExisting) {
        boolean insertPointChosen = false;
        int insertAt = parent.getChildCount();
        Enumeration<TreeNode> kids = parent.children();
        int j = 0;
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)kids.nextElement();
            int c = this.m_dbRenderer.compare((Object)userObj, next.getUserObject());
            if (c == 0) {
                if (replaceExisting) {
                    insertAt = j;
                    this.m_treeModel.removeNodeFromParent(next);
                    break;
                }
                return next;
            }
            if (c < 1 && !insertPointChosen) {
                insertAt = j;
                insertPointChosen = true;
            }
            ++j;
        }
        DefaultMutableTreeNode node = this.m_nodeMaker.createTreeNode(userObj);
        this.m_treeModel.insertNodeInto(node, parent, insertAt);
        TreePath path = new TreePath(node.getPath());
        if (addToSelection != null) {
            addToSelection.add(path);
        }
        return node;
    }

    private DBObject[] trimPath(Object[] path) {
        int root = -1;
        int j = 0;
        while (j < path.length) {
            if (path[j].equals(this.m_top.getUserObject())) {
                root = j;
                break;
            }
            ++j;
        }
        int size = path.length - (root + 1);
        DBObject[] dbPath = new DBObject[size];
        System.arraycopy(path, root + 1, dbPath, 0, size);
        return dbPath;
    }

    private void removeFromParent(DefaultMutableTreeNode node) {
        if (node != null && node != this.m_top) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            this.m_treeModel.removeNodeFromParent(node);
            if (parent != null && parent.getChildCount() < 1) {
                this.removeFromParent(parent);
            }
        }
    }

    public void setSelectedItems(DBObject[] objs) {
        TreeSelectionModel selectionModel = this.m_tree.getSelectionModel();
        selectionModel.clearSelection();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] != null) {
                this.setSelected(objs[i], this.m_top, selectionModel);
            }
            ++i;
        }
    }

    private void setSelected(DBObject obj, DefaultMutableTreeNode parent, TreeSelectionModel selectionModel) {
        Enumeration<TreeNode> kids = parent.children();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)kids.nextElement();
            if (!obj.equals(node.getUserObject())) continue;
            selectionModel.addSelectionPath(new TreePath(node.getPath()));
            return;
        }
    }

    public boolean isSelectableItemPresent() {
        return this.m_top.getChildCount() > 0;
    }

    public boolean addSelectedItems(Transferable[] addMe) {
        if (this.m_remove) {
            this.m_tree.clearSelection();
            ArrayList selection = new ArrayList();
            int i = 0;
            while (i < addMe.length) {
                try {
                    DBObjectTransferable t = (DBObjectTransferable)addMe[i];
                    DefaultMutableTreeNode parent = this.m_top;
                    DBObject[] path = t.getPath();
                    if (path != null && path.length > 1) {
                        int j = 0;
                        while (j < path.length) {
                            parent = this.findOrAddChild(parent, path[j], null, j == path.length - 1);
                            ++j;
                        }
                    } else {
                        DBObject obj = t.getDBObject();
                        this.findOrAddChild(parent, obj, selection, true);
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
                ++i;
            }
            int size = selection.size();
            if (size > 0) {
                TreePath[] sel = selection.toArray(new TreePath[size]);
                this.m_tree.setSelectionPaths(sel);
            }
        }
        return true;
    }

    public void removeSelectedItems() {
        if (this.m_remove) {
            TreePath[] paths = this.m_tree.getSelectionPaths();
            int i = 0;
            while (paths != null && i < paths.length) {
                if (paths[i] != null) {
                    this.removeFromParent((DefaultMutableTreeNode)paths[i].getLastPathComponent());
                }
                ++i;
            }
        }
    }

    public void removeAllSelectableItems() {
        if (this.m_remove) {
            this.m_top = new DefaultMutableTreeNode("DB_OBJECTS");
            this.m_treeModel.setRoot(this.m_top);
            this.m_treeModel.reload();
        }
    }

    public Transferable createTransferable(TreePath treePath) {
        DBObjectTransferable retval = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object obj = node.getUserObject();
        if (obj instanceof ChildDBObject && ((ChildDBObject)obj).getParent() == null) {
            ((ChildDBObject)obj).setParent((DBObject)((DefaultMutableTreeNode)node.getParent()).getUserObject());
        }
        Object[] path = node.getUserObjectPath();
        if (obj != null && obj instanceof DBObject) {
            if (path == null) {
                retval = new DBObjectTransferable((DBObject)obj);
            } else {
                DBObject[] dbPath = this.trimPath(path);
                retval = new DBObjectTransferable((DBObject)obj, dbPath);
            }
        }
        return retval;
    }

    public Transferable[] getAllSelectableItems() {
        ArrayList<DBObjectTransferable> retval = new ArrayList<DBObjectTransferable>();
        Enumeration<TreeNode> kids = this.m_top.children();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)kids.nextElement();
            DBObject obj = (DBObject)node.getUserObject();
            retval.add(new DBObjectTransferable(obj));
        }
        if (retval.size() > 0) {
            return retval.toArray(new Transferable[retval.size()]);
        }
        return EMPTY;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Transferable[] selection = this.getSelectedItems();
        if (selection != null) {
            DataFlavor[] retval = new DataFlavor[selection.length];
            int i = 0;
            while (i < retval.length) {
                retval[i] = ((DBObjectTransferable)selection[i]).getPrimaryFlavor();
                ++i;
            }
            return retval;
        }
        return null;
    }

    public boolean canAcceptFlavors(DataFlavor[] df) {
        int i = 0;
        while (i < df.length) {
            Class<?> clz;
            if (df[i] != null && ModelUtil.areEqual(clz = df[i].getDefaultRepresentationClass(), DBObjectTransferable.class)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void valueChanged(TreeSelectionEvent e) {
        super.valueChanged(e);
    }
}

