/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.javatools.icons.OracleIcons;

public class ListButtons
extends JPanel
implements ListSelectionListener,
ActionListener {
    protected DefaultListModel m_listModel;
    protected JList m_list;
    protected Helper m_helper;
    protected JButton m_addButton;
    protected JButton m_removeButton;
    protected JButton m_upButton;
    protected JButton m_downButton;

    private void $init$() {
        this.m_addButton = new JButton();
        this.m_removeButton = new JButton();
        this.m_upButton = new JButton();
        this.m_downButton = new JButton();
    }

    public ListButtons(JList list) {
        this(list, null);
    }

    public ListButtons(JList list, Helper helper) {
        this.$init$();
        this.m_helper = helper;
        this.m_list = list;
        list.addListSelectionListener(this);
        ListModel model = list.getModel();
        if (!(model instanceof DefaultListModel)) {
            throw new IllegalArgumentException("list must be pre-populated with a DefaultListModel");
        }
        this.m_listModel = (DefaultListModel)model;
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void sizeUp(JButton button) {
        Dimension size = new Dimension(28, 25);
        button.setPreferredSize(size);
        button.setMaximumSize(size);
        button.setMinimumSize(size);
    }

    protected void layoutComponents() {
        this.m_addButton.setName("BTN_ADD");
        this.m_removeButton.setName("BTN_REMOVE");
        this.m_upButton.setName("BTN_UP");
        this.m_downButton.setName("BTN_DOWN");
        this.sizeUp(this.m_upButton);
        this.m_upButton.setIcon(OracleIcons.getIcon((String)"previous.png"));
        String utttext = this.m_helper == null ? UIArb.getString(475) : this.m_helper.getUpTooltipText();
        DBObjectRenderer.setToolTipText(this.m_upButton, utttext);
        this.m_upButton.addActionListener(this);
        this.sizeUp(this.m_downButton);
        this.m_downButton.setIcon(OracleIcons.getIcon((String)"next.png"));
        String dtttext = this.m_helper == null ? UIArb.getString(158) : this.m_helper.getDownTooltipText();
        DBObjectRenderer.setToolTipText(this.m_downButton, dtttext);
        this.m_downButton.addActionListener(this);
        this.sizeUp(this.m_addButton);
        this.m_addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        String atttext = this.m_helper == null ? UIArb.getString(37) : this.m_helper.getAddTooltipText();
        DBObjectRenderer.setToolTipText(this.m_addButton, atttext);
        this.m_addButton.addActionListener(this);
        this.sizeUp(this.m_removeButton);
        this.m_removeButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        String rtttext = this.m_helper == null ? UIArb.getString(729) : this.m_helper.getRemoveTooltipText();
        DBObjectRenderer.setToolTipText(this.m_removeButton, rtttext);
        this.m_removeButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        int y = 0;
        if (this.m_helper != null && this.m_helper.includeAddRemoveButtons()) {
            this.add((Component)this.m_addButton, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_removeButton, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
        if (this.m_helper == null || this.m_helper.includeReorderButtons()) {
            this.add((Component)this.m_upButton, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)this.m_downButton, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void valueChanged(ListSelectionEvent e) {
        this.enableButtons();
    }

    public void enableButtons() {
        boolean removeEnabled = false;
        boolean upEnabled = false;
        boolean downEnabled = false;
        int sel = this.m_list.getSelectedIndex();
        Object val = sel != -1 ? this.m_listModel.get(sel) : null;
        int[] selection = this.m_list.getSelectedIndices();
        if (selection.length == 1) {
            if (val != null) {
                removeEnabled = this.m_helper == null || this.m_helper.canRemove() && this.m_helper.canRemove(val);
                Object above = sel > 0 ? this.m_listModel.get(sel - 1) : null;
                Object below = sel < this.m_listModel.getSize() - 1 ? this.m_listModel.get(sel + 1) : null;
                upEnabled = above != null && (this.m_helper == null || this.m_helper.canReorder() && this.m_helper.canMoveUp(val) && this.m_helper.canMoveDown(above));
                downEnabled = below != null && (this.m_helper == null || this.m_helper.canReorder() && this.m_helper.canMoveDown(val) && this.m_helper.canMoveUp(below));
            }
        } else if (selection.length > 1) {
            removeEnabled = true;
            if (this.m_helper != null) {
                int i = 0;
                while (removeEnabled && i < selection.length) {
                    Object rem = this.m_listModel.get(selection[i]);
                    removeEnabled = this.m_helper.canRemove() && this.m_helper.canRemove(rem);
                    ++i;
                }
            }
        }
        this.m_removeButton.setEnabled(removeEnabled);
        this.m_upButton.setEnabled(upEnabled);
        this.m_downButton.setEnabled(downEnabled);
        this.m_addButton.setEnabled(this.m_helper == null || this.m_helper.canAdd() && this.m_helper.canAdd(val));
    }

    public void setButtonNames(String panelName) {
        String prefix;
        String string = prefix = panelName != null ? panelName : "ListButtons.";
        if (!prefix.endsWith(".")) {
            prefix = prefix + " ";
        }
        this.m_removeButton.setName(prefix + "ButtonRemove");
        this.m_upButton.setName(prefix + "ButtonUp");
        this.m_downButton.setName(prefix + "ButtonDown");
        this.m_addButton.setName(prefix + "ButtonAdd");
    }

    private Object swap(int i1, int i2) {
        Object o1 = this.m_listModel.getElementAt(i1);
        Object o2 = this.m_listModel.getElementAt(i2);
        this.m_listModel.setElementAt(o1, i2);
        this.m_listModel.setElementAt(o2, i1);
        return o1;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.m_helper != null) {
            int sel;
            if (source == this.m_addButton) {
                this.m_helper.addToList();
            } else if (source == this.m_removeButton) {
                this.m_helper.removeFromList();
            } else if (source == this.m_upButton) {
                int sel2 = this.m_list.getSelectedIndex();
                if (sel2 > 0) {
                    Object obj = this.swap(sel2--, sel2);
                    this.m_list.setSelectedIndex(sel2);
                    this.m_helper.objectMovedUp(obj);
                }
            } else if (source == this.m_downButton && (sel = this.m_list.getSelectedIndex()) < this.m_listModel.getSize() - 1) {
                Object obj = this.swap(sel++, sel);
                this.m_list.setSelectedIndex(sel);
                this.m_helper.objectMovedDown(obj);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.enableButtons();
        } else {
            this.m_addButton.setEnabled(enabled);
            this.m_removeButton.setEnabled(enabled);
            this.m_upButton.setEnabled(enabled);
            this.m_downButton.setEnabled(enabled);
        }
    }

    public static interface Helper {
        public boolean includeAddRemoveButtons();

        public boolean includeReorderButtons();

        public boolean canRemove();

        public boolean canRemove(Object var1);

        public boolean canAdd();

        public boolean canAdd(Object var1);

        public boolean canReorder();

        public boolean canMoveUp(Object var1);

        public boolean canMoveDown(Object var1);

        public String getUpTooltipText();

        public String getDownTooltipText();

        public String getAddTooltipText();

        public String getRemoveTooltipText();

        public void addToList();

        public void removeFromList();

        public void objectMovedUp(Object var1);

        public void objectMovedDown(Object var1);
    }

    public static abstract class HelperAdapter
    implements Helper {
        public boolean includeAddRemoveButtons() {
            return true;
        }

        public boolean includeReorderButtons() {
            return true;
        }

        public boolean canRemove(Object val) {
            return true;
        }

        public boolean canRemove() {
            return true;
        }

        public boolean canAdd(Object val) {
            return true;
        }

        public boolean canAdd() {
            return true;
        }

        public boolean canMoveUp(Object val) {
            return true;
        }

        public boolean canMoveDown(Object val) {
            return true;
        }

        public boolean canReorder() {
            return true;
        }

        public String getAddTooltipText() {
            return null;
        }

        public String getRemoveTooltipText() {
            return null;
        }

        public String getUpTooltipText() {
            return null;
        }

        public String getDownTooltipText() {
            return null;
        }

        public void objectMovedUp(Object obj) {
        }

        public void objectMovedDown(Object obj) {
        }
    }
}

