/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.ora.DatabaseLink;

public class NameAndPublicSchemaEditor
extends NameAndSchemaEditor {
    public static final String PUBLIC = "PUBLIC";
    private Schema m_lastSchema;
    private JCheckBox m_chkPublic;

    private void $init$() {
        this.m_chkPublic = new JCheckBox();
    }

    public NameAndPublicSchemaEditor() {
        this.$init$();
        DBUIResourceHelper reshelp = new DBUIResourceHelper("NameAndPublicSchemaEditor");
        reshelp.resButton(this.m_chkPublic, UIArb.getString(515), "Public");
        this.m_chkPublic.addActionListener(this);
        this.add(this.m_chkPublic, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void commit() throws TraversalException {
        super.commit();
        boolean isPublic = this.m_chkPublic.isSelected();
        this.commitPublic(isPublic);
    }

    private void commitPublic(boolean isPublic) {
        SchemaObject obj = this.getSchemaObject();
        if (obj instanceof Synonym) {
            ((Synonym)obj).setPublic(isPublic);
        } else if (obj instanceof DatabaseLink) {
            ((DatabaseLink)obj).setPublic(isPublic);
        }
    }

    public void init(SchemaObject obj, SchemaObject origObj, SchemaObjectInfoVerifier verifier, DBObjectProvider pro, Schema[] schemas, boolean canEdit) {
        super.init(obj, origObj, verifier, pro, schemas, canEdit);
        boolean isPublic = false;
        if (obj instanceof Synonym) {
            isPublic = ((Synonym)obj).isPublic();
        } else if (obj instanceof DatabaseLink) {
            isPublic = ((DatabaseLink)obj).isPublic();
        }
        this.setSchema(isPublic);
        this.m_chkPublic.setEnabled(canEdit && (verifier == null || verifier.canChangeSchema()));
    }

    private void setSchema(boolean isPublic) {
        this.m_chkPublic.setSelected(isPublic);
        SchemaPicker cmbSchema = this.getSchemaPicker();
        DBObjectProvider pro = this.getProvider();
        this.m_lastSchema = this.getSchemaObject().getSchema();
        if (isPublic) {
            Schema ps = null;
            try {
                ps = this.getProvider().getSchema(PUBLIC);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "error finding PUBLIC schema", dbe);
            }
            if (ps == null) {
                ps = new Schema(PUBLIC);
            }
            cmbSchema.setEditable(true);
            cmbSchema.setSelectedItem(ps);
            cmbSchema.setEnabled(false);
            cmbSchema.setEditable(false);
        } else {
            SchemaObjectInfoVerifier verifier = this.getVerifier();
            boolean enabled = verifier == null || verifier.canChangeSchema();
            boolean editable = verifier == null || verifier.canCreateSchema();
            cmbSchema.setEnabled(enabled);
            cmbSchema.setEditable(editable);
            if (this.m_lastSchema == null || PUBLIC.equals(this.m_lastSchema.getName())) {
                try {
                    this.m_lastSchema = pro.getDefaultSchema();
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            if (this.m_lastSchema != null) {
                cmbSchema.setSelectedItem(this.m_lastSchema);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object s;
        Object source = e.getSource();
        SchemaPicker cmbSchema = this.getSchemaPicker();
        if (source == this.m_chkPublic) {
            boolean isPublic = this.m_chkPublic.isSelected();
            this.setSchema(isPublic);
            this.commitPublic(isPublic);
        } else if (source == cmbSchema && (s = cmbSchema.getSelectedItem()) instanceof Schema && ((Schema)s).getName().equals(PUBLIC)) {
            this.setSchema(true);
        }
        super.actionPerformed(e);
    }
}

