/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;

public class NameAndSchemaAdvancedEditor
extends NameAndSchemaEditor
implements PanelLibrary.HeaderPanel {
    protected static final String SIMPLE = "Simple";
    private JCheckBox m_advanced;
    private boolean m_enteredOnce;
    private PanelLibrary m_panels;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.m_advanced = new JCheckBox();
        this.m_enteredOnce = false;
    }

    public NameAndSchemaAdvancedEditor() {
        this.$init$();
        DBUIResourceHelper reshelp = new DBUIResourceHelper("NameAndSchemaAdvancedEditor");
        this.m_advanced.setSelected(false);
        reshelp.resButton(this.m_advanced, UIArb.getString(833), "Advanced");
        this.add(this.m_advanced, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.m_advanced.addActionListener(this);
    }

    static {
        $assertionsDisabled = NameAndSchemaAdvancedEditor.class.desiredAssertionStatus() ^ true;
    }

    public void onEntry(TraversableContext data) {
        block7: {
            super.onEntry(data);
            if (!this.m_enteredOnce) {
                this.m_enteredOnce = true;
                this.m_panels = (PanelLibrary)data.find("PANEL_LIBRARY");
                if (this.isEditing() || !ModelUtil.hasNonNullElement((Object[])this.getSimpleNavigables())) {
                    this.m_advanced.setVisible(false);
                } else {
                    this.m_advanced.setVisible(true);
                    if (this.getAdvancedPreference()) {
                        this.m_advanced.setSelected(true);
                    } else {
                        this.m_advanced.setSelected(false);
                        try {
                            this.showSimplePanel();
                        }
                        catch (TraversalException te) {
                            DBLog.getLogger().log(Level.WARNING, "traversal exception on init", te);
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError((Object)te.getMessage());
                        }
                    }
                }
            }
        }
    }

    protected void showSimplePanel() throws TraversalException {
        this.changePanels(SIMPLE, this.getSimpleNavigables());
    }

    protected final Navigable[] getSimpleNavigables() {
        List<Navigable> navs = this.getPanelLibrary().getSimpleNavigables();
        return navs == null ? new Navigable[]{} : navs.toArray(new Navigable[navs.size()]);
    }

    protected void showAdvancedPanel() throws TraversalException {
        this.changePanels("DEFAULT_PANEL", null);
    }

    protected boolean isAdvancedLayout() {
        return this.m_advanced.isSelected();
    }

    protected PanelLibrary getPanelLibrary() {
        if (!this.m_enteredOnce) {
            throw new IllegalStateException("can't get panel library until onEntry has been called");
        }
        return this.m_panels;
    }

    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_advanced) {
            if (this.m_advanced.isSelected()) {
                try {
                    this.showAdvancedPanel();
                }
                catch (TraversalException te) {
                    te.showMessageDialog((Component)((Object)this));
                    this.m_advanced.setSelected(false);
                }
            } else {
                try {
                    this.showSimplePanel();
                }
                catch (TraversalException te) {
                    te.showMessageDialog((Component)((Object)this));
                    this.m_advanced.setSelected(true);
                }
            }
        } else {
            super.actionPerformed(ev);
        }
    }

    private boolean getAdvancedPreference() {
        DatabaseIdePreferences prefs = DatabaseIdePreferences.getPreferences();
        if (prefs != null) {
            return prefs.isAdvancedView(this.getPanelLibrary().getType());
        }
        return false;
    }

    public void validatePanelChange(TraversableContext data) throws TraversalException {
    }

    public void commit() throws TraversalException {
        super.commit();
        DatabaseIdePreferences prefs = DatabaseIdePreferences.getPreferences();
        if (prefs != null) {
            prefs.setAdvancedView(this.getPanelLibrary().getType(), this.m_advanced.isSelected());
        }
    }
}

