/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameTextField;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.DBTraversablePanel;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;

public class NameAndSchemaEditor
extends DBTraversablePanel
implements ActionListener {
    private List<PanelLibrary.HeaderPanelListener> m_list;
    private final SchemaPicker m_cmbOwner;
    private final NameTextField m_fldName;
    private JLabel m_lblPlsqlLowerCase;
    private JCheckBox m_chkPlsqlLowerCase;
    protected boolean m_listening;
    private SchemaObject m_originalObject;
    private Schema[] m_schemas;
    private SchemaObject m_schemaObject;
    private DBObjectProvider m_pro;
    private SchemaObjectInfoVerifier m_verifier;

    private void $init$() {
        this.m_list = new ArrayList<PanelLibrary.HeaderPanelListener>();
        this.m_cmbOwner = new SchemaPicker();
        this.m_fldName = new NameTextField();
        this.m_lblPlsqlLowerCase = new JLabel();
        this.m_chkPlsqlLowerCase = new JCheckBox();
        this.m_verifier = null;
    }

    public NameAndSchemaEditor() {
        this.$init$();
        this.buildPanel((JPanel)((Object)this));
    }

    private void buildPanel(JPanel pnlInfo) {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("NameAndSchemaEditor");
        pnlInfo.setLayout(new GridBagLayout());
        JLabel lblOwner = new JLabel();
        this.m_cmbOwner.addActionListener(this);
        reshelp.resLabel(lblOwner, this.m_cmbOwner, UIArb.getString(474), "Schema");
        pnlInfo.add((Component)lblOwner, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        pnlInfo.add((Component)this.m_cmbOwner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblName = new JLabel();
        reshelp.resLabel(lblName, this.m_fldName, UIArb.getString(364), "Name");
        this.m_fldName.setColumns(24);
        pnlInfo.add((Component)lblName, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        pnlInfo.add((Component)this.m_fldName, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        pnlInfo.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        reshelp.resButton(this.m_chkPlsqlLowerCase, UIArb.getString(693), "PlSqlLowercase");
        pnlInfo.add((Component)this.m_chkPlsqlLowerCase, new GridBagConstraints(0, 100, 0, 0, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void commitSchema() throws TraversalException {
        Schema oldSchema = this.m_schemaObject.getSchema();
        Schema schema = this.m_cmbOwner.getSchema();
        this.m_schemaObject.setSchema(schema);
        DBObjectChange.firePropertyChanged((SchemaObject)this.m_schemaObject, (PropertyChangeEvent[])new PropertyChangeEvent[]{new PropertyChangeEvent(this.m_schemaObject, "schema", oldSchema, schema)});
    }

    private Schema[] validateSchemaPermissions(Schema[] schemas) {
        if (this.m_pro instanceof Database) {
            ArrayList<Schema> retval = new ArrayList<Schema>();
            String type = this.m_schemaObject.getType();
            int i = 0;
            while (i < schemas.length) {
                if (this.m_pro.hasPriviledge(type, schemas[i], this.isEditing() ? "MODIFY" : "CREATE")) {
                    retval.add(schemas[i]);
                }
                ++i;
            }
            return retval.toArray(new Schema[retval.size()]);
        }
        return schemas;
    }

    protected SchemaObjectInfoVerifier getVerifier() {
        return this.m_verifier;
    }

    protected SchemaPicker getSchemaPicker() {
        return this.m_cmbOwner;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected final SchemaObject getSchemaObject() {
        return this.m_schemaObject;
    }

    protected final boolean isEditing() {
        return this.m_originalObject != null;
    }

    protected final SchemaObject getOriginalObject() {
        return this.m_originalObject;
    }

    protected void init(SchemaObject obj, SchemaObject origObj, SchemaObjectInfoVerifier verifier, DBObjectProvider pro, Schema[] schemas, boolean canEdit) {
        this.m_originalObject = origObj;
        this.m_pro = pro;
        this.m_schemaObject = obj;
        this.m_schemas = schemas;
        this.m_verifier = verifier;
        this.m_cmbOwner.init(this.m_pro, obj.getSchema(), this.validateSchemaPermissions(this.m_schemas));
        this.m_fldName.init((DBObject)obj, (DBObject)origObj, pro);
        this.m_cmbOwner.setEnabled(canEdit && (this.m_verifier == null || this.m_verifier.canChangeSchema()));
        this.m_cmbOwner.setEditable(this.m_verifier == null && !(pro instanceof Database) || this.m_verifier != null && this.m_verifier.canCreateSchema());
        this.m_fldName.setEnabled(canEdit && (this.m_verifier == null || this.m_verifier.canChangeName()));
        this.m_listening = true;
        if (this.m_schemaObject instanceof SourceObject) {
            this.m_lblPlsqlLowerCase.setVisible(true);
            this.m_chkPlsqlLowerCase.setVisible(true);
            this.m_chkPlsqlLowerCase.setSelected(GlobalSettings.getInstance().isNewPlSqlLowerCase());
            this.m_chkPlsqlLowerCase.setEnabled(canEdit);
        } else {
            this.m_lblPlsqlLowerCase.setVisible(false);
            this.m_chkPlsqlLowerCase.setVisible(false);
        }
    }

    public void commit() throws TraversalException {
        this.m_listening = false;
        this.commitSchema();
        this.m_fldName.commit();
        if (this.m_schemaObject instanceof SourceObject) {
            GlobalSettings.getInstance().setNewPlSqlLowerCase(this.m_chkPlsqlLowerCase.isSelected());
        }
    }

    public void onEntry(TraversableContext data) {
        DBObjectProvider pro = (DBObjectProvider)data.get("DBObjectProvider");
        Schema[] schemas = (Schema[])data.get("SchemaList");
        SchemaObject obj = (SchemaObject)data.get("NewObject");
        SchemaObject origObj = (SchemaObject)data.get("OriginalObject");
        SchemaObjectInfoVerifier v = (SchemaObjectInfoVerifier)data.get("SchemaObjectInfoVerifier");
        boolean canEdit = (Boolean)data.find("DBObjectIsEditable");
        this.init(obj, origObj, v, pro, schemas, canEdit);
    }

    public void onExit(TraversableContext data) throws TraversalException {
        this.commit();
    }

    public Component getDefaultFocusComponent() {
        return this.m_fldName;
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.m_listening) {
            try {
                this.commitSchema();
                this.m_fldName.getTimer().restart();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
        }
    }

    public final void addHeaderPanelListener(PanelLibrary.HeaderPanelListener list) {
        this.m_list.add(list);
    }

    public final boolean removeHeaderPanelListener(PanelLibrary.HeaderPanelListener list) {
        return this.m_list.remove(list);
    }

    protected final void changePanels(String key, Navigable[] navs) throws TraversalException {
        for (PanelLibrary.HeaderPanelListener list : this.m_list) {
            list.panelSetChange(key, navs);
        }
    }
}

