/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectListPicker;
import oracle.ide.db.util.NameController;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class SchemaObjectTargetPicker
extends DBObjectListPicker
implements DocumentListener,
ListSelectionListener,
ShuttleListener,
Traversable {
    private JPanel m_panel;
    private JLabel m_label;
    private JTextField m_newName;
    private int m_current;
    private boolean m_commitPending;
    private boolean m_ignoreList;
    private boolean m_ignoreField;
    private DBObjectProvider m_provider;
    private NameController m_nameController;

    private void $init$() {
        this.m_current = -1;
    }

    public SchemaObjectTargetPicker() {
        this(new JList());
    }

    public SchemaObjectTargetPicker(NameController nameController) {
        this(new JList());
        this.m_nameController = nameController;
    }

    public SchemaObjectTargetPicker(JList list) {
        super(list);
        this.$init$();
    }

    private void setupNamePanel() {
        this.m_panel = new JPanel();
        this.m_label = new JLabel();
        this.getList().addListSelectionListener(this);
        this.m_panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0);
        gbc.gridwidth = 2;
        this.m_panel.add(super.getComponent(), gbc);
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.m_panel.add((Component)this.m_label, gbc);
        if (this.m_nameController != null) {
            this.m_newName = new JTextField();
            ResourceUtils.resLabel((JLabel)this.m_label, (Component)this.m_newName, (String)this.m_nameController.getNameLabel());
            this.m_newName.getDocument().addDocumentListener(this);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.m_panel.add((Component)this.m_newName, gbc);
        }
    }

    public JLabel getLabel() {
        return this.m_label;
    }

    private void populateName() {
        if (this.m_nameController != null) {
            this.m_ignoreField = true;
            try {
                this.m_newName.setText(null);
                SchemaObjectDescriptor desc = (SchemaObjectDescriptor)this.getList().getSelectedValue();
                Object[] selection = this.getList().getSelectedValues();
                if (desc != null && selection != null && selection.length == 1) {
                    this.m_newName.setEnabled(true);
                    String otherName = desc.getOtherName();
                    if (!ModelUtil.hasLength((String)otherName)) {
                        otherName = this.m_nameController.getDefaultName(desc.getType(), desc.getName());
                        desc.setOtherName(otherName);
                    }
                    this.m_newName.setText(this.m_nameController.getExternalName(otherName));
                    this.m_current = this.getList().getSelectedIndex();
                } else {
                    this.m_newName.setEnabled(false);
                    this.m_newName.setText(null);
                    this.m_current = -1;
                }
            }
            finally {
                this.m_commitPending = false;
                this.m_ignoreField = false;
            }
        }
    }

    private boolean commitName(boolean showDialog) {
        SchemaObjectDescriptor current;
        if (this.m_current > -1 && this.m_commitPending && (current = (SchemaObjectDescriptor)this.getList().getModel().getElementAt(this.m_current)) != null) {
            Collection names;
            boolean dup;
            boolean nameInvalid = false;
            String newExtName = this.m_newName.getText().trim();
            String originalName = current.getOtherName();
            if (this.m_nameController != null) {
                try {
                    this.m_nameController.validateName(current.getType(), newExtName);
                }
                catch (InvalidNameException ine) {
                    if (showDialog) {
                        MessageDialog.error((Component)this.getList(), (Object)ine.getMessage(), (String)UIArb.getString(177), null);
                    }
                    nameInvalid = true;
                }
            }
            String newName = this.m_nameController.getInternalName(newExtName);
            if (!nameInvalid && ModelUtil.areDifferent((Object)newName, (Object)originalName) && !this.m_nameController.canHaveDuplicateNames() && (dup = (names = this.getExistingNames(current)).contains(newName))) {
                if (showDialog) {
                    MessageDialog.error((Component)this.getList(), (Object)UIArb.format(518, current.getName()), (String)UIArb.getString(177), null);
                }
                nameInvalid = true;
            }
            if (nameInvalid) {
                this.m_ignoreList = true;
                try {
                    this.getList().setSelectedIndex(this.m_current);
                    this.m_newName.requestFocusInWindow();
                }
                finally {
                    this.m_ignoreList = false;
                }
                return false;
            }
            if (ModelUtil.hasLength((String)newName) && ModelUtil.areDifferent((Object)newName, (Object)originalName)) {
                current.setOtherName(newName);
            } else {
                current.setOtherName(null);
            }
            this.getList().repaint();
        }
        return true;
    }

    private Collection getExistingNames(SchemaObjectDescriptor notMe) {
        ArrayList<String> names = new ArrayList<String>();
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        int i = 0;
        while (i < model.size()) {
            SchemaObjectDescriptor next = (SchemaObjectDescriptor)model.get(i);
            if (notMe == null || notMe != next) {
                names.add(next.getName());
            }
            ++i;
        }
        return names;
    }

    public Component getComponent() {
        if (this.m_panel == null && this.m_nameController != null) {
            this.setupNamePanel();
        }
        if (this.m_panel != null) {
            return this.m_panel;
        }
        return super.getComponent();
    }

    public boolean addSelectedItems(Transferable[] add) {
        if (!this.commitName(false)) {
            return false;
        }
        if (!(this.getList().getModel() instanceof DefaultListModel)) {
            return false;
        }
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        ListSelectionModel select = this.getList().getSelectionModel();
        this.m_ignoreList = true;
        select.clearSelection();
        this.m_ignoreList = false;
        int firstIndex = model.getSize();
        int numberAdded = 0;
        int i = 0;
        while (i < add.length) {
            if (add[i] instanceof DBObjectTransferable) {
                this.cachePath((DBObjectTransferable)add[i]);
                DBObject toAdd = ((DBObjectTransferable)add[i]).getDBObject();
                if (toAdd instanceof SchemaObject) {
                    SchemaObjectDescriptor desc = new SchemaObjectDescriptor((SchemaObject)toAdd);
                    int index = model.getSize();
                    model.add(index, desc);
                    ++numberAdded;
                }
            }
            ++i;
        }
        if (numberAdded > 0) {
            this.m_ignoreList = true;
            select.setSelectionInterval(firstIndex, firstIndex + numberAdded - 1);
            this.m_ignoreList = false;
        }
        return true;
    }

    public void removeSelectedItems() {
        this.m_current = -1;
        super.removeSelectedItems();
    }

    public void removeAllSelectableItems() {
        this.m_current = -1;
        super.removeAllSelectableItems();
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (!this.commitName(true)) {
            throw new TraversalException(null);
        }
    }

    public void onEntry(TraversableContext tc) {
        this.m_provider = (DBObjectProvider)tc.get("TargetDBObjectProvider");
        if (this.m_newName != null) {
            this.populateName();
        }
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public String getHelpID() {
        return null;
    }

    public Object getExitTransition() {
        return null;
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.m_ignoreField) {
            this.m_commitPending = true;
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.m_ignoreField) {
            this.m_commitPending = true;
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.m_ignoreField) {
            this.m_commitPending = true;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.m_ignoreList && this.commitName(true)) {
            this.populateName();
        }
    }

    public void shuttleItemsMoved(ShuttleEvent p0) {
        if (this.getList().getSelectedIndex() != this.m_current) {
            this.populateName();
        }
    }

    public void shuttleItemsRemoved(ShuttleEvent p0) {
        this.populateName();
    }

    public void shuttleItemsReordered(ShuttleEvent p0) {
        this.populateName();
    }
}

