/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.util.SchemaObjectBuilder;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDBEditorFactory
implements DBEditorFactory {
    private Map<String, Object> m_libraries;

    private void $init$() {
        this.m_libraries = new HashMap<String, Object>();
    }

    protected BaseDBEditorFactory() {
        this.$init$();
    }

    protected PanelLibrary getPanelLibrary(String dbObjectType) {
        Object obj = this.m_libraries.get(dbObjectType);
        if (obj instanceof Class) {
            try {
                PanelLibrary lib = (PanelLibrary)((Class)obj).newInstance();
                this.initializeLibrary(lib);
                this.m_libraries.put(dbObjectType, lib);
                PanelLibrary panelLibrary = lib;
                return panelLibrary;
            }
            catch (Exception e) {
                DBLog.logStackTrace((Throwable)e);
            }
        } else if (obj instanceof PanelLibrary) {
            return (PanelLibrary)obj;
        }
        return null;
    }

    protected void initializeLibrary(PanelLibrary lib) {
    }

    private boolean purgeLibraryCache() {
        for (String key : this.m_libraries.keySet()) {
            Object obj = this.m_libraries.get(key);
            if (!(obj instanceof PanelLibrary)) continue;
            this.m_libraries.put(key, obj.getClass());
        }
        return true;
    }

    protected void registerLibrary(String dbObjectType, Class<? extends PanelLibrary> libClass) {
        this.m_libraries.put(dbObjectType, libClass);
    }

    @Override
    public String[] listSupportedTypes() {
        return this.m_libraries.keySet().toArray(new String[this.m_libraries.size()]);
    }

    @Override
    public boolean isCreateSupported(String dbObjectType) {
        return this.m_libraries.containsKey(dbObjectType);
    }

    @Override
    public boolean canCreateDBObject(Schema schema, DBObjectProvider pro, String dbObjectType) {
        if (this.m_libraries.containsKey(dbObjectType)) {
            if (pro instanceof Database) {
                return ((Database)pro).hasPriviledge(dbObjectType, schema, "CREATE");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canCreateDBObject(DBObjectTypeNode node) {
        try {
            DBObjectProvider pro = DBObjectProviderFactory.findOrCreateProvider((Object)node.getProviderIdentifier());
            Schema schema = pro.getSchema(node.getSchemaName());
            boolean bl = this.canCreateDBObject(schema, pro, node.getObjectType());
            return bl;
        }
        catch (DBException dbe) {
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public SchemaObject createDBObject(DBObjectTypeNode node) {
        try {
            DBObjectProvider pro = DBObjectProviderFactory.findOrCreateProvider((Object)node.getProviderIdentifier());
            Schema schema = pro.getSchema(node.getSchemaName());
            SchemaObject schemaObject = this.createDBObject(schema, pro, node.getObjectType());
            return schemaObject;
        }
        catch (DBException dbe) {
            SchemaObject schemaObject = null;
            return schemaObject;
        }
    }

    @Override
    public final SchemaObject createDBObject(Schema schema, DBObjectProvider pro, String dbObjectType) {
        return (SchemaObject)this.createDBObject(schema, pro, dbObjectType, null, true);
    }

    @Override
    public DBObject createDBObject(DBObjectNode node, String dbObjectType) {
        Schema schema;
        DBObjectProvider pro = node.getProvider();
        DBObject parent = node.getDBObject();
        try {
            schema = pro.getSchema(node.getSchemaName());
        }
        catch (DBException dbe) {
            schema = new Schema(node.getSchemaName());
        }
        return this.createDBObject(schema, pro, dbObjectType, parent, true);
    }

    @Override
    public final DBObject createDBObject(Schema schema, DBObjectProvider pro, String dbObjectType, DBObject parent, boolean commitToProvider) {
        PanelLibrary lib = this.getPanelLibrary(dbObjectType);
        if (lib != null) {
            try {
                schema = schema == null ? pro.getDefaultSchema() : schema;
            }
            catch (DBException dbe) {
                // empty catch block
            }
            DBObject obj = lib.getObjectForCreate(schema, pro, parent);
            if (this.createDBObject(obj, pro, commitToProvider)) {
                return obj;
            }
        }
        return null;
    }

    @Override
    public final SchemaObject createDBObject(Schema schema, DBObjectProvider pro, SchemaObject template, boolean commitToProvider) {
        PanelLibrary lib = this.getPanelLibrary(template.getType());
        if (lib != null) {
            SchemaObject obj = TemplateExpander.initialiseObject((SchemaObject)template);
            try {
                schema = schema == null ? pro.getDefaultSchema() : schema;
            }
            catch (DBException dbe) {
                // empty catch block
            }
            obj.setSchema(schema);
            if (this.createDBObject((DBObject)obj, pro, commitToProvider)) {
                return obj;
            }
        }
        return null;
    }

    @Override
    public final boolean createDBObject(DBObject newObj, DBObjectProvider pro) {
        return this.createDBObject(newObj, pro, true);
    }

    @Override
    public final boolean createDBObject(DBObject newObj, DBObjectProvider pro, boolean commitToProvider) {
        PanelLibrary lib = this.getPanelLibrary(newObj.getType());
        if (lib != null) {
            Map<String, Class> verifiers;
            Namespace ns;
            Traversable mainPanel;
            List<Navigable> navs;
            if (newObj.getName() == null && newObj instanceof SchemaObject) {
                DBObject defaultObj = lib.getObjectForCreate(((SchemaObject)newObj).getSchema(), pro, null);
                newObj.setName(defaultObj.getName());
            }
            if ((navs = lib.getCreateNavigables(newObj, pro)) != null && (mainPanel = lib.getMainDialogPanel(newObj, pro, null, navs.toArray(new Navigable[navs.size()]))) != null && (ns = this.createNamespace(pro, newObj, null, verifiers = lib.getCreateVerifiers(), false, commitToProvider)) != null) {
                ns.put("PANEL_LIBRARY", (Object)lib);
                String dialogName = "create" + newObj.getType();
                return this.launchDialog(ns, lib.getCreateTitle(), mainPanel, lib, lib.getSize(false), dialogName);
            }
        }
        return false;
    }

    @Override
    public boolean canEditDBObject(DBObjectNode node) {
        return this.canEditDBObject(node.getDBObject(), node.getProvider());
    }

    @Override
    public boolean canEditDBObject(DBObject obj, DBObjectProvider pro) {
        List<Navigable> navs;
        String dbObjectType = obj.getType();
        PanelLibrary lib = this.getPanelLibrary(dbObjectType);
        if (lib != null && (navs = lib.getEditNavigables(obj, pro)) != null) {
            if (pro instanceof Database) {
                return ((Database)pro).hasPriviledge(dbObjectType, DBUtil.getSchema((DBObject)obj), "MODIFY");
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean editDBObject(DBObjectNode node) {
        return this.editDBObject(node.getDBObject(), node.getProvider());
    }

    @Override
    public final boolean editDBObject(DBObject obj, DBObjectProvider pro) {
        return this.editDBObject(obj, pro, obj instanceof SchemaObject);
    }

    @Override
    public final boolean editDBObject(DBObject obj, DBObjectProvider pro, boolean commitToProvider) {
        return this.editDBObject(obj, pro, null, commitToProvider);
    }

    @Override
    public final boolean editDBObject(DBObject obj, DBObjectProvider pro, DBObject child) {
        return this.editDBObject(obj, pro, child, obj instanceof SchemaObject);
    }

    @Override
    public boolean editDBObject(DBObject obj, DBObjectProvider pro, DBObject child, boolean commitToProvider) {
        Map<String, Class> verifiers;
        Namespace ns;
        Traversable mainPanel;
        List<Navigable> navs;
        PanelLibrary lib = this.getPanelLibrary(obj.getType());
        if (lib != null && (navs = lib.getEditNavigables(obj, pro)) != null && (mainPanel = lib.getMainDialogPanel(obj, pro, child, navs.toArray(new Navigable[navs.size()]))) != null && (ns = this.createNamespace(pro, obj, child, verifiers = lib.getEditVerifiers(), true, commitToProvider)) != null) {
            ns.put("PANEL_LIBRARY", (Object)lib);
            String dialogName = "edit" + obj.getType();
            return this.launchDialog(ns, lib.getEditTitle(), mainPanel, lib, lib.getSize(true), dialogName);
        }
        return false;
    }

    @Override
    public String getCreateLabel(String dbObjectType) {
        PanelLibrary lib = this.getPanelLibrary(dbObjectType);
        if (lib != null) {
            return lib.getCreateText();
        }
        return null;
    }

    protected Namespace createNamespace(DBObjectProvider provider, DBObject object, DBObject child, Map<String, Class> verifiers, boolean isEdit, boolean commitToProvider) {
        SchemaObject copy = null;
        Namespace data = new Namespace();
        data.put("DBObjectProvider", (Object)provider);
        data.put("COMMIT_TO_PROVIDER_KEY", (Object)commitToProvider);
        if (object != null) {
            DBObject copyDefault;
            if (object instanceof SchemaObject) {
                if (isEdit) {
                    SchemaObjectBuilder builder = new SchemaObjectBuilder(true);
                    if (!builder.ensureObjectBuilt((SchemaObject)object)) {
                        return null;
                    }
                    copy = object.copyTo(null, true);
                    data.put("OriginalObject", (Object)object);
                    data.put("NewObject", (Object)copy);
                } else {
                    data.put("NewObject", (Object)object);
                }
            } else {
                data.put("NewChildObject", (Object)object);
                data.put("standAlone", (Object)true);
                SchemaObject parent = (SchemaObject)object.getParent();
                if (parent.getID() instanceof TemporaryObjectID) {
                    copy = parent;
                    data.put("NewObject", (Object)parent);
                    try {
                        data.put("OriginalObject", (Object)((TemporaryObjectID)parent.getID()).resolveOriginalID());
                    }
                    catch (DBException e) {
                        FeedbackManager.reportException((Throwable)e);
                    }
                } else {
                    copy = parent.copyTo(null, true);
                    data.put("NewObject", (Object)copy);
                    data.put("OriginalObject", (Object)parent);
                }
            }
            if (child != null && copy != null && (copyDefault = DBUtil.findChildInCopy((DBObject)object, copy, (DBObject)child)) != null) {
                data.put("DefaultChild", (Object)copyDefault);
            }
            try {
                Schema schema = DBUtil.getSchema((DBObject)object);
                data.put("Schema", (Object)schema);
                Schema[] schemas = provider.listSchemas();
                data.put("SchemaList", (Object)schemas);
            }
            catch (DBException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(IdeUtil.getMainWindow(), UIArb.getString(222), (SQLException)cause);
                }
                DBExceptionDialog.showErrorDialog((Component)IdeUtil.getMainWindow(), UIArb.getString(222), ex);
            }
            boolean updatable = isEdit ? this.canUpdateObject(object, provider) : true;
            data.put("DBObjectIsEditable", (Object)updatable);
            if (verifiers != null) {
                for (String key : verifiers.keySet()) {
                    Class cls = verifiers.get(key);
                    try {
                        Object obj = cls.newInstance();
                        if (obj instanceof Verifier) {
                            SchemaObject so = object instanceof SchemaObject ? (SchemaObject)object : DBUtil.getSchemaObject((DBObject)object);
                            Verifier verifier = (Verifier)obj;
                            if (copy == null) {
                                verifier.initializeVerifier(provider, null, so);
                            } else {
                                SchemaObject copySo = copy instanceof SchemaObject ? copy : DBUtil.getSchemaObject((DBObject)copy);
                                verifier.initializeVerifier(provider, so, copySo);
                            }
                            verifier.setEditable(updatable);
                        }
                        data.put(key, obj);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        return data;
    }

    protected boolean canUpdateObject(DBObject obj, DBObjectProvider pro) {
        return true;
    }

    private boolean launchDialog(Namespace data, String title, Traversable panel, PanelLibrary lib, Dimension size, String dialogName) {
        Component initialFocus;
        TDialogLauncher launcher;
        Frame parent = IdeUtil.getMainWindow();
        if (size == null) {
            launcher = new TDialogLauncher((Component)parent, title, panel, data, (DialogRunnerCallback)new SizeKeeperCallback("edit.object"));
        } else {
            launcher = new TDialogLauncher((Component)parent, title, panel, data);
            launcher.setInitialSize(size);
        }
        JEWTDialog dialog = launcher.initDialog();
        dialog.setName(dialogName);
        Boolean updateable = (Boolean)data.get("DBObjectIsEditable");
        if (updateable != null && !updateable.booleanValue()) {
            dialog.setOKButtonEnabled(false);
        }
        if ((initialFocus = lib.getInitialFocus(panel)) != null) {
            dialog.setInitialFocus(initialFocus);
        }
        return launcher.showDialog();
    }
}

