/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.SchemaObject;

public class DBEditorFactoryRegistry {
    private static List<Entry> m_factories = new ArrayList<Entry>();

    private DBEditorFactoryRegistry() {
    }

    public static void registerDBEditorFactory(Class providerClass, DBEditorFactory factory) {
        m_factories.add(new Entry(providerClass, factory));
    }

    public static DBEditorFactory getCreateFactory(DBObjectProvider pro, String dbObjectType) {
        if (pro != null) {
            Class<?> c = pro.getClass();
            ListIterator<Entry> iter = m_factories.listIterator(m_factories.size());
            while (iter.hasPrevious()) {
                Entry e = iter.previous();
                if (!e.m_providerClass.isAssignableFrom(c) || !e.m_factory.isCreateSupported(dbObjectType) && !pro.isNewFromTemplateType(dbObjectType)) continue;
                return e.m_factory;
            }
        }
        return null;
    }

    public static DBEditorFactory getCreateFactory(DBObjectTypeNode node) {
        try {
            DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory(DBObjectProviderFactory.findOrCreateProvider((Object)node.getProviderIdentifier()), node.getObjectType());
            return dBEditorFactory;
        }
        catch (DBException dbe) {
            DBEditorFactory dBEditorFactory = null;
            return dBEditorFactory;
        }
    }

    public static DBEditorFactory getEditFactory(SchemaObject obj, DBObjectProvider pro) {
        if (pro != null) {
            Class<?> c = pro.getClass();
            ListIterator<Entry> iter = m_factories.listIterator(m_factories.size());
            while (iter.hasPrevious()) {
                Entry e = iter.previous();
                if (!e.m_providerClass.isAssignableFrom(c) || !e.m_factory.canEditDBObject((DBObject)obj, pro)) continue;
                return e.m_factory;
            }
        }
        return null;
    }

    public static DBEditorFactory getEditFactory(DBObjectNode node) {
        DBObject obj = node.getDBObject();
        if (obj instanceof SchemaObject) {
            return DBEditorFactoryRegistry.getEditFactory((SchemaObject)obj, node.getProvider());
        }
        return null;
    }

    private static class Entry {
        Class m_providerClass;
        DBEditorFactory m_factory;

        Entry(Class dbClass, DBEditorFactory factory) {
            this.m_providerClass = dbClass;
            this.m_factory = factory;
        }
    }
}

