/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.controls.SchemaObjectTargetPicker;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.SkippingTraversable;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.NameController;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class SelectDBObjectsPanel
extends SkippingTraversable
implements ActionListener,
ItemListener,
DocumentListener,
ShuttleListener,
KeyListener,
CheckBoxListItemStateListener {
    private static final ArrayList<String> NOT_SCHEMA_OBJECT_TYPES = new ArrayList<String>(Arrays.asList("COLUMN", "CONSTRAINT", "INDEX", "SCHEMA"));
    public static final String SELECTED_OBJECTS = "SelectDBObjectsPanel.SELECTED_OBJECTS";
    public static final String SETTINGS_KEY = SelectDBObjectsPanel.class.getName();
    private static final String SETTINGS_AUTO_QUERY_KEY = "autoQuery";
    private static final String SETTINGS_QUERY_KEY = "query";
    private static final String SETTINGS_FILTER_KEY = "filter";
    private static final String SETTINGS_SCHEMA_KEY = "schema";
    private static final String SETTINGS_CONNECTION_KEY = "connection";
    protected WizardCallbacks m_callBacks;
    private boolean m_entered;
    private boolean m_init;
    private Schema m_publicSchema;
    private DBObjectProvider m_pro;
    private SchemaObjectTargetPicker m_chosen;
    private DBObjectSourcePicker m_from;
    private List m_selectedTypes;
    private Timer m_timer;
    private JPanel m_centerPanel;
    private JLabel m_filterLabel;
    private JTextField m_filter;
    private JCheckBox m_autoQuery;
    private JLabel m_schemasLabel;
    private SchemaPicker m_schemas;
    private JButton m_query;
    private DBUIResourceHelper m_reshelp;
    private JEWTDialog m_typesDialog;
    private CheckBoxListModel m_typeBoxes;
    private CheckBoxListPanel m_typesPanel;
    private JLabel m_typesDialogErrorLabel;
    private JLabel m_typeLabel;
    private JButton m_typeButton;
    protected Shuttle m_shuttle;

    private void $init$() {
        this.m_centerPanel = new JPanel();
        this.m_filterLabel = new JLabel();
        this.m_filter = new JTextField();
        this.m_autoQuery = new JCheckBox();
        this.m_schemasLabel = new JLabel();
        this.m_schemas = new SchemaPicker();
        this.m_query = new JButton();
        this.m_reshelp = new DBUIResourceHelper(this.getPanelName());
        this.m_typeLabel = new JLabel();
        this.m_typeButton = new JButton();
        this.m_shuttle = new Shuttle();
    }

    public SelectDBObjectsPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    protected String getPanelName() {
        return "SelectDBObjectsPanel";
    }

    protected void layoutComponents() {
        this.m_centerPanel.setLayout(new GridBagLayout());
        JPanel row1 = this.getRow1();
        this.m_centerPanel.add((Component)row1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel row2 = this.getRow2();
        this.m_centerPanel.add((Component)row2, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_shuttle.addShuttleListener((ShuttleListener)this);
        this.m_reshelp.setName((Component)this.m_shuttle, "Shuttle");
        this.m_centerPanel.add((Component)this.m_shuttle, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.m_centerPanel, "Center");
    }

    private JPanel getRow1() {
        JPanel row1 = new JPanel();
        row1.setLayout(new GridBagLayout());
        this.m_reshelp.resLabel(this.m_schemasLabel, this.m_schemas, UIArb.getString(228), "Schema");
        row1.add((Component)this.m_schemasLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_schemas.addActionListener(this);
        row1.add((Component)this.m_schemas, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 15), 0, 0));
        row1.add((Component)this.m_typeLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_typeButton.addActionListener(this);
        this.m_reshelp.resButton(this.m_typeButton, UIArb.getString(885), "FilterTypes");
        row1.add((Component)this.m_typeButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return row1;
    }

    private JPanel getRow2() {
        JPanel row2 = new JPanel();
        row2.setLayout(new GridBagLayout());
        this.m_reshelp.resLabel(this.m_filterLabel, this.m_filter, UIArb.getString(356), "Filter");
        row2.add((Component)this.m_filterLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_filter.setText("%");
        this.m_filter.getDocument().addDocumentListener(this);
        this.m_filter.addKeyListener(this);
        row2.add((Component)this.m_filter, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_autoQuery, UIArb.getString(53), "AutoQuery");
        this.m_autoQuery.addItemListener(this);
        row2.add((Component)this.m_autoQuery, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_query, UIArb.getString(143), "Query");
        this.m_query.addActionListener(this);
        row2.add((Component)this.m_query, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return row2;
    }

    private void setupTypesModel() {
        this.m_typesPanel = null;
        this.m_typeBoxes = new CheckBoxListModel();
        Object[] availableTypes = this.getAvailableTypes();
        Arrays.sort(availableTypes);
        int i = 0;
        while (i < availableTypes.length) {
            String label = DBTypeDisplayRegistry.getDisplayName((String)availableTypes[i]);
            Icon icon = DBTypeDisplayRegistry.getNodeIcon((String)availableTypes[i]);
            this.m_typeBoxes.addElement(availableTypes[i], icon, true, true, label);
            ++i;
        }
        this.m_typeBoxes.addCheckBoxStateListener((CheckBoxListItemStateListener)this);
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected NameController getNameController() {
        return null;
    }

    protected DBObjectSourcePicker getFromPicker() {
        if (this.m_from == null) {
            this.m_from = new DBObjectSourcePicker(this.m_pro, false, true);
        }
        return this.m_from;
    }

    protected ItemPicker getToPicker() {
        if (this.m_chosen == null) {
            NameController nameController = this.getNameController();
            this.m_chosen = new SchemaObjectTargetPicker(nameController);
            if (nameController != null) {
                this.m_shuttle.addShuttleListener((ShuttleListener)this.m_chosen);
            }
        }
        return this.m_chosen;
    }

    protected boolean canFinish() {
        return false;
    }

    protected boolean canAlwaysNext() {
        return false;
    }

    protected boolean canRenameObjects() {
        return false;
    }

    protected String[] getAvailableTypes() {
        ItemPicker to = this.getToPicker();
        if (to instanceof SchemaObjectTargetPicker) {
            DBObjectProvider source = this.m_pro;
            DBObjectProvider target = ((SchemaObjectTargetPicker)to).getProvider();
            if (source != null) {
                ArrayList<String> retval = new ArrayList<String>();
                String[] types = this.listSupportedSchemaTypes(source);
                List<String> targTypes = target != null ? Arrays.asList(this.listSupportedSchemaTypes(target)) : null;
                int i = 0;
                while (i < types.length) {
                    if (targTypes == null || targTypes.contains(types[i])) {
                        retval.add(types[i]);
                    }
                    ++i;
                }
                return retval.toArray(new String[retval.size()]);
            }
        }
        return new String[]{"TABLE", "VIEW"};
    }

    private String[] listSupportedSchemaTypes(DBObjectProvider pro) {
        ArrayList<String> allTypes = new ArrayList<String>(Arrays.asList(pro.listObjectTypes()));
        allTypes.removeAll(NOT_SCHEMA_OBJECT_TYPES);
        return allTypes.toArray(new String[allTypes.size()]);
    }

    protected String getProviderKey() {
        return "DBObjectProvider";
    }

    public final void onEntry(TraversableContext dataContext) {
        super.onEntry(dataContext);
        this.m_callBacks = dataContext.getWizardCallbacks();
        if (this.isSkipping()) {
            return;
        }
        boolean providerChanged = false;
        DBObjectProvider pro = this.getProvider(dataContext);
        if (this.m_pro != pro) {
            providerChanged = true;
        }
        this.m_pro = pro;
        if (this.m_pro != null) {
            ItemPicker to = this.getToPicker();
            if (to instanceof Traversable) {
                ((Traversable)to).onEntry(dataContext);
            }
            this.init(providerChanged, dataContext);
            this.entered();
        }
    }

    public final void onExit(TraversableContext dataContext) throws TraversalException {
        if (this.m_pro != null) {
            ItemPicker to = this.getToPicker();
            if (to instanceof Traversable) {
                ((Traversable)to).onExit(dataContext);
            }
            this.exited();
            this.commit(dataContext);
            this.saveSettings();
        }
    }

    private void entered() {
        this.m_entered = true;
    }

    private void exited() {
        this.m_entered = false;
        this.saveSettings();
    }

    protected DBObjectProvider getProvider(TraversableContext dataContext) {
        return (DBObjectProvider)dataContext.get(this.getProviderKey());
    }

    protected void commit(TraversableContext dataContext) throws TraversalException {
        dataContext.put(SELECTED_OBJECTS, this.getSelectedObjects());
    }

    protected Object getSelectedObjects() {
        Object[] retval = null;
        if (this.m_chosen == null) {
            ItemPicker to = this.getToPicker();
            retval = to.getAllSelectableItems();
        } else {
            ListModel model = this.m_chosen.getList().getModel();
            int c = model.getSize();
            retval = new SchemaObjectDescriptor[c];
            int i = 0;
            while (i < c) {
                ((SchemaObjectDescriptor[])retval)[i] = (SchemaObjectDescriptor)model.getElementAt(i);
                ++i;
            }
        }
        return retval;
    }

    protected void setIncludePublicSchema(boolean inc) {
        this.m_publicSchema = inc ? new Schema("PUBLIC") : null;
    }

    protected void init(boolean providerChanged, TraversableContext dataContext) {
        boolean doQuery = providerChanged;
        if (!this.m_init) {
            this.m_init = true;
            doQuery = true;
        }
        this.setupTypesModel();
        this.loadSettings();
        if (doQuery) {
            Schema defaultSchema = (Schema)dataContext.get("Schema");
            this.getFromPicker().setProvider(this.m_pro);
            Schema[] schemas = null;
            try {
                schemas = this.m_pro.listSchemas();
                TreeSet<Schema> ss = new TreeSet<Schema>();
                ss.addAll(Arrays.asList(schemas));
                if (this.m_publicSchema != null) {
                    ss.add(this.m_publicSchema);
                }
                schemas = ss.toArray(new Schema[ss.size()]);
            }
            catch (DBException e) {
                e.printStackTrace();
            }
            if (defaultSchema == null && this.m_pro instanceof Database) {
                try {
                    String username = ((Database)this.m_pro).getUserName();
                    defaultSchema = this.m_pro.getSchema(username);
                }
                catch (DBException dbe) {
                    Assert.printStackTrace((Throwable)dbe);
                }
            }
            this.m_schemas.init(this.m_pro, defaultSchema, schemas);
            this.loadSchemaSetting();
            this.selectTypes();
        }
        this.checkWizardButtons();
        JLabel lblFrom = new JLabel();
        JLabel lblTo = new JLabel();
        DBObjectSourcePicker fromPick = this.getFromPicker();
        ItemPicker toPick = this.getToPicker();
        this.m_shuttle.setFromPicker((ItemPicker)fromPick);
        this.m_shuttle.setToPicker(toPick);
        this.m_reshelp.setName(fromPick.getComponent(), "From");
        this.m_reshelp.setName(toPick.getComponent(), "To");
        this.m_shuttle.add((Component)lblFrom, (Object)"FromHeader");
        this.m_shuttle.add((Component)lblTo, (Object)"ToHeader");
        this.m_reshelp.resLabel(lblFrom, fromPick.getComponent(), UIArb.getString(293), "Available");
        this.m_reshelp.resLabel(lblTo, toPick.getComponent(), UIArb.getString(360), "Selected");
        if (doQuery && this.m_autoQuery.isSelected()) {
            this.fireQuery();
        }
        if (this.m_callBacks != null) {
            if (this.m_autoQuery.isSelected()) {
                if (!this.getToPicker().isSelectableItemPresent()) {
                    this.m_callBacks.wizardSetInitialFocus((Component)this.getFromPicker().getTree());
                }
            } else {
                this.m_callBacks.wizardSetInitialFocus((Component)this.m_query);
            }
        }
    }

    protected void fireQuery() {
        this.getTimer().stop();
        DBObjectSourcePicker from = this.getFromPicker();
        if (from != null && this.m_selectedTypes != null) {
            try {
                Schema schema = this.m_schemas.getSchema();
                String filter = this.m_filter.getText();
                String[] types = this.m_selectedTypes.toArray(new String[this.m_selectedTypes.size()]);
                this.setupQuery(from, schema, filter, types);
                this.getTimer().stop();
                from.query();
                this.m_shuttle.setEnabled(true);
            }
            catch (TraversalException te) {
                te.showMessageDialog((Component)this.m_schemas);
            }
        }
    }

    protected void setupQuery(DBObjectSourcePicker from, Schema schema, String filter, String[] types) {
        from.setSchema(schema);
        from.setTypes(types);
        if (filter.startsWith("'") && filter.endsWith("'") && !filter.startsWith("''") && !filter.endsWith("''")) {
            filter = filter.substring(1, filter.length() - 1);
        }
        if (!(filter = filter.replaceAll("'", "''")).startsWith("\"") || !filter.endsWith("\"")) {
            filter = filter.replaceAll("\\*", "%");
        }
        if ((filter = this.m_pro.getInternalName(filter)).indexOf("%") < 0 && !filter.endsWith("%")) {
            filter = filter + "%";
        }
        from.setFilter(filter);
        this.m_filter.setText(this.externaliseFilter(filter));
    }

    private String externaliseFilter(String filter) {
        String extNoPercent;
        String external;
        String string = external = ModelUtil.hasLength((String)filter) ? this.m_pro.getExternalName(filter) : "";
        if (filter.indexOf(37) < 0) {
            String quoteString = this.m_pro.getIdentifierQuoteString();
            if (quoteString != null && external.endsWith(quoteString)) {
                return external.substring(0, external.lastIndexOf(quoteString)) + '%' + quoteString;
            }
            return external + '%';
        }
        String noPercent = filter.replaceAll("%", "");
        String string2 = extNoPercent = ModelUtil.hasLength((String)noPercent) ? this.m_pro.getExternalName(noPercent) : noPercent;
        if (noPercent.equals(extNoPercent)) {
            return filter;
        }
        return external;
    }

    private void selectTypes() {
        FastStringBuffer typesTT = new FastStringBuffer();
        typesTT.append(UIArb.getString(553));
        this.m_selectedTypes = this.m_typeBoxes.getSelectionList();
        if (this.m_selectedTypes != null) {
            Iterator iter = this.m_selectedTypes.iterator();
            while (iter.hasNext()) {
                typesTT.append(" ");
                typesTT.append(DBTypeDisplayRegistry.getDisplayName((String)iter.next()));
            }
        }
        DBObjectRenderer.setToolTipText(this.m_typeButton, typesTT.toString());
        if (this.m_selectedTypes == null || this.m_selectedTypes.size() < this.m_typeBoxes.getSize()) {
            this.m_typeLabel.setText(UIArb.getString(156));
        } else {
            this.m_typeLabel.setText(UIArb.getString(220));
        }
    }

    private Timer getTimer() {
        if (this.m_timer == null) {
            1 alist = new 1();
            this.m_timer = new Timer(2000, alist);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected PropertyStorage getPropertyStorage() {
        return DatabaseIdePreferences.getPreferences();
    }

    protected void loadSettings() {
        HashStructure settings = this.getSettings();
        if (settings != null) {
            boolean aq = settings.getBoolean(SETTINGS_AUTO_QUERY_KEY, false);
            this.m_autoQuery.setSelected(aq);
            this.m_query.setEnabled(aq ^ true);
            this.m_typeBoxes.deselectAll();
            int i = 0;
            while (i < this.m_typeBoxes.getSize()) {
                String type = (String)this.m_typeBoxes.getUserObjectAt(i);
                if (settings.getBoolean(SETTINGS_QUERY_KEY + type, true)) {
                    this.m_typeBoxes.setElementSelected(i);
                }
                ++i;
            }
            List selected = this.m_typeBoxes.getSelectionList();
            if (selected == null || selected.size() < 1) {
                this.m_typeBoxes.selectAll();
            }
            if (this.useSavedFilterAndSchema()) {
                this.m_filter.setText(settings.getString(SETTINGS_FILTER_KEY));
            }
        } else {
            this.setDefaultSettings();
        }
    }

    private void loadSchemaSetting() {
        HashStructure settings = this.getSettings();
        if (settings != null) {
            String schemaName;
            String connectionName = this.getConnectionName();
            if (this.useSavedFilterAndSchema() && ModelUtil.hasLength((String)(schemaName = settings.getString(SETTINGS_SCHEMA_KEY)))) {
                try {
                    Schema schema = this.m_pro.getSchema(schemaName);
                    this.m_schemas.setSelectedItem(schema);
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
        }
    }

    private boolean useSavedFilterAndSchema() {
        String userName;
        String connectionName;
        HashStructure settings = this.getSettings();
        return settings != null && ModelUtil.hasLength((String)(connectionName = this.getConnectionName())) && connectionName.equals(settings.getString(SETTINGS_CONNECTION_KEY)) && ModelUtil.hasLength((String)(userName = this.getUserName())) && userName.equals(settings.getString(SETTINGS_SCHEMA_KEY));
    }

    private HashStructure getSettings() {
        String key = this.getSettingsKey();
        HashStructure settings = null;
        if (key != null) {
            PropertyStorage ps = this.getPropertyStorage();
            settings = ps.getProperties().getHashStructure(key);
        }
        return settings;
    }

    protected void setDefaultSettings() {
        boolean autoQuery = this.m_pro instanceof Database ^ true;
        this.m_autoQuery.setSelected(autoQuery);
        this.m_query.setEnabled(autoQuery ^ true);
    }

    protected void saveSettings() {
        String key = this.getSettingsKey();
        if (key != null) {
            PropertyStorage ps = this.getPropertyStorage();
            HashStructure settings = ps.getProperties().getOrCreateHashStructure(key);
            settings.putBoolean(SETTINGS_AUTO_QUERY_KEY, this.m_autoQuery.isSelected());
            int i = 0;
            while (i < this.m_typeBoxes.getSize()) {
                String type = (String)this.m_typeBoxes.getUserObjectAt(i);
                settings.putBoolean(SETTINGS_QUERY_KEY + type, this.m_typeBoxes.isElementSelected(i));
                ++i;
            }
            settings.putString(SETTINGS_CONNECTION_KEY, this.getConnectionName());
            settings.putString(SETTINGS_FILTER_KEY, this.m_filter.getText());
            try {
                Schema schema = this.m_schemas.getSchema();
                if (schema != null) {
                    settings.putString(SETTINGS_SCHEMA_KEY, schema.getName());
                }
            }
            catch (TraversalException te) {
                // empty catch block
            }
        }
    }

    private String getConnectionName() {
        String connectionName = null;
        if (this.m_pro instanceof Database) {
            connectionName = ((Database)this.m_pro).getConnectionName();
        }
        return connectionName;
    }

    private String getUserName() {
        String userName = null;
        if (this.m_pro instanceof Database) {
            try {
                userName = ((Database)this.m_pro).getUserName();
            }
            catch (DBException d) {
                d.printStackTrace();
            }
        }
        return userName;
    }

    protected void checkWizardButtons() {
        ItemPicker to;
        if (this.m_callBacks != null && (to = this.getToPicker()) != null) {
            Boolean finish;
            Transferable[] t = to.getAllSelectableItems();
            boolean haveStuff = t != null && t.length > 0;
            Boolean bl = finish = this.canFinish() && haveStuff ? Boolean.TRUE : Boolean.FALSE;
            Boolean next = this.canAlwaysNext() ? Boolean.TRUE : (haveStuff ? Boolean.TRUE : Boolean.FALSE);
            this.m_callBacks.wizardEnableButtons(null, next, finish);
        }
    }

    private void showFilterTypesDialog() {
        this.m_typesDialog = JEWTDialog.createDialog((Component)this.m_typeButton, (String)UIArb.getString(644), (int)7);
        DefaultTraversablePanel content = new DefaultTraversablePanel();
        content.setHelpID("f1_db_filter_types_html");
        content.setLayout((LayoutManager)new BorderLayout(0, 5));
        if (this.m_typesPanel == null) {
            this.m_typesPanel = new CheckBoxListPanel(this.m_typeBoxes);
            this.m_typesPanel.getList().setLayoutOrientation(1);
        }
        content.add((Component)this.m_typesPanel, (Object)"Center");
        if (this.m_typesDialogErrorLabel == null) {
            this.m_typesDialogErrorLabel = new JLabel(" ");
        }
        content.add((Component)this.m_typesDialogErrorLabel, (Object)"South");
        this.m_typesDialog.setContent((Component)content);
        this.m_typesDialog.setName(this.getPanelName() + ".TypesDialog");
        try {
            if (this.m_typesDialog.runDialog()) {
                this.selectTypes();
                if (this.m_autoQuery.isSelected()) {
                    this.fireQuery();
                }
            } else {
                this.m_typeBoxes.deselectAll();
                int i = 0;
                while (i < this.m_typeBoxes.getSize()) {
                    if (this.m_selectedTypes.contains(this.m_typeBoxes.getUserObjectAt(i))) {
                        this.m_typeBoxes.setElementSelected(i);
                    }
                    ++i;
                }
            }
        }
        finally {
            this.m_typesDialog.dispose();
            this.m_typesDialog = null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_entered) {
            Object source = e.getSource();
            if (source == this.m_query) {
                this.fireQuery();
            } else if (source == this.m_schemas) {
                if (this.m_autoQuery.isSelected()) {
                    this.fireQuery();
                }
            } else if (source == this.m_typeButton) {
                this.showFilterTypesDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source;
        if (this.m_entered && (source = e.getSource()) == this.m_autoQuery) {
            switch (e.getStateChange()) {
                case 1: {
                    this.m_query.setEnabled(false);
                    this.fireQuery();
                    break;
                }
                case 2: {
                    this.m_query.setEnabled(true);
                    break;
                }
            }
        }
    }

    private void showTypesErrorDialog(Component parent) {
        MessageDialog.error((Component)parent, (Object)UIArb.getString(559), (String)UIArb.getString(567), null);
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.m_entered && this.m_autoQuery.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.m_entered && this.m_autoQuery.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (this.m_entered && this.m_autoQuery.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void shuttleItemsMoved(ShuttleEvent p0) {
        this.checkWizardButtons();
    }

    public void shuttleItemsRemoved(ShuttleEvent p0) {
        this.checkWizardButtons();
    }

    public void shuttleItemsReordered(ShuttleEvent p0) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.fireQuery();
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void stateChanged(Object source) {
        if (this.m_typesDialog != null) {
            List selected = this.m_typeBoxes.getSelectionList();
            if (selected == null || selected.isEmpty()) {
                this.m_typesDialogErrorLabel.setText(UIArb.getString(559));
                this.m_typesDialog.setOKButtonEnabled(false);
            } else {
                this.m_typesDialogErrorLabel.setText(" ");
                this.m_typesDialog.setOKButtonEnabled(true);
            }
        }
    }

    protected String getTraversableName() {
        return null;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SelectDBObjectsPanel.this.fireQuery();
        }
    }
}

