/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;

public class SelectSchemaPanel
extends BaseInfoPanel
implements ItemListener {
    private GridBagLayout layCenter;
    private JLabel m_lblSchemaName;
    private SchemaPicker m_pickerSchema;
    private JCheckBox m_useDefault;
    private DBObjectRenderer renderer;
    public static final String USE_DEFAULT_KEY = "USE_DEFAULT";

    private void $init$() {
        this.layCenter = new GridBagLayout();
        this.m_lblSchemaName = new JLabel();
        this.m_pickerSchema = new SchemaPicker(true);
        this.m_useDefault = new JCheckBox();
        this.renderer = new DBObjectRenderer();
    }

    public SelectSchemaPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layCenter);
        DBUIResourceHelper reshelp = new DBUIResourceHelper("SelectSchemaPanel");
        reshelp.resLabel(this.m_lblSchemaName, this.m_pickerSchema, UIArb.getString(212), "Schema");
        ResourceUtils.resButton((AbstractButton)this.m_useDefault, (String)UIArb.getString(251));
        this.m_useDefault.addItemListener(this);
        this.add(this.m_lblSchemaName, new GridBagConstraints(10, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_pickerSchema, new GridBagConstraints(20, 10, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_useDefault, new GridBagConstraints(20, 20, 17, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return UIArb.getString(264);
    }

    public String getHeaderDescription() {
        return UIArb.getString(393);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_useDefault) {
            this.enablePicker();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider provider = (DBObjectProvider)dataContext.find("DBObjectProvider");
        Schema schema = (Schema)dataContext.find("NewObject");
        Boolean useDefault = (Boolean)dataContext.find(USE_DEFAULT_KEY);
        this.init(provider, schema, useDefault != null ? useDefault : false);
        this.enablePicker();
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            callbacks.wizardSetInitialFocus((Component)(this.m_pickerSchema.isEnabled() ? this.m_pickerSchema : this.m_useDefault));
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        dataContext.remove("NewObject");
        if (!this.m_useDefault.isSelected()) {
            dataContext.put("NewObject", (Object)this.m_pickerSchema.getSchema());
        } else {
            dataContext.put("NewObject", null);
        }
        dataContext.put(USE_DEFAULT_KEY, (Object)this.m_useDefault.isSelected());
    }

    private void init(DBObjectProvider provider, Schema model, boolean useDefault) {
        super.init(provider, null);
        this.renderer.setProvider(provider);
        try {
            this.m_pickerSchema.init(provider, model, provider.listSchemas());
            this.m_useDefault.setSelected(useDefault);
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        this.m_pickerSchema.setEditable(true);
        this.m_pickerSchema.setEnabled(true);
    }

    private void enablePicker() {
        boolean usingDefault = this.m_useDefault.isSelected();
        this.m_lblSchemaName.setEnabled(usingDefault ^ true);
        this.m_pickerSchema.setEnabled(usingDefault ^ true);
    }
}

