/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.db.UIArb;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencePanel
extends BaseEditorPanel<Sequence>
implements ItemListener {
    private static String CACHE = "CACHE";
    private static String NOCACHE = "NOCACHE";
    private static String[] cacheValues = new String[]{null, CACHE, NOCACHE};
    private JLabel m_lblStartWith;
    private JLabel m_lblIncrement;
    private JLabel m_lblMinValue;
    private JLabel m_lblMaxValue;
    private JLabel m_lblCacheSize;
    private JLabel m_lblCache;
    private SequenceNumberField m_fldStartWith;
    private SequenceNumberField m_fldIncrement;
    private SequenceNumberField m_fldMinValue;
    private SequenceNumberField m_fldMaxValue;
    private SequenceNumberField m_fldCacheSize;
    private JComboBox m_fldCache;
    private DefaultComboBoxModel m_cacheModel;
    private JCheckBox m_cbxCycle;
    private JCheckBox m_cbxOrder;

    private void $init$() {
        this.m_lblStartWith = new JLabel();
        this.m_lblIncrement = new JLabel();
        this.m_lblMinValue = new JLabel();
        this.m_lblMaxValue = new JLabel();
        this.m_lblCacheSize = new JLabel();
        this.m_lblCache = new JLabel();
        this.m_fldStartWith = new SequenceNumberField();
        this.m_fldIncrement = new SequenceNumberField();
        this.m_fldMinValue = new SequenceNumberField();
        this.m_fldMaxValue = new SequenceNumberField();
        this.m_fldCacheSize = new SequenceNumberField();
        this.m_fldCache = new JComboBox();
        this.m_cacheModel = new DefaultComboBoxModel<String>(cacheValues);
        this.m_cbxCycle = new JCheckBox();
        this.m_cbxOrder = new JCheckBox();
    }

    public SequencePanel() {
        this.$init$();
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        DBUIHelper helper = this.getHelper();
        helper.registerComponent(this.m_lblStartWith, (Component)((Object)this.m_fldStartWith), UIArb.getString(745), Property.startWith);
        helper.registerComponent(this.m_lblIncrement, (Component)((Object)this.m_fldIncrement), UIArb.getString(468), Property.incrementBy);
        helper.registerComponent(this.m_lblMinValue, (Component)((Object)this.m_fldMinValue), UIArb.getString(112), Property.minValue);
        helper.registerComponent(this.m_lblMaxValue, (Component)((Object)this.m_fldMaxValue), UIArb.getString(449), Property.maxValue);
        helper.registerComponent((AbstractButton)this.m_cbxCycle, UIArb.getString(145), Property.cycleFlag);
        helper.registerComponent((AbstractButton)this.m_cbxOrder, UIArb.getString(738), Property.orderFlag);
        helper.registerComponent(this.m_lblCache, (Component)this.m_fldCache, UIArb.getString(31), Property.cacheFlag);
        helper.registerComponent(this.m_lblCacheSize, (Component)((Object)this.m_fldCacheSize), UIArb.getString(709), Property.cacheSize);
        this.m_cbxCycle.addItemListener(this);
        this.m_cbxOrder.addItemListener(this);
        this.m_fldCache.setModel(this.m_cacheModel);
        this.m_fldCache.addItemListener(this);
        this.add(this.m_lblIncrement, new GridBagConstraints(10, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldIncrement), new GridBagConstraints(20, 30, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 12, 0, 0), 0, 0));
        this.add(this.m_lblMinValue, new GridBagConstraints(30, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 24, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldMinValue), new GridBagConstraints(40, 30, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 12, 0, 0), 0, 0));
        this.add(this.m_lblStartWith, new GridBagConstraints(10, 40, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldStartWith), new GridBagConstraints(20, 40, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblMaxValue, new GridBagConstraints(30, 40, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldMaxValue), new GridBagConstraints(40, 40, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblCache, new GridBagConstraints(10, 50, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_fldCache, new GridBagConstraints(20, 50, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblCacheSize, new GridBagConstraints(30, 50, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldCacheSize), new GridBagConstraints(40, 50, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_cbxCycle, new GridBagConstraints(20, 60, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 12, 0, 0), 0, 0));
        this.add(this.m_cbxOrder, new GridBagConstraints(20, 70, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void initialisePanel() {
        BigInteger maxValue;
        BigInteger minValue;
        BigInteger increment;
        Sequence model = (Sequence)this.getDBObject();
        BigInteger startWith = model.getStartWith();
        if (startWith != null) {
            this.m_fldStartWith.setNumber(startWith);
        }
        if ((increment = model.getIncrementBy()) != null) {
            this.m_fldIncrement.setNumber(increment);
        }
        if ((minValue = model.getMinValue()) != null) {
            this.m_fldMinValue.setNumber(minValue);
        }
        if ((maxValue = model.getMaxValue()) != null) {
            this.m_fldMaxValue.setNumber(maxValue);
        }
        this.m_cbxCycle.setSelected(model.getCycleFlag() == Boolean.TRUE);
        Boolean cacheFlag = model.getCacheFlag();
        if (cacheFlag != null) {
            this.m_cacheModel.setSelectedItem(cacheFlag != false ? CACHE : NOCACHE);
            this.m_cacheModel.removeElement(null);
            this.m_fldCacheSize.setEditable(cacheFlag);
            this.m_fldCacheSize.setEnabled(cacheFlag);
            if (cacheFlag.booleanValue()) {
                BigInteger cacheSize = model.getCacheSize();
                if (cacheSize != null && cacheSize.intValue() > 1) {
                    this.m_fldCacheSize.setNumber(cacheSize);
                } else {
                    this.m_fldCacheSize.setNumber(this.getCacheSizeDefault());
                }
            }
        } else {
            this.m_cacheModel.setSelectedItem(null);
            this.m_fldCacheSize.setEditable(false);
            this.m_fldCacheSize.setEnabled(false);
        }
        this.m_fldCacheSize.setSigned(false);
        this.m_cbxOrder.setSelected(model.getOrderFlag() == Boolean.TRUE);
    }

    @Override
    protected void commitPanel() {
        Sequence sequence = (Sequence)this.getDBObject();
        BigInteger biStartWith = (BigInteger)this.m_fldStartWith.getNumber();
        BigInteger biIncrement = (BigInteger)this.m_fldIncrement.getNumber();
        BigInteger biMinValue = (BigInteger)this.m_fldMinValue.getNumber();
        BigInteger biMaxValue = (BigInteger)this.m_fldMaxValue.getNumber();
        Boolean cycle = this.m_cbxCycle.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        Boolean order = this.m_cbxOrder.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        BigInteger biCacheSize = null;
        Boolean isCached = null;
        String cache = (String)this.m_fldCache.getSelectedItem();
        if (cache != null && (isCached = Boolean.valueOf(cache == CACHE)).booleanValue()) {
            biCacheSize = (BigInteger)this.m_fldCacheSize.getNumber();
        }
        sequence.setStartWith(biStartWith);
        sequence.setIncrementBy(biIncrement);
        sequence.setMinValue(biMinValue);
        sequence.setMaxValue(biMaxValue);
        sequence.setCycleFlag(cycle);
        sequence.setCacheFlag(isCached);
        sequence.setCacheSize(biCacheSize);
        sequence.setOrderFlag(order);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_fldCache) {
            String cache = (String)this.m_cacheModel.getSelectedItem();
            boolean cached = (cache == null || cache == NOCACHE) ^ true;
            this.m_lblCacheSize.setEnabled(cached);
            this.m_fldCacheSize.setEditable(cached);
            this.m_fldCacheSize.setEnabled(cached);
            this.m_fldCacheSize.setNumber(cached ? this.getCacheSizeDefault() : null);
        }
    }

    private BigInteger getCacheSizeDefault() {
        BigInteger twenty;
        BigInteger max = (BigInteger)this.m_fldMaxValue.getNumber();
        BigInteger min = (BigInteger)this.m_fldMinValue.getNumber();
        BigInteger inc = (BigInteger)this.m_fldIncrement.getNumber();
        if (inc == null) {
            inc = BigInteger.ONE;
        }
        if (max == null) {
            max = inc.signum() > 0 ? BigInteger.valueOf(10).pow(27) : BigInteger.ONE.negate();
        }
        if (min == null) {
            min = inc.signum() > 0 ? BigInteger.ONE : BigInteger.valueOf(10).pow(26).negate();
        }
        BigInteger[] dr = max.subtract(min).abs().divideAndRemainder(inc.abs());
        BigInteger def = dr[0];
        if (dr[1].signum() > 0) {
            def = def.add(BigInteger.ONE);
        }
        if (def.subtract(twenty = new BigInteger("20")).signum() > 0) {
            def = twenty;
        }
        return def;
    }

    private static class SequenceNumberField
    extends NumberTextField {
        private BigInteger m_maxValue;

        private void $init$() {
            this.m_maxValue = BigInteger.valueOf(10).pow(28).subtract(BigInteger.ONE);
        }

        public SequenceNumberField() {
            this.$init$();
            this.setDataType(BigInteger.class);
            this.setSigned(true);
        }

        protected String convertNumberToString(Number n) {
            return n.toString();
        }

        protected boolean validateNumber(Number n) {
            return n == null || ((BigInteger)n).abs().compareTo(this.m_maxValue) <= 0;
        }

        public BigInteger getMaximumValue() {
            return this.m_maxValue;
        }

        public void setMaximumValue(BigInteger max) {
            this.m_maxValue = max;
        }
    }
}

