/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.SynonymInfoVerifier;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;

public class SynonymPanel
extends BaseInfoPanel
implements ActionListener {
    private static final String[] SYNONYM_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "PACKAGE", "MATERIALIZED VIEW", "PROCEDURE", "FUNCTION", "TYPE", "SYNONYM"};
    private static final String FORSCHEMACHANGED = "ForSchemaChanged";
    private static final String OBJECTCHANGED = "ObjectChanged";
    private static final String SETOBJECTBASED = "SetObjectBased";
    private static final String SETNAMEBASED = "SetNameBased";
    protected DBObjectProvider m_prov;
    protected Synonym m_synonym;
    protected Schema m_forSchema;
    protected String m_savedName;
    private GridBagLayout layCenter;
    private JLabel m_lblFor;
    private JLabel m_lblForSchemaName;
    private JMultiLineLabel m_lblDanglingBlather;
    private SchemaPicker m_cmbForSchema;
    private JComboBox m_cmbObject;
    private JTextField m_txtName;
    private JRadioButton m_rdbObjectBased;
    private JRadioButton m_rdbNameBased;
    private ButtonGroup m_rbgBased;
    private DBObjectRenderer m_renderer;
    private static final DefaultComboBoxModel EMPTY_MDL_OBJECT = new NonNullableComboBoxModel();
    private Map m_schemaMap;
    private SynonymInfoVerifier m_verifier;
    private boolean m_isDefaultObject;
    private boolean m_isNewSynonymObject;
    private boolean m_active;
    private HashMap m_loadingSchemas;

    private void $init$() {
        this.m_prov = null;
        this.m_synonym = null;
        this.m_forSchema = null;
        this.m_savedName = null;
        this.layCenter = new GridBagLayout();
        this.m_lblFor = new JLabel();
        this.m_lblForSchemaName = new JLabel();
        this.m_lblDanglingBlather = new JMultiLineLabel();
        this.m_cmbForSchema = new SchemaPicker();
        this.m_cmbObject = new JComboBox();
        this.m_txtName = new JTextField();
        this.m_rdbObjectBased = new JRadioButton();
        this.m_rdbNameBased = new JRadioButton();
        this.m_rbgBased = new ButtonGroup();
        this.m_renderer = new DBObjectRenderer();
        this.m_schemaMap = new HashMap();
        this.m_isDefaultObject = true;
        this.m_isNewSynonymObject = true;
        this.m_active = false;
        this.m_loadingSchemas = new HashMap();
    }

    public SynonymPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layCenter);
        this.m_cmbForSchema.setName("SynonymPanel.m_cmbForSchema");
        this.m_cmbForSchema.setActionCommand(FORSCHEMACHANGED);
        this.m_cmbForSchema.addActionListener(this);
        this.m_cmbForSchema.setEditable(false);
        this.m_cmbObject.setName("BasedOn");
        this.m_cmbObject.setRenderer(this.m_renderer);
        this.m_cmbObject.setModel(EMPTY_MDL_OBJECT);
        this.m_cmbObject.setEditable(false);
        this.m_cmbObject.setActionCommand(OBJECTCHANGED);
        this.m_cmbObject.addActionListener(this);
        this.m_lblFor.setText(UIArb.getString(314));
        this.m_lblDanglingBlather.setPreferredAspectRatio(0.0f);
        ResourceUtils.resLabel((JLabel)this.m_lblForSchemaName, (Component)this.m_cmbForSchema, (String)UIArb.getString(635));
        this.m_rdbObjectBased.setName("SynonymPanel.m_rdbObjectBased");
        ResourceUtils.resButton((AbstractButton)this.m_rdbObjectBased, (String)UIArb.getString(641));
        this.m_rdbObjectBased.setActionCommand(SETOBJECTBASED);
        this.m_rdbObjectBased.addActionListener(this);
        this.m_rdbNameBased.setName("SynonymPanel.m_rdbNameBased");
        ResourceUtils.resButton((AbstractButton)this.m_rdbNameBased, (String)UIArb.getString(512));
        this.m_rdbNameBased.setActionCommand(SETNAMEBASED);
        this.m_rdbNameBased.addActionListener(this);
        this.m_rbgBased.add(this.m_rdbObjectBased);
        this.m_rbgBased.add(this.m_rdbNameBased);
        this.m_txtName.setName("SynonymPanel.m_txtName");
        this.setLayout(this.layCenter);
        int y = 0;
        this.add(this.m_lblFor, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblForSchemaName, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_cmbForSchema, new GridBagConstraints(2, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_rdbObjectBased, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_cmbObject, new GridBagConstraints(2, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_rdbNameBased, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_txtName, new GridBagConstraints(2, y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_lblDanglingBlather, new GridBagConstraints(1, ++y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, ++y, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return UIArb.getString(491);
    }

    public String getHeaderDescription() {
        return UIArb.getString(451);
    }

    protected boolean isDangling(DBObjectID ref) {
        return false;
    }

    protected String getDanglingBlather() {
        return null;
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_active = false;
        this.m_prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.m_synonym = (Synonym)dataContext.find("NewObject");
        this.m_verifier = (SynonymInfoVerifier)dataContext.find("SchemaObjectInfoVerifier");
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.init(this.m_synonym, this.m_verifier, schemas);
        this.m_active = true;
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        Synonym synonym = (Synonym)dataContext.find("NewObject");
        if (synonym == null) {
            synonym = new Synonym();
        }
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.commit(synonym, schemas, dataContext.getDirection() != 2);
        this.m_active = false;
    }

    private void init(Synonym model, SynonymInfoVerifier verifier, Schema[] schemas) {
        super.init(this.m_prov, verifier);
        this.m_renderer.setProvider(this.m_prov);
        if (this.isDangling(model.getReference())) {
            this.m_lblDanglingBlather.setText(this.getDanglingBlather());
        } else {
            this.m_lblDanglingBlather.setText(null);
        }
        this.m_forSchema = model.getSchema();
        boolean nameBased = true;
        DBObjectID refID = model.getReference();
        if (refID != null) {
            this.m_isNewSynonymObject = false;
            nameBased = refID instanceof ReferenceID || this.isDangling(refID);
            SchemaObject forObject = null;
            try {
                forObject = (SchemaObject)refID.resolveID();
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (forObject == null) {
                this.setForSchemaAndName(refID);
            } else {
                this.m_forSchema = forObject.getSchema();
                this.m_savedName = this.getProvider().getExternalName(forObject.getName());
            }
        }
        this.setEnabledFields(nameBased);
        SchemaObject ref = null;
        if (refID != null) {
            try {
                DBObject temp = refID.resolveID();
                if (temp instanceof SchemaObject) {
                    ref = (SchemaObject)temp;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if (ref != null) {
            this.m_isDefaultObject = false;
            this.m_forSchema = ref.getSchema();
        }
        if (nameBased) {
            this.m_cmbObject.setModel(EMPTY_MDL_OBJECT);
            this.m_txtName.setText(this.m_savedName);
        } else {
            if (!this.populateObjectField()) {
                nameBased = true;
            }
            if (this.m_cmbObject.getModel().getSize() < 1) {
                nameBased = true;
            }
            if (ref != null) {
                this.m_cmbObject.setSelectedItem(ref.getName());
            }
        }
        this.m_cmbForSchema.init(this.m_prov, this.m_forSchema, schemas);
        this.setEnabledFields(nameBased);
        this.m_lblFor.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_lblForSchemaName.setEnabled(verifier == null || verifier.canChangeSchema());
        this.m_cmbForSchema.setEnabled(verifier == null || verifier.canChangeSchema());
        this.m_rdbNameBased.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_rdbObjectBased.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_cmbObject.setEnabled(!nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_txtName.setEditable(nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_txtName.setEnabled(nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_isNewSynonymObject = false;
    }

    private void commit(Synonym synonym, Schema[] schemas, boolean forward) throws TraversalException {
        this.m_forSchema = this.m_cmbForSchema.getSchema();
        String refObjName = null;
        boolean objectBased = this.m_rdbObjectBased.isSelected();
        if (objectBased) {
            refObjName = (String)this.m_cmbObject.getSelectedItem();
        } else {
            refObjName = this.m_txtName.getText();
            if (refObjName != null) {
                refObjName = this.getProvider().getInternalName(refObjName);
            }
        }
        if (!ModelUtil.hasLength((String)refObjName)) {
            throw new TraversalException(UIArb.getString(881));
        }
        SchemaObject refObj = this.findObject(refObjName);
        if (objectBased && refObj != null) {
            synonym.setReference(refObj.getID());
        } else {
            ReferenceID nameBasedReference = new ReferenceID(null, this.m_forSchema, refObjName);
            synonym.setReference((DBObjectID)nameBasedReference);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_active) {
            boolean nameBased = this.m_rdbNameBased.isSelected();
            if (FORSCHEMACHANGED.equals(e.getActionCommand())) {
                try {
                    this.m_forSchema = this.m_cmbForSchema.getSchema();
                    if (this.m_rdbObjectBased.isSelected() && !this.populateObjectField()) {
                        nameBased = true;
                    }
                }
                catch (TraversalException traversalException) {}
            } else if (OBJECTCHANGED.equals(e.getActionCommand())) {
                int selectedIndex = this.m_cmbObject.getSelectedIndex();
                this.m_isDefaultObject = this.m_isNewSynonymObject || selectedIndex == -1;
            } else if (SETOBJECTBASED.equals(e.getActionCommand())) {
                if (!this.populateObjectField()) {
                    nameBased = true;
                } else {
                    SchemaObject object;
                    this.m_savedName = this.m_txtName.getText();
                    if (ModelUtil.hasLength((String)this.m_savedName) && (object = this.findObject(this.m_savedName)) != null) {
                        this.m_cmbObject.setSelectedItem(object.getName());
                    }
                    this.m_txtName.setText(null);
                }
            } else {
                SchemaObject ob = this.findObject((String)this.m_cmbObject.getSelectedItem());
                if (!this.m_isDefaultObject && ob != null) {
                    this.m_txtName.setText(ob.getName());
                } else if (this.m_savedName != null && this.m_savedName.length() > 0) {
                    this.m_txtName.setText(this.m_savedName);
                }
                nameBased = true;
            }
            this.setEnabledFields(nameBased);
        }
    }

    private void setEnabledFields(boolean nameBased) {
        this.m_rdbNameBased.setSelected(nameBased);
        this.m_rdbObjectBased.setSelected(nameBased ^ true);
        this.m_txtName.setEditable(nameBased);
        this.m_txtName.setEnabled(nameBased);
        this.m_cmbObject.setEnabled(nameBased ^ true);
    }

    private void getAllSynonymObjects(Schema refSchema) {
        try {
            SchemaObject[] objects = this.m_prov.listObjects(SYNONYM_TYPES, refSchema);
            SchemaObject originalSynonym = this.m_verifier.getOriginalObject();
            String originalSynonymName = originalSynonym != null ? originalSynonym.getName() : null;
            Schema originalSchema = originalSynonym != null ? originalSynonym.getSchema() : null;
            NonNullableComboBoxModel objectModel = new NonNullableComboBoxModel();
            int i = 0;
            while (i < objects.length) {
                if (!(originalSynonym != null && "SYNONYM".equals(objects[i].getType()) && ModelUtil.areEqual((Object)originalSchema, (Object)refSchema) && ModelUtil.areEqual((Object)originalSynonymName, (Object)objects[i].getName()))) {
                    objectModel.addElement(objects[i].getName());
                }
                ++i;
            }
            this.m_schemaMap.put(refSchema.getName(), objectModel);
        }
        catch (DBException e) {
            // empty catch block
        }
    }

    private boolean setObjectModel(Schema refSchema) {
        DefaultComboBoxModel objectModel = null;
        if (this.m_verifier.canChangeReference()) {
            objectModel = (DefaultComboBoxModel)this.m_schemaMap.get(refSchema.getName());
        } else if (this.m_synonym != null) {
            objectModel = new NonNullableComboBoxModel();
            try {
                DBObject refob = this.m_synonym.getReference().resolveID();
                if (refob != null) {
                    objectModel.addElement(refob.getName());
                }
            }
            catch (DBException dbe) {
                Assert.printStackTrace((Throwable)dbe);
            }
        }
        this.m_cmbObject.setModel(objectModel != null ? objectModel : EMPTY_MDL_OBJECT);
        return objectModel != null;
    }

    private SchemaObject findObject(String name) {
        SchemaObject result = null;
        if (name != null) {
            int i = 0;
            while (i < SYNONYM_TYPES.length) {
                try {
                    result = this.m_prov.getObject(SYNONYM_TYPES[i], this.m_forSchema, name);
                    if (result != null) {
                        break;
                    }
                }
                catch (DBException e) {
                    // empty catch block
                }
                ++i;
            }
        }
        return result;
    }

    private boolean populateObjectField() {
        Schema refSchema = this.m_forSchema;
        if (!this.m_schemaMap.containsKey(refSchema.getName())) {
            this.loadObjectModel(refSchema);
        }
        return this.setObjectModel(refSchema);
    }

    protected void setForSchemaAndName(DBObjectID refID) {
        if (refID instanceof ReferenceID) {
            ReferenceID sRefID = (ReferenceID)refID;
            String schemaName = sRefID.getSchemaName();
            if (schemaName != null) {
                try {
                    Schema forSchema = this.m_prov.getSchema(schemaName);
                    this.m_forSchema = forSchema == null ? new Schema(schemaName) : forSchema;
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            this.m_savedName = this.getProvider().getExternalName(sRefID.getName());
        }
    }

    private void loadObjectModel(Schema refSchema) {
        if (!this.m_loadingSchemas.containsKey(refSchema.getName())) {
            ObjectModelLoader objectModelLoader = new ObjectModelLoader(refSchema);
            this.m_loadingSchemas.put(refSchema.getName(), objectModelLoader);
            objectModelLoader.execute();
        } else {
            ObjectModelLoader objectModelLoader = (ObjectModelLoader)this.m_loadingSchemas.get(refSchema.getName());
            if (objectModelLoader != null) {
                objectModelLoader.execute();
            }
        }
    }

    public String getTitle() {
        return UIArb.getString(256);
    }

    public String getProgressText() {
        return UIArb.getString(125);
    }

    static HashMap ra$m_loadingSchemas(SynonymPanel synonymPanel) {
        return synonymPanel.m_loadingSchemas;
    }

    static void mav$getAllSynonymObjects(SynonymPanel synonymPanel, Schema schema) {
        synonymPanel.getAllSynonymObjects(schema);
    }

    private class ObjectModelLoader
    implements Runnable {
        private Schema m_schema;
        private ProgressBar m_bar;

        public ObjectModelLoader() {
        }

        public ObjectModelLoader(Schema schema) {
            this.m_schema = schema;
        }

        public void execute() {
            if (SynonymPanel.this.m_prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), SynonymPanel.this.getTitle(), (Runnable)this, true);
                this.m_bar.start(SynonymPanel.this.getProgressText(), this.m_schema.getName());
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar bar = this.m_bar;
            ObjectModelLoader objectModelLoader = this;
            synchronized (objectModelLoader) {
                if (SynonymPanel.ra$m_loadingSchemas(SynonymPanel.this).containsKey(this.m_schema.getName())) {
                    try {
                        Assert.println((String)("Start getAllSynonymObjects for schema " + this.m_schema.getName()));
                        SynonymPanel.mav$getAllSynonymObjects(SynonymPanel.this, this.m_schema);
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)e.getMessage());
                    }
                    SynonymPanel.ra$m_loadingSchemas(SynonymPanel.this).remove(this.m_schema.getName());
                    Assert.println((String)("Finished getAllSynonymObjects for schema " + this.m_schema.getName()));
                }
                if (bar != null) {
                    bar.setDoneStatus();
                }
            }
        }
    }
}

