/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.MViewInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;

public class MViewLeftPanel
extends JPanel
implements ListCellRenderer {
    private final String[] _withStrings;
    private MViewInfoVerifier m_verifier;
    private JLabel _refreshPeriodLabel;
    private JComboBox _refreshPeriodComboBox;
    private JLabel _refreshMethodLabel;
    private JComboBox _refreshMethodComboBox;
    private JLabel _refreshWithLabel;
    private JComboBox _refreshWithComboBox;
    private DateFormat _oracleDateFormat;
    private DateEditor _dateChooser;
    private DateEditor _nextDateChooser;
    private JLabel _refreshAtLabel;
    private JLabel _nextDateLabel;
    private JCheckBox _rollbackCheckBox;
    private ButtonGroup defaultUse;
    private JRadioButton _defaultRollbackRadio;
    private JRadioButton _useSpecificRadioButton;
    private JTextField _rollbackSegmentTextField;
    private ButtonGroup localMaster;
    private JRadioButton _localRollbackRadio;
    private JRadioButton _masterRollbackRadio;
    private JCheckBox _refreshUseConstraintCheckBox;
    private JRadioButton _enforcedRadioButton;
    private JRadioButton _trustedRadioButton;
    private ButtonGroup _conButtonGroup;
    private DBUIResourceHelper _resHelper;
    private DefaultListCellRenderer m_rend;

    private void $init$() {
        this._withStrings = new String[]{"", UIArb.getString(416), UIArb.getString(315)};
        this.m_verifier = null;
        this._refreshPeriodLabel = new JLabel();
        this._refreshPeriodComboBox = new JComboBox<MaterializedView.RefreshMode>(MaterializedView.RefreshMode.values());
        this._refreshMethodLabel = new JLabel();
        this._refreshMethodComboBox = new JComboBox<MaterializedView.RefreshMethod>(MaterializedView.RefreshMethod.values());
        this._refreshWithLabel = new JLabel();
        this._refreshWithComboBox = new JComboBox<String>(this._withStrings);
        this._oracleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        this._dateChooser = new DateEditor();
        this._nextDateChooser = new DateEditor();
        this._refreshAtLabel = new JLabel();
        this._nextDateLabel = new JLabel();
        this._rollbackCheckBox = new JCheckBox();
        this.defaultUse = new ButtonGroup();
        this._defaultRollbackRadio = new JRadioButton();
        this._useSpecificRadioButton = new JRadioButton();
        this._rollbackSegmentTextField = new JTextField();
        this.localMaster = new ButtonGroup();
        this._localRollbackRadio = new JRadioButton();
        this._masterRollbackRadio = new JRadioButton();
        this._refreshUseConstraintCheckBox = new JCheckBox();
        this._enforcedRadioButton = new JRadioButton();
        this._trustedRadioButton = new JRadioButton();
        this._conButtonGroup = new ButtonGroup();
        this._resHelper = new DBUIResourceHelper("MViewLeftPanel");
    }

    public MViewLeftPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void init(DBObjectProvider prov, MaterializedView mview, MViewInfoVerifier verifier, Schema[] schemas, boolean isEditable) {
        this.m_verifier = verifier;
        this._refreshMethodComboBox.setSelectedItem(mview.getRefreshMethod());
        if (mview.getRefreshMethod() != MaterializedView.RefreshMethod.NA) {
            this._refreshMethodComboBox.removeItem(MaterializedView.RefreshMethod.NA);
        }
        this._refreshPeriodComboBox.setSelectedItem(mview.getRefreshMode());
        MaterializedView.RefreshWith refreshWith = mview.getKeyType();
        if (this.m_verifier == null) {
            if (refreshWith == MaterializedView.RefreshWith.ROWID) {
                this._refreshWithComboBox.setSelectedItem(UIArb.getString(315));
            } else if (refreshWith == MaterializedView.RefreshWith.PRIMARY_KEY) {
                this._refreshWithComboBox.setSelectedItem(UIArb.getString(416));
            } else {
                this._refreshWithComboBox.setSelectedItem("");
            }
        } else {
            this.m_verifier.setupRefreshCombo(this._refreshWithComboBox, refreshWith);
        }
        this._refreshPeriodComboBox.setSelectedItem(mview.getRefreshMode());
        if (mview.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.NONE) {
            this._rollbackCheckBox.setSelected(false);
            this._masterRollbackRadio.setEnabled(false);
            this._localRollbackRadio.setEnabled(false);
            this._defaultRollbackRadio.setEnabled(false);
            this._useSpecificRadioButton.setEnabled(false);
            this._rollbackSegmentTextField.setEnabled(false);
            this._rollbackCheckBox.setEnabled(verifier == null || verifier.canRefreshUseRollback());
        } else {
            this._rollbackCheckBox.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._rollbackCheckBox.setSelected(true);
            this._localRollbackRadio.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._masterRollbackRadio.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._useSpecificRadioButton.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._defaultRollbackRadio.setEnabled(verifier == null || verifier.canRefreshUseRollback());
            this._rollbackSegmentTextField.setEnabled(false);
            if (mview.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.LOCAL) {
                this._localRollbackRadio.setSelected(true);
            } else {
                this._localRollbackRadio.setSelected(false);
            }
            if (mview.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.MASTER) {
                this._masterRollbackRadio.setSelected(true);
            } else {
                this._masterRollbackRadio.setSelected(false);
            }
            if (mview.getRollbackSegmentName() == null || mview.getRollbackSegmentName().trim().equals("")) {
                this._defaultRollbackRadio.setSelected(true);
            } else {
                this._defaultRollbackRadio.setSelected(false);
                this._useSpecificRadioButton.setSelected(true);
                this._rollbackSegmentTextField.setEnabled(verifier == null || verifier.canRefreshUseRollback());
                this._rollbackSegmentTextField.setText(mview.getRollbackSegmentName());
            }
        }
        MaterializedView.UsingConstraints usingCons = mview.getUsingConstraints();
        this._refreshUseConstraintCheckBox.setSelected(usingCons != null);
        this._refreshUseConstraintCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshConstraints());
        this._enforcedRadioButton.setEnabled(this._refreshUseConstraintCheckBox.isSelected());
        this._trustedRadioButton.setEnabled(this._refreshUseConstraintCheckBox.isSelected());
        this._refreshWithLabel.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshType());
        this._refreshWithComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshType());
        this._refreshMethodLabel.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshMethod());
        this._refreshMethodComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshMethod());
        this._refreshPeriodLabel.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshWhen());
        this._refreshPeriodComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshWhen());
        if (usingCons == MaterializedView.UsingConstraints.TRUSTED) {
            this._trustedRadioButton.setSelected(true);
        } else {
            this._enforcedRadioButton.setSelected(true);
        }
        if (mview.getLastRefreshDate() != null) {
            this._dateChooser.setDate(mview.getLastRefreshDate());
        }
        if (mview.getNextRefreshDate() != null) {
            this._nextDateChooser.setDate(mview.getNextRefreshDate());
            this._refreshPeriodComboBox.setSelectedIndex(3);
        }
        if (!isEditable) {
            this.disableAll();
        }
    }

    private Connection getConnection(DBObjectProvider prov) {
        Connection conn = null;
        if (prov instanceof Database) {
            conn = ((Database)prov).getConnection();
        }
        return conn;
    }

    public void commit(MaterializedView mview, Schema[] schema, boolean isForward) throws TraversalException {
        String keyMethod;
        mview.setRefreshMethod((MaterializedView.RefreshMethod)this._refreshMethodComboBox.getSelectedItem());
        MaterializedView.RefreshMode mode = (MaterializedView.RefreshMode)this._refreshPeriodComboBox.getSelectedItem();
        mview.setRefreshMode(mode);
        if (mode == MaterializedView.RefreshMode.SPECIFY) {
            mview.setLastRefreshDate(this.getStartDate());
            mview.setNextRefreshDate(this.getNextDate());
            long secInterval = (this.getNextDate().getTime() - this.getStartDate().getTime()) / 1000L;
            if (secInterval > 0L) {
                StringBuilder sb = new StringBuilder("SYSDATE ");
                if (secInterval / 86400L >= 1L) {
                    sb.append("+ ");
                    sb.append(Long.valueOf(secInterval / 86400L).toString());
                    secInterval %= 86400L;
                }
                if (secInterval > 0L) {
                    sb.append("+ (");
                    if (secInterval % 3600L == 0L) {
                        sb.append(Long.valueOf(secInterval / 3600L).toString()).append("/24)");
                    } else if (secInterval % (long)60 == 0L) {
                        sb.append(Long.valueOf(secInterval / (long)60).toString()).append("/(24*60))");
                    } else {
                        sb.append(Long.valueOf(secInterval).toString()).append("/(24*60*60))");
                    }
                }
                mview.setInterval(sb.toString());
            } else {
                mview.setInterval(null);
            }
        }
        if ((keyMethod = this.getMethod()).equals(UIArb.getString(416))) {
            mview.setKeyType(MaterializedView.RefreshWith.PRIMARY_KEY);
        } else if (keyMethod.equals(UIArb.getString(315))) {
            mview.setKeyType(MaterializedView.RefreshWith.ROWID);
        } else {
            mview.setKeyType(MaterializedView.RefreshWith.UNSPECIFIED);
        }
        if (this._rollbackCheckBox.isSelected()) {
            if (this._localRollbackRadio.isSelected()) {
                mview.setRollbackSegmentType(MaterializedView.RollbackSegmentType.LOCAL);
            } else if (this._masterRollbackRadio.isSelected()) {
                mview.setRollbackSegmentType(MaterializedView.RollbackSegmentType.MASTER);
            }
            if (this._defaultRollbackRadio.isSelected()) {
                mview.setRollbackSegmentName(null);
            } else if (this._useSpecificRadioButton.isSelected()) {
                mview.setRollbackSegmentName(this._rollbackSegmentTextField.getText());
            }
        } else {
            mview.setRollbackSegmentName(null);
            mview.setRollbackSegmentType(MaterializedView.RollbackSegmentType.NONE);
        }
        if (this._refreshUseConstraintCheckBox.isSelected()) {
            if (this._enforcedRadioButton.isSelected()) {
                mview.setUsingConstraints(MaterializedView.UsingConstraints.ENFORCED);
            } else if (this._trustedRadioButton.isSelected()) {
                mview.setUsingConstraints(MaterializedView.UsingConstraints.TRUSTED);
            }
        } else {
            mview.setUsingConstraints(null);
        }
    }

    public String getMethod() {
        return (String)this._refreshWithComboBox.getSelectedItem();
    }

    public Date getStartDate() {
        return this._dateChooser.getDate();
    }

    public Date getNextDate() {
        return this._nextDateChooser.getDate();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.localMaster.add(this._localRollbackRadio);
        this.localMaster.add(this._masterRollbackRadio);
        this.defaultUse.add(this._defaultRollbackRadio);
        this.defaultUse.add(this._useSpecificRadioButton);
        this.setBorder(BorderFactory.createTitledBorder(UIArb.getString(589)));
        this._resHelper.resLabel(this._refreshPeriodLabel, this._refreshPeriodComboBox, UIArb.getString(418), "_refreshPeriodComboBox");
        this._refreshPeriodComboBox.addActionListener(new 1());
        this._resHelper.resLabel(this._refreshMethodLabel, this._refreshMethodComboBox, UIArb.getString(835), "_refreshMethodComboBox");
        this._refreshMethodComboBox.setSelectedItem(MaterializedView.RefreshMethod.FAST);
        this._refreshMethodComboBox.removeItem(MaterializedView.RefreshMethod.NEVER);
        this._resHelper.resLabel(this._refreshWithLabel, this._refreshWithComboBox, UIArb.getString(476), "_refreshWithComboBox");
        this._refreshWithComboBox.setSelectedIndex(0);
        this._dateChooser.setToolTipText(UIArb.getString(716));
        this._dateChooser.setDateFormat(this._oracleDateFormat);
        this._dateChooser.setEnabled(false);
        this._dateChooser.setDate(new Date());
        this._resHelper.resLabel(this._refreshAtLabel, (Component)this._dateChooser, UIArb.getString(188), "_dateChooser");
        this._refreshAtLabel.setEnabled(false);
        this._nextDateChooser.setToolTipText(UIArb.getString(28));
        this._nextDateChooser.setDateFormat(this._oracleDateFormat);
        this._nextDateChooser.setEnabled(false);
        this._nextDateChooser.setDate(new Date());
        this._resHelper.resLabel(this._nextDateLabel, (Component)this._nextDateChooser, UIArb.getString(556), "_nextDateChooser");
        this._nextDateLabel.setEnabled(false);
        this._resHelper.resButton(this._rollbackCheckBox, UIArb.getString(727), "_rollbackCheckBox");
        this._rollbackCheckBox.addActionListener(new 2());
        this._resHelper.resButton(this._defaultRollbackRadio, UIArb.getString(619), "_defaultRollbackRadio");
        this._defaultRollbackRadio.addActionListener(new 3());
        this._defaultRollbackRadio.setEnabled(false);
        this._resHelper.resButton(this._useSpecificRadioButton, UIArb.getString(242), "_useSpecificRadioButton");
        this._useSpecificRadioButton.addActionListener(new 4());
        this._useSpecificRadioButton.setEnabled(false);
        this._rollbackSegmentTextField.setEnabled(false);
        this._resHelper.resButton(this._localRollbackRadio, UIArb.getString(41), "_localRollbackRadio");
        this._localRollbackRadio.setEnabled(false);
        this._resHelper.resButton(this._masterRollbackRadio, UIArb.getString(381), "_masterRollbackRadio");
        this._masterRollbackRadio.setEnabled(false);
        this._resHelper.resButton(this._refreshUseConstraintCheckBox, UIArb.getString(140), "_refreshUseConstraintCheckBox");
        this._refreshUseConstraintCheckBox.addActionListener(new 5());
        this._resHelper.resButton(this._enforcedRadioButton, UIArb.getString(73), "_enforcedRadioButton");
        this._resHelper.resButton(this._trustedRadioButton, UIArb.getString(110), "_trustedRadioButton");
        this._conButtonGroup.add(this._trustedRadioButton);
        this._conButtonGroup.add(this._enforcedRadioButton);
        this._trustedRadioButton.setEnabled(false);
        this._trustedRadioButton.addActionListener(new 6());
        this._enforcedRadioButton.setEnabled(false);
        int y = 0;
        GridBagConstraints gbcLabels = new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0);
        GridBagConstraints gbcWidgets = new GridBagConstraints(1, y, 1, 1, 0.7, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
        this.add((Component)this._refreshPeriodLabel, gbcLabels);
        this.add((Component)this._refreshPeriodComboBox, gbcWidgets);
        gbcLabels.gridy = ++y;
        gbcWidgets.gridy = y++;
        this.add((Component)this._refreshMethodLabel, gbcLabels);
        this.add((Component)this._refreshMethodComboBox, gbcWidgets);
        gbcLabels.gridy = y;
        gbcWidgets.gridy = y++;
        this.add((Component)this._refreshWithLabel, gbcLabels);
        this.add((Component)this._refreshWithComboBox, gbcWidgets);
        gbcLabels.gridy = y;
        gbcWidgets.gridy = y++;
        this.add((Component)this._refreshAtLabel, gbcLabels);
        this.add((Component)this._dateChooser, gbcWidgets);
        gbcLabels.gridy = y;
        gbcWidgets.gridy = y++;
        this.add((Component)this._nextDateLabel, gbcLabels);
        this.add((Component)this._nextDateChooser, gbcWidgets);
        ++gbcWidgets.gridx;
        gbcWidgets.insets.right = 5;
        this.add(Box.createHorizontalGlue(), gbcWidgets);
        GridBagConstraints gbcWide = new GridBagConstraints(0, y, 3, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 0, 5), 0, 0);
        this.add((Component)this._rollbackCheckBox, gbcWide);
        JPanel rollbackRadios = new JPanel();
        GridBagConstraints gbcRadio = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
        rollbackRadios.setLayout(new GridBagLayout());
        rollbackRadios.add((Component)this._masterRollbackRadio, gbcRadio);
        gbcRadio.gridx = 1;
        rollbackRadios.add((Component)this._localRollbackRadio, gbcRadio);
        gbcRadio.insets.top = 10;
        gbcRadio.gridy = 1;
        rollbackRadios.add((Component)this._useSpecificRadioButton, gbcRadio);
        gbcRadio.gridx = 0;
        rollbackRadios.add((Component)this._defaultRollbackRadio, gbcRadio);
        gbcRadio.gridx = 2;
        gbcRadio.weightx = 1.0;
        gbcRadio.fill = 2;
        rollbackRadios.add((Component)this._rollbackSegmentTextField, gbcRadio);
        ++y;
        gbcWide.gridy = y++;
        gbcWide.insets.left = 15;
        gbcWide.insets.top = 5;
        this.add((Component)rollbackRadios, gbcWide);
        JPanel constraintsPanel = new JPanel();
        GridBagConstraints gbcCons = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
        constraintsPanel.setLayout(new GridBagLayout());
        gbcCons.gridwidth = 2;
        constraintsPanel.add((Component)this._refreshUseConstraintCheckBox, gbcCons);
        gbcCons.gridx = 0;
        gbcCons.gridy = 1;
        gbcCons.insets.left = 10;
        gbcCons.gridwidth = 1;
        constraintsPanel.add((Component)this._enforcedRadioButton, gbcCons);
        gbcCons.insets.left = 0;
        gbcCons.gridx = 1;
        constraintsPanel.add((Component)this._trustedRadioButton, gbcCons);
        gbcCons.weightx = 1.0;
        gbcCons.gridx = 2;
        constraintsPanel.add(Box.createHorizontalGlue(), gbcCons);
        gbcWide.insets.left = 5;
        gbcWide.gridy = y++;
        gbcWide.insets.top = 15;
        this.add((Component)constraintsPanel, gbcWide);
        gbcWide.gridy = y;
        gbcWide.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gbcWide);
    }

    private void _rollbackCheckBox_actionPerformed(ActionEvent e) {
        if (this._rollbackCheckBox.isSelected()) {
            this._defaultRollbackRadio.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            this._useSpecificRadioButton.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            this._localRollbackRadio.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            this._masterRollbackRadio.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            if (this._useSpecificRadioButton.isSelected()) {
                this._rollbackSegmentTextField.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            }
        } else {
            this._defaultRollbackRadio.setEnabled(false);
            this._useSpecificRadioButton.setEnabled(false);
            this._localRollbackRadio.setEnabled(false);
            this._masterRollbackRadio.setEnabled(false);
            this._rollbackSegmentTextField.setEnabled(false);
        }
    }

    private void _useSpecificRadioButton_actionPerformed(ActionEvent e) {
        this._rollbackSegmentTextField.setEnabled(true);
    }

    private void _defaultRollbackRadio_actionPerformed(ActionEvent e) {
        this._rollbackSegmentTextField.setEnabled(false);
    }

    private void _useCheckContraints_actionPerformed(ActionEvent e) {
        if (this._refreshUseConstraintCheckBox.isSelected()) {
            this._enforcedRadioButton.setEnabled(true);
            this._trustedRadioButton.setEnabled(true);
        } else {
            this._enforcedRadioButton.setEnabled(false);
            this._trustedRadioButton.setEnabled(false);
        }
    }

    private void _refreshPeriodComboBox_actionPerformed(ActionEvent e) {
        if (this._refreshPeriodComboBox.getSelectedItem() == MaterializedView.RefreshMode.NEVER) {
            this._dateChooser.setEnabled(false);
            this._nextDateChooser.setEnabled(false);
            this._rollbackCheckBox.setSelected(false);
            this._rollbackCheckBox_actionPerformed(new ActionEvent(new Object(), 1, ""));
            this._refreshUseConstraintCheckBox.setSelected(false);
            this._useCheckContraints_actionPerformed(new ActionEvent(new Object(), 1, ""));
            this._rollbackCheckBox.setEnabled(false);
            this._refreshMethodComboBox.setEnabled(false);
            this._refreshWithLabel.setEnabled(false);
            this._refreshWithComboBox.setEnabled(false);
            this._rollbackCheckBox.setEnabled(false);
            this._refreshUseConstraintCheckBox.setEnabled(false);
            this._refreshMethodLabel.setEnabled(false);
        } else {
            this._rollbackCheckBox.setEnabled(true);
            this._refreshMethodComboBox.setEnabled(true);
            this._refreshWithLabel.setEnabled(true);
            this._refreshWithComboBox.setEnabled(true);
            this._rollbackCheckBox.setEnabled(true);
            this._refreshUseConstraintCheckBox.setEnabled(true);
            this._refreshMethodLabel.setEnabled(true);
            if (this._refreshPeriodComboBox.getSelectedItem() == MaterializedView.RefreshMode.SPECIFY) {
                this._dateChooser.setEnabled(true);
                this._nextDateChooser.setEnabled(true);
                this._nextDateLabel.setEnabled(true);
                this._refreshAtLabel.setEnabled(true);
            } else {
                this._dateChooser.setEnabled(false);
                this._nextDateChooser.setEnabled(false);
                this._nextDateLabel.setEnabled(false);
                this._refreshAtLabel.setEnabled(false);
            }
        }
    }

    private void _trustedRadioButton_actionPerformed(ActionEvent e) {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.m_rend == null) {
            this.m_rend = new DefaultListCellRenderer();
        }
        if (value instanceof MaterializedView.RefreshMode) {
            switch (7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMode[((MaterializedView.RefreshMode)value).ordinal()]) {
                case 1: {
                    value = UIArb.getString(685);
                    break;
                }
                case 2: {
                    value = UIArb.getString(739);
                    break;
                }
                case 3: {
                    value = UIArb.getString(795);
                    break;
                }
                case 4: {
                    value = UIArb.getString(771);
                    break;
                }
            }
        } else if (value instanceof MaterializedView.RefreshMethod) {
            switch (7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod[((MaterializedView.RefreshMethod)value).ordinal()]) {
                case 1: {
                    value = UIArb.getString(339);
                    break;
                }
                case 2: {
                    value = UIArb.getString(190);
                    break;
                }
                case 3: {
                    value = UIArb.getString(440);
                    break;
                }
                default: {
                    value = UIArb.getString(526);
                    break;
                }
            }
        }
        return this.m_rend.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }

    private void disableAll() {
        this._refreshPeriodLabel.setEnabled(false);
        this._refreshPeriodComboBox.setEnabled(false);
        this._refreshMethodLabel.setEnabled(false);
        this._refreshMethodComboBox.setEnabled(false);
        this._refreshWithLabel.setEnabled(false);
        this._refreshWithComboBox.setEnabled(false);
        this._dateChooser.setEnabled(false);
        this._nextDateChooser.setEnabled(false);
        this._refreshAtLabel.setEnabled(false);
        this._nextDateLabel.setEnabled(false);
        this._rollbackCheckBox.setEnabled(false);
        this._defaultRollbackRadio.setEnabled(false);
        this._useSpecificRadioButton.setEnabled(false);
        this._rollbackSegmentTextField.setEnabled(false);
        this._localRollbackRadio.setEnabled(false);
        this._masterRollbackRadio.setEnabled(false);
        this._refreshUseConstraintCheckBox.setEnabled(false);
        this._enforcedRadioButton.setEnabled(false);
        this._trustedRadioButton.setEnabled(false);
    }

    static void mav$_refreshPeriodComboBox_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._refreshPeriodComboBox_actionPerformed(actionEvent);
    }

    static void mav$_rollbackCheckBox_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._rollbackCheckBox_actionPerformed(actionEvent);
    }

    static void mav$_defaultRollbackRadio_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._defaultRollbackRadio_actionPerformed(actionEvent);
    }

    static void mav$_useSpecificRadioButton_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._useSpecificRadioButton_actionPerformed(actionEvent);
    }

    static void mav$_useCheckContraints_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._useCheckContraints_actionPerformed(actionEvent);
    }

    static void mav$_trustedRadioButton_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._trustedRadioButton_actionPerformed(actionEvent);
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewLeftPanel.mav$_refreshPeriodComboBox_actionPerformed(MViewLeftPanel.this, e);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewLeftPanel.mav$_rollbackCheckBox_actionPerformed(MViewLeftPanel.this, e);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewLeftPanel.mav$_defaultRollbackRadio_actionPerformed(MViewLeftPanel.this, e);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewLeftPanel.mav$_useSpecificRadioButton_actionPerformed(MViewLeftPanel.this, e);
        }
    }

    final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewLeftPanel.mav$_useCheckContraints_actionPerformed(MViewLeftPanel.this, e);
        }
    }

    final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewLeftPanel.mav$_trustedRadioButton_actionPerformed(MViewLeftPanel.this, e);
        }
    }

    static class 7 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$ora$MaterializedView$RefreshMode;
        static final /* synthetic */ int[] $sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod;

        static {
            int[] nArray = new int[MaterializedView.RefreshMethod.values().length];
            $sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod = nArray;
            try {
                nArray[MaterializedView.RefreshMethod.COMPLETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod[MaterializedView.RefreshMethod.FORCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod[MaterializedView.RefreshMethod.FAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod[MaterializedView.RefreshMethod.NEVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            int[] nArray2 = new int[MaterializedView.RefreshMode.values().length];
            $sm$oracle$javatools$db$ora$MaterializedView$RefreshMode = nArray2;
            try {
                nArray2[MaterializedView.RefreshMode.DEMAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMode[MaterializedView.RefreshMode.COMMIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMode[MaterializedView.RefreshMode.SPECIFY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMode[MaterializedView.RefreshMode.NEVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

