/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.panels.sql.WhereEditor;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

public class HavingPanel
extends BaseSQLQueryBuilderPanel {
    private JPanel m_center;
    private WhereEditor m_whereEditor;
    private JWrappedLabel m_desc;
    private JWrappedLabel m_groupBy;
    private JLabel m_labelGROUPBY;
    private JLabel m_labelHAVING;
    private boolean m_havingAllowedLayout;
    private GroupByObject m_gbo;
    private SQLQueryBuilder m_builder;

    private void $init$() {
        this.m_whereEditor = new WhereEditor("HavingPanel");
        this.m_desc = new JWrappedLabel();
        this.m_groupBy = new JWrappedLabel();
        this.m_labelGROUPBY = new JLabel("<html><b>GROUP BY</b></html>");
        this.m_labelHAVING = new JLabel();
    }

    public HavingPanel() {
        this.$init$();
    }

    protected void layoutComponents() {
        if (this.m_builder != null) {
            this.m_gbo = this.m_builder.getSQLQuery().getGroupByObject();
            if (this.m_gbo == null) {
                this.layoutMessageOnly(UIArb.getString(809));
                this.m_havingAllowedLayout = false;
            } else if (!this.m_havingAllowedLayout) {
                this.layoutHaving();
                this.m_havingAllowedLayout = true;
            }
        }
    }

    private void layoutHaving() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 15));
        this.m_desc.setText(UIArb.getString(554));
        this.add((Component)this.m_desc, "North");
        if (this.m_center == null) {
            DBUIResourceHelper reshelp = new DBUIResourceHelper("HavingPanel");
            this.m_center = new JPanel();
            this.m_center.setLayout(new GridBagLayout());
            reshelp.setName(this.m_center, "HavingPanel");
            this.m_center.add((Component)this.m_labelGROUPBY, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_center.add((Component)this.m_groupBy, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
            reshelp.resLabel(this.m_labelHAVING, this.m_whereEditor.getDefaultComponent(), "&HAVING", "Having");
            this.m_labelHAVING.setText("<html><b><u>H</u>AVING</b></html>");
            this.m_center.add((Component)this.m_labelHAVING, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_center.add((Component)this.m_whereEditor, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add(this.m_center, "Center");
    }

    protected void init(SQLQueryBuilder builder, DBObject defaultObject) {
        this.m_builder = builder;
        this.m_whereEditor.setTemplates(this.m_builder.getSQLQuery().getFromObjects(), null);
        this.m_whereEditor.setDBObjectProvider(this.m_pro);
        this.layoutComponents();
        this.m_gbo = this.m_builder.getSQLQuery().getGroupByObject();
        if (this.m_gbo != null) {
            SQLFragment[] colus = this.m_gbo.getExpressions();
            FastStringBuffer buff = new FastStringBuffer();
            int i = 0;
            while (i < colus.length) {
                buff.append(colus[i].getSQLText());
                if (i < colus.length - 1) {
                    buff.append(", ");
                }
                ++i;
            }
            this.m_groupBy.setText(buff.toString());
            this.m_whereEditor.setTemplates(this.m_builder.listAllFromObjects(), this.m_builder.listAvailableFKs());
            WhereObject having = this.m_gbo.getHaving();
            this.m_whereEditor.init(having, this.m_builder);
        }
        this.enableButtons(true);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (this.m_builder != null && this.m_whereEditor.isEnabled() && this.m_gbo != null && this.m_whereEditor.hasTextChanged()) {
            String sql = this.m_whereEditor.getWhereText();
            if (ModelUtil.hasLength((String)sql)) {
                try {
                    SQLFragment having = this.m_builder.parseHavingExpression(sql);
                    if (!(having instanceof WhereObject)) {
                        having = new WhereObject(having);
                    }
                    this.m_builder.setHavingObject((WhereObject)having);
                }
                catch (SQLQueryException sqe) {
                    throw new TraversalException(sqe.getMessage());
                }
            } else if (this.m_builder.getSQLQuery().getGroupByObject() != null) {
                this.m_builder.setHavingObject(null);
            }
        }
    }
}

