/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SearchableTextArea;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.util.ExpressionEditSupport;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;

public class QueryPanel
extends BaseSQLQueryBuilderPanel
implements ActionListener,
DocumentListener {
    private JLabel m_queryLabel;
    private SearchableTextArea m_query;
    private boolean m_commitPending;
    private boolean m_invalidChangeCommitted;
    private JButton m_test;
    private JButton m_revert;
    private JLabel m_feedbackLabel;
    private DescriptionScrollPane m_feedback;
    private String m_originalText;

    private void $init$() {
        this.m_queryLabel = new JLabel();
        this.m_query = new SearchableTextArea();
        this.m_test = new JButton();
        this.m_revert = new JButton();
        this.m_feedbackLabel = new JLabel();
        this.m_feedback = new DescriptionScrollPane();
    }

    public QueryPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean invalidWithoutBuilder() {
        return false;
    }

    protected void layoutComponents() {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("QueryPanel");
        new ExpressionEditSupport(this.m_query.getTextComponent());
        this.setLayout(new BorderLayout(0, 15));
        JPanel center = new JPanel();
        center.setLayout(new GridBagLayout());
        reshelp.resLabel(this.m_queryLabel, this.m_query, UIArb.getString(347), "Query");
        center.add((Component)this.m_queryLabel, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        ((JTextArea)this.m_query.getTextComponent()).setLineWrap(true);
        ((JTextArea)this.m_query.getTextComponent()).setWrapStyleWord(true);
        center.add((Component)this.m_query, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        reshelp.resButton(this.m_revert, UIArb.getString(118), "Revert");
        this.m_revert.addActionListener(this);
        center.add((Component)this.m_revert, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0));
        reshelp.resButton(this.m_test, UIArb.getString(666), "Test");
        this.m_test.addActionListener(this);
        center.add((Component)this.m_test, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        reshelp.resLabel(this.m_feedbackLabel, this.m_feedback.getLabelComponent(), UIArb.getString(834), "Results");
        this.m_feedback.setBorder(null);
        this.m_feedback.setColumnHeaderView((Component)this.m_feedbackLabel);
        center.add((Component)this.m_feedback, new GridBagConstraints(1, 2, 1, 2, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        center.add(Box.createVerticalGlue(), new GridBagConstraints(2, 3, 1, 1, 0.0, 0.5, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(center, "Center");
    }

    protected void init(SQLQueryBuilder builder, DBObject defaultObject) {
        SQLQuery query = QueryPanel.findQuery(this.m_namespace);
        if (builder != null && !(query instanceof NonDeclarativeSQLQuery)) {
            this.enableButtons(true);
            query = (SQLQuery)builder.getSQLQuery();
        }
        if (query != null) {
            String sql = query.getSQLText();
            this.m_originalText = sql == null ? "" : sql.trim();
            this.initQuery();
        }
    }

    protected boolean isQueryPanel() {
        return true;
    }

    private void initQuery() {
        this.m_query.getTextComponent().getDocument().removeDocumentListener(this);
        if (ModelUtil.hasLength((String)this.m_originalText)) {
            this.m_query.getTextComponent().setText(this.m_originalText);
            this.m_commitPending = this.m_invalidChangeCommitted;
        } else {
            this.m_query.getTextComponent().setText("SELECT \n    \nFROM \n    ");
        }
        this.m_query.getTextComponent().setCaretPosition(0);
        this.m_query.getTextComponent().getDocument().addDocumentListener(this);
        this.m_revert.setEnabled(false);
        this.m_test.setEnabled(this.m_commitPending);
        this.setFeedback(null);
        this.validate();
    }

    private void setFeedback(String feedback) {
        this.m_feedback.setText(feedback);
        this.m_feedback.getAccessibleContext().setAccessibleName(this.m_feedbackLabel.getText());
        this.m_feedback.getAccessibleContext().setAccessibleDescription(feedback);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (this.m_commitPending) {
            String sql = this.m_query.getTextComponent().getText().trim();
            if (this.m_invalidChangeCommitted || !ModelUtil.hasLength((String)this.m_originalText) || ModelUtil.areDifferent((Object)sql, (Object)this.m_originalText)) {
                this.m_invalidChangeCommitted = false;
                SQLQuery query = QueryPanel.findQuery((Namespace)dataContext);
                Object obj = dataContext.get("NewObject");
                if (query != null) {
                    SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.m_pro, (Schema)this.m_defaultSchema);
                    dataContext.put("SQLQueryBuilder", (Object)builder);
                    try {
                        builder.buildQuery(sql, this.m_sObj instanceof SQLQueryOwner ? (SQLQueryOwner)this.m_sObj : null);
                        if (obj instanceof MaterializedView) {
                            builder.getSQLQuery().setOrderByObjects(null);
                        }
                    }
                    catch (SQLParseException spe) {
                        this.m_invalidChangeCommitted = true;
                        throw new TraversalException(spe.getMessage());
                    }
                    catch (SQLQueryException sqe) {
                        this.m_invalidChangeCommitted = true;
                        query = builder.getSQLQuery();
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                        throw new TraversalException("An error has occured " + e.getMessage());
                    }
                    if (query instanceof NonDeclarativeSQLQuery && this.m_pro instanceof Database) {
                        ((NonDeclarativeSQLQuery)query).setQueryString(sql);
                        if (obj instanceof SQLQueryOwner) {
                            try {
                                builder.getSQLQuery().setParent((DBObject)obj);
                                builder.syncViewColumns();
                            }
                            catch (AliasInUseException aiue) {}
                        }
                    } else if (obj instanceof SQLQueryOwner) {
                        ((SQLQueryOwner)obj).setSQLQuery((SQLQuery)builder.getSQLQuery());
                        try {
                            builder.syncViewColumns();
                        }
                        catch (AliasInUseException aiue) {
                            throw new TraversalException(aiue.getMessage());
                        }
                    } else if (obj instanceof SQLQuery) {
                        dataContext.put("NewObject", (Object)builder.getSQLQuery());
                    }
                }
            }
        }
    }

    private void queryEdited() {
        this.m_commitPending = true;
        this.m_revert.setEnabled(true);
        this.m_test.setEnabled(true);
        this.m_query.getTextComponent().getDocument().removeDocumentListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_test) {
            try {
                SQLQueryBuilder sqb = this.m_sObj instanceof SQLQueryOwner ? SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.m_pro, (SQLQueryOwner)((SQLQueryOwner)this.m_sObj), (String)this.m_query.getTextComponent().getText().trim()) : SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.m_pro, (Schema)this.m_defaultSchema, (String)this.m_query.getTextComponent().getText().trim());
                OrderByObject[] ob = sqb.getSQLQuery().getOrderByObjects();
                if (this.getObject() instanceof MaterializedView && ob != null && ob.length > 0) {
                    throw new SQLQueryException(UIArb.getString(762));
                }
                this.setFeedback(UIArb.getString(698));
            }
            catch (SQLParseException spe) {
                this.setFeedback(spe.getMessage());
            }
            catch (SQLQueryException sqe) {
                FastStringBuffer message = new FastStringBuffer();
                message.append(UIArb.getString(376));
                message.append("\n\n").append(sqe.getMessage());
                this.setFeedback(message.toString());
            }
            catch (Exception ex) {
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)ex);
            }
            this.validate();
            this.m_feedback.getLabelComponent().requestFocusInWindow();
        } else if (source == this.m_revert) {
            this.initQuery();
            this.m_query.requestFocusInWindow();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.queryEdited();
    }

    public void removeUpdate(DocumentEvent e) {
        this.queryEdited();
    }

    public void changedUpdate(DocumentEvent e) {
        this.queryEdited();
    }
}

