/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.panels.sql.WhereEditor;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

public class WhereObjectPanel
extends BaseSQLQueryBuilderPanel {
    private JWrappedLabel m_desc;
    private JLabel m_labelWHERE;
    private JPanel m_wherePanel;
    private SQLQueryBuilder m_builder;
    private WhereEditor m_whereEditor;

    private void $init$() {
        this.m_desc = new JWrappedLabel(UIArb.getString(47));
        this.m_labelWHERE = new JLabel();
        this.m_whereEditor = new WhereEditor("WhereObjectPanel");
    }

    public WhereObjectPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout(0, 15));
        this.add((Component)this.m_desc, "North");
        DBUIResourceHelper reshelp = new DBUIResourceHelper("WhereObjectPanel");
        this.m_wherePanel = new JPanel();
        this.m_wherePanel.setLayout(new GridBagLayout());
        reshelp.setName(this.m_wherePanel, "WherePanel");
        reshelp.resLabel(this.m_labelWHERE, this.m_whereEditor.getDefaultComponent(), "&WHERE", "Where");
        this.m_labelWHERE.setText("<html><b><u>W</u>HERE</b></html>");
        this.m_wherePanel.add((Component)this.m_labelWHERE, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_wherePanel.add((Component)this.m_whereEditor, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_wherePanel, "Center");
    }

    protected void init(SQLQueryBuilder builder, DBObject defaultObject) {
        this.enableButtons(true);
        this.m_builder = builder;
        this.m_whereEditor.setTemplates(this.m_builder.listAllFromObjects(), this.m_builder.listAvailableFKs());
        WhereObject where = this.m_builder.getSQLQuery().getWhereObject();
        this.m_whereEditor.init(where, this.m_builder);
        this.m_whereEditor.setDBObjectProvider(this.m_pro);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (this.m_builder != null && this.m_whereEditor.hasTextChanged()) {
            String sql = this.m_whereEditor.getWhereText().trim();
            if (sql != null && ModelUtil.hasLength((String)sql)) {
                try {
                    SQLFragment frag = this.m_builder.parseWhereExpression(sql);
                    WhereObject where = frag instanceof WhereObject ? (WhereObject)frag : new WhereObject(frag);
                    this.m_builder.setWhereObject(where);
                }
                catch (SQLQueryException sqe) {
                    throw new TraversalException(sqe.getMessage());
                }
            } else {
                this.m_builder.setWhereObject(null);
            }
        }
    }
}

