/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.ConstraintPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;

public abstract class BaseConstraintPanel
extends BaseInfoPanel {
    private JPanel pnlList;
    private ConstraintPanel pnlDetail;
    private GridBagLayout layList;
    private GridBagLayout layMain;
    private JLabel lblConstraints;
    private JScrollPane scrConstraints;
    private JButton btnAdd;
    private JButton btnRemove;
    private JList lstConstraints;
    private JPanel pnlButtons;
    private GridLayout layButtons;
    private EventHandler _handler;
    private DBObjectRenderer renderer;
    private DefaultListModel _mdlCons;
    private Relation _relation;
    private Namespace _cNamespace;
    private Constraint _con;
    private Constraint _selectedCon;
    private boolean _isNewConstraint;
    private int _currentSelection;
    private List _consList;
    private static Map s_postfixes = new HashMap();

    private void $init$() {
        this.pnlList = new JPanel();
        this.pnlDetail = this.getDetailPanel();
        this.layList = new GridBagLayout();
        this.layMain = new GridBagLayout();
        this.lblConstraints = new JLabel();
        this.scrConstraints = new JScrollPane();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.lstConstraints = new JList();
        this.pnlButtons = new JPanel();
        this.layButtons = new GridLayout();
        this._handler = new EventHandler(null);
        this.renderer = this.getRenderer();
        this._mdlCons = new DefaultListModel();
        this._isNewConstraint = false;
        this._currentSelection = 0;
        this._consList = new ArrayList();
    }

    public BaseConstraintPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        int idx;
        this._cNamespace = new Namespace((Namespace)dataContext);
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
        this.init((DBObjectProvider)dataContext.find("DBObjectProvider"), (ConstraintsInfoVerifier)dataContext.find("ConstraintsInfoVerifier"));
        this._relation = (Relation)dataContext.find("NewObject");
        this._updateDetailPanel();
        ConstraintsInfoVerifier verifier = (ConstraintsInfoVerifier)this.getVerifier();
        this.btnAdd.setEnabled(verifier == null || verifier.canAddConstraints());
        this._consList = new ArrayList<Constraint>(Arrays.asList(this._relation.getConstraints()));
        Constraint[] cons = this.findSupportedConstraints(this._relation);
        this._mdlCons.clear();
        int i = 0;
        while (i < cons.length) {
            this._mdlCons.addElement(cons[i]);
            this._consList.remove(cons[i]);
            ++i;
        }
        int sel = 0;
        Object defaultObject = dataContext.find("DefaultChild");
        if (defaultObject != null && (idx = this._mdlCons.indexOf(defaultObject)) != -1) {
            sel = idx;
        }
        if (cons.length > 0) {
            this.setSelectedConstraint(sel);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this._commitDetail(true);
        Constraint[] oldCons = this._consList.toArray(new Constraint[this._consList.size()]);
        Constraint[] newCons = this._getConstraintsFromList();
        Constraint[] cons = new Constraint[oldCons.length + newCons.length];
        System.arraycopy(oldCons, 0, cons, 0, oldCons.length);
        System.arraycopy(newCons, 0, cons, oldCons.length, newCons.length);
        this._relation.setConstraints(cons);
        this._con = null;
    }

    private Constraint[] _getConstraintsFromList() {
        Object[] newCons = new Constraint[this._mdlCons.getSize()];
        this._mdlCons.copyInto(newCons);
        return newCons;
    }

    private void jbInit() throws Exception {
        DBUIResourceHelper reshelp = new DBUIResourceHelper(this.getPanelName());
        this.setLayout(this.layMain);
        this.pnlList.setLayout(this.layList);
        reshelp.resLabel(this.lblConstraints, this.lstConstraints, this.getListLabel(), "ConstraintList");
        reshelp.resButton(this.btnAdd, UIArb.getString(10), "Add");
        this.btnAdd.addActionListener(this._handler);
        reshelp.resButton(this.btnRemove, UIArb.getString(590), "Remove");
        this.btnRemove.addActionListener(this._handler);
        this.lstConstraints.setVisibleRowCount(4);
        this.lstConstraints.setSelectionMode(0);
        this.lstConstraints.setModel(this._mdlCons);
        this.lstConstraints.addListSelectionListener(this._handler);
        this.lstConstraints.setCellRenderer(this.renderer);
        this.pnlButtons.setLayout(this.layButtons);
        this.layButtons.setColumns(1);
        this.layButtons.setRows(2);
        this.layButtons.setVgap(5);
        this.pnlList.add((Component)this.lblConstraints, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrConstraints.getViewport().add((Component)this.lstConstraints, null);
        this.pnlList.add((Component)this.scrConstraints, new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlButtons.add((Component)this.btnAdd, null);
        this.pnlButtons.add((Component)this.btnRemove, null);
        this.pnlList.add((Component)this.pnlButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.pnlList, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((JPanel)((Object)this.pnlDetail), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
    }

    protected abstract ConstraintPanel getDetailPanel();

    protected abstract String getConstraintType();

    protected abstract String getListLabel();

    protected abstract String getPanelName();

    protected final Constraint createNewConstraint() {
        String cType = this.getConstraintType();
        Object result = "PKConstraint".equals(cType) ? new PKConstraint() : ("FKConstraint".equals(cType) ? new FKConstraint() : ("CheckConstraint".equals(cType) ? new CheckConstraint() : new UniqueConstraint()));
        result.setID(TemporaryObjectID.createID((DBObject)result));
        this._isNewConstraint = true;
        result.setRelation(this._relation);
        return result;
    }

    protected Constraint[] findSupportedConstraints(Relation table) {
        String cType = this.getConstraintType();
        Constraint[] relCons = table.getConstraints();
        ArrayList<Constraint> cons = new ArrayList<Constraint>();
        int i = 0;
        while (i < relCons.length) {
            if (cType.equals(relCons[i].getConstraintType())) {
                cons.add(relCons[i]);
            }
            ++i;
        }
        return cons.toArray(new Constraint[cons.size()]);
    }

    protected DBObjectRenderer getRenderer() {
        return new DBObjectRenderer();
    }

    private void _updateDetailPanel() {
        ConstraintsInfoVerifier verifier = (ConstraintsInfoVerifier)this.getVerifier();
        boolean canRemove = this._con != null && (verifier == null || verifier.canRemoveConstraints() && verifier.canRemoveConstraint(this._con));
        this.btnRemove.setEnabled(canRemove);
        boolean canModify = this._con != null && (verifier == null || verifier.canModifyConstraint(this._con));
        this._cNamespace.put("NewChildObject", (Object)this._con);
        this._cNamespace.put("Modifiable", (Object)canModify);
        this._cNamespace.put("otherCons", (Object)this._getConstraintsFromList());
        this._cNamespace.put("constraintPanel", (Object)this);
        try {
            this.pnlDetail.init(this._cNamespace);
        }
        catch (TraversalException ex) {
            this._con = null;
            this.lstConstraints.clearSelection();
        }
    }

    private void _showConstraintError(TraversalException ex) {
        ex.showMessageDialog((Component)((Object)this));
        int indexOfSelectedIndex = this.lstConstraints.getSelectedIndex();
        if (indexOfSelectedIndex < 0 || this._mdlCons.elementAt(indexOfSelectedIndex).equals(this._mdlCons.elementAt(this._currentSelection))) {
            this.setSelectedConstraint(this._currentSelection);
        } else if (this._currentSelection != indexOfSelectedIndex) {
            this.setSelectedConstraint(this._con);
        }
    }

    private void _updateSelection() {
        Constraint con = (Constraint)this.lstConstraints.getSelectedValue();
        if (con != this._con) {
            try {
                this._commitDetail(true);
                this._con = con;
                if (this._con == null || this._isNewConstraint) {
                    this._selectedCon = null;
                    this._isNewConstraint = false;
                } else {
                    this._selectedCon = (Constraint)con.copyTo(null);
                }
                this._updateDetailPanel();
            }
            catch (TraversalException ex) {
                this._showConstraintError(ex);
            }
        }
        ConstraintsInfoVerifier verifier = (ConstraintsInfoVerifier)this.getVerifier();
        boolean canRemove = con != null && (verifier == null || verifier.canRemoveConstraints() && verifier.canRemoveConstraint(con));
        this.btnRemove.setEnabled(canRemove);
    }

    private void _commitDetail(boolean verify) throws TraversalException {
        if (this._con != null) {
            ConstraintsInfoVerifier verifier;
            this.pnlDetail.commit();
            if (verify && (verifier = (ConstraintsInfoVerifier)this.getVerifier()) != null) {
                verifier.verifyConstraint(this._selectedCon, this._con);
            }
        }
    }

    protected static String findUniqueName(Relation tbl, Constraint con, Constraint[] otherCons, DBObjectProvider pro) {
        String baseName = BaseConstraintPanel.getDefaultBaseName(tbl.getName(), con.getConstraintType(), pro);
        Constraint[] cons = tbl.getConstraints();
        if (otherCons.length > 0) {
            Constraint[] tmp = cons;
            cons = new Constraint[tmp.length + otherCons.length];
            System.arraycopy(tmp, 0, cons, 0, tmp.length);
            System.arraycopy(otherCons, 0, cons, tmp.length, otherCons.length);
        }
        return BaseConstraintPanel.findUniqueName(baseName, con, cons);
    }

    static {
        s_postfixes.put("PKConstraint", "_PK");
        s_postfixes.put("UniqueConstraint", "_UK");
        s_postfixes.put("FKConstraint", "_FK");
        s_postfixes.put("CheckConstraint", "_CHK");
    }

    protected static String getDefaultBaseName(String relName, String conType, DBObjectProvider pro) {
        String name = relName == null ? "" : relName;
        int maxNameLength = pro.getDescriptor().getMaxNameLength("CONSTRAINT");
        String postfix = (String)s_postfixes.get(conType);
        if (pro.getDescriptor().getCasePolicy() == 1) {
            postfix = postfix.toLowerCase();
        }
        int maxlen = maxNameLength - postfix.length() - 2;
        return name.length() > maxlen ? name.substring(0, maxlen) + postfix : name + postfix;
    }

    protected static String getDefaultFKBaseName(String relName, String refName, DBObjectProvider pro) {
        return refName != null ? BaseConstraintPanel.getDefaultBaseName(relName + "_" + refName, "FKConstraint", pro) : BaseConstraintPanel.getDefaultBaseName(relName, "FKConstraint", pro);
    }

    protected static String findUniqueName(String base, Constraint con, Constraint[] cons) {
        HashSet<String> conSet = new HashSet<String>();
        if (cons != null) {
            int i = 0;
            while (i < cons.length) {
                if (con != cons[i]) {
                    conSet.add(cons[i].getName());
                }
                ++i;
            }
        }
        if (con instanceof PKConstraint && !conSet.contains(base)) {
            return base;
        }
        String name = null;
        int i = 1;
        while (name == null) {
            name = base + i;
            if (conSet.contains(name)) {
                name = null;
            }
            ++i;
        }
        return name;
    }

    private void setSelectedConstraint(int indexOfConstraint) {
        this._currentSelection = indexOfConstraint;
        this.lstConstraints.setSelectedIndex(this._currentSelection);
    }

    private void setSelectedConstraint(Constraint constraint) {
        this.lstConstraints.setSelectedValue(constraint, true);
        this._currentSelection = this.lstConstraints.getSelectedIndex();
    }

    protected void constraintChanged(Constraint con) {
        if (this._con == null) {
            this._con = con;
        }
    }

    static JList ra$lstConstraints(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel.lstConstraints;
    }

    static void wa$_currentSelection(BaseConstraintPanel baseConstraintPanel, int n) {
        baseConstraintPanel._currentSelection = n;
    }

    static JButton ra$btnAdd(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel.btnAdd;
    }

    static void mav$_commitDetail(BaseConstraintPanel baseConstraintPanel, boolean bl) {
        baseConstraintPanel._commitDetail(bl);
    }

    static Relation ra$_relation(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel._relation;
    }

    static Constraint[] mav$_getConstraintsFromList(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel._getConstraintsFromList();
    }

    static DBObjectProvider mav$getProvider(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel.getProvider();
    }

    static DefaultListModel ra$_mdlCons(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel._mdlCons;
    }

    static void mav$setSelectedConstraint(BaseConstraintPanel baseConstraintPanel, int n) {
        baseConstraintPanel.setSelectedConstraint(n);
    }

    static void mav$_showConstraintError(BaseConstraintPanel baseConstraintPanel, TraversalException traversalException) {
        baseConstraintPanel._showConstraintError(traversalException);
    }

    static JButton ra$btnRemove(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel.btnRemove;
    }

    static Constraint ra$_con(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel._con;
    }

    static void wa$_con(BaseConstraintPanel baseConstraintPanel, Constraint constraint) {
        baseConstraintPanel._con = constraint;
    }

    static void mav$_updateDetailPanel(BaseConstraintPanel baseConstraintPanel) {
        baseConstraintPanel._updateDetailPanel();
    }

    static void mav$_updateSelection(BaseConstraintPanel baseConstraintPanel) {
        baseConstraintPanel._updateSelection();
    }

    private final class EventHandler
    implements ListSelectionListener,
    ActionListener,
    ListDataListener {
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                BaseConstraintPanel.mav$_updateSelection(BaseConstraintPanel.this);
            }
        }

        public void actionPerformed(ActionEvent e) {
            int idx;
            BaseConstraintPanel.wa$_currentSelection(BaseConstraintPanel.this, BaseConstraintPanel.ra$lstConstraints(BaseConstraintPanel.this).getSelectedIndex());
            Object src = e.getSource();
            if (src == BaseConstraintPanel.ra$btnAdd(BaseConstraintPanel.this)) {
                try {
                    BaseConstraintPanel.mav$_commitDetail(BaseConstraintPanel.this, true);
                    Constraint con = BaseConstraintPanel.this.createNewConstraint();
                    con.setEnabled(true);
                    con.setName(BaseConstraintPanel.findUniqueName(BaseConstraintPanel.ra$_relation(BaseConstraintPanel.this), con, BaseConstraintPanel.mav$_getConstraintsFromList(BaseConstraintPanel.this), BaseConstraintPanel.mav$getProvider(BaseConstraintPanel.this)));
                    BaseConstraintPanel.ra$_relation(BaseConstraintPanel.this).addConstraint(con);
                    BaseConstraintPanel.ra$_mdlCons(BaseConstraintPanel.this).addElement(con);
                    int idx2 = BaseConstraintPanel.ra$_mdlCons(BaseConstraintPanel.this).indexOf(con);
                    BaseConstraintPanel.mav$setSelectedConstraint(BaseConstraintPanel.this, idx2);
                }
                catch (TraversalException ex) {
                    BaseConstraintPanel.mav$_showConstraintError(BaseConstraintPanel.this, ex);
                }
            } else if (src == BaseConstraintPanel.ra$btnRemove(BaseConstraintPanel.this) && (idx = BaseConstraintPanel.ra$lstConstraints(BaseConstraintPanel.this).getSelectedIndex()) != -1) {
                BaseConstraintPanel.ra$_relation(BaseConstraintPanel.this).removeConstraint(BaseConstraintPanel.ra$_con(BaseConstraintPanel.this));
                BaseConstraintPanel.wa$_con(BaseConstraintPanel.this, null);
                int newIdx = idx == BaseConstraintPanel.ra$_mdlCons(BaseConstraintPanel.this).size() - 1 ? idx - 1 : idx + 1;
                BaseConstraintPanel.mav$setSelectedConstraint(BaseConstraintPanel.this, newIdx);
                BaseConstraintPanel.ra$_mdlCons(BaseConstraintPanel.this).remove(idx);
                if (newIdx == -1) {
                    BaseConstraintPanel.mav$_updateDetailPanel(BaseConstraintPanel.this);
                }
            }
        }

        public void contentsChanged(ListDataEvent e) {
        }

        public void intervalAdded(ListDataEvent e) {
        }

        public void intervalRemoved(ListDataEvent e) {
        }

        private EventHandler() {
        }

        EventHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

