/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.ColumnEditorPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.dialogs.MessageDialog;

public class ColumnDialog
extends JPanel
implements VetoableChangeListener {
    public static final String COLUMN_HELP_ID = "f1_offdbpkconscolumn_html";
    private JEWTDialog m_dialog;
    private JWrappedLabel m_desc;
    private ColumnEditorPanel m_colPanel;
    private Column m_col;

    public ColumnDialog(DBObjectProvider prv, Table sourceTable, Column col, boolean standalone) {
        this.m_col = col;
        this.createComponents(prv, sourceTable, standalone);
        this.layoutComponents();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, COLUMN_HELP_ID);
    }

    public static boolean createColumn(DBObjectProvider prv, Table sourceTable, Component parent) throws DBException {
        return ColumnDialog.editColumn(prv, sourceTable, null, parent);
    }

    public static boolean editColumn(DBObjectProvider prv, Table sourceTable, Column col, Component parent) throws DBException {
        String TITLE = UIArb.getString(424);
        if (sourceTable == null || prv == null) {
            throw new IllegalArgumentException("Null information supplied to Edit Column dialog");
        }
        boolean created = false;
        if (col == null) {
            col = ColumnDialog.createDefaultColumn(prv, sourceTable);
            created = true;
        }
        int bit = 7;
        JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)TITLE, (int)bit);
        ColumnDialog panel = new ColumnDialog(prv, sourceTable, col, true);
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        dialog.setPreferredSize(500, 400);
        panel.setDialog(dialog);
        if (dialog.runDialog()) {
            return true;
        }
        if (created) {
            sourceTable.removeColumn(col);
        }
        dialog.dispose();
        return false;
    }

    private void createComponents(DBObjectProvider prv, Table tbl, boolean standalone) {
        String name = tbl.getName();
        String text = UIArb.format(888, name);
        this.m_desc = new JWrappedLabel(text);
        this.m_colPanel = new ColumnEditorPanel(standalone);
        this.m_colPanel.init(prv, tbl.getSchema(), null);
        this.m_colPanel.setColumn(this.m_col);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(0, 15));
        this.add((Component)this.m_desc, "North");
        this.add((Component)this.m_colPanel, "Center");
    }

    private void setDialog(JEWTDialog dialog) {
        this.m_dialog = dialog;
        this.m_dialog.addVetoableChangeListener((VetoableChangeListener)this);
    }

    private static Column createDefaultColumn(DBObjectProvider pr, Table table) {
        Column col = new Column();
        col.setName("COL");
        DataType datatype = pr.getDataType("NUMBER");
        DataTypeUsage dtu = datatype.createDefaultUsage();
        col.setDataTypeUsage(dtu);
        table.addColumn(col);
        return col;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
            try {
                this.m_colPanel.commit(this.m_col);
            }
            catch (TraversalException e) {
                MessageDialog.error((Component)this, (Object)e.getMessage(), (String)UIArb.getString(82), null);
                throw new PropertyVetoException("invalid column", evt);
            }
        }
    }
}

