/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.util.ModelUtil;

public class ColumnSequencePanel
extends BaseInfoPanel
implements ActionListener {
    private JLabel _lblColumns;
    private JLabel _lblSequence;
    private JLabel _lblTrigger;
    private JComboBox _cmbColumns;
    private JTextField _txtTrigger;
    private JPanel _sequencePanel;
    private JRadioButton _btnNone;
    private JRadioButton _btnExistingSequence;
    private JRadioButton _btnNewSequence;
    private JComboBox _cmbExistingSequence;
    private JTextField _txtNewSequence;
    private Table _table;
    private Column _lastColSelection;
    private String[] _existingSequenceNames;
    private List<String> _sessionTriggerNames;

    public ColumnSequencePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this._sequencePanel.setLayout(new GridBagLayout());
        this._sequencePanel.setName("ColumnSequencePanel.PNL_COL_SEQ");
        this._btnNone.setName("ColumnSequencePanel.BTN_NONE");
        this._btnExistingSequence.setName("ColumnSequencePanel.BTN_EXISTING_SEQ");
        this._btnNewSequence.setName("ColumnSequencePanel.BTN_NEW_SEQ");
        this._cmbColumns.setName("ColumnSequencePanel.CMB_COLUMN");
        this._cmbExistingSequence.setName("ColumnSequencePanel.CMB_EXISTING_SEQ");
        this._txtTrigger.setName("ColumnSequencePanel.TXT_TRIGGER");
        ResourceUtils.resButton((AbstractButton)this._btnNone, (String)UIArb.getString(617));
        ResourceUtils.resButton((AbstractButton)this._btnExistingSequence, (String)UIArb.getString(529));
        ResourceUtils.resButton((AbstractButton)this._btnNewSequence, (String)UIArb.getString(539));
        ResourceUtils.resLabel((JLabel)this._lblColumns, (Component)this._cmbColumns, (String)UIArb.getString(180));
        ResourceUtils.resLabel((JLabel)this._lblSequence, (Component)this._sequencePanel, (String)UIArb.getString(798));
        ResourceUtils.resLabel((JLabel)this._lblTrigger, (Component)this._txtTrigger, (String)UIArb.getString(330));
        int y = 0;
        this.add(this._lblColumns, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._cmbColumns, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 20), 0, 0));
        this.add(this._lblSequence, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._btnNone, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._btnExistingSequence, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._cmbExistingSequence, new GridBagConstraints(2, y, 1, 1, 2.0, 0.0, 17, 2, new Insets(5, 0, 0, 30), 0, 0));
        this.add(this._btnNewSequence, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._txtNewSequence, new GridBagConstraints(2, y, 1, 1, 2.0, 0.0, 17, 2, new Insets(5, 0, 0, 30), 0, 0));
        this.add(this._lblTrigger, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._txtTrigger, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 20), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._cmbColumns.addActionListener(this);
        this._txtNewSequence.addActionListener(this);
        this._cmbExistingSequence.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._btnNone);
        bg.add(this._btnExistingSequence);
        bg.add(this._btnNewSequence);
        this._btnNone.setSelected(true);
        this._btnNone.addActionListener(this);
        this._btnExistingSequence.addActionListener(this);
        this._btnNewSequence.addActionListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this._cmbColumns) {
            try {
                this.commit();
            }
            catch (TraversalException te) {
                te.showMessageDialog((Component)this._cmbColumns);
                this._cmbColumns.setSelectedItem(this._lastColSelection);
                return;
            }
            this.setupPanelForColumn();
        } else if (source == this._btnNone) {
            this._cmbExistingSequence.setEnabled(false);
            this._txtNewSequence.setEnabled(false);
            this._txtTrigger.setEnabled(false);
        } else if (source == this._btnExistingSequence) {
            this._cmbExistingSequence.setEnabled(true);
            this._txtNewSequence.setEnabled(false);
            this.setTriggerText();
        } else if (source == this._btnNewSequence) {
            this._txtNewSequence.setEnabled(true);
            if (!ModelUtil.hasLength((String)this._txtNewSequence.getText())) {
                this._txtNewSequence.setText(this.getUniqueName("SEQUENCE"));
            }
            this._cmbExistingSequence.setEnabled(false);
            this.setTriggerText();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        Table table = (Table)dataContext.find("NewObject");
        this.init(prov, table);
        if (!((Boolean)dataContext.find("DBObjectIsEditable")).booleanValue()) {
            this._lblColumns.setEnabled(false);
            this._lblSequence.setEnabled(false);
            this._lblTrigger.setEnabled(false);
            this._cmbColumns.setEnabled(false);
            this._txtTrigger.setEnabled(false);
            this._sequencePanel.setEnabled(false);
            this._btnNone.setEnabled(false);
            this._btnExistingSequence.setEnabled(false);
            this._btnNewSequence.setEnabled(false);
            this._cmbExistingSequence.setEnabled(false);
            this._txtNewSequence.setEnabled(false);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
    }

    private void init(DBObjectProvider prov, Table table) {
        super.init(prov, null);
        this._table = table;
        this._existingSequenceNames = this.getSequenceNames(table.getSchema());
        this._cmbExistingSequence.setModel(new DefaultComboBoxModel<String>(this._existingSequenceNames));
        ArrayList<Column> columns = new ArrayList<Column>();
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            Column col = columnArray[n];
            try {
                DBObject datatype = col.getDataTypeUsage().getDataTypeID().resolveID();
                if (datatype instanceof DataTypeSynonym) {
                    datatype = ((DataTypeSynonym)datatype).getBaseType();
                }
                if (datatype instanceof NumericDataType || datatype instanceof CharacterDataType) {
                    String trgName;
                    columns.add(col);
                    DBObjectID triggerID = (DBObjectID)col.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER");
                    if (triggerID != null && ModelUtil.hasLength((String)(trgName = DBUtil.getDBObjectName((DBObjectID)triggerID))) && !this._sessionTriggerNames.contains(trgName)) {
                        this._sessionTriggerNames.add(trgName);
                    }
                }
            }
            catch (DBException e) {
                // empty catch block
            }
            ++n;
        }
        this._cmbColumns.setModel(new DefaultComboBoxModel<Object>(columns.toArray()));
        if (columns.size() == 0) {
            this.enableAllComponents(false, true);
            return;
        }
        if (this._lastColSelection != null && columns.contains(this._lastColSelection)) {
            this._cmbColumns.setSelectedItem(this._lastColSelection);
        }
        this._cmbColumns.setEnabled(true);
        this.setupPanelForColumn();
    }

    private void commit() throws TraversalException {
        if (this._btnNone.isSelected()) {
            if (this._lastColSelection != null) {
                this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE", null);
                this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", null);
            }
        } else {
            DBObjectID lastColSelectionTrgID;
            String lastColSelectionTrgName;
            String trgName = this.getInternalName(this._txtTrigger.getText(), "TRIGGER");
            if (!trgName.equals(lastColSelectionTrgName = DBUtil.getDBObjectName((DBObjectID)(lastColSelectionTrgID = (DBObjectID)this._lastColSelection.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER"))))) {
                if (!this._sessionTriggerNames.contains(trgName)) {
                    try {
                        this.getProvider().validateUniqueName("TRIGGER", (DBObject)this._table.getSchema(), trgName);
                        this._sessionTriggerNames.add(trgName);
                    }
                    catch (NameInUseException e) {
                        throw new TraversalException(e.getMessage());
                    }
                }
                Trigger trg = new Trigger(this._table.getSchema(), trgName);
                trg.setID(TemporaryObjectID.createID((DBObject)trg));
                this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)trg.getID());
            }
            if (this._btnNewSequence.isSelected()) {
                String seqName = this.getInternalName(this._txtNewSequence.getText(), "SEQUENCE");
                try {
                    if (this._table.getName().equals(seqName)) {
                        throw new NameInUseException((DBObject)this._table);
                    }
                    this.getProvider().validateUniqueName("SEQUENCE", (DBObject)this._table.getSchema(), seqName);
                }
                catch (NameInUseException e) {
                    throw new TraversalException(e.getMessage());
                }
                Sequence seq = new Sequence(seqName, this._table.getSchema());
                seq.setID(TemporaryObjectID.createID((DBObject)seq));
                this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE", (Object)seq.getID());
            } else {
                try {
                    String seqName = (String)this._cmbExistingSequence.getSelectedItem();
                    SchemaObject seq = this.getProvider().getObject("SEQUENCE", this._table.getSchema(), seqName);
                    if (seq == null) {
                        throw new TraversalException(UIArb.format(511, seqName));
                    }
                    this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE", (Object)seq.getID());
                }
                catch (DBException e) {
                    throw new TraversalException(e.getMessage());
                }
            }
        }
    }

    private String getInternalName(String extName, String type) throws TraversalException {
        if (!ModelUtil.hasLength((String)extName)) {
            throw new TraversalException(UIArb.getString("TRIGGER".equals(type) ? 436 : 588));
        }
        String intName = this.getProvider().getInternalName(extName, type);
        try {
            this.getProvider().validateName(type, intName);
        }
        catch (InvalidNameException e) {
            throw new TraversalException(type + " : " + e.getMessage());
        }
        return intName;
    }

    private String[] getSequenceNames(Schema schema) {
        try {
            String[] stringArray = this.getProvider().listObjects("SEQUENCE", schema);
            return stringArray;
        }
        catch (DBException dBException) {
            return null;
        }
    }

    private void setupPanelForColumn() {
        this._lastColSelection = (Column)this._cmbColumns.getSelectedItem();
        this.enableAllComponents(true, true);
        DBObjectID seqID = (DBObjectID)this._lastColSelection.getProperty("AUTO_GENERATED_SEQUENCE");
        if (seqID != null) {
            String seqName = null;
            try {
                DBObject seq = seqID.resolveID();
                seqName = seq != null ? seq.getName() : null;
            }
            catch (DBException e) {
                // empty catch block
            }
            if (this.isExistingSequence(seqName)) {
                this._btnExistingSequence.setSelected(true);
                this._cmbExistingSequence.setSelectedItem(seqName);
                this._txtNewSequence.setEnabled(false);
                this._txtNewSequence.setText("");
            } else {
                this._btnNewSequence.setSelected(true);
                this._txtNewSequence.setText(this.getProvider().getExternalName(seqName));
                this._cmbExistingSequence.setEnabled(false);
            }
            this.setTriggerText();
        } else {
            this._btnNone.setSelected(true);
            this._cmbExistingSequence.setEnabled(false);
            this._txtNewSequence.setText("");
            this._txtNewSequence.setEnabled(false);
            this._txtTrigger.setText("");
            this._txtTrigger.setEnabled(false);
        }
    }

    private void setTriggerText() {
        String extName = this._txtTrigger.getText();
        this._txtTrigger.setEnabled(true);
        DBObjectID trgID = (DBObjectID)this._lastColSelection.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER");
        if (trgID != null) {
            try {
                DBObject trg = trgID.resolveID();
                extName = trg != null ? this.getProvider().getExternalName(trg.getName()) : null;
            }
            catch (DBException e) {}
        } else if (!ModelUtil.hasLength((String)this._txtTrigger.getText())) {
            extName = !this._sessionTriggerNames.isEmpty() ? this._sessionTriggerNames.get(0) : this.getUniqueName("TRIGGER");
        }
        this._txtTrigger.setText(extName);
    }

    protected void enableAllComponents(boolean boo, boolean incLabels) {
        this._cmbColumns.setEnabled(boo);
        this._btnNone.setEnabled(boo);
        this._btnNewSequence.setEnabled(boo);
        this._btnExistingSequence.setEnabled(boo);
        this._txtTrigger.setEnabled(boo);
        this._sequencePanel.setEnabled(boo);
        this._cmbExistingSequence.setEnabled(boo);
        this._txtNewSequence.setEnabled(boo);
        if (boo || incLabels) {
            this._lblColumns.setEnabled(boo);
            this._lblSequence.setEnabled(boo);
            this._lblTrigger.setEnabled(boo);
        }
    }

    private String getUniqueName(String type) {
        String baseName;
        String name = null;
        String tableName = this._table.getName();
        String suffix = "SEQUENCE".equals(type) ? "SEQ" : "TRG";
        int maxTableNameLength = tableName.length() > 25 ? 25 : tableName.length();
        do {
            baseName = this._table.getName().substring(0, maxTableNameLength--) + '_' + suffix;
        } while (ModelUtil.hasLength((String)(name = this.getProvider().getUniqueName(type, (DBObject)this._table.getSchema(), baseName))) && name.length() > 30);
        name = name != null ? this.getProvider().getExternalName(name) : null;
        return name;
    }

    private boolean isExistingSequence(String seqName) {
        String[] stringArray = this._existingSequenceNames;
        int n = 0;
        while (n < stringArray.length) {
            String existingSeqName = stringArray[n];
            if (existingSeqName.equals(seqName)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void $init$() {
        this._lblColumns = new JLabel();
        this._lblSequence = new JLabel();
        this._lblTrigger = new JLabel();
        this._cmbColumns = new JComboBox();
        this._txtTrigger = new JTextField();
        this._sequencePanel = new JPanel();
        this._btnNone = new JRadioButton();
        this._btnExistingSequence = new JRadioButton();
        this._btnNewSequence = new JRadioButton();
        this._cmbExistingSequence = new JComboBox();
        this._txtNewSequence = new JTextField();
        this._lastColSelection = null;
        this._sessionTriggerNames = new ArrayList<String>();
    }
}

