/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.table.BaseConstraintPanel;
import oracle.ide.db.panels.table.ConstraintPanel;
import oracle.ide.db.panels.table.PKDialog;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class FKPanel
extends JPanel
implements ConstraintPanel,
ActionListener,
FocusListener,
Traversable {
    private static final String[] ON_DELETE_LABELS = new String[]{"RESTRICT", "CASCADE", "SET NULL"};
    private static final String ADD_CMD = "ADD";
    private static final String REMOVE_CMD = "REMOVE";
    private static final String SETOBJECTBASED = "SetObjectBased";
    private static final String SETNAMEBASED = "SetNameBased";
    private static final int DELAY = 1500;
    private JLabel lblRefSchema;
    private JLabel lblRefTable;
    private JLabel lblRefCon;
    private JButton btnAddPK;
    private SchemaPicker cmbRefSchema;
    private JComboBox cmbRefTable;
    private JComboBox cmbRefCon;
    private JTextField txtRefSchema;
    private JTextField txtRefTable;
    private JTextField txtRefCon;
    protected JPanel pnlColumns;
    private GridBagLayout layColumns;
    private JLabel lblColAssoc;
    private JScrollPane scrColumns;
    private JTable tblColumns;
    private JButton btnAdd;
    private JButton btnRemove;
    private L _listener;
    private JLabel lblDelete;
    private JComboBox cmbDelete;
    private JPanel pnlRef;
    private DBObjectRenderer renderer;
    private TableColumn colLocal;
    private TableColumn colRef;
    private DefaultTableColumnModel mdlCols;
    private DefaultComboBoxModel mdlTblCols;
    private JComboBox cmbTblCols;
    private DefaultCellEditor edTblCols;
    private NonNullableComboBoxModel mdlDelete;
    private ColumnsModel mdlColumns;
    private JCheckBox chkEnabled;
    private JRadioButton rdbObjectBased;
    private JRadioButton rdbNameBased;
    private ButtonGroup rbgBased;
    private GridBagLayout gridBagLayout1;
    private JLabel lblName;
    private JTextField fldName;
    private Schema[] _schemas;
    private HashMap _tableMap;
    private HashMap _conMap;
    protected DBObjectProvider _prov;
    private boolean _modifiable;
    private Schema _currSchema;
    private Table _table;
    private Table _sourceTable;
    private String _currTableName;
    protected FKConstraint _con;
    private Constraint[] _otherCons;
    private ConstraintsInfoVerifier _verifier;
    private boolean _standalone;
    private HashMap m_loadingTables;
    private HashMap m_loadingConstraints;
    private boolean m_showNameBasedUI;
    private boolean _nameBased;
    private DBObjectID _lastObjectBasedRef;
    private ReferenceID _lastNameBasedRef;
    private boolean _initialising;
    public static final String SOURCE_TABLE = "sourceTable";

    private void $init$() {
        this.lblRefSchema = new JLabel();
        this.lblRefTable = new JLabel();
        this.lblRefCon = new JLabel();
        this.btnAddPK = new JButton();
        this.cmbRefSchema = new SchemaPicker();
        this.cmbRefTable = new JComboBox();
        this.cmbRefCon = new JComboBox();
        this.txtRefSchema = new JTextField();
        this.txtRefTable = new JTextField();
        this.txtRefCon = new JTextField();
        this.pnlColumns = new JPanel();
        this.layColumns = new GridBagLayout();
        this.lblColAssoc = new JLabel();
        this.scrColumns = new JScrollPane();
        this.tblColumns = new JTable();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this._listener = new L(null);
        this.lblDelete = new JLabel();
        this.cmbDelete = new JComboBox();
        this.pnlRef = new JPanel();
        this.renderer = new DBObjectRenderer();
        this.colLocal = new TableColumn(0);
        this.colRef = new TableColumn(1);
        this.mdlCols = new DefaultTableColumnModel();
        this.cmbTblCols = new JComboBox();
        this.edTblCols = new DefaultCellEditor(this.cmbTblCols);
        this.mdlDelete = new NonNullableComboBoxModel((Object[])ON_DELETE_LABELS);
        this.mdlColumns = new ColumnsModel();
        this.chkEnabled = new JCheckBox();
        this.rdbObjectBased = new JRadioButton();
        this.rdbNameBased = new JRadioButton();
        this.rbgBased = new ButtonGroup();
        this.gridBagLayout1 = new GridBagLayout();
        this.lblName = new JLabel();
        this.fldName = new JTextField();
        this._tableMap = new HashMap();
        this._conMap = new HashMap();
        this.m_loadingTables = new HashMap();
        this.m_loadingConstraints = new HashMap();
        this.m_showNameBasedUI = false;
        this._nameBased = false;
        this._lastObjectBasedRef = null;
        this._lastNameBasedRef = null;
        this._initialising = false;
    }

    public FKPanel() {
        this(false);
    }

    public FKPanel(boolean showNameBasedUI) {
        this.$init$();
        this.m_showNameBasedUI = showNameBasedUI;
        try {
            this.jbInit();
            this._updateEnabledState(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("FKPanel");
        reshelp.resLabel(this.lblRefSchema, this.cmbRefSchema, UIArb.getString(18), "RefSchema");
        reshelp.resLabel(this.lblRefTable, this.cmbRefTable, UIArb.getString(134), "RefTable");
        reshelp.resLabel(this.lblRefCon, this.cmbRefCon, UIArb.getString(349), "RefCon");
        reshelp.resLabel(this.lblRefSchema, this.txtRefSchema, UIArb.getString(18), "RefSchemaText");
        reshelp.resLabel(this.lblRefTable, this.txtRefTable, UIArb.getString(134), "RefTableText");
        reshelp.resLabel(this.lblRefCon, this.txtRefCon, UIArb.getString(349), "RefConText");
        this.cmbRefSchema.setName("cmbRefSchema");
        this.cmbRefTable.setName("cmbRefTable");
        this.cmbRefCon.setName("cmbRefCon");
        this.cmbRefSchema.addActionListener(this);
        this.cmbRefTable.addActionListener(this);
        this.cmbRefCon.addActionListener(this);
        this.txtRefSchema.addFocusListener(this);
        this.txtRefTable.addFocusListener(this);
        this.txtRefCon.addFocusListener(this);
        reshelp.resButton(this.rdbObjectBased, UIArb.getString(641), "ObjectBased");
        this.rdbObjectBased.setActionCommand(SETOBJECTBASED);
        this.rdbObjectBased.addActionListener(this);
        reshelp.resButton(this.rdbNameBased, UIArb.getString(512), "NameBased");
        this.rdbNameBased.setActionCommand(SETNAMEBASED);
        this.rdbNameBased.addActionListener(this);
        this.rbgBased.add(this.rdbObjectBased);
        this.rbgBased.add(this.rdbNameBased);
        this.cmbRefCon.setRenderer(this.renderer);
        this.cmbTblCols.setRenderer(this.renderer);
        reshelp.resButton(this.chkEnabled, UIArb.getString(373), "Enabled");
        this.btnAddPK.setPreferredSize(new Dimension(70, 25));
        reshelp.resButton(this.btnAddPK, UIArb.getString(194), "AddPK");
        this.btnAddPK.addActionListener(this);
        reshelp.resLabel(this.lblName, this.fldName, UIArb.getString(364), "Name");
        this.renderer.setNullLabel(UIArb.getString(144));
        reshelp.resLabel(this.lblColAssoc, this.tblColumns, UIArb.getString(573), "AssociationsTable");
        this.pnlColumns.setLayout(this.layColumns);
        this.colLocal.setHeaderValue(UIArb.getString(764));
        this.colLocal.setCellEditor(this.edTblCols);
        this.colLocal.setCellRenderer(this.renderer);
        this._setColRefTableName(null);
        this.colRef.setCellRenderer(this.renderer);
        this.pnlRef.setLayout(this.gridBagLayout1);
        this.mdlCols.addColumn(this.colLocal);
        this.mdlCols.addColumn(this.colRef);
        reshelp.resLabel(this.lblDelete, this.cmbDelete, UIArb.getString(626), "OnDelete");
        this.cmbDelete.setModel(this.mdlDelete);
        this.tblColumns.setModel(this.mdlColumns);
        this.tblColumns.setColumnModel(this.mdlCols);
        this.scrColumns.getViewport().add((Component)this.tblColumns, null);
        this.tblColumns.getSelectionModel().addListSelectionListener(this._listener);
        Dimension size = new Dimension(28, 25);
        this.btnAdd.setPreferredSize(size);
        this.btnAdd.setIcon(OracleIcons.getIcon((String)"add.png"));
        DBObjectRenderer.setToolTipText(this.btnAdd, UIArb.getString(695));
        this.btnAdd.setActionCommand(ADD_CMD);
        this.btnAdd.addActionListener(this._listener);
        this.btnRemove.setPreferredSize(size);
        this.btnRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        DBObjectRenderer.setToolTipText(this.btnRemove, UIArb.getString(849));
        this.btnRemove.setActionCommand(REMOVE_CMD);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(this._listener);
        this.pnlColumns.add((Component)this.lblColAssoc, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_showNameBasedUI) {
            JPanel pnlButtons = new JPanel(new GridBagLayout());
            pnlButtons.add((Component)this.scrColumns, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlButtons.add((Component)this.btnAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 5, 0, 0), 0, 0));
            pnlButtons.add((Component)this.btnRemove, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 5, 0, 0), 0, 0));
            this.pnlColumns.add((Component)pnlButtons, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.pnlColumns.add((Component)this.scrColumns, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.pnlColumns.add((Component)this.lblDelete, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlColumns.add((Component)this.cmbDelete, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        if (this.m_showNameBasedUI) {
            JPanel nameNasedUIRadioPanel = new JPanel(new GridBagLayout());
            nameNasedUIRadioPanel.add((Component)this.rdbObjectBased, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            nameNasedUIRadioPanel.add((Component)this.rdbNameBased, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 5, 0), 0, 0));
            this.pnlRef.add((Component)nameNasedUIRadioPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.pnlRef.add((Component)this.lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.pnlRef.add((Component)this.fldName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.pnlRef.add((Component)this.chkEnabled, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        this.pnlRef.add((Component)this.lblRefSchema, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.pnlRef.add((Component)this.cmbRefSchema, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlRef.add((Component)this.lblRefTable, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.pnlRef.add((Component)this.cmbRefTable, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.pnlRef.add((Component)this.lblRefCon, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.pnlRef.add((Component)this.cmbRefCon, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlRef.add((Component)this.btnAddPK, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        this.txtRefSchema.setVisible(false);
        this.txtRefTable.setVisible(false);
        this.txtRefCon.setVisible(false);
        this.pnlRef.add((Component)this.txtRefSchema, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlRef.add((Component)this.txtRefTable, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.pnlRef.add((Component)this.txtRefCon, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pnlRef, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void init(Namespace namespace) throws TraversalException {
        this._prov = (DBObjectProvider)namespace.find("DBObjectProvider");
        this._table = (Table)namespace.find("NewObject");
        this._con = (FKConstraint)namespace.find("NewChildObject");
        this._otherCons = (Constraint[])namespace.find("otherCons");
        this._verifier = (ConstraintsInfoVerifier)namespace.find("ConstraintsInfoVerifier");
        this._schemas = (Schema[])namespace.find("SchemaList");
        this._sourceTable = (Table)namespace.find(SOURCE_TABLE);
        this._modifiable = true;
        if (namespace.find("Modifiable") != null) {
            this._modifiable = (Boolean)namespace.find("Modifiable");
        }
        this._standalone = false;
        if (namespace.find("standAlone") != null) {
            this._standalone = (Boolean)namespace.find("standAlone");
        }
        if (this._con != null && this._con.getReferenceID() != null) {
            try {
                Constraint ref = (Constraint)this._con.getReferenceID().resolveID();
                if (ref != null) {
                    this._sourceTable = (Table)ref.getRelation();
                }
            }
            catch (DBException e) {
                e.printStackTrace();
            }
        }
        this.cmbTblCols.setEditable(this._standalone);
        this._lastObjectBasedRef = null;
        this._lastNameBasedRef = null;
        if (this._table != null) {
            this.mdlTblCols = new NonNullableComboBoxModel((Object[])this._table.getColumns());
            this.cmbTblCols.setModel(this.mdlTblCols);
        }
        if (this._con != null && this._con.getReferenceID() instanceof ReferenceID) {
            this._lastNameBasedRef = (ReferenceID)this._con.getReferenceID();
            this.rdbNameBased.setSelected(true);
            this.setNamedBased(true);
        } else {
            this._lastObjectBasedRef = this._con == null ? null : this._con.getReferenceID();
            this.rdbObjectBased.setSelected(true);
            this._initialising = true;
            this.setNamedBased(false);
            this._initialising = false;
        }
        if (!this._standalone) {
            this.btnAddPK.setVisible(false);
        } else {
            this.btnAddPK.setEnabled(FKPanel.getPKConstraint(this._sourceTable) == null);
        }
    }

    protected boolean isPukkaConstraint() {
        DBObjectID refID;
        boolean ok;
        boolean bl = ok = this._con != null && !this._nameBased;
        if (ok && (refID = this._con.getReferenceID()) != null) {
            try {
                DBObject refOb = refID.resolveID();
                ok = refOb != null;
            }
            catch (DBException dbe) {
                Assert.printStackTrace((Throwable)dbe);
                ok = false;
            }
        }
        return ok;
    }

    private void _initConstraint() throws TraversalException {
        Relation rel;
        String cName = "";
        boolean cEnabled = false;
        DBObject refObj = null;
        Column[] fkCols = new Column[]{};
        int cDelMode = 0;
        if (this._nameBased) {
            boolean WhatAreWeDoingHere = true;
        }
        if (this._con != null) {
            cName = this._prov.getExternalName(this._con.getName());
        }
        if (this.isPukkaConstraint()) {
            cEnabled = this._con.isEnabled();
            try {
                DBObjectID refID = this._con.getReferenceID();
                if (refID != null) {
                    refObj = refID.resolveID();
                }
            }
            catch (DBException ex) {
                // empty catch block
            }
            fkCols = this._con.getColumns();
            cDelMode = this._con.getDeleteMode();
        } else if (this._con != null) {
            this._updateEnabledState(false);
        }
        this.fldName.setText(cName);
        this.chkEnabled.setSelected(cEnabled);
        this.mdlDelete.setSelectedItem((Object)ON_DELETE_LABELS[cDelMode]);
        Schema refSchema = null;
        String refRel = null;
        String refCon = null;
        UniqueConstraint ref = refObj instanceof UniqueConstraint ? (UniqueConstraint)refObj : null;
        Object object = rel = ref != null ? ref.getRelation() : this._sourceTable;
        if (rel != null) {
            refSchema = rel.getSchema();
            refRel = rel.getName();
            if (ref != null) {
                refCon = ref.getName();
            }
        }
        Schema schema = refSchema != null ? refSchema : this._currSchema;
        this.cmbRefSchema.setSelectedItem(schema);
        if (schema != null && this.m_loadingTables.containsKey(schema.getName())) {
            throw new TraversalException(null);
        }
        if (refRel != null) {
            this.cmbRefTable.setSelectedItem(refRel);
        } else {
            this._setColRefTableName((String)this.cmbRefTable.getSelectedItem());
        }
        if (refCon != null) {
            this._selectConstraint(refCon);
        }
        int i = 0;
        while (i < fkCols.length) {
            this.mdlColumns.setValueAt(fkCols[i], i, 0);
            ++i;
        }
    }

    private void initNameBasedConstraint(String schemaName, String tableName, String consName, String[] columnNames) {
        Schema schema = new Schema(schemaName);
        Table table = new Table(tableName, schema);
        UniqueConstraint uk = new UniqueConstraint(consName, (Relation)table);
        if (columnNames != null) {
            int i = 0;
            while (i < columnNames.length) {
                Column c = new Column(columnNames[i]);
                table.addColumn(c);
                uk.addColumn(c);
                ++i;
            }
        }
        this._currSchema = schema;
        this._currTableName = tableName;
        this._updateEnabledState(this._modifiable);
        this.fldName.setText(this._prov.getExternalName(this._con.getName()));
        this.chkEnabled.setSelected(this._con.isEnabled());
        this.mdlDelete.setSelectedItem((Object)ON_DELETE_LABELS[this._con.getDeleteMode()]);
        this.txtRefSchema.setText(schemaName);
        this.txtRefTable.setText(tableName);
        this.txtRefCon.setText(consName);
        this._setColRefTableName(this._currTableName);
        this.mdlColumns.init(this.mdlTblCols, uk, this._modifiable);
        this.btnAdd.setEnabled(this.mdlColumns.canAddRow(0));
        Column[] fkCols = this._con.getColumns();
        int i = 0;
        while (i < fkCols.length) {
            this.mdlColumns.setValueAt(fkCols[i], i, 0);
            ++i;
        }
    }

    public void commit() throws TraversalException {
        if (this.tblColumns.isEditing()) {
            int currRow = this.tblColumns.getSelectedRow();
            int currCol = this.tblColumns.getSelectedColumn();
            this.tblColumns.editCellAt(currRow, 2 - currCol);
            this.tblColumns.editCellAt(currRow, currCol);
        }
        if (this.isPukkaConstraint()) {
            String oldRelName = null;
            DBObjectID oldRefID = this._con.getReferenceID();
            if (oldRefID != null) {
                try {
                    Relation oldRel;
                    DBObject oldRef = oldRefID.resolveID();
                    if (oldRef instanceof UniqueConstraint && (oldRel = ((UniqueConstraint)oldRef).getRelation()) != null) {
                        oldRelName = oldRel.getName();
                    }
                }
                catch (DBException ex) {
                    // empty catch block
                }
            }
            String conName = this.fldName.getText();
            UniqueConstraint ref = (UniqueConstraint)this.cmbRefCon.getSelectedItem();
            if (ref == null) {
                if (oldRelName == null) {
                    oldRelName = this._currTableName;
                }
                if (conName.startsWith(BaseConstraintPanel.getDefaultFKBaseName(this._currTableName, oldRelName, this._prov))) {
                    conName = BaseConstraintPanel.findUniqueName((Relation)this._table, (Constraint)this._con, this._otherCons, this._prov);
                }
                this._con.setReferenceID(null);
            } else {
                String refTableName;
                Relation refRel = ref.getRelation();
                String string = refTableName = refRel != null ? refRel.getName() : this._currTableName;
                if (ModelUtil.areDifferent((Object)oldRelName, (Object)refTableName) && this.isNewConstraint() && conName.startsWith(BaseConstraintPanel.getDefaultFKBaseName(this._currTableName, oldRelName, this._prov))) {
                    conName = BaseConstraintPanel.findUniqueName(BaseConstraintPanel.getDefaultFKBaseName(this._currTableName, refTableName, this._prov), (Constraint)this._con, this._otherCons);
                }
                this._con.setReferenceID(ref.getID());
            }
            if (this._verifier != null) {
                this._verifier.verifyName(conName);
            }
            this._con.setName(this._prov.getInternalName(conName));
            this.fldName.setText(conName);
            this._con.setEnabled(this.chkEnabled.isSelected());
            Column[] cols = this.mdlColumns.getTableColumns();
            this._con.setColumns(cols);
            this._con.setDeleteMode(this.cmbDelete.getSelectedIndex());
        } else if (this._nameBased) {
            String conName = this.fldName.getText();
            if (this._verifier != null) {
                this._verifier.verifyName(conName);
            }
            this._con.setName(this._prov.getInternalName(conName));
            this.fldName.setText(conName);
            this._con.setEnabled(this.chkEnabled.isSelected());
            Column[] cols = this.mdlColumns.getTableColumns();
            Column[] refCols = this.mdlColumns.getRefTableColumns();
            this._con.setColumns(cols);
            this._con.setDeleteMode(this.cmbDelete.getSelectedIndex());
            String schemaName = this._prov.getInternalName(this.txtRefSchema.getText());
            String tableName = this._prov.getInternalName(this.txtRefTable.getText());
            String ukName = this._prov.getInternalName(this.txtRefCon.getText());
            String[] colNames = new String[refCols.length];
            int i = 0;
            while (i < refCols.length) {
                colNames[i] = refCols[i].getName();
                ++i;
            }
            this.setCCReferenceID(this._con, schemaName, tableName, ukName, colNames, true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (this.rdbNameBased.isSelected()) {
            if (src == this.rdbNameBased) {
                try {
                    this.setNamedBased(true);
                }
                catch (TraversalException traversalException) {}
            }
        } else if (src == this.cmbRefSchema) {
            try {
                this._updateSelectedSchema(this.cmbRefSchema.getSchema());
            }
            catch (TraversalException f) {}
        } else if (src == this.cmbRefTable) {
            this._updateSelectedTable((String)this.cmbRefTable.getSelectedItem());
        } else if (src == this.cmbRefCon) {
            UniqueConstraint con = (UniqueConstraint)this.cmbRefCon.getSelectedItem();
            this.mdlColumns.init(this.mdlTblCols, con, false);
            if (con != null && !this._initialising) {
                this._lastObjectBasedRef = con.getID();
            }
        } else if (src == this.rdbObjectBased) {
            try {
                this.setNamedBased(false);
            }
            catch (TraversalException f) {}
        } else if (src == this.btnAddPK) {
            try {
                if (PKDialog.createOrEditPK(this._prov, this._sourceTable, this)) {
                    String tableName = this._sourceTable.getName();
                    String schemaName = this._sourceTable.getSchema().getName();
                    String key = tableName == null ? "" : schemaName + "." + tableName;
                    DefaultComboBoxModel cons = (DefaultComboBoxModel)this._conMap.get(key);
                    cons.addElement(FKPanel.getPKConstraint(this._sourceTable));
                    this._updateSelectedTable(tableName);
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
    }

    private void setNamedBased(boolean enable) throws TraversalException {
        if (this._con != null && enable) {
            this._nameBased = true;
            String schemaName = "";
            String tableName = "";
            String ukName = "";
            String[] colNames = new String[]{};
            this._con.setReferenceID((DBObjectID)this._lastNameBasedRef);
            if (this._lastNameBasedRef == null) {
                if (this._lastObjectBasedRef != null) {
                    schemaName = (String)this.cmbRefSchema.getSelectedItem();
                    if (schemaName == null) {
                        schemaName = "";
                    }
                    tableName = this.cmbRefTable.getSelectedItem() == null ? "" : this._prov.getInternalName((String)this.cmbRefTable.getSelectedItem());
                    ukName = this.cmbRefCon.getSelectedItem() == null ? "" : this._prov.getInternalName(((Constraint)this.cmbRefCon.getSelectedItem()).getName());
                    Column[] refCols = this.mdlColumns.getRefTableColumns();
                    colNames = new String[refCols.length];
                    int i = 0;
                    while (i < refCols.length) {
                        colNames[i] = this._prov.getInternalName(refCols[i].getName());
                        ++i;
                    }
                }
                this.setCCReferenceID(this._con, schemaName, tableName, ukName, colNames, false);
                this._lastNameBasedRef = (ReferenceID)this._con.getReferenceID();
            }
            this.initNameBasedConstraint(this.getSchemaName(this._lastNameBasedRef), this.getTableName(this._lastNameBasedRef), this.getConstraintName(this._lastNameBasedRef), this.getColumnNames(this._lastNameBasedRef));
        } else if (!enable) {
            if (this._nameBased && this._lastNameBasedRef != null) {
                try {
                    this.commit();
                    this._lastNameBasedRef = (ReferenceID)this._con.getReferenceID();
                }
                catch (TraversalException e) {
                    // empty catch block
                }
            }
            this._nameBased = false;
            if (this._con != null) {
                this._con.setReferenceID(this._lastObjectBasedRef);
            }
            this.btnAdd.setEnabled(false);
            this.btnRemove.setEnabled(false);
            if (this.isPukkaConstraint()) {
                Schema schema = this._table.getSchema();
                String tName = this._table.getName();
                if (ModelUtil.areDifferent((Object)tName, (Object)this._currTableName) || ModelUtil.areDifferent((Object)schema, (Object)this._currSchema)) {
                    this._tableMap.remove(this._currSchema);
                    String key = this._currSchema + "." + this._currTableName;
                    this._conMap.remove(key);
                }
                this._currSchema = schema;
                this._currTableName = tName;
                this.renderer.setNullLabel(UIArb.getString(144));
            } else {
                this._currSchema = new Schema();
                this._currTableName = null;
                this.renderer.setNullLabel("");
            }
            String key = this._currSchema + "." + this._currTableName;
            NonNullableComboBoxModel mdl = new NonNullableComboBoxModel();
            Constraint[] cons = this._table.getConstraints();
            int i = 0;
            while (i < cons.length) {
                if ("PKConstraint".equals(cons[i].getConstraintType()) || "UniqueConstraint".equals(cons[i].getConstraintType())) {
                    mdl.addElement(cons[i]);
                }
                ++i;
            }
            this._conMap.put(key, mdl);
            this._updateEnabledState(this._modifiable && this.isPukkaConstraint());
            this._schemas = (Schema[])FKPanel.insert(this._currSchema, this._schemas);
            this.cmbRefSchema.init(this._prov, this._currSchema);
            try {
                this._initConstraint();
            }
            catch (TraversalException e) {
                // empty catch block
            }
        }
        this.cmbRefSchema.setVisible(enable ^ true);
        this.cmbRefTable.setVisible(enable ^ true);
        this.cmbRefCon.setVisible(enable ^ true);
        this.txtRefSchema.setVisible(enable);
        this.txtRefTable.setVisible(enable);
        this.txtRefCon.setVisible(enable);
        this.validate();
    }

    private void _updateSelectedSchema(Schema schema) {
        if (schema != null) {
            DefaultComboBoxModel tblModel = (DefaultComboBoxModel)this._tableMap.get(schema);
            if (tblModel == null) {
                if (schema.getName() == null) {
                    tblModel = new NonNullableComboBoxModel();
                    this._tableMap.put(schema, tblModel);
                } else {
                    this.loadTables(schema);
                    tblModel = (DefaultComboBoxModel)this._tableMap.get(schema);
                    if (tblModel == null) {
                        tblModel = new NonNullableComboBoxModel();
                    }
                }
            }
            this.cmbRefTable.setModel(tblModel);
            this.cmbRefTable.setSelectedIndex(tblModel.getSize() > 0 ? 0 : -1);
        }
    }

    private void _updateSelectedTable(String tableName) {
        Schema schema = null;
        try {
            schema = this.cmbRefSchema.getSchema();
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
        String key = tableName == null ? "" : schema + "." + tableName;
        DefaultComboBoxModel cons = (DefaultComboBoxModel)this._conMap.get(key);
        if (cons == null) {
            Table table = null;
            if (tableName != null) {
                try {
                    table = (Table)this._prov.getObject("TABLE", schema, tableName);
                }
                catch (DBException ex) {
                    // empty catch block
                }
            }
            if (table != null) {
                this.loadConstraints(table, key);
                cons = (DefaultComboBoxModel)this._conMap.get(key);
            }
            if (cons == null) {
                cons = new NonNullableComboBoxModel();
            }
        }
        this.cmbRefCon.setModel(cons);
        this.cmbRefCon.setSelectedIndex(cons.getSize() > 0 ? 0 : -1);
        this._setColRefTableName(tableName);
        if (tableName != null) {
            this._setDefaultConstraintName(tableName);
        }
    }

    private boolean isNewConstraint() {
        DBObjectID id = this._con.getID();
        if (id != null && id instanceof TemporaryObjectID) {
            try {
                if (((TemporaryObjectID)id).resolveOriginalID() != null) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (DBException dBException) {}
        } else if (id != null) {
            return false;
        }
        return true;
    }

    private void _setDefaultConstraintName(String tableName) {
        if (this._con == null || this.isNewConstraint() && this._con.getName().startsWith(this._currTableName) && this._con.getName().contains("_FK")) {
            String conName = BaseConstraintPanel.findUniqueName(BaseConstraintPanel.getDefaultFKBaseName(this._currTableName, tableName, this._prov), (Constraint)this._con, this._otherCons);
            this.fldName.setText(conName);
        }
    }

    private void _setColRefTableName(String tableName) {
        String header = tableName != null ? UIArb.format(429, tableName) : UIArb.getString(609);
        this.colRef.setHeaderValue(header);
        this.repaint();
    }

    private void _selectConstraint(String conName) {
        if (conName != null) {
            int i = this.cmbRefCon.getItemCount() - 1;
            while (i >= 0) {
                UniqueConstraint con = (UniqueConstraint)this.cmbRefCon.getItemAt(i);
                if (conName.equals(con.getName())) {
                    this.cmbRefCon.setSelectedIndex(i);
                    break;
                }
                --i;
            }
        }
    }

    protected void _updateEnabledState(boolean enabled) {
        this.fldName.setEnabled(enabled);
        this.chkEnabled.setEnabled(enabled);
        this.cmbRefSchema.setEnabled(enabled && !this._standalone);
        this.cmbRefTable.setEnabled(enabled && !this._standalone);
        this.cmbRefCon.setEnabled(enabled);
        this.txtRefSchema.setEnabled(enabled && !this._standalone);
        this.txtRefTable.setEnabled(enabled && !this._standalone);
        this.txtRefCon.setEnabled(enabled);
        this.cmbDelete.setEnabled(enabled);
        this.rdbObjectBased.setEnabled(enabled);
        this.rdbNameBased.setEnabled(enabled);
    }

    private void loadTables(Schema schema) {
        if (!this.m_loadingTables.containsKey(schema.getName())) {
            TableLoader tableLoader = new TableLoader(schema);
            this.m_loadingTables.put(schema.getName(), tableLoader);
            tableLoader.execute();
        } else {
            TableLoader tableLoader = (TableLoader)this.m_loadingTables.get(schema.getName());
            if (tableLoader != null) {
                tableLoader.execute();
            }
        }
    }

    private void loadConstraints(Table table, String key) {
        if (!this.m_loadingConstraints.containsKey(key)) {
            ConstraintLoader constraintLoader = new ConstraintLoader(table, key);
            this.m_loadingConstraints.put(key, constraintLoader);
            constraintLoader.execute();
        } else {
            ConstraintLoader constraintLoader = (ConstraintLoader)this.m_loadingConstraints.get(key);
            if (constraintLoader != null) {
                constraintLoader.execute();
            }
        }
    }

    private static Object[] insert(Object value, Object[] dest) {
        Arrays.sort(dest);
        int idx = Arrays.binarySearch(dest, value);
        if (idx < 0) {
            int i = -(idx + 1);
            int size = dest.length + 1;
            Object[] tmp = (Object[])Array.newInstance(dest.getClass().getComponentType(), size);
            System.arraycopy(dest, 0, tmp, 0, i);
            tmp[i] = value;
            System.arraycopy(dest, i, tmp, i + 1, dest.length - i);
            dest = tmp;
        }
        return dest;
    }

    protected final void setCCReferenceID(FKConstraint fk, String schemaName, String tableName, String consName, String[] columnNames, boolean validate) throws TraversalException {
        if (validate) {
            if (!ModelUtil.hasLength((String)schemaName)) {
                throw new TraversalException(UIArb.getString(730));
            }
            if (!ModelUtil.hasLength((String)tableName)) {
                throw new TraversalException(UIArb.getString(800));
            }
            if (!ModelUtil.hasLength((String)consName)) {
                throw new TraversalException(UIArb.getString(832));
            }
            if (columnNames == null || columnNames.length == 0) {
                throw new TraversalException(UIArb.getString(55));
            }
        }
        ReferenceID tabID = new ReferenceID("TABLE", schemaName, tableName);
        tabID.setProvider(this._prov);
        ReferenceID conID = new ReferenceID("CONSTRAINT", (DBObjectID)tabID, consName, null, columnNames);
        fk.setReferenceID((DBObjectID)conID);
    }

    protected final String getSchemaName(ReferenceID ccRefID) {
        DBObjectID id;
        String schemaName = null;
        if (ccRefID != null && (id = ccRefID.getParent()) instanceof ReferenceID) {
            schemaName = ((ReferenceID)id).getSchemaName();
        }
        return schemaName;
    }

    protected final String getTableName(ReferenceID ccRefID) {
        DBObjectID id;
        String tableName = null;
        if (ccRefID != null && (id = ccRefID.getParent()) instanceof ReferenceID) {
            tableName = ((ReferenceID)id).getName();
        }
        return tableName;
    }

    protected final String getConstraintName(ReferenceID ccRefID) {
        return ccRefID == null ? null : ccRefID.getName();
    }

    protected final String[] getColumnNames(ReferenceID ccRefID) {
        return ccRefID == null ? null : ccRefID.getChildObjectNames();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src == this.txtRefSchema) {
            String t = this.txtRefSchema.getText();
            t = this._prov.getExternalName(this._prov.getInternalName(t));
            this.txtRefSchema.setText(t);
        } else if (src == this.txtRefTable) {
            String t = this.txtRefTable.getText();
            t = this._prov.getExternalName(this._prov.getInternalName(t));
            this.txtRefTable.setText(t);
            this._setColRefTableName(ModelUtil.hasLength((String)t) ? t : null);
        } else if (src == this.txtRefCon) {
            String t = this.txtRefCon.getText();
            t = this._prov.getExternalName(this._prov.getInternalName(t));
            this.txtRefCon.setText(t);
        }
    }

    private static final PKConstraint getPKConstraint(Table tbl) {
        Constraint[] cons;
        if (tbl == null) {
            return null;
        }
        PKConstraint pk = null;
        Constraint[] constraintArray = cons = tbl.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            Constraint con = constraintArray[n];
            if (con instanceof PKConstraint) {
                pk = (PKConstraint)con;
                break;
            }
            ++n;
        }
        return pk;
    }

    public void onEntry(TraversableContext dataContext) {
        try {
            this.init((Namespace)dataContext);
        }
        catch (TraversalException e) {
            e.printStackTrace();
        }
    }

    public Component getComponent() {
        return this;
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return null;
    }

    static DefaultComboBoxModel ra$mdlTblCols(FKPanel fKPanel) {
        return fKPanel.mdlTblCols;
    }

    static JButton ra$btnAdd(FKPanel fKPanel) {
        return fKPanel.btnAdd;
    }

    static ColumnsModel ra$mdlColumns(FKPanel fKPanel) {
        return fKPanel.mdlColumns;
    }

    static JButton ra$btnRemove(FKPanel fKPanel) {
        return fKPanel.btnRemove;
    }

    static boolean ra$_modifiable(FKPanel fKPanel) {
        return fKPanel._modifiable;
    }

    static Table ra$_table(FKPanel fKPanel) {
        return fKPanel._table;
    }

    static HashMap ra$m_loadingTables(FKPanel fKPanel) {
        return fKPanel.m_loadingTables;
    }

    static Schema ra$_currSchema(FKPanel fKPanel) {
        return fKPanel._currSchema;
    }

    static String ra$_currTableName(FKPanel fKPanel) {
        return fKPanel._currTableName;
    }

    static Object[] maS$insert(Object object, Object[] objectArray) {
        return FKPanel.insert(object, objectArray);
    }

    static HashMap ra$_tableMap(FKPanel fKPanel) {
        return fKPanel._tableMap;
    }

    static HashMap ra$m_loadingConstraints(FKPanel fKPanel) {
        return fKPanel.m_loadingConstraints;
    }

    static HashMap ra$_conMap(FKPanel fKPanel) {
        return fKPanel._conMap;
    }

    static JTable ra$tblColumns(FKPanel fKPanel) {
        return fKPanel.tblColumns;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnsModel
    extends AbstractTableModel {
        private ConstraintValidator _constraintValidator;
        private Column[] _fkCols;
        private Column[] _refCols;
        private Boolean[] _isDefaultName;
        private boolean _refColsEditable;

        private void $init$() {
            this._fkCols = new Column[0];
            this._refCols = new Column[0];
            this._isDefaultName = new Boolean[0];
        }

        public ColumnsModel() {
            this.$init$();
        }

        public void init(DefaultComboBoxModel mdlRelCols, UniqueConstraint cons, boolean editable) {
            if (this._constraintValidator == null) {
                this._constraintValidator = new ConstraintValidator(FKPanel.this._prov);
            }
            this._refCols = cons != null ? cons.getColumns() : new Column[]{};
            this._fkCols = new Column[this._refCols.length];
            this._isDefaultName = new Boolean[this._refCols.length];
            this._refColsEditable = editable;
            int i = 0;
            while (i < this._refCols.length) {
                this._isDefaultName[i] = Boolean.FALSE;
                ArrayList<Column> localCols = new ArrayList<Column>();
                int j = 0;
                while (j < mdlRelCols.getSize()) {
                    Column col = (Column)mdlRelCols.getElementAt(j);
                    if (this._constraintValidator.isCompatibleDataTypes(this.getDataType(col), this.getDataType(this._refCols[i]))) {
                        localCols.add(col);
                    }
                    ++j;
                }
                for (Column col : localCols) {
                    if (!col.getName().equals(this._refCols[i].getName())) continue;
                    this._fkCols[i] = col;
                    int k = 0;
                    while (k < i) {
                        if (col.equals((Object)this._fkCols[k])) {
                            this._fkCols[k] = this.getFkColumn(localCols, (Column)mdlRelCols.getElementAt(0));
                        }
                        ++k;
                    }
                    break block2;
                }
                if (this._fkCols[i] == null) {
                    this._fkCols[i] = this.getFkColumn(localCols, (Column)mdlRelCols.getElementAt(0));
                }
                ++i;
            }
            this.fireTableDataChanged();
        }

        private Column getFkColumn(List<Column> localCols, Column lastResort) {
            Column retCol = lastResort;
            List<Column> fkCols = Arrays.asList(this._fkCols);
            for (Column col : localCols) {
                if (fkCols.contains(col)) continue;
                retCol = col;
                break;
            }
            if (retCol == null && localCols.size() > 0) {
                retCol = localCols.get(0);
            }
            return retCol;
        }

        public Column[] getTableColumns() {
            return this._fkCols;
        }

        public Column[] getRefTableColumns() {
            return this._refCols;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this._fkCols[rowIndex];
                }
                case 1: {
                    if (this._refColsEditable) {
                        return FKPanel.this._prov.getExternalName(this._refCols[rowIndex].getName());
                    }
                    return this._refCols[rowIndex];
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Column c;
            Column column = c = aValue instanceof Column ? (Column)aValue : null;
            if (columnIndex == 0 && rowIndex < this._fkCols.length && (this._fkCols[rowIndex] != c || c == null)) {
                if (c == null) {
                    c = new Column();
                    c.setName((String)aValue);
                    FKPanel.ra$_table(FKPanel.this).addColumn(c);
                    Column other = this._refCols[rowIndex];
                    DataTypeUsage dtu = other.getDataTypeUsage();
                    c.setDataTypeUsage((DataTypeUsage)dtu.copyTo(null));
                }
                this._fkCols[rowIndex] = c;
                if (this._isDefaultName[rowIndex].booleanValue()) {
                    this._refCols[rowIndex].setName(this.getDefaultName(c));
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                } else {
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                }
            } else if (columnIndex == 1) {
                String name = c.getName();
                name = FKPanel.this._prov.getInternalName(name);
                c.setName(name);
                this._refCols[rowIndex] = c;
                this._isDefaultName[rowIndex] = Boolean.FALSE;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        @Override
        public int getRowCount() {
            return this._fkCols.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return FKPanel.ra$_modifiable(FKPanel.this) && (columnIndex == 0 || this._refColsEditable);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return UIArb.getString(764);
                }
                case 1: {
                    return UIArb.getString(609);
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            return Column.class;
        }

        private DataType getDataType(Column column) {
            DataType dt = null;
            try {
                dt = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
            }
            catch (DBException dBException) {
                // empty catch block
            }
            return dt;
        }

        public void addConsColumn() {
            this.addConsColumn(this._fkCols.length - 1);
        }

        public void addConsColumn(int idx) {
            ++idx;
            ArrayList<Column> fkCols = new ArrayList<Column>();
            ArrayList<Column> refCols = new ArrayList<Column>();
            ArrayList<Boolean> isDefaultName = new ArrayList<Boolean>();
            int i = 0;
            while (i < this._fkCols.length) {
                fkCols.add(this._fkCols[i]);
                refCols.add(this._refCols[i]);
                isDefaultName.add(this._isDefaultName[i]);
                ++i;
            }
            Column defFKCol = (Column)FKPanel.ra$mdlTblCols(FKPanel.this).getElementAt(0);
            int i2 = 0;
            while (i2 < FKPanel.ra$mdlTblCols(FKPanel.this).getSize()) {
                if (!fkCols.contains(FKPanel.ra$mdlTblCols(FKPanel.this).getElementAt(i2))) {
                    defFKCol = (Column)FKPanel.ra$mdlTblCols(FKPanel.this).getElementAt(i2);
                    break;
                }
                ++i2;
            }
            Column c = new Column(this.getDefaultName(defFKCol));
            refCols.add(idx, c);
            fkCols.add(idx, defFKCol);
            isDefaultName.add(idx, Boolean.TRUE);
            this._refCols = refCols.toArray(new Column[refCols.size()]);
            this._fkCols = fkCols.toArray(new Column[fkCols.size()]);
            this._isDefaultName = isDefaultName.toArray(new Boolean[isDefaultName.size()]);
            this.fireTableRowsInserted(idx, idx);
            FKPanel.ra$btnAdd(FKPanel.this).setEnabled(FKPanel.ra$mdlColumns(FKPanel.this).canAddRow(idx));
            FKPanel.ra$btnRemove(FKPanel.this).setEnabled(FKPanel.ra$mdlColumns(FKPanel.this).canRemoveRow(idx));
        }

        private String getDefaultName(Column fkCol) {
            String base = fkCol.getName();
            String defName = null;
            int i = 0;
            while (true) {
                defName = base;
                if (i > 0) {
                    defName = defName + i;
                }
                boolean found = false;
                Column[] columnArray = this._refCols;
                int n = 0;
                while (n < columnArray.length) {
                    Column c = columnArray[n];
                    if (c.getName().equals(defName)) {
                        found = true;
                        break;
                    }
                    ++n;
                }
                if (!found) break;
                ++i;
            }
            return defName;
        }

        public boolean canAddRow(int rowIndex) {
            return this._refColsEditable && this._fkCols.length < FKPanel.ra$mdlTblCols(FKPanel.this).getSize();
        }

        public boolean canRemoveRow(int rowIndex) {
            return this._refColsEditable && rowIndex >= 0;
        }

        public void removeConsColumn(int idx) {
            ArrayList<Column> fkCols = new ArrayList<Column>();
            ArrayList<Column> refCols = new ArrayList<Column>();
            int i = 0;
            while (i < this._fkCols.length) {
                fkCols.add(this._fkCols[i]);
                refCols.add(this._refCols[i]);
                ++i;
            }
            fkCols.remove(idx);
            refCols.remove(idx);
            this._refCols = refCols.toArray(new Column[refCols.size()]);
            this._fkCols = fkCols.toArray(new Column[fkCols.size()]);
            this.fireTableRowsDeleted(idx, idx);
        }
    }

    private class TableLoader
    implements Runnable {
        private Schema m_schema;
        private ProgressBar m_bar;

        public TableLoader() {
        }

        public TableLoader(Schema schema) {
            this.m_schema = schema;
        }

        public void execute() {
            if (FKPanel.this._prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), UIArb.getString(813), (Runnable)this, true);
                this.m_bar.start(UIArb.getString(576), this.m_schema.getName(), 1500);
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar bar = this.m_bar;
            TableLoader tableLoader = this;
            synchronized (tableLoader) {
                if (FKPanel.ra$m_loadingTables(FKPanel.this).containsKey(this.m_schema.getName())) {
                    try {
                        Object[] tables = FKPanel.this._prov.listObjects("TABLE", this.m_schema);
                        if (this.m_schema != null && FKPanel.ra$_currSchema(FKPanel.this) != null && this.m_schema.getName().equals(FKPanel.ra$_currSchema(FKPanel.this).getName())) {
                            tables = (String[])FKPanel.maS$insert(FKPanel.ra$_currTableName(FKPanel.this), tables);
                        }
                        FKPanel.ra$_tableMap(FKPanel.this).put(this.m_schema, new NonNullableComboBoxModel(tables));
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    FKPanel.ra$m_loadingTables(FKPanel.this).remove(this.m_schema.getName());
                }
                if (bar != null) {
                    bar.setDoneStatus();
                }
            }
        }
    }

    private class ConstraintLoader
    implements Runnable {
        private String m_key;
        private Table m_table;
        private ProgressBar m_bar;

        public ConstraintLoader() {
        }

        public ConstraintLoader(Table table, String key) {
            this.m_table = table;
            this.m_key = key;
        }

        public void execute() {
            if (FKPanel.this._prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), UIArb.getString(813), (Runnable)this, true);
                this.m_bar.start(UIArb.getString(576), this.m_key, 1500);
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar bar = this.m_bar;
            ConstraintLoader constraintLoader = this;
            synchronized (constraintLoader) {
                if (FKPanel.ra$m_loadingConstraints(FKPanel.this).containsKey(this.m_key)) {
                    Constraint[] tblCons = this.m_table.getConstraints();
                    NonNullableComboBoxModel cons = new NonNullableComboBoxModel();
                    int i = 0;
                    while (i < tblCons.length) {
                        String type = tblCons[i].getConstraintType();
                        if ("UniqueConstraint".equals(type) || "PKConstraint".equals(type)) {
                            cons.addElement(tblCons[i]);
                        }
                        ++i;
                    }
                    FKPanel.ra$_conMap(FKPanel.this).put(this.m_key, cons);
                    FKPanel.ra$m_loadingConstraints(FKPanel.this).remove(this.m_key);
                }
                if (bar != null) {
                    bar.setDoneStatus();
                }
            }
        }
    }

    private class L
    implements ListSelectionListener,
    ActionListener {
        public void valueChanged(ListSelectionEvent e) {
            int row = FKPanel.ra$tblColumns(FKPanel.this).getSelectedRow();
            this.updateButtons(row);
        }

        private void updateButtons(int row) {
            FKPanel.ra$btnAdd(FKPanel.this).setEnabled(FKPanel.ra$mdlColumns(FKPanel.this).canAddRow(row));
            FKPanel.ra$btnRemove(FKPanel.this).setEnabled(FKPanel.ra$mdlColumns(FKPanel.this).canRemoveRow(row));
        }

        public void actionPerformed(ActionEvent e) {
            int sel = FKPanel.ra$tblColumns(FKPanel.this).getSelectedRow();
            String cmd = e.getActionCommand();
            if (FKPanel.ADD_CMD.equals(cmd)) {
                if (sel >= 0) {
                    FKPanel.ra$mdlColumns(FKPanel.this).addConsColumn(sel);
                } else {
                    FKPanel.ra$mdlColumns(FKPanel.this).addConsColumn();
                }
            } else if (FKPanel.REMOVE_CMD.equals(cmd)) {
                FKPanel.ra$mdlColumns(FKPanel.this).removeConsColumn(sel);
            }
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

