/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class IndexPartitionsPanel
extends BaseInfoPanel
implements ActionListener,
ListSelectionListener,
ListButtons.Helper {
    private boolean m_isFirstEntry;
    private boolean m_isEditable;
    private boolean m_isCompressed;
    private PanelType m_panelType;
    private DBObjectProvider m_provider;
    private Index m_index;
    private Table m_table;
    private OracleIndexPartitions m_globalIndexPartitionModel;
    private OracleIndexPartitions m_localIndexPartitionModel;
    private OracleIndexPartitions m_indexPartitionModel;
    private OracleTablePartitions m_tablePartitionModel;
    private int m_selectedTablePartitionIdx;
    private IndexPartition m_currentGlobalPartition;
    private OracleIndexPartitions m_subpartitionsModel;
    private Set<IndexPartition> m_sessionPartitions;
    private JButton m_btnStorage;
    private JButton m_btnSubpartitions;
    private JButton m_btnTablespaces;
    private JLabel m_lblDescription;
    private JCheckBox m_cbxCompress;
    private JPanel m_pnlRegularIndexHeader;
    private JLabel m_lblPartitioning;
    private JRadioButton m_rdbGlobal;
    private JRadioButton m_rdbLocal;
    private JRadioButton m_rdbNone;
    private JLabel m_lblTablespace;
    private JComboBox m_cmbTablespace;
    private NonNullableComboBoxModel m_mdlTablespace;
    private String[] m_tablespaces;
    private Map<IndexPartition, OracleStorageProperties> m_partitionStoragePropertiesMap;
    private JPanel m_pnlPartitionDefinition;
    private JPanel m_pnlTablePartitions;
    private JLabel m_lblTablePartitions;
    private DefaultListModel m_mdlTablePartitions;
    private JList m_lstTablePartitions;
    private ListSelectionListener m_mdlTablePartitionsSelectionListener;
    private JPanel m_pnlIndividualAndTablespaces;
    private JRadioButton m_rdbIndividual;
    private JRadioButton m_rdbTablespaces;
    private JPanel m_pnlGlobalIndexPartitions;
    private DefaultListModel m_mdlGlobalIndexPartitions;
    private JList m_lstGlobalIndexPartitions;
    private JLabel m_lblGlobalIndexPartitions;
    private ListButtons m_btnsGlobalIndexPartitions;
    private JLabel m_lblName;
    private JTextField m_txtName;
    private JLabel m_lblValuesLessThan;
    private JTextField m_txtValuesLessThan;
    private JPanel m_pnlTablespacesShuttle;
    private JLabel m_lblTablespacesShuttle;
    private DefaultListModel m_tblsFromModel;
    private ListPicker m_tblsFromPick;
    private DefaultListModel m_tblsToModel;
    private ReorderableListPicker m_tblsToPick;
    private Shuttle m_tblsShuttle;
    private JPanel m_pnlGlobalPartitionBy;
    private JLabel m_lblGlobalPartitionColumns;
    private NonNullableComboBoxModel m_mdlGlobalPartitionColumns;
    private JComboBox m_cmbGlobalPartitionColumns;
    private JLabel m_lblGlobalPartitionBy;
    private JComboBox m_cmbGlobalPartitionBy;
    private JPanel m_pnlGlobalIndividualAndQuantity;
    private JRadioButton m_rdbGlobalIndividual;
    private JRadioButton m_rdbGlobalQuantity;
    private JLabel m_hashCountLabel;
    private SpinnerNumberModel m_hashCountModel;
    private JSpinner m_hashCountSpinner;
    private JPanel m_pnlDomainIndexHeader;
    private JLabel m_lblDomainPartitioning;
    private JRadioButton m_rdbDomainLocal;
    private JRadioButton m_rdbDomainNone;
    private JLabel m_lblIndextypeParameters;
    private JTextArea m_txtIndextypeParameters;
    private static final String DEFAULT = "<DEFAULT>";
    private static final String RANGE = "RANGE";
    private static final String HASH = "HASH";

    public IndexPartitionsPanel() {
        this(PanelType.NONE);
    }

    public IndexPartitionsPanel(PanelType panelType) {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_panelType = panelType;
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_provider = (DBObjectProvider)dataContext.get("DBObjectProvider");
        this.m_index = (Index)dataContext.find("NewObject");
        this.m_tablespaces = this.getTablespaces(dataContext, this.m_provider);
        this.m_isEditable = (Boolean)dataContext.find("DBObjectIsEditable");
        this.init(this.m_provider, this.m_index, null, this.m_tablespaces, -1, this.m_isEditable);
        if (!this.m_isEditable) {
            this.enableAllComponents(false, true);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
    }

    public void commit() throws TraversalException {
        try {
            this.savePanel();
            if (this.m_panelType == PanelType.NONE) {
                this.m_index.setProperty("OracleIndexPartitions", null);
            } else {
                OracleIndexPartitions partitionModel = this.getCleanedIndexPartitionModel();
                this.m_provider.validateObject((DBObject)partitionModel);
                if (partitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION) {
                    this.m_currentGlobalPartition.setSubpartitions(partitionModel);
                } else {
                    this.m_index.setProperty("OracleIndexPartitions", (Object)partitionModel);
                    IndexPartition[] partitions = partitionModel.getPartitions();
                    if (partitions.length > 0) {
                        int i = 0;
                        while (i < partitions.length) {
                            if (partitions[i].getSubpartitions() != null && this.m_subpartitionsModel != null && this.m_subpartitionsModel.getPartitions() != null && this.m_subpartitionsModel.getPartitions()[i].getSubpartitions() != null) {
                                partitions[i].setSubpartitions(this.m_subpartitionsModel.getPartitions()[i].getSubpartitions());
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        catch (ValidationException ve) {
            throw new TraversalException(ve.getMessage());
        }
    }

    public void init(DBObjectProvider provider, Index index, OracleIndexPartitions indexPartitionModel, String[] tablespaces, int selectedTablePartitionIdx, boolean isEditable) {
        boolean isNullModel;
        super.init(provider, null);
        this.m_provider = provider;
        this.m_index = index;
        this.m_table = index.getTable();
        this.m_tablespaces = tablespaces;
        this.m_selectedTablePartitionIdx = selectedTablePartitionIdx;
        this.m_currentGlobalPartition = null;
        this.m_isEditable = isEditable;
        boolean bl = this.m_isCompressed = index.getKeyCompression() != null;
        if (!this.m_provider.getDescriptor().supportsFeature("GLOBAL HASH INDEX PARTITIONING")) {
            this.m_cmbGlobalPartitionBy.removeItem(HASH);
        }
        boolean bl2 = isNullModel = this.m_index.getProperty("OracleIndexPartitions") == null;
        if (this.m_selectedTablePartitionIdx > -1) {
            this.m_currentGlobalPartition = indexPartitionModel.getPartitions()[this.m_selectedTablePartitionIdx];
            this.m_indexPartitionModel = this.m_currentGlobalPartition.getSubpartitions();
            if (this.m_indexPartitionModel == null) {
                this.m_indexPartitionModel = this.createIndexPartitionModel();
            }
            isNullModel = false;
        } else if (this.m_isFirstEntry) {
            this.m_indexPartitionModel = (OracleIndexPartitions)this.m_index.getProperty("OracleIndexPartitions");
            this.m_indexPartitionModel = this.m_indexPartitionModel == null ? this.createIndexPartitionModel() : (OracleIndexPartitions)this.m_indexPartitionModel.copyTo(null, true);
        }
        this.initialiseTablespaceModels();
        this.initialiseTablePartitionModel();
        this.initialiseGlobalHashQuantity();
        if (this.m_index.getIndexType() == Index.IndexType.DOMAIN) {
            if (isNullModel) {
                this.m_rdbDomainNone.setSelected(true);
            } else {
                this.m_rdbDomainLocal.setSelected(true);
            }
            this.addDomainIndexSubpanel();
        } else if (this.m_selectedTablePartitionIdx > -1) {
            if (this.m_panelType == PanelType.SUBPARTITION_TABLESPACES) {
                this.m_rdbTablespaces.setSelected(true);
            } else {
                this.m_rdbIndividual.setSelected(true);
            }
            this.addLocalSubpartitionsSubpanel();
        } else if (isNullModel) {
            this.addNoneSubpanel();
        } else if (this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH || this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            if (this.m_isFirstEntry) {
                this.m_globalIndexPartitionModel = this.m_indexPartitionModel;
            }
            this.m_cmbGlobalPartitionBy.removeActionListener(this);
            this.m_cmbGlobalPartitionBy.setSelectedItem(this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH ? HASH : RANGE);
            this.m_cmbGlobalPartitionBy.addActionListener(this);
            this.addGlobalSubpanel();
        } else {
            if (this.m_isFirstEntry) {
                this.m_localIndexPartitionModel = this.m_indexPartitionModel;
            }
            this.addLocalSubpanel();
        }
        this.m_isFirstEntry = false;
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            Object source = ae.getSource();
            if (source == this.m_btnStorage) {
                this.execStorageDialog();
            } else if (source == this.m_btnSubpartitions) {
                this.execSubpartitionsDialog();
            } else if (source == this.m_btnTablespaces) {
                this.execTablespacesDialog();
            } else if (source == this.m_cmbGlobalPartitionBy) {
                this.addGlobalSubpanel();
            } else if (source == this.m_rdbGlobal || source == this.m_rdbGlobalIndividual || source == this.m_rdbGlobalQuantity) {
                this.savePanel();
                this.addGlobalSubpanel();
            } else if (source == this.m_rdbLocal) {
                this.savePanel();
                this.addLocalSubpanel();
            } else if (source == this.m_rdbNone) {
                this.savePanel();
                this.addNoneSubpanel();
            } else if (source == this.m_rdbIndividual || source == this.m_rdbTablespaces) {
                this.savePanel();
                if (this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_TABLESPACES) {
                    this.addLocalSubpartitionsSubpanel();
                } else {
                    this.addLocalHashDefinitionsSubpanel();
                }
            } else if (source == this.m_cmbGlobalPartitionColumns) {
                this.saveGlobalPartitionColumns();
            } else if (source == this.m_rdbDomainLocal || source == this.m_rdbDomainNone) {
                this.savePanel();
                this.addDomainIndexSubpanel();
            }
        }
        catch (ValidationException ve) {
            MessageDialog.error((Component)((Object)this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
        }
    }

    public boolean canAdd() {
        return this.m_isEditable;
    }

    public boolean canAdd(Object val) {
        return this.m_isEditable;
    }

    public boolean canMoveDown(Object val) {
        return this.m_isEditable;
    }

    public boolean canMoveUp(Object val) {
        return this.m_isEditable;
    }

    public boolean canRemove() {
        return this.m_isEditable;
    }

    public boolean canRemove(Object val) {
        return this.m_isEditable;
    }

    public boolean canReorder() {
        return this.m_isEditable;
    }

    public String getAddTooltipText() {
        return null;
    }

    public String getDownTooltipText() {
        return null;
    }

    public String getRemoveTooltipText() {
        return null;
    }

    public String getUpTooltipText() {
        return null;
    }

    public boolean includeAddRemoveButtons() {
        return true;
    }

    public boolean includeReorderButtons() {
        return true;
    }

    public void addToList() {
        if (this.m_currentGlobalPartition == null || this.trySaveGlobalPartition()) {
            this.m_currentGlobalPartition = null;
            int i = this.m_lstGlobalIndexPartitions.getSelectedIndex();
            i = i < 0 ? this.m_mdlGlobalIndexPartitions.size() : i + 1;
            IndexPartition partition = this.createIndexPartition();
            partition.setName(this.getInitialPartitionName(true));
            this.m_mdlGlobalIndexPartitions.add(i, partition);
            this.m_lstGlobalIndexPartitions.setSelectedIndex(i);
            this.m_txtName.requestFocus();
        }
    }

    public void removeFromList() {
        int i = this.m_lstGlobalIndexPartitions.getSelectedIndex();
        if (i >= 0) {
            this.m_sessionPartitions.remove(this.m_currentGlobalPartition);
            this.m_currentGlobalPartition = null;
            this.m_mdlGlobalIndexPartitions.remove(i);
        }
    }

    public void objectMovedUp(Object obj) {
    }

    public void objectMovedDown(Object obj) {
    }

    public void valueChanged(ListSelectionEvent e) {
        IndexPartition p = (IndexPartition)this.m_lstGlobalIndexPartitions.getSelectedValue();
        if (this.m_currentGlobalPartition != null && this.m_currentGlobalPartition != p && !this.trySaveGlobalPartition()) {
            this.m_lstGlobalIndexPartitions.setSelectedValue(this.m_currentGlobalPartition, true);
            return;
        }
        this.m_currentGlobalPartition = p;
        this.initialiseCurrentGlobalPartition();
    }

    private void enableAllComponents(boolean boo, boolean incLabels) {
        this.m_btnStorage.setEnabled(boo);
        this.m_btnSubpartitions.setEnabled(boo);
        this.m_btnTablespaces.setEnabled(boo);
        this.m_pnlRegularIndexHeader.setEnabled(boo);
        this.m_rdbNone.setEnabled(boo);
        this.m_rdbGlobal.setEnabled(boo);
        this.m_rdbLocal.setEnabled(boo);
        this.m_cmbTablespace.setEnabled(boo);
        this.m_pnlPartitionDefinition.setEnabled(boo);
        this.m_pnlTablePartitions.setEnabled(boo);
        this.m_pnlIndividualAndTablespaces.setEnabled(boo);
        this.m_rdbIndividual.setEnabled(boo);
        this.m_rdbTablespaces.setEnabled(boo);
        this.m_pnlGlobalIndexPartitions.setEnabled(boo);
        this.m_txtName.setEnabled(boo);
        this.m_txtValuesLessThan.setEnabled(boo);
        this.m_pnlTablespacesShuttle.setEnabled(boo);
        this.m_tblsShuttle.setEnabled(boo);
        this.m_pnlGlobalPartitionBy.setEnabled(boo);
        this.m_cmbGlobalPartitionBy.setEnabled(boo);
        this.m_cmbGlobalPartitionColumns.setEnabled(boo);
        this.m_pnlGlobalIndividualAndQuantity.setEnabled(boo);
        this.m_rdbGlobalIndividual.setEnabled(boo);
        this.m_rdbGlobalQuantity.setEnabled(boo);
        this.m_pnlDomainIndexHeader.setEnabled(boo);
        this.m_rdbDomainLocal.setEnabled(boo);
        this.m_rdbDomainNone.setEnabled(boo);
        this.m_btnsGlobalIndexPartitions.enableButtons();
        if (boo || incLabels) {
            this.m_lblDescription.setEnabled(boo);
            this.m_lblPartitioning.setEnabled(boo);
            this.m_lblTablespace.setEnabled(boo);
            this.m_lblTablePartitions.setEnabled(boo);
            this.m_lblGlobalIndexPartitions.setEnabled(boo);
            this.m_lblName.setEnabled(boo);
            this.m_lblValuesLessThan.setEnabled(boo);
            this.m_lblTablespacesShuttle.setEnabled(boo);
            this.m_hashCountLabel.setEnabled(boo);
            this.m_lblGlobalPartitionColumns.setEnabled(boo);
            this.m_lblGlobalPartitionBy.setEnabled(boo);
            this.m_lblDomainPartitioning.setEnabled(boo);
            this.m_lblIndextypeParameters.setEnabled(boo);
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_pnlPartitionDefinition.setLayout(new GridBagLayout());
        this.m_pnlDomainIndexHeader.setName("IndexPartitionsPanel.PNL_DOMAIN_INDEX_HEADER");
        this.m_pnlGlobalIndexPartitions.setName("IndexPartitionsPanel.PNL_GLOBAL_INDEX_PARTITIONS");
        this.m_pnlGlobalIndividualAndQuantity.setName("IndexPartitionsPanel.PNL_GLOBAL_I_Q");
        this.m_pnlGlobalPartitionBy.setName("IndexPartitionsPanel.PNL_GLOBAL_PARTITION_BY");
        this.m_pnlIndividualAndTablespaces.setName("IndexPartitionsPanel.PNL_IND_TBLS");
        this.m_pnlPartitionDefinition.setName("IndexPartitionsPanel.PNL_PARTITION_DEFINITION");
        this.m_pnlRegularIndexHeader.setName("IndexPartitionsPanel.PNL_REGULAR_IDX");
        this.m_pnlTablePartitions.setName("IndexPartitionsPanel.PNL_TABLE_PARTITIONS");
        this.m_pnlTablespacesShuttle.setName("IndexPartitionsPanel.PNL_TBLS_SHUTTLE");
        this.m_cmbGlobalPartitionBy.setName("IndexPartitionsPanel.CMB_GLOBAL_PARTITION_BY");
        this.m_cmbGlobalPartitionColumns.setName("IndexPartitionsPanel.CMB_GLOBAL_PARTITION_COLS");
        this.m_cmbTablespace.setName("IndexPartitionsPanel.CMB_GLOBAL_TABLESPACE");
        this.m_hashCountSpinner.setName("IndexPartitionsPanel.SPN_HASH_COUNT");
        this.m_lstGlobalIndexPartitions.setName("IndexPartitionsPanel.LST_GLOBAL_IDX_PARTITIONS");
        this.m_lstTablePartitions.setName("IndexPartitionsPanel.LST_TABLE_PARTITIONS");
        this.m_txtValuesLessThan.setName("IndexPartitionsPanel.TXT_VALUES_LESS_THAN");
        this.m_txtIndextypeParameters.setName("IndexPartitionsPanel.TXT_IDXTYPE_PARAMETERS");
        this.m_txtName.setName("IndexPartitionsPanel.TXT_NAME");
        this.m_tblsShuttle.setName("IndexPartitionsPanel.TBLS_SHUTTLE");
        this.m_btnsGlobalIndexPartitions.setName("IndexPartitionsPanel.BTNS_GLOBAL_IDX_PARTITIONS");
        this.m_btnsGlobalIndexPartitions.setButtonNames("BTNS_GLOBAL_IDX_PARTITIONS");
        this.m_btnsGlobalIndexPartitions.setButtonNames("IndexPartitionsPanel.BTNS_GLOBAL_IDX_PARTITIONS");
        this.m_btnTablespaces.setName("IndexPartitionsPanel.BTN_TBLS");
        this.m_btnSubpartitions.setName("IndexPartitionsPanel.BTN_SUBPARTITIONS");
        this.m_btnStorage.setName("IndexPartitionsPanel.BTN_STORAGE");
        this.m_rdbTablespaces.setName("IndexPartitionsPanel.RDB_TBLS");
        this.m_rdbNone.setName("IndexPartitionsPanel.RDB_NONE");
        this.m_rdbLocal.setName("IndexPartitionsPanel.RDB_LOCAL");
        this.m_rdbGlobal.setName("IndexPartitionsPanel.RDB_GLOBAL");
        this.m_rdbGlobalIndividual.setName("IndexPartitionsPanel.RDB_GLOBAL_INDIVIDUAL");
        this.m_rdbGlobalQuantity.setName("IndexPartitionsPanel.RDB_GLOBAL_QUANTITY");
        this.m_rdbIndividual.setName("IndexPartitionsPanel.RDB_INDIVIDUAL");
        this.m_rdbDomainLocal.setName("IndexPartitionsPanel.RBD_DOMAIN_LOCAL");
        this.m_rdbDomainNone.setName("IndexPartitionsPanel.RBD_DOMAIN_NONE");
        ResourceUtils.resLabel((JLabel)this.m_lblName, (Component)this.m_txtName, (String)UIArb.getString(35));
        this.m_txtName.setColumns(30);
        ResourceUtils.resLabel((JLabel)this.m_lblValuesLessThan, (Component)this.m_txtValuesLessThan, (String)UIArb.getString(679));
        ResourceUtils.resLabel((JLabel)this.m_lblTablespace, (Component)this.m_cmbTablespace, (String)UIArb.getString(668));
        ResourceUtils.resLabel((JLabel)this.m_lblGlobalPartitionBy, (Component)this.m_cmbGlobalPartitionBy, (String)UIArb.getString(453));
        this.m_cmbGlobalPartitionBy.addItem(HASH);
        this.m_cmbGlobalPartitionBy.addItem(RANGE);
        this.m_cmbGlobalPartitionBy.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblGlobalPartitionColumns, (Component)this.m_cmbGlobalPartitionColumns, (String)UIArb.getString(712));
        this.m_cmbGlobalPartitionColumns.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblIndextypeParameters, (Component)this.m_txtIndextypeParameters, (String)UIArb.getString(68));
        this.m_pnlGlobalIndexPartitions.setLayout(new GridBagLayout());
        this.m_lstGlobalIndexPartitions.setSelectionMode(0);
        this.m_lstGlobalIndexPartitions.addListSelectionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_btnStorage, (String)UIArb.getString(843));
        this.m_btnStorage.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_btnSubpartitions, (String)UIArb.getString(173));
        this.m_btnSubpartitions.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_btnTablespaces, (String)UIArb.getString(546));
        this.m_btnTablespaces.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_hashCountLabel, (Component)this.m_hashCountSpinner, (String)UIArb.getString(812));
        ResourceUtils.resButton((AbstractButton)this.m_cbxCompress, (String)UIArb.getString(873));
        this.layoutRegularIndexHeaderSubpanel();
        this.layoutDomainIndexHeaderSubpanel();
        this.layoutTablePartitionsSubpanel();
        this.layoutTablespacesShuttleSubpanel();
        this.layoutIndividualAndTablespacesSubpanel();
        this.layoutGlobalIndividualAndQuantitySubpanel();
        this.layoutGlobalPartitionBySubpanel();
    }

    private void layoutIndividualAndTablespacesSubpanel() {
        ResourceUtils.resButton((AbstractButton)this.m_rdbTablespaces, (String)UIArb.getString(477));
        ResourceUtils.resButton((AbstractButton)this.m_rdbIndividual, (String)UIArb.getString(399));
        this.m_pnlIndividualAndTablespaces.setLayout(new GridBagLayout());
        this.m_pnlIndividualAndTablespaces.add((Component)this.m_rdbIndividual, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlIndividualAndTablespaces.add((Component)this.m_rdbTablespaces, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbTablespaces);
        bg.add(this.m_rdbIndividual);
        this.m_rdbTablespaces.setSelected(true);
        this.m_rdbTablespaces.addActionListener(this);
        this.m_rdbIndividual.addActionListener(this);
    }

    private void layoutGlobalIndividualAndQuantitySubpanel() {
        ResourceUtils.resButton((AbstractButton)this.m_rdbGlobalIndividual, (String)UIArb.getString(399));
        ResourceUtils.resButton((AbstractButton)this.m_rdbGlobalQuantity, (String)UIArb.getString(582));
        this.m_pnlGlobalIndividualAndQuantity.setLayout(new GridBagLayout());
        this.m_pnlGlobalIndividualAndQuantity.add((Component)this.m_rdbGlobalIndividual, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlGlobalIndividualAndQuantity.add((Component)this.m_rdbGlobalQuantity, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbGlobalQuantity);
        bg.add(this.m_rdbGlobalIndividual);
        this.m_rdbGlobalIndividual.setSelected(true);
        this.m_rdbGlobalIndividual.addActionListener(this);
        this.m_rdbGlobalQuantity.addActionListener(this);
    }

    protected void layoutTablePartitionsSubpanel() {
        JScrollPane scrTablePartitions = new JScrollPane();
        scrTablePartitions.setVerticalScrollBarPolicy(22);
        this.m_lstTablePartitions.setModel(this.m_mdlTablePartitions);
        this.m_lstTablePartitions.setSelectionMode(0);
        this.m_lstTablePartitions.setCellRenderer(new DBObjectRenderer());
        scrTablePartitions.getViewport().add((Component)this.m_lstTablePartitions, null);
        this.m_pnlTablePartitions.setLayout(new GridBagLayout());
        this.m_pnlTablePartitions.add((Component)this.m_lblTablePartitions, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlTablePartitions.add((Component)scrTablePartitions, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.m_lstTablePartitions.getSelectionModel().addListSelectionListener(this.m_mdlTablePartitionsSelectionListener);
    }

    protected void layoutPartitionDefinitionPanel(int titleID) {
        this.m_pnlPartitionDefinition.removeAll();
        this.m_pnlPartitionDefinition.setBorder(BorderFactory.createTitledBorder(UIArb.getString(titleID)));
        this.m_pnlPartitionDefinition.add((Component)this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.m_pnlPartitionDefinition.add((Component)this.m_txtName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
    }

    private void layoutRegularIndexHeaderSubpanel() {
        this.m_pnlRegularIndexHeader.setLayout(new GridBagLayout());
        this.m_lblPartitioning.setText(UIArb.getString(578));
        ResourceUtils.resButton((AbstractButton)this.m_rdbGlobal, (String)UIArb.getString(3));
        ResourceUtils.resButton((AbstractButton)this.m_rdbLocal, (String)UIArb.getString(207));
        ResourceUtils.resButton((AbstractButton)this.m_rdbNone, (String)UIArb.getString(219));
        this.m_pnlRegularIndexHeader.add((Component)this.m_lblPartitioning, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.m_pnlRegularIndexHeader.add((Component)this.m_rdbNone, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.m_pnlRegularIndexHeader.add((Component)this.m_rdbLocal, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.m_pnlRegularIndexHeader.add((Component)this.m_rdbGlobal, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbGlobal);
        bg.add(this.m_rdbLocal);
        bg.add(this.m_rdbNone);
        this.m_rdbNone.setSelected(true);
        this.m_rdbGlobal.addActionListener(this);
        this.m_rdbLocal.addActionListener(this);
        this.m_rdbNone.addActionListener(this);
    }

    private void layoutDomainIndexHeaderSubpanel() {
        this.m_pnlDomainIndexHeader.setLayout(new GridBagLayout());
        this.m_lblDomainPartitioning.setText(UIArb.getString(578));
        ResourceUtils.resButton((AbstractButton)this.m_rdbDomainLocal, (String)UIArb.getString(207));
        ResourceUtils.resButton((AbstractButton)this.m_rdbDomainNone, (String)UIArb.getString(219));
        this.m_pnlDomainIndexHeader.add((Component)this.m_lblDomainPartitioning, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.m_pnlDomainIndexHeader.add((Component)this.m_rdbDomainNone, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.m_pnlDomainIndexHeader.add((Component)this.m_rdbDomainLocal, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbDomainLocal);
        bg.add(this.m_rdbDomainNone);
        this.m_rdbDomainLocal.addActionListener(this);
        this.m_rdbDomainNone.addActionListener(this);
    }

    private void layoutIndexPartitionsPanel() {
        int y = 0;
        ResourceUtils.resLabel((JLabel)this.m_lblGlobalIndexPartitions, (Component)this.m_lstGlobalIndexPartitions, (String)UIArb.getString(498));
        this.m_pnlGlobalIndexPartitions.removeAll();
        this.m_pnlGlobalIndexPartitions.add((Component)this.m_lblGlobalIndexPartitions, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlGlobalIndexPartitions.add((Component)new JScrollPane(this.m_lstGlobalIndexPartitions), new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlGlobalIndexPartitions.add((Component)this.m_btnsGlobalIndexPartitions, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.m_pnlGlobalIndexPartitions.add((Component)this.m_pnlPartitionDefinition, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.layoutPartitionDefinitionPanel(204);
    }

    private void layoutGlobalPartitionBySubpanel() {
        this.m_pnlGlobalPartitionBy.setLayout(new GridBagLayout());
        this.m_pnlGlobalPartitionBy.add((Component)this.m_lblGlobalPartitionBy, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlGlobalPartitionBy.add((Component)this.m_cmbGlobalPartitionBy, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlGlobalPartitionBy.add((Component)this.m_lblGlobalPartitionColumns, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 5), 0, 0));
        this.m_pnlGlobalPartitionBy.add((Component)this.m_cmbGlobalPartitionColumns, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
    }

    private void layoutTablespacesShuttleSubpanel() {
        this.m_pnlTablespacesShuttle.setLayout(new GridBagLayout());
        this.m_tblsShuttle.setFromPicker((ItemPicker)this.m_tblsFromPick);
        this.m_tblsShuttle.setToPicker((ItemPicker)this.m_tblsToPick);
        this.m_pnlTablespacesShuttle.add((Component)this.m_lblTablespacesShuttle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlTablespacesShuttle.add((Component)this.m_tblsShuttle, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void addNoneSubpanel() {
        this.m_panelType = PanelType.NONE;
        this.removeAll();
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_rdbNone.setSelected(true);
        this.validate();
        this.repaint();
    }

    private void addLocalSubpanel() {
        this.m_indexPartitionModel = this.m_localIndexPartitionModel;
        OracleTablePartitions tablePartitions = (OracleTablePartitions)this.m_table.getProperty("OracleTablePartitions");
        boolean isHashPartitionedTable = tablePartitions != null && tablePartitions.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.HASH);
        this.initialiseSessionPartitions();
        this.removeAll();
        if (tablePartitions == null || !isHashPartitionedTable && tablePartitions.getPartitions().length == 0) {
            int y = 0;
            this.m_lblDescription.setText(UIArb.getString(581));
            this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        } else {
            if (isHashPartitionedTable) {
                if (this.m_panelType == PanelType.LOCAL_HASH_TABLESPACES || this.m_tblsToModel.getSize() > 0 && this.m_panelType != PanelType.LOCAL_HASH_INDIVIDUAL) {
                    this.m_rdbTablespaces.setSelected(true);
                } else {
                    this.m_rdbIndividual.setSelected(true);
                }
                this.addLocalHashDefinitionsSubpanel();
            } else if (tablePartitions.getSubpartitionModel() != null) {
                this.addLocalCompDefinitionsSubpanel();
            } else {
                this.addLocalRangeListDefinitionsSubpanel();
            }
            if (this.m_selectedTablePartitionIdx == -1) {
                this.m_selectedTablePartitionIdx = 0;
            }
            this.populateIndexPartition();
        }
        this.m_rdbLocal.setSelected(true);
        this.validate();
        this.repaint();
    }

    private void addLocalRangeListDefinitionsSubpanel() {
        this.m_panelType = PanelType.LOCAL_OTHER;
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.LOCAL_OTHER);
        int y = 0;
        this.removeAll();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(150));
        this.m_lblDescription.setText(UIArb.getString(409));
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
        this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 5), 0, 0));
        this.layoutPartitionDefinitionPanel(204);
        y = 0;
        this.m_pnlPartitionDefinition.add((Component)this.m_cbxCompress, new GridBagConstraints(1, ++y, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.m_pnlPartitionDefinition.add((Component)this.m_btnStorage, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        if (this.m_lstTablePartitions.getSelectedIndex() == -1) {
            this.m_lstTablePartitions.setSelectedIndex(0);
        }
        this.validate();
        this.repaint();
    }

    private void addLocalHashDefinitionsSubpanel() {
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.LOCAL_HASH);
        int y = 0;
        this.removeAll();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(150));
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_pnlIndividualAndTablespaces, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        if (this.m_rdbIndividual.isSelected()) {
            this.m_panelType = PanelType.LOCAL_HASH_INDIVIDUAL;
            this.m_lblDescription.setText(UIArb.getString(409));
            this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
            this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.layoutPartitionDefinitionPanel(204);
            this.m_pnlPartitionDefinition.add((Component)this.m_lblTablespace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.m_pnlPartitionDefinition.add((Component)this.m_cmbTablespace, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_cmbTablespace.setEditable(this.isOfflineProvider());
            this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            if (this.m_lstTablePartitions.getSelectedIndex() == -1) {
                this.m_lstTablePartitions.setSelectedIndex(0);
            }
        } else {
            this.m_panelType = PanelType.LOCAL_HASH_TABLESPACES;
            this.m_lblTablespacesShuttle.setText(UIArb.getString(372));
            this.add(this.m_pnlTablespacesShuttle, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 5), 0, 0));
        }
        this.validate();
        this.repaint();
    }

    private void addLocalSubpartitionsSubpanel() {
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.SUBPARTITION);
        this.removeAll();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(51));
        int y = 0;
        this.add(this.m_pnlIndividualAndTablespaces, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        if (this.m_rdbIndividual.isSelected()) {
            this.m_panelType = PanelType.SUBPARTITION_INDIVIDUAL;
            this.m_lblDescription.setText(UIArb.getString(765));
            this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
            this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
            this.layoutPartitionDefinitionPanel(861);
            this.m_pnlPartitionDefinition.add((Component)this.m_lblTablespace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.m_pnlPartitionDefinition.add((Component)this.m_cmbTablespace, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_cmbTablespace.setEditable(this.isOfflineProvider());
            this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_selectedTablePartitionIdx = this.m_lstTablePartitions.getSelectedIndex();
            if (this.m_selectedTablePartitionIdx == -1) {
                this.m_lstTablePartitions.setSelectedIndex(0);
            }
            this.m_txtName.setEnabled(this.m_isEditable && this.m_tablePartitionModel != null);
            this.m_cmbTablespace.setEnabled(this.m_isEditable && this.m_tablePartitionModel != null);
        } else {
            this.m_panelType = PanelType.SUBPARTITION_TABLESPACES;
            this.m_lblTablespacesShuttle.setText(UIArb.getString(605));
            this.add(this.m_pnlTablespacesShuttle, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 5), 0, 0));
        }
        this.validate();
        this.repaint();
    }

    private void addDomainIndexSubpanel() {
        this.m_panelType = PanelType.NONE;
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.DOMAIN);
        OracleTablePartitions tablePartitions = (OracleTablePartitions)this.m_table.getProperty("OracleTablePartitions");
        this.removeAll();
        if (tablePartitions == null || tablePartitions.getPartitions().length == 0) {
            this.m_lblDescription.setText(UIArb.getString(581));
            this.add(this.m_lblDescription, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        } else if (tablePartitions.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.RANGE) && tablePartitions.getSubpartitionModel() == null) {
            if (this.m_rdbDomainNone.isSelected()) {
                this.m_panelType = PanelType.NONE;
                this.add(this.m_pnlDomainIndexHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
                this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            } else {
                this.addLocalDomainSubpanel();
            }
        } else {
            String type = tablePartitions.getSubpartitionModel() != null ? UIArb.getString(652) : tablePartitions.getPartitionType().toString();
            this.m_lblDescription.setText(UIArb.format(252, type));
            this.add(this.m_lblDescription, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        }
        this.validate();
        this.repaint();
    }

    private void addLocalDomainSubpanel() {
        this.m_panelType = PanelType.DOMAIN;
        this.initialiseSessionPartitions();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(150));
        this.m_lblDescription.setText(UIArb.getString(409));
        int y = 0;
        this.add(this.m_pnlDomainIndexHeader, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
        this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 5), 0, 0));
        this.layoutPartitionDefinitionPanel(204);
        y = 0;
        this.m_pnlPartitionDefinition.add((Component)this.m_lblIndextypeParameters, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlPartitionDefinition.add((Component)new JScrollPane(this.m_txtIndextypeParameters), new GridBagConstraints(0, ++y, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        if (this.m_selectedTablePartitionIdx == -1) {
            this.m_selectedTablePartitionIdx = 0;
        }
        this.populateIndexPartition();
    }

    private void addLocalCompDefinitionsSubpanel() {
        this.m_panelType = PanelType.LOCAL_COMPOSITE;
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.LOCAL_COMP);
        int y = 0;
        this.removeAll();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(150));
        this.m_lblDescription.setText(UIArb.getString(409));
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
        this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 5), 0, 0));
        this.add(this.m_btnTablespaces, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.layoutPartitionDefinitionPanel(204);
        y = 0;
        this.m_pnlPartitionDefinition.add((Component)this.m_cbxCompress, new GridBagConstraints(1, ++y, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        JPanel buttons = new JPanel();
        this.m_pnlPartitionDefinition.add((Component)buttons, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        buttons.add((Component)this.m_btnStorage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        buttons.add((Component)this.m_btnSubpartitions, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this.m_lstTablePartitions.getSelectedIndex() == -1) {
            this.m_lstTablePartitions.setSelectedIndex(0);
        }
        this.validate();
        this.repaint();
    }

    private void addGlobalSubpanel() {
        this.m_indexPartitionModel = this.m_globalIndexPartitionModel;
        this.initialiseGlobalIndexPartitionColumnModel();
        this.initialiseGlobalIndexPartitionsModel();
        this.initialiseSessionPartitions();
        int y = 0;
        String partitionBy = (String)this.m_cmbGlobalPartitionBy.getSelectedItem();
        this.removeAll();
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_pnlGlobalPartitionBy, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        if (this.m_mdlGlobalPartitionColumns.getSize() == 0) {
            this.m_lblDescription.setText(UIArb.getString(92));
            this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        } else if (HASH.equals(partitionBy)) {
            this.add(this.m_pnlGlobalIndividualAndQuantity, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
            if (this.m_rdbGlobalQuantity.isSelected()) {
                this.addGlobalHashQuantitySubpanel(y);
            } else {
                this.m_panelType = PanelType.GLOBAL_HASH_INDIVIDUAL;
                this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.GLOBAL_HASH);
                this.add(this.m_pnlGlobalIndexPartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 5), 0, 0));
                this.layoutIndexPartitionsPanel();
                this.m_pnlPartitionDefinition.add((Component)this.m_lblTablespace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
                this.m_pnlPartitionDefinition.add((Component)this.m_cmbTablespace, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
                this.m_cmbTablespace.setEditable(this.isOfflineProvider());
            }
        } else {
            this.m_panelType = PanelType.GLOBAL_RANGE;
            this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.GLOBAL_RANGE);
            this.add(this.m_pnlGlobalIndexPartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.layoutIndexPartitionsPanel();
            y = 0;
            this.m_pnlPartitionDefinition.add((Component)this.m_lblValuesLessThan, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.m_pnlPartitionDefinition.add((Component)this.m_txtValuesLessThan, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_pnlPartitionDefinition.add((Component)this.m_btnStorage, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_rdbGlobal.setSelected(true);
        this.initialiseCurrentGlobalPartition();
        this.validate();
        this.repaint();
    }

    private void addGlobalHashQuantitySubpanel(int y) {
        this.m_panelType = PanelType.GLOBAL_HASH_QUANTITY;
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.GLOBAL_HASH);
        this.m_lblDescription.setText(UIArb.getString(171));
        this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        JPanel panel = new JPanel();
        panel.add((Component)this.m_hashCountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_hashCountSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(panel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_lblTablespacesShuttle.setText(UIArb.getString(263));
        this.add(this.m_pnlTablespacesShuttle, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
    }

    private void initialiseCurrentGlobalPartition() {
        boolean enabled;
        boolean bl = enabled = this.m_currentGlobalPartition != null;
        if (enabled) {
            this.m_currentGlobalPartition.setParent((DBObject)this.m_indexPartitionModel);
            String name = this.m_currentGlobalPartition.getName();
            if (ModelUtil.hasLength((String)name)) {
                this.m_txtName.setText(this.m_provider.getExternalName(name));
            } else {
                this.m_txtName.setText(null);
            }
            if (this.m_panelType == PanelType.GLOBAL_RANGE) {
                Object[] values = this.m_currentGlobalPartition.getValuesLessThan();
                StringBuffer buff = new StringBuffer();
                int i = 0;
                while (i < values.length) {
                    buff.append(values[i].toString());
                    if (i < values.length - 1) {
                        buff.append(",");
                    }
                    ++i;
                }
                this.m_txtValuesLessThan.setText(buff.toString());
            } else {
                OracleStorageProperties osp = this.m_currentGlobalPartition.getSegmentAttributes();
                String tablespaceName = osp != null ? this.m_provider.getExternalName(osp.getTablespace()) : null;
                this.m_cmbTablespace.setSelectedItem(tablespaceName);
            }
        } else {
            this.m_txtName.setText(null);
            this.m_txtValuesLessThan.setText(null);
            this.m_txtIndextypeParameters.setText(null);
            this.m_cmbTablespace.setSelectedItem(null);
        }
        this.m_txtName.setEnabled(this.m_isEditable && enabled);
        this.m_txtValuesLessThan.setEnabled(this.m_isEditable && enabled);
        this.m_txtIndextypeParameters.setEnabled(this.m_isEditable && enabled);
        this.m_cmbTablespace.setEnabled(this.m_isEditable && enabled);
    }

    private void initialiseSessionPartitions() {
        this.m_sessionPartitions.clear();
        if (this.m_indexPartitionModel != null) {
            IndexPartition[] indexPartitionArray = this.m_indexPartitionModel.getPartitions();
            int n = 0;
            while (n < indexPartitionArray.length) {
                IndexPartition partition = indexPartitionArray[n];
                this.m_sessionPartitions.add(partition);
                ++n;
            }
        }
    }

    private boolean trySaveGlobalPartition() {
        try {
            this.saveGlobalPartition();
        }
        catch (ValidationException ve) {
            MessageDialog.error((Component)((Object)this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private void saveGlobalPartition() throws ValidationException {
        this.m_currentGlobalPartition.setParent((DBObject)this.m_indexPartitionModel);
        String name = this.m_txtName.getText();
        if (ModelUtil.hasLength((String)name)) {
            this.m_provider.validateName("INDEX PARTITION", name);
            this.m_sessionPartitions.remove(this.m_currentGlobalPartition);
            this.m_currentGlobalPartition.setName(this.m_provider.getInternalName(name));
            this.validateNameIsUnique(this.m_currentGlobalPartition.getName());
            this.m_sessionPartitions.add(this.m_currentGlobalPartition);
        } else {
            if (this.isOfflineProvider()) {
                name = this.m_currentGlobalPartition.getName();
                this.m_txtName.setText(this.m_provider.getExternalName(name));
                throw new ValidationException((DBObject)this.m_table, UIArb.getString(271));
            }
            this.m_currentGlobalPartition.setName(null);
        }
        if (this.m_panelType == PanelType.GLOBAL_RANGE) {
            this.m_currentGlobalPartition.setValuesLessThan(this.m_txtValuesLessThan.getText());
            this.m_provider.validateObjectProperty((DBObject)this.m_currentGlobalPartition, (Object)Property.globalPartitionColumns);
        } else {
            String tablespaceName = (String)this.m_cmbTablespace.getEditor().getItem();
            if (!ModelUtil.hasLength((String)tablespaceName) || DEFAULT.equals(tablespaceName)) {
                this.m_currentGlobalPartition.setSegmentAttributes(null);
                this.m_cmbTablespace.setSelectedItem(DEFAULT);
            } else {
                OracleStorageProperties osp = this.m_currentGlobalPartition.getSegmentAttributes();
                if (osp == null) {
                    osp = new OracleStorageProperties();
                    this.m_currentGlobalPartition.setSegmentAttributes(osp);
                }
                osp.setTablespace(this.m_provider.getInternalName(tablespaceName));
            }
        }
    }

    protected void initialiseTablespaceModels() {
        int len;
        int n = len = this.m_tablespaces != null ? this.m_tablespaces.length : 0;
        if (this.m_mdlTablespace == null) {
            Object[] tmp = new String[len + 1];
            tmp[0] = DEFAULT;
            int i = 0;
            while (i < len) {
                tmp[i + 1] = this.m_provider.getExternalName(this.m_tablespaces[i]);
                ++i;
            }
            this.m_mdlTablespace = new NonNullableComboBoxModel(tmp);
            this.m_cmbTablespace.setModel(this.m_mdlTablespace);
        }
        this.m_tblsFromModel.removeAllElements();
        int i = 0;
        while (i < len) {
            this.m_tblsFromModel.addElement(this.m_provider.getExternalName(this.m_tablespaces[i]));
            ++i;
        }
        this.m_tblsToModel.removeAllElements();
        if (this.m_indexPartitionModel != null) {
            String[] chosenTbls = this.m_indexPartitionModel.getTablespaces();
            int i2 = 0;
            while (i2 < chosenTbls.length) {
                String tablespaceName = this.m_provider.getExternalName(chosenTbls[i2]);
                this.m_tblsFromModel.removeElement(tablespaceName);
                this.m_tblsToModel.addElement(tablespaceName);
                ++i2;
            }
        }
    }

    private void initialiseGlobalIndexPartitionsModel() {
        this.m_lstGlobalIndexPartitions.removeListSelectionListener(this);
        this.m_mdlGlobalIndexPartitions.removeAllElements();
        if (this.m_indexPartitionModel != null && this.m_indexPartitionModel.getPartitions() != null) {
            IndexPartition[] indexPartitionArray = this.m_indexPartitionModel.getPartitions();
            int n = 0;
            while (n < indexPartitionArray.length) {
                IndexPartition partition = indexPartitionArray[n];
                this.m_mdlGlobalIndexPartitions.addElement(partition);
                ++n;
            }
        }
        this.m_lstGlobalIndexPartitions.addListSelectionListener(this);
    }

    private void initialiseTablePartitionModel() {
        boolean isSubpartitions = this.m_selectedTablePartitionIdx > -1;
        this.m_lstTablePartitions.getSelectionModel().removeListSelectionListener(this.m_mdlTablePartitionsSelectionListener);
        this.m_mdlTablePartitions.clear();
        this.m_tablePartitionModel = (OracleTablePartitions)this.m_table.getProperty("OracleTablePartitions");
        String tablePartitionName = null;
        if (isSubpartitions) {
            TablePartition tablePartition = this.m_tablePartitionModel.getPartitions()[this.m_selectedTablePartitionIdx];
            tablePartitionName = tablePartition.getName();
            this.m_tablePartitionModel = tablePartition.getPartitionLevelSubpartitions();
        }
        if (this.m_tablePartitionModel != null && this.m_tablePartitionModel.getPartitions().length == 0 && this.m_tablePartitionModel.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.HASH)) {
            int quantity = this.m_tablePartitionModel.getHashQuantity() == null ? 1 : this.m_tablePartitionModel.getHashQuantity();
            int suffix = 1;
            while (suffix <= quantity) {
                String name = UIArb.getString(isSubpartitions ? 342 : 600) + suffix;
                if (isSubpartitions) {
                    int maxPrefixLength = 30 - name.length();
                    int prefixLength = maxPrefixLength > tablePartitionName.length() ? tablePartitionName.length() : maxPrefixLength - 1;
                    name = tablePartitionName.substring(0, prefixLength) + '_' + name;
                }
                this.m_tablePartitionModel.addPartition(new TablePartition(name));
                ++suffix;
            }
        }
        if (this.m_tablePartitionModel != null) {
            TablePartition[] tablePartitionArray = this.m_tablePartitionModel.getPartitions();
            int n = 0;
            while (n < tablePartitionArray.length) {
                TablePartition partition = tablePartitionArray[n];
                String name = ModelUtil.hasLength((String)partition.getName()) ? partition.getName() : UIArb.getString(255);
                this.m_mdlTablePartitions.addElement(name);
                ++n;
            }
        }
        this.m_lstTablePartitions.getSelectionModel().addListSelectionListener(this.m_mdlTablePartitionsSelectionListener);
    }

    private void initialiseGlobalIndexPartitionColumnModel() {
        DBObjectID[] colIDs;
        this.m_cmbGlobalPartitionColumns.removeActionListener(this);
        this.m_mdlGlobalPartitionColumns.removeAllElements();
        Column[] columnArray = OracleIndexPartitions.getValidGlobalPartitionColumns((Index)this.m_index);
        int n = 0;
        while (n < columnArray.length) {
            Column col = columnArray[n];
            this.m_mdlGlobalPartitionColumns.addElement((Object)col.getName());
            ++n;
        }
        if (this.m_indexPartitionModel != null && (colIDs = this.m_indexPartitionModel.getGlobalPartitionColumns()).length > 0) {
            DBObjectID colID = colIDs[colIDs.length - 1];
            Column column = (Column)this.m_table.findOwnedObject(colID);
            if (column == null) {
                try {
                    column = (Column)colID.resolveID();
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            if (column != null) {
                this.m_cmbGlobalPartitionColumns.setSelectedItem(column.getName());
            }
        }
        this.m_cmbGlobalPartitionColumns.addActionListener(this);
    }

    private void initialiseGlobalHashQuantity() {
        Integer q;
        if (this.m_indexPartitionModel != null && (q = this.m_indexPartitionModel.getGlobalHashQuantity()) != null) {
            this.m_hashCountModel.setValue(q);
            this.m_rdbGlobalIndividual.setSelected(false);
            this.m_rdbGlobalQuantity.setSelected(true);
        }
    }

    private void savePanel() throws ValidationException {
        if (this.m_panelType == PanelType.DOMAIN) {
            this.saveLocalPartition();
        } else if (this.m_panelType == PanelType.GLOBAL_HASH_QUANTITY) {
            this.saveGlobalPartitionColumns();
            this.saveTablespaces();
            Number num = this.m_hashCountModel.getNumber();
            this.m_indexPartitionModel.setGlobalHashQuantity(num == null ? null : new Integer(num.intValue()));
        } else if (this.m_panelType == PanelType.GLOBAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.GLOBAL_RANGE) {
            this.saveGlobalPartitionColumns();
            this.savePartitions();
        } else if (this.m_panelType == PanelType.LOCAL_OTHER || this.m_panelType == PanelType.LOCAL_COMPOSITE || this.m_panelType == PanelType.LOCAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL) {
            this.saveLocalPartition();
        } else if (this.m_panelType == PanelType.LOCAL_HASH_TABLESPACES || this.m_panelType == PanelType.SUBPARTITION_TABLESPACES) {
            this.saveTablespaces();
        }
    }

    private OracleIndexPartitions createIndexPartitionModel() {
        OracleIndexPartitions model = new OracleIndexPartitions();
        model.setParent((DBObject)this.m_index);
        DBObjectID id = TemporaryObjectID.createID((DBObject)model);
        model.setID(id);
        return model;
    }

    private IndexPartition createIndexPartition() {
        IndexPartition partition = new IndexPartition(this.m_indexPartitionModel);
        DBObjectID id = TemporaryObjectID.createID((DBObject)partition);
        partition.setID(id);
        return partition;
    }

    private IndexPartition[] createIndexPartitions(int length) {
        IndexPartition[] indexPartitions = new IndexPartition[length];
        int i = 0;
        while (i < length) {
            indexPartitions[i] = this.createIndexPartition();
            ++i;
        }
        return indexPartitions;
    }

    private OracleIndexPartitions getCleanedIndexPartitionModel() {
        OracleIndexPartitions partitionModel = (OracleIndexPartitions)this.m_indexPartitionModel.copyTo(null, true);
        partitionModel.setParent((DBObject)this.m_index);
        if (this.m_panelType == PanelType.GLOBAL_RANGE || this.m_panelType == PanelType.GLOBAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.LOCAL_OTHER || this.m_panelType == PanelType.LOCAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL) {
            partitionModel.setTablespaces(null);
            partitionModel.setGlobalHashQuantity(null);
        }
        if (this.m_panelType == PanelType.GLOBAL_HASH_QUANTITY || this.m_panelType == PanelType.LOCAL_HASH_TABLESPACES || this.m_panelType == PanelType.SUBPARTITION_TABLESPACES) {
            partitionModel.setPartitions(null);
        }
        if (this.m_panelType != PanelType.GLOBAL_RANGE) {
            IndexPartition[] indexPartitionArray = partitionModel.getPartitions();
            int n = 0;
            while (n < indexPartitionArray.length) {
                IndexPartition indexPartition = indexPartitionArray[n];
                indexPartition.setValuesLessThan((Object[])null);
                ++n;
            }
        }
        if (partitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.LOCAL_HASH || partitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION) {
            IndexPartition[] indexPartitionArray = partitionModel.getPartitions();
            int n = 0;
            while (n < indexPartitionArray.length) {
                IndexPartition indexPartition = indexPartitionArray[n];
                if (indexPartition.getSegmentAttributes() != null) {
                    OracleStorageProperties segmentAttrs = new OracleStorageProperties();
                    segmentAttrs.setTablespace(indexPartition.getSegmentAttributes().getTablespace());
                    indexPartition.setSegmentAttributes(segmentAttrs);
                }
                ++n;
            }
        }
        return partitionModel;
    }

    private void execSubpartitionsDialog() {
        if (this.m_selectedTablePartitionIdx > -1) {
            try {
                this.savePanel();
            }
            catch (ValidationException ve) {
                MessageDialog.error((Component)((Object)this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
                return;
            }
            JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)((Object)this)), (String)UIArb.getString(528), (int)3);
            IndexPartitionsPanel subpartitionsPanel = new IndexPartitionsPanel(this.getSubpartitionsPanelType());
            subpartitionsPanel.setPreferredSize(new Dimension(500, 250));
            subpartitionsPanel.init(this.m_provider, this.m_index, this.m_indexPartitionModel, this.m_tablespaces, this.m_selectedTablePartitionIdx, this.m_isEditable);
            IndexPartition currentIndexPartition = this.m_indexPartitionModel.getPartitions()[this.m_selectedTablePartitionIdx];
            dialog.setContent((Component)((Object)subpartitionsPanel));
            dialog.setResizable(true);
            1 list = new 1(this, subpartitionsPanel, currentIndexPartition);
            dialog.addVetoableChangeListener((VetoableChangeListener)list);
            dialog.runDialog();
        }
    }

    private PanelType getSubpartitionsPanelType() {
        OracleIndexPartitions subpartitions = null;
        if (this.m_subpartitionsModel != null && this.m_subpartitionsModel.getPartitions().length > this.m_selectedTablePartitionIdx) {
            subpartitions = this.m_subpartitionsModel.getPartitions()[this.m_selectedTablePartitionIdx].getSubpartitions();
        } else if (this.m_indexPartitionModel.getPartitions().length > this.m_selectedTablePartitionIdx) {
            subpartitions = this.m_indexPartitionModel.getPartitions()[this.m_selectedTablePartitionIdx].getSubpartitions();
        }
        return subpartitions != null && subpartitions.getPartitions().length > 0 ? PanelType.SUBPARTITION_INDIVIDUAL : PanelType.SUBPARTITION_TABLESPACES;
    }

    private void saveSubpartitionModel(OracleIndexPartitions subpartitionModel) {
        if (this.m_subpartitionsModel == null) {
            this.m_subpartitionsModel = this.createIndexPartitionModel();
            int partitionCount = this.m_tablePartitionModel.getPartitions().length;
            this.m_subpartitionsModel.setPartitions(this.createIndexPartitions(partitionCount));
        }
        this.m_subpartitionsModel.getPartitions()[this.m_selectedTablePartitionIdx].setSubpartitions(subpartitionModel);
    }

    private void execTablespacesDialog() {
        JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)((Object)this)), (String)UIArb.getString(152), (int)3);
        this.m_pnlTablespacesShuttle.setPreferredSize(new Dimension(600, 200));
        this.m_lblTablespacesShuttle.setText(UIArb.getString(372));
        dialog.setContent((Component)this.m_pnlTablespacesShuttle);
        dialog.setResizable(true);
        2 list = new 2();
        dialog.addVetoableChangeListener((VetoableChangeListener)list);
        dialog.runDialog();
    }

    private void execStorageDialog() {
        if (this.m_selectedTablePartitionIdx > -1 && (this.m_panelType == PanelType.LOCAL_OTHER || this.m_panelType == PanelType.LOCAL_COMPOSITE) || this.m_currentGlobalPartition != null && this.m_panelType == PanelType.GLOBAL_RANGE) {
            try {
                this.savePanel();
            }
            catch (ValidationException ve) {
                MessageDialog.error((Component)((Object)this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
                return;
            }
            IndexPartition indexPartition = this.m_currentGlobalPartition != null ? this.m_currentGlobalPartition : this.m_indexPartitionModel.getPartitions()[this.m_selectedTablePartitionIdx];
            OracleStorageProperties osp = indexPartition.getSegmentAttributes();
            osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.INDEX_PARTITION, this.m_provider, (DBObject)indexPartition, (DBObject)this.m_index, null, this.m_tablespaces, (Component)((Object)this));
            indexPartition.setSegmentAttributes(osp);
            this.m_partitionStoragePropertiesMap.put(indexPartition, null);
        }
    }

    private void saveTablespaces() {
        Enumeration tblsEnum = this.m_tblsToModel.elements();
        String[] tbls = new String[this.m_tblsToModel.size()];
        int i = 0;
        while (i < tbls.length) {
            tbls[i] = this.m_provider.getInternalName((String)tblsEnum.nextElement());
            ++i;
        }
        this.m_indexPartitionModel.setTablespaces(tbls);
    }

    private void saveGlobalPartitionColumns() {
        ArrayList<DBObjectID> columnIDs = new ArrayList<DBObjectID>();
        String selectedColumn = (String)this.m_cmbGlobalPartitionColumns.getSelectedItem();
        int i = 0;
        while (i < this.m_mdlGlobalPartitionColumns.getSize()) {
            String columnName = (String)this.m_mdlGlobalPartitionColumns.getElementAt(i);
            Column column = this.m_table.getColumn(columnName);
            if (column.getID() == null) {
                column.setID(TemporaryObjectID.createID((DBObject)column));
            }
            columnIDs.add(column.getID());
            if (columnName.equals(selectedColumn)) break;
            ++i;
        }
        this.m_indexPartitionModel.setGlobalPartitionColumns(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
    }

    private void savePartitions() throws ValidationException {
        if (this.m_currentGlobalPartition != null) {
            this.saveGlobalPartition();
        }
        IndexPartition[] partitions = new IndexPartition[this.m_mdlGlobalIndexPartitions.getSize()];
        Enumeration model = this.m_mdlGlobalIndexPartitions.elements();
        int i = 0;
        while (i < partitions.length) {
            partitions[i] = (IndexPartition)model.nextElement();
            ++i;
        }
        this.m_indexPartitionModel.setPartitions(partitions);
    }

    private void saveLocalPartition() throws ValidationException {
        if (this.m_selectedTablePartitionIdx > -1) {
            int length;
            IndexPartition[] indexPartitions = this.m_indexPartitionModel.getPartitions();
            if (indexPartitions.length != (length = this.m_tablePartitionModel.getPartitions().length)) {
                indexPartitions = this.createIndexPartitions(length);
                this.m_indexPartitionModel.setPartitions(indexPartitions);
            }
            IndexPartition indexPartition = indexPartitions[this.m_selectedTablePartitionIdx];
            String internalName = "";
            String externalName = this.m_txtName.getText();
            if (ModelUtil.hasLength((String)externalName)) {
                this.m_provider.validateName("INDEX PARTITION", externalName);
            }
            try {
                internalName = this.getInternalName(externalName);
            }
            catch (TraversalException e) {
                MessageDialog.error((Component)((Object)this), (Object)e.getMessage(), null, null);
            }
            indexPartition.setName(internalName);
            if (this.m_panelType == PanelType.LOCAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL) {
                String tablespaceName = (String)this.m_mdlTablespace.getSelectedItem();
                if (!ModelUtil.hasLength((String)tablespaceName) || DEFAULT.equals(tablespaceName)) {
                    indexPartition.setSegmentAttributes(null);
                    this.m_cmbTablespace.setSelectedItem(DEFAULT);
                } else {
                    OracleStorageProperties osp = indexPartition.getSegmentAttributes();
                    if (osp == null) {
                        osp = new OracleStorageProperties();
                        indexPartition.setSegmentAttributes(osp);
                    }
                    osp.setTablespace(this.m_provider.getInternalName(tablespaceName));
                }
            } else if (this.m_panelType == PanelType.DOMAIN) {
                indexPartition.setDomainParameters(ModelUtil.hasLength((String)this.m_txtIndextypeParameters.getText()) ? this.m_txtIndextypeParameters.getText() : null);
            }
            Boolean compress = null;
            if (this.m_cbxCompress.isEnabled()) {
                compress = this.m_cbxCompress.isSelected();
            }
            indexPartition.setKeyCompression(compress);
        }
        this.m_selectedTablePartitionIdx = this.m_lstTablePartitions.getSelectedIndex();
        if (this.m_selectedTablePartitionIdx > -1) {
            this.populateIndexPartition();
        }
    }

    private void populateIndexPartition() {
        String name;
        IndexPartition[] indexPartitions = this.m_indexPartitionModel.getPartitions();
        String string = name = this.m_selectedTablePartitionIdx > -1 && indexPartitions.length > this.m_selectedTablePartitionIdx && indexPartitions[this.m_selectedTablePartitionIdx] != null ? indexPartitions[this.m_selectedTablePartitionIdx].getName() : this.getInitialPartitionName(false);
        if (name == null) {
            name = this.getInitialPartitionName(false);
        }
        this.m_txtName.setText(this.getExternalName(name));
        this.m_txtName.setEnabled(this.m_isEditable);
        this.m_cbxCompress.setEnabled(this.m_isCompressed && this.m_isEditable);
        if (this.m_selectedTablePartitionIdx > -1 && indexPartitions.length > 0) {
            Boolean compress = indexPartitions[this.m_selectedTablePartitionIdx].getKeyCompression();
            this.m_cbxCompress.setSelected(compress != null && compress != false);
        } else {
            this.m_cbxCompress.setSelected(false);
        }
        if (this.m_panelType == PanelType.LOCAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL) {
            OracleStorageProperties osp = indexPartitions.length > this.m_selectedTablePartitionIdx ? indexPartitions[this.m_selectedTablePartitionIdx].getSegmentAttributes() : null;
            name = osp != null ? osp.getTablespace() : DEFAULT;
            this.m_mdlTablespace.setSelectedItem((Object)(name == null ? DEFAULT : name));
            this.m_cmbTablespace.setEnabled(this.m_isEditable);
        } else if (this.m_panelType == PanelType.DOMAIN) {
            String indextypeParameters = indexPartitions.length > this.m_selectedTablePartitionIdx ? indexPartitions[this.m_selectedTablePartitionIdx].getDomainParameters() : null;
            this.m_txtIndextypeParameters.setText(indextypeParameters);
        }
    }

    private String getInitialPartitionName(boolean isGlobalPartition) {
        String tablePartitionName;
        Set indexPartitionNames = this.getIndexPartitionNames();
        String string = tablePartitionName = isGlobalPartition ? "" : this.m_tablePartitionModel.getPartitions()[this.m_selectedTablePartitionIdx].getName();
        if (!isGlobalPartition && !ModelUtil.hasLength((String)tablePartitionName)) {
            return "";
        }
        int suffix = 1;
        String indexPartitionName = this.makelIndexPartitionName(tablePartitionName, suffix);
        while (indexPartitionNames.contains(indexPartitionName)) {
            indexPartitionName = this.makelIndexPartitionName(tablePartitionName, ++suffix);
        }
        return indexPartitionName;
    }

    private String makelIndexPartitionName(String tablePartitionName, int suffix) {
        String indexPartitionName = ModelUtil.hasLength((String)tablePartitionName) ? tablePartitionName : UIArb.getString(600) + suffix;
        while (indexPartitionName.length() > 30) {
            String string = indexPartitionName = ModelUtil.hasLength((String)(tablePartitionName = tablePartitionName.substring(0, tablePartitionName.length() - 1))) ? tablePartitionName : UIArb.getString(600) + suffix;
        }
        return indexPartitionName;
    }

    private Set getIndexPartitionNames() {
        HashSet<String> indexPartitionNames = new HashSet<String>();
        for (IndexPartition indexPartition : this.m_sessionPartitions) {
            String name = indexPartition.getName();
            if (!ModelUtil.hasLength((String)name)) continue;
            indexPartitionNames.add(name);
        }
        return indexPartitionNames;
    }

    private void validateNameIsUnique(String name) throws ValidationException {
        Set names = this.getIndexPartitionNames();
        if (names.contains(name)) {
            throw new ValidationException((DBObject)this.m_index, UIArb.getString(43));
        }
    }

    private boolean isOfflineProvider() {
        return this.m_provider instanceof Database ^ true;
    }

    private void $init$() {
        this.m_isFirstEntry = true;
        this.m_isEditable = false;
        this.m_isCompressed = false;
        this.m_globalIndexPartitionModel = this.createIndexPartitionModel();
        this.m_localIndexPartitionModel = this.createIndexPartitionModel();
        this.m_sessionPartitions = new HashSet<IndexPartition>();
        this.m_btnStorage = new JButton();
        this.m_btnSubpartitions = new JButton();
        this.m_btnTablespaces = new JButton();
        this.m_lblDescription = new JLabel();
        this.m_cbxCompress = new JCheckBox();
        this.m_pnlRegularIndexHeader = new JPanel();
        this.m_lblPartitioning = new JLabel();
        this.m_rdbGlobal = new JRadioButton();
        this.m_rdbLocal = new JRadioButton();
        this.m_rdbNone = new JRadioButton();
        this.m_lblTablespace = new JLabel();
        this.m_cmbTablespace = new JComboBox();
        this.m_partitionStoragePropertiesMap = new HashMap<IndexPartition, OracleStorageProperties>();
        this.m_pnlPartitionDefinition = new JPanel();
        this.m_pnlTablePartitions = new JPanel();
        this.m_lblTablePartitions = new JLabel();
        this.m_mdlTablePartitions = new DefaultListModel();
        this.m_lstTablePartitions = new JList(this.m_mdlTablePartitions);
        this.m_mdlTablePartitionsSelectionListener = new 3();
        this.m_pnlIndividualAndTablespaces = new JPanel();
        this.m_rdbIndividual = new JRadioButton();
        this.m_rdbTablespaces = new JRadioButton();
        this.m_pnlGlobalIndexPartitions = new JPanel();
        this.m_mdlGlobalIndexPartitions = new DefaultListModel();
        this.m_lstGlobalIndexPartitions = new JList(this.m_mdlGlobalIndexPartitions);
        this.m_lblGlobalIndexPartitions = new JLabel();
        this.m_btnsGlobalIndexPartitions = new ListButtons(this.m_lstGlobalIndexPartitions, this);
        this.m_lblName = new JLabel();
        this.m_txtName = new JTextField("");
        this.m_lblValuesLessThan = new JLabel();
        this.m_txtValuesLessThan = new JTextField("");
        this.m_pnlTablespacesShuttle = new JPanel();
        this.m_lblTablespacesShuttle = new JLabel();
        this.m_tblsFromModel = new DefaultListModel();
        this.m_tblsFromPick = new ListPicker(new JList(this.m_tblsFromModel));
        this.m_tblsToModel = new DefaultListModel();
        this.m_tblsToPick = new ReorderableListPicker(new JList(this.m_tblsToModel));
        this.m_tblsShuttle = new Shuttle();
        this.m_pnlGlobalPartitionBy = new JPanel();
        this.m_lblGlobalPartitionColumns = new JLabel();
        this.m_mdlGlobalPartitionColumns = new NonNullableComboBoxModel();
        this.m_cmbGlobalPartitionColumns = new JComboBox(this.m_mdlGlobalPartitionColumns);
        this.m_lblGlobalPartitionBy = new JLabel();
        this.m_cmbGlobalPartitionBy = new JComboBox();
        this.m_pnlGlobalIndividualAndQuantity = new JPanel();
        this.m_rdbGlobalIndividual = new JRadioButton();
        this.m_rdbGlobalQuantity = new JRadioButton();
        this.m_hashCountLabel = new JLabel();
        this.m_hashCountModel = new SpinnerNumberModel(new Integer(2), new Integer(1), null, new Integer(1));
        this.m_hashCountSpinner = new JSpinner(this.m_hashCountModel);
        this.m_pnlDomainIndexHeader = new JPanel();
        this.m_lblDomainPartitioning = new JLabel();
        this.m_rdbDomainLocal = new JRadioButton();
        this.m_rdbDomainNone = new JRadioButton();
        this.m_lblIndextypeParameters = new JLabel();
        this.m_txtIndextypeParameters = new JTextArea();
    }

    static void mav$saveLocalPartition(IndexPartitionsPanel indexPartitionsPanel) {
        indexPartitionsPanel.saveLocalPartition();
    }

    static JTextField ra$m_txtName(IndexPartitionsPanel indexPartitionsPanel) {
        return indexPartitionsPanel.m_txtName;
    }

    static void mav$saveTablespaces(IndexPartitionsPanel indexPartitionsPanel) {
        indexPartitionsPanel.saveTablespaces();
    }

    static void mav$saveSubpartitionModel(IndexPartitionsPanel indexPartitionsPanel, OracleIndexPartitions oracleIndexPartitions) {
        indexPartitionsPanel.saveSubpartitionModel(oracleIndexPartitions);
    }

    static OracleIndexPartitions ra$m_indexPartitionModel(IndexPartitionsPanel indexPartitionsPanel) {
        return indexPartitionsPanel.m_indexPartitionModel;
    }

    final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ IndexPartitionsPanel v$subpartitionsPanel;
        private final /* synthetic */ IndexPartition v$currentIndexPartition;
        final /* synthetic */ IndexPartitionsPanel this$0;

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                try {
                    this.v$subpartitionsPanel.commit();
                    IndexPartitionsPanel.mav$saveSubpartitionModel(this.this$0, this.v$currentIndexPartition.getSubpartitions());
                    this.v$currentIndexPartition.setSubpartitions(IndexPartitionsPanel.ra$m_indexPartitionModel(this.v$subpartitionsPanel));
                }
                catch (TraversalException x) {
                    MessageDialog.error((Component)((Object)this.this$0), (Object)x.getMessage(), null, null);
                    throw new PropertyVetoException(x.getMessage(), evt);
                }
            }
        }

        public 1(IndexPartitionsPanel indexPartitionsPanel, IndexPartitionsPanel indexPartitionsPanel2, IndexPartition indexPartition) {
            this.v$currentIndexPartition = indexPartition;
            this.v$subpartitionsPanel = indexPartitionsPanel2;
            this.this$0 = indexPartitionsPanel;
        }
    }

    final class 2
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                IndexPartitionsPanel.mav$saveTablespaces(IndexPartitionsPanel.this);
            }
        }
    }

    final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent lse) {
            try {
                IndexPartitionsPanel.mav$saveLocalPartition(IndexPartitionsPanel.this);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
            IndexPartitionsPanel.ra$m_txtName(IndexPartitionsPanel.this).requestFocusInWindow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PanelType
    extends Enum<PanelType> {
        private static final /* synthetic */ PanelType[] $v;
        public static final /* enum */ PanelType NONE;
        public static final /* enum */ PanelType DOMAIN;
        public static final /* enum */ PanelType GLOBAL_RANGE;
        public static final /* enum */ PanelType GLOBAL_HASH_INDIVIDUAL;
        public static final /* enum */ PanelType GLOBAL_HASH_QUANTITY;
        public static final /* enum */ PanelType LOCAL_OTHER;
        public static final /* enum */ PanelType LOCAL_HASH_INDIVIDUAL;
        public static final /* enum */ PanelType LOCAL_HASH_TABLESPACES;
        public static final /* enum */ PanelType LOCAL_COMPOSITE;
        public static final /* enum */ PanelType SUBPARTITION_INDIVIDUAL;
        public static final /* enum */ PanelType SUBPARTITION_TABLESPACES;

        public static PanelType valueOf(String string) {
            return Enum.valueOf(PanelType.class, string);
        }

        public static final PanelType[] values() {
            return (PanelType[])$v.clone();
        }

        static {
            PanelType[] panelTypeArray = new PanelType[11];
            panelTypeArray[10] = SUBPARTITION_TABLESPACES = new PanelType("SUBPARTITION_TABLESPACES", 10);
            panelTypeArray[9] = SUBPARTITION_INDIVIDUAL = new PanelType("SUBPARTITION_INDIVIDUAL", 9);
            panelTypeArray[8] = LOCAL_COMPOSITE = new PanelType("LOCAL_COMPOSITE", 8);
            panelTypeArray[7] = LOCAL_HASH_TABLESPACES = new PanelType("LOCAL_HASH_TABLESPACES", 7);
            panelTypeArray[6] = LOCAL_HASH_INDIVIDUAL = new PanelType("LOCAL_HASH_INDIVIDUAL", 6);
            panelTypeArray[5] = LOCAL_OTHER = new PanelType("LOCAL_OTHER", 5);
            panelTypeArray[4] = GLOBAL_HASH_QUANTITY = new PanelType("GLOBAL_HASH_QUANTITY", 4);
            panelTypeArray[3] = GLOBAL_HASH_INDIVIDUAL = new PanelType("GLOBAL_HASH_INDIVIDUAL", 3);
            panelTypeArray[2] = GLOBAL_RANGE = new PanelType("GLOBAL_RANGE", 2);
            panelTypeArray[1] = DOMAIN = new PanelType("DOMAIN", 1);
            panelTypeArray[0] = NONE = new PanelType("NONE", 0);
            $v = panelTypeArray;
        }

        private PanelType(String string2, int n2) {
        }
    }
}

