/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.OracleStorageProperties;

public class IndexPropertiesPanel
extends BaseInfoPanel
implements ActionListener {
    private static final int NOPARALLEL = 1;
    private static final int PARALLEL_DEFAULT = 0;
    private DBObjectProvider m_provider;
    private Index m_index;
    private IndexInfoVerifier m_verifier;
    private JCheckBox m_parallelCheckBox;
    private JLabel m_lblParallelDegree;
    private NumberField m_txtParallelDegree;
    private JCheckBox m_keyCompressCheckBox;
    private NumberField m_keyCompressField;
    private JButton m_storageButton;
    private StorageInfoVerifier m_siVerifier;
    private String[] m_tablespaces;
    private DBUIResourceHelper m_resHelper;

    private void $init$() {
        this.m_parallelCheckBox = new JCheckBox();
        this.m_lblParallelDegree = new JLabel();
        this.m_txtParallelDegree = new NumberField();
        this.m_keyCompressCheckBox = new JCheckBox();
        this.m_keyCompressField = new NumberField();
        this.m_storageButton = new JButton();
        this.m_resHelper = new DBUIResourceHelper("IndexPropertiesPanel");
    }

    public IndexPropertiesPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_provider = (DBObjectProvider)dataContext.get("DBObjectProvider");
        this.m_index = (Index)dataContext.find("NewObject");
        this.m_verifier = (IndexInfoVerifier)dataContext.find("IndexVerifier");
        this.m_siVerifier = (StorageInfoVerifier)dataContext.find("StorageInfoVerifier");
        this.m_tablespaces = this.getTablespaces(dataContext, this.m_provider);
        this.init();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.m_keyCompressCheckBox) {
            this.m_keyCompressField.setEnabled(this.m_keyCompressCheckBox.isSelected());
        } else if (src == this.m_parallelCheckBox) {
            this.m_txtParallelDegree.setEnabled(this.m_parallelCheckBox.isSelected());
        } else if (src == this.m_storageButton) {
            OracleStorageProperties osp = (OracleStorageProperties)this.m_index.getProperty("OracleStorageProperties");
            if ((osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.INDEX, this.m_provider, (DBObject)this.m_index, null, this.m_siVerifier, this.m_tablespaces, (Component)((Object)this))) != null) {
                this.m_index.setProperty("OracleStorageProperties", (Object)osp);
            } else {
                this.m_index.getProperties().remove("OracleStorageProperties");
            }
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_resHelper.resButton(this.m_keyCompressCheckBox, UIArb.getString(592), "m_keyCompressCheckBox");
        this.m_resHelper.resButton(this.m_parallelCheckBox, UIArb.getString(489), "m_parallelCheckBox");
        this.m_resHelper.resButton(this.m_storageButton, UIArb.getString(843), "m_storageButton");
        this.m_keyCompressCheckBox.addActionListener(this);
        this.m_parallelCheckBox.addActionListener(this);
        this.m_storageButton.addActionListener(this);
        this.add(this.m_keyCompressCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_keyCompressField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_parallelCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_txtParallelDegree), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_storageButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 13, 0, new Insets(20, 5, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void init() {
        super.init(this.m_provider, this.m_verifier);
        this.populateParallel(this.m_index != null ? this.m_index.getParallelDegree() : 1);
        if (this.m_index.getKeyCompression() == null) {
            this.m_keyCompressCheckBox.setSelected(false);
            this.m_keyCompressField.setEnabled(false);
            this.m_keyCompressField.setNumber(null);
        } else {
            this.m_keyCompressCheckBox.setSelected(true);
            this.m_keyCompressField.setEnabled(true);
            this.m_keyCompressField.setNumber(this.m_index.getKeyCompression());
        }
        this.enableControls();
    }

    private void commit() throws TraversalException {
        if (!this.m_parallelCheckBox.isSelected()) {
            this.m_index.setParallelDegree(1);
        } else {
            Number degree = this.m_txtParallelDegree.getNumber();
            if (degree != null) {
                this.m_index.setParallelDegree(degree.intValue());
            } else {
                this.m_index.setParallelDegree(0);
            }
        }
        if (!this.m_keyCompressCheckBox.isSelected()) {
            this.m_index.setKeyCompression(null);
        } else {
            Number n = this.m_keyCompressField.getNumber();
            Integer kc = n == null ? 0 : Integer.valueOf(n.intValue());
            this.m_index.setKeyCompression(kc);
        }
        if (this.m_verifier != null) {
            this.m_verifier.verifyIndex(null, this.m_index);
        }
    }

    private void enableControls() {
        this.m_parallelCheckBox.setEnabled(this.m_verifier.canEditParallel(this.m_index));
        this.m_txtParallelDegree.setEnabled(this.m_verifier.canEditParallel(this.m_index));
        this.m_keyCompressCheckBox.setEnabled(this.m_verifier.canEditParallel(this.m_index));
        this.m_keyCompressField.setEnabled(this.m_verifier.canEditParallel(this.m_index));
        this.m_storageButton.setEnabled(this.m_verifier.canEditParallel(this.m_index));
    }

    private void populateParallel(int parallel) {
        if (parallel == 1) {
            this.m_parallelCheckBox.setSelected(false);
            this.m_lblParallelDegree.setEnabled(false);
            this.m_txtParallelDegree.setEnabled(false);
        } else {
            this.m_parallelCheckBox.setSelected(true);
            this.m_lblParallelDegree.setEnabled(true);
            this.m_txtParallelDegree.setEnabled(true);
            if (parallel > 0) {
                this.m_txtParallelDegree.setText(String.valueOf(parallel));
            }
        }
    }

    private static class NumberField
    extends NumberTextField {
        public NumberField() {
            this.setDataType(Integer.class);
            this.setSigned(false);
        }

        protected String convertNumberToString(Number n) {
            return n.toString();
        }

        protected boolean validateNumber(Number n) {
            return n == null || n.intValue() > 0;
        }
    }
}

