/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageClausePanel;
import oracle.ide.db.verifiers.table.LobParamsVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LobDescriptorPanel
extends BaseInfoPanel
implements ActionListener {
    private StorageClausePanel _pnlSubLobStorage;
    private JPanel _mainPanel;
    private JComboBox _cmbColumns;
    private JCheckBox _cbxStoreAsLob;
    private JComboBox _cmbCache;
    private JTextField _txtSegName;
    private NumberTextField _txtChunk;
    private NumberTextField _txtPctVersion;
    private NumberTextField _txtFreePools;
    private JCheckBox _cbxStoreInRow;
    private JCheckBox _cbxRetention;
    private JComboBox _cmbLogging;
    private JComboBox _cmbTablespace;
    private JLabel _lblColumns;
    private JLabel _lblCache;
    private JLabel _lblSegName;
    private JLabel _lblChunk;
    private JLabel _lblPctVersion;
    private JLabel _lblFreePools;
    private JLabel _lblLogging;
    private JLabel _lblTablespace;
    private Table _table;
    private Column _column;
    private LOBDescriptor _lobDescriptor;
    private DBObjectProvider _prov;
    private LobParamsVerifier _lpVerifier;
    private StorageInfoVerifier _siVerifier;
    private String lastColSelection;
    private static final String DEFAULT = "<DEFAULT>";
    public static final String[] LOGGING_OPTIONS = new String[]{"<DEFAULT>", "ON", "OFF"};
    private NonNullableComboBoxModel mdlLogging;
    private NonNullableComboBoxModel mdlTablespace;
    private Map<String, StoreAsLobInfo> _colLobDescMap;

    private void $init$() {
        this._pnlSubLobStorage = new StorageClausePanel();
        this._mainPanel = new JPanel();
        this._cmbColumns = new JComboBox();
        this._cbxStoreAsLob = new JCheckBox();
        this._cmbCache = new JComboBox();
        this._txtSegName = new JTextField();
        this._txtChunk = new NumberTextField();
        this._txtPctVersion = new NumberTextField();
        this._txtFreePools = new NumberTextField();
        this._cbxStoreInRow = new JCheckBox();
        this._cbxRetention = new JCheckBox();
        this._cmbLogging = new JComboBox();
        this._cmbTablespace = new JComboBox();
        this._lblColumns = new JLabel();
        this._lblCache = new JLabel();
        this._lblSegName = new JLabel();
        this._lblChunk = new JLabel();
        this._lblPctVersion = new JLabel();
        this._lblFreePools = new JLabel();
        this._lblLogging = new JLabel();
        this._lblTablespace = new JLabel();
        this._table = null;
        this._column = null;
        this._lobDescriptor = null;
        this._prov = null;
        this._lpVerifier = null;
        this._siVerifier = null;
        this.lastColSelection = null;
        this.mdlLogging = new NonNullableComboBoxModel((Object[])LOGGING_OPTIONS);
        this._colLobDescMap = new HashMap<String, StoreAsLobInfo>();
    }

    public LobDescriptorPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected LobDescriptorPanel(Map columnLobMap) {
        this();
        if (columnLobMap != null) {
            this._colLobDescMap = columnLobMap;
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this._mainPanel.setLayout(new GridBagLayout());
        this._mainPanel.setName("PNL_MAIN");
        this._cmbColumns.setName("CMB_COLUMNS");
        this._cmbCache.setName("CMB_CACHE");
        this._cbxStoreAsLob.setName("CBX_STORE_AS_LOB");
        this._cbxStoreInRow.setName("CBX_STORE_IN_ROW");
        this._cbxRetention.setName("CBX_RETENTION");
        this._txtSegName.setName("TXT_SEGNAME");
        this._txtChunk.setName("TXT_CHUNK");
        this._txtPctVersion.setName("TXT_PCTVERSION");
        this._txtFreePools.setName("TXT_FREEPOOLS");
        this._cmbTablespace.setName("CMB_TABLESPACE");
        this._cmbLogging.setName("CMB_LOGGING");
        ResourceUtils.resLabel((JLabel)this._lblTablespace, (Component)this._cmbTablespace, (String)UIArb.getString(668));
        ResourceUtils.resLabel((JLabel)this._lblColumns, (Component)this._cmbColumns, (String)UIArb.getString(855));
        ResourceUtils.resButton((AbstractButton)this._cbxStoreAsLob, (String)UIArb.getString(870));
        ResourceUtils.resLabel((JLabel)this._lblSegName, (Component)this._txtSegName, (String)UIArb.getString(174));
        ResourceUtils.resButton((AbstractButton)this._cbxStoreInRow, (String)UIArb.getString(651));
        ResourceUtils.resLabel((JLabel)this._lblChunk, (Component)this._txtChunk, (String)UIArb.getString(121));
        ResourceUtils.resLabel((JLabel)this._lblPctVersion, (Component)this._txtPctVersion, (String)UIArb.getString(288));
        ResourceUtils.resLabel((JLabel)this._lblFreePools, (Component)this._txtFreePools, (String)UIArb.getString(386));
        ResourceUtils.resButton((AbstractButton)this._cbxRetention, (String)UIArb.getString(791));
        ResourceUtils.resLabel((JLabel)this._lblCache, (Component)this._cmbCache, (String)UIArb.getString(353));
        ResourceUtils.resLabel((JLabel)this._lblLogging, (Component)this._cmbLogging, (String)UIArb.getString(367));
        this.add(this._lblColumns, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 10, 0), 0, 0));
        this.add(this._cmbColumns, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 10, 0), 0, 0));
        JComboCardPanel cardPanel = new JComboCardPanel(new JLabel(), (JComponent)this._cbxStoreAsLob);
        cardPanel.showSubPanel((JComponent)this._mainPanel);
        this.add((Component)cardPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._lblSegName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._txtSegName, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._lblTablespace, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._cmbTablespace, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._cbxStoreInRow, new GridBagConstraints(3, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._lblChunk, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._txtChunk, new GridBagConstraints(6, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this._mainPanel.add((Component)this._lblCache, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._cmbCache, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._cbxRetention, new GridBagConstraints(3, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._lblPctVersion, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._txtPctVersion, new GridBagConstraints(6, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this._mainPanel.add((Component)this._lblLogging, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._cmbLogging, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._lblFreePools, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._txtFreePools, new GridBagConstraints(6, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this._pnlSubLobStorage.setComponentNames("PNL_SUB_LOB_STORAGE");
        this._mainPanel.add((Component)((Object)this._pnlSubLobStorage), new GridBagConstraints(1, 5, 6, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 10, 5), 0, 0));
        this._cmbCache.addItem(DEFAULT);
        this._cmbCache.addItem("NOCACHE");
        this._cmbCache.addItem("CACHE");
        this._cmbCache.addItem("CACHE READS");
        this._cmbColumns.addActionListener(this);
        this._cbxStoreAsLob.addActionListener(this);
        this._cmbCache.addActionListener(this);
        this._cmbLogging.setModel(this.mdlLogging);
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        Table table = (Table)dataContext.find("NewObject");
        LobParamsVerifier lpVerifier = (LobParamsVerifier)dataContext.find("LobParamsVerifier");
        StorageInfoVerifier siVerifier = (StorageInfoVerifier)dataContext.find("StorageInfoVerifier");
        String[] tablespaces = this.getTablespaces(dataContext, prov);
        ArrayList<LOBDescriptor> lobDescriptorList = new ArrayList<LOBDescriptor>();
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            Column column = columnArray[n];
            DBObjectID colID = column.getID();
            OracleColumnProperties ocp = (OracleColumnProperties)column.getProperty("OracleColumnProperties");
            if (ocp != null) {
                LOBDescriptor ld = null;
                if (LOBDescriptor.isLOBColumn((DBObjectID)colID)) {
                    ld = ocp.getLOBProperties();
                } else if (LOBDescriptor.isVARRAYColumn((DBObjectID)colID)) {
                    ld = ocp.getVAProperties();
                }
                if (ld != null) {
                    ld.addColumn(colID);
                    lobDescriptorList.add(ld);
                }
            }
            ++n;
        }
        this.init(prov, table, lobDescriptorList, tablespaces, lpVerifier, siVerifier);
    }

    protected void init(DBObjectProvider prov, Table table, List<LOBDescriptor> lobDescriptorList, String[] tablespaces, LobParamsVerifier lpVerifier, StorageInfoVerifier siVerifier) {
        super.init(prov, lpVerifier);
        this._prov = prov;
        this._table = table;
        this._lpVerifier = lpVerifier;
        this._siVerifier = siVerifier;
        for (String colName : this._colLobDescMap.keySet()) {
            Column column = table.getColumn(colName);
            if (column != null && (LOBDescriptor.isLOBColumn((DBObjectID)column.getID()) || LOBDescriptor.isVARRAYColumn((DBObjectID)column.getID()))) continue;
            this._colLobDescMap.remove(colName);
        }
        ArrayList<String> lobCols = new ArrayList<String>();
        int i = 0;
        while (i < table.getColumns().length) {
            Column col = table.getColumns()[i];
            if (LOBDescriptor.isLOBColumn((DBObjectID)col.getID())) {
                lobCols.add(col.getName());
                this.initLOBDescriptor(col, false, lobDescriptorList);
            } else if (LOBDescriptor.isVARRAYColumn((DBObjectID)col.getID())) {
                lobCols.add(col.getName());
                this.initLOBDescriptor(col, true, lobDescriptorList);
            }
            ++i;
        }
        this._cmbColumns.setModel(new DefaultComboBoxModel<Object>(lobCols.toArray()));
        if (this.mdlTablespace == null) {
            int len = tablespaces != null ? tablespaces.length : 0;
            Object[] tmp = new String[len + 1];
            tmp[0] = DEFAULT;
            int i2 = 0;
            while (i2 < len) {
                tmp[i2 + 1] = this.getExternalName(tablespaces[i2]);
                ++i2;
            }
            this.mdlTablespace = new NonNullableComboBoxModel(tmp);
            this._cmbTablespace.setModel(this.mdlTablespace);
        }
        if (lobCols.size() == 0) {
            this.enableAllComponents(false, true);
            return;
        }
        this.enableAllComponents(true, true);
        if (this.lastColSelection != null && lobCols.contains(this.lastColSelection)) {
            this._cmbColumns.setSelectedItem(this.lastColSelection);
        }
        this._cmbColumns.setEnabled(true);
        this._cbxStoreAsLob.setEnabled(true);
        this.setupPanelForColumn();
    }

    private void initLOBDescriptor(Column col, boolean isVarray, List<LOBDescriptor> LOBDescriptorList) {
        OracleStorageProperties sp;
        LOBDescriptor ld = null;
        DBObjectID colID = col.getID();
        boolean newCol = false;
        if (colID instanceof TemporaryObjectID) {
            try {
                newCol = ((TemporaryObjectID)colID).resolveOriginalID() == null;
            }
            catch (DBException e) {
                newCol = true;
            }
        }
        for (LOBDescriptor l : LOBDescriptorList) {
            DBObjectID[] colIDlist = l.getColumns();
            int i = 0;
            while (i < colIDlist.length) {
                if (colID.equals(colIDlist[i], false)) {
                    ld = l;
                    this._colLobDescMap.put(col.getName(), new StoreAsLobInfo(ld, isVarray, true, newCol, null));
                    break;
                }
                ++i;
            }
            if (ld != null) break;
        }
        if (ld == null) {
            StoreAsLobInfo lobInfo = this._colLobDescMap.get(col.getName());
            if (lobInfo != null) {
                ld = StoreAsLobInfo.mav$getLobDescriptor(lobInfo);
            } else {
                ld = new LOBDescriptor();
                DBObjectID[] colref = new DBObjectID[]{col.getID()};
                ld.setColumns(colref);
                this._colLobDescMap.put(col.getName(), new StoreAsLobInfo(ld, isVarray, false, newCol, null));
            }
        }
        if ((sp = ld.getStorage()) == null) {
            ld.setStorage(new OracleStorageProperties());
        }
    }

    private void setupPanelForColumn() {
        block4: {
            this._column = (Column)this._table.findOwnedObject("COLUMN", (String)this._cmbColumns.getSelectedItem());
            StoreAsLobInfo lobInfo = this._colLobDescMap.get(this._column.getName());
            this._lobDescriptor = StoreAsLobInfo.mav$getLobDescriptor(lobInfo);
            this._cbxStoreAsLob.setSelected(StoreAsLobInfo.mav$isStoreAsLob(lobInfo));
            this._cbxStoreAsLob.setEnabled(StoreAsLobInfo.mav$showStoreAsLobCbx(lobInfo));
            this._pnlSubLobStorage.init(this._prov, this._lobDescriptor.getStorage(), this._siVerifier);
            this._txtSegName.setText(this._prov.getExternalName(this._lobDescriptor.getLOBSegName()));
            if (this._cmbTablespace.isEditable()) {
                this._cmbTablespace.getEditor().setItem(this.getExternalName(this._lobDescriptor.getStorage().getTablespace()));
            } else {
                this._cmbTablespace.setSelectedItem(this.getExternalName(this._lobDescriptor.getStorage().getTablespace()));
            }
            this._txtChunk.setText(this.i2s(this._lobDescriptor.getChunk()));
            this._txtPctVersion.setText(this.i2s(this._lobDescriptor.getPctVersion()));
            this._txtFreePools.setText(this.i2s(this._lobDescriptor.getFreepools()));
            this._cbxStoreInRow.setSelected(this._lobDescriptor.isStorageEnabledInRow());
            this._cbxRetention.setSelected(this._lobDescriptor.isRetention());
            if (this._lobDescriptor.getCache() != null) {
                this._cmbCache.setSelectedItem(this._lobDescriptor.getCache());
            } else {
                this._cmbCache.setSelectedItem(DEFAULT);
            }
            this.enableMainComponents(this._cbxStoreAsLob.isSelected(), true);
            Boolean b = this._lobDescriptor.getStorage().getLogging();
            int logIdx = b == null ? 0 : (b != false ? 1 : 2);
            this._cmbLogging.setSelectedIndex(logIdx);
            if (!StoreAsLobInfo.mav$isVarray(lobInfo)) break block4;
            this._lobDescriptor.getStorage().setTablespace(null);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        Table table = (Table)dataContext.find("NewObject");
        this.commit();
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            Column column = columnArray[n];
            StoreAsLobInfo lobInfo = this._colLobDescMap.get(column.getName());
            if (lobInfo != null) {
                OracleColumnProperties ocp = (OracleColumnProperties)column.getProperty("OracleColumnProperties");
                if (StoreAsLobInfo.mav$isStoreAsLob(lobInfo)) {
                    LOBDescriptor ld = StoreAsLobInfo.mav$getLobDescriptor(lobInfo);
                    if (ld != null) {
                        if (ocp == null) {
                            ocp = new OracleColumnProperties();
                            column.setProperty("OracleColumnProperties", (Object)ocp);
                        } else {
                            ocp.setLOBProperties(null);
                            ocp.setVAProperties(null);
                        }
                        ld.setColumns(null);
                        if (LOBDescriptor.isLOBColumn((DBObjectID)column.getID())) {
                            ocp.setLOBProperties(ld);
                        } else if (LOBDescriptor.isVARRAYColumn((DBObjectID)column.getID())) {
                            ocp.setVAProperties(ld);
                        }
                    }
                } else if (ocp != null) {
                    ocp.setLOBProperties(null);
                    ocp.setVAProperties(null);
                }
                if (ocp != null && ocp.getProperties() == null && ocp.getLOBProperties() == null && ocp.getVAProperties() == null && ocp.getNestedTableProperties() == null) {
                    column.getProperties().remove("OracleColumnProperties");
                }
            }
            ++n;
        }
    }

    protected void commit() throws TraversalException {
        this.commitLOBDescriptor();
    }

    protected final Map commit(List<LOBDescriptor> lobDescriptorList) throws TraversalException {
        this.commit();
        if (lobDescriptorList != null) {
            lobDescriptorList.clear();
            for (StoreAsLobInfo lobInfo : this._colLobDescMap.values()) {
                if (!StoreAsLobInfo.mav$isStoreAsLob(lobInfo)) continue;
                lobDescriptorList.add(StoreAsLobInfo.mav$getLobDescriptor(lobInfo));
            }
        }
        return null;
    }

    private void commitLOBDescriptor() throws TraversalException {
        if (this._lobDescriptor != null) {
            if (this._lpVerifier != null) {
                this._lpVerifier.checkPctVersionAndRetention(this._txtPctVersion.getText(), this._cbxRetention.isSelected());
            }
            this._pnlSubLobStorage.commit(this._lobDescriptor.getStorage());
            this._lobDescriptor.setLOBSegName(this.s2s(this._prov.getInternalName(this._txtSegName.getText())));
            this._lobDescriptor.setChunk(this.s2i(this._txtChunk.getText()));
            this._lobDescriptor.setPctVersion(this.s2i(this._txtPctVersion.getText()));
            this._lobDescriptor.setFreepools(this.s2i(this._txtFreePools.getText()));
            this._lobDescriptor.setStorageEnabledInRow(this._cbxStoreInRow.isSelected());
            this._lobDescriptor.setRetention(this._cbxRetention.isSelected());
            String cache = (String)this._cmbCache.getSelectedItem();
            this._lobDescriptor.setCache(DEFAULT.equals(cache) ? null : cache);
            String tblspc = (String)this.mdlTablespace.getSelectedItem();
            if (!ModelUtil.hasLength((String)tblspc) || DEFAULT.equals(tblspc)) {
                tblspc = null;
            }
            if (ModelUtil.hasLength((String)tblspc)) {
                tblspc = this.getInternalName(tblspc);
            }
            this._lobDescriptor.getStorage().setTablespace(tblspc);
            Boolean logging = null;
            switch (this._cmbLogging.getSelectedIndex()) {
                case 1: {
                    logging = Boolean.TRUE;
                    break;
                }
                case 2: {
                    logging = Boolean.FALSE;
                    break;
                }
            }
            this._lobDescriptor.getStorage().setLogging(logging);
            try {
                this._prov.validateObject((DBObject)this._lobDescriptor);
            }
            catch (ValidationException e) {
                throw new TraversalException(e.getMessage());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this._cmbColumns) {
            try {
                this.commitLOBDescriptor();
            }
            catch (TraversalException e) {
                e.showMessageDialog((Component)((Object)this));
                this._cmbColumns.setSelectedItem(this.lastColSelection);
                return;
            }
            this.lastColSelection = (String)this._cmbColumns.getSelectedItem();
            this.setupPanelForColumn();
        } else if (source == this._cbxStoreAsLob) {
            boolean storeAsLob = this._cbxStoreAsLob.isSelected();
            StoreAsLobInfo lobInfo = this._colLobDescMap.get(this._column.getName());
            StoreAsLobInfo.mav$setStoreAsLob(lobInfo, storeAsLob);
            this.enableMainComponents(storeAsLob, true);
            if (StoreAsLobInfo.mav$isVarray(lobInfo)) {
                this._lobDescriptor.getStorage().setTablespace(null);
            }
        } else if (source == this._cmbCache) {
            this.setupLogging();
        }
    }

    protected void enableAllComponents(boolean boo, boolean incLabels) {
        this._cmbColumns.setEnabled(boo);
        this._cbxStoreAsLob.setEnabled(boo);
        if (boo || incLabels) {
            this._lblColumns.setEnabled(boo);
        }
        this.enableMainComponents(boo, incLabels);
    }

    private void enableMainComponents(boolean boo, boolean incLabels) {
        if (boo && this._lpVerifier != null) {
            this._cmbCache.setEnabled(this._lpVerifier.canChangeCache());
            this._txtSegName.setEnabled(this._lpVerifier.canChangeSegName());
            this._txtChunk.setEnabled(this._lpVerifier.canChangeChunk());
            this._txtPctVersion.setEnabled(this._lpVerifier.canChangePctVersion());
            this._txtFreePools.setEnabled(this._lpVerifier.canChangeFreepools());
            this._cbxStoreInRow.setEnabled(this._lpVerifier.canChangeStoreInRow());
            this._cbxRetention.setEnabled(this._lpVerifier.canChangeRetention());
            if (incLabels) {
                this._lblCache.setEnabled(this._lpVerifier.canChangeCache());
                this._lblSegName.setEnabled(this._lpVerifier.canChangeSegName());
                this._lblChunk.setEnabled(this._lpVerifier.canChangeChunk());
                this._lblPctVersion.setEnabled(this._lpVerifier.canChangePctVersion());
                this._lblFreePools.setEnabled(this._lpVerifier.canChangeFreepools());
                this._lblTablespace.setEnabled(boo);
            }
        } else {
            this._cmbCache.setEnabled(boo);
            this._txtSegName.setEnabled(boo);
            this._txtChunk.setEnabled(boo);
            this._txtPctVersion.setEnabled(boo);
            this._txtFreePools.setEnabled(boo);
            this._cbxStoreInRow.setEnabled(boo);
            this._cbxRetention.setEnabled(boo);
            if (boo || incLabels) {
                this._lblCache.setEnabled(boo);
                this._lblSegName.setEnabled(boo);
                this._lblChunk.setEnabled(boo);
                this._lblPctVersion.setEnabled(boo);
                this._lblFreePools.setEnabled(boo);
                this._lblTablespace.setEnabled(boo);
                this._lblLogging.setEnabled(boo);
            }
        }
        this._cmbTablespace.setEnabled(boo);
        this._cmbTablespace.setEditable(this.getProvider() != null && !(this.getProvider() instanceof Database));
        if (boo && this._siVerifier != null && this._siVerifier.canChangeLogging() || boo && this._siVerifier == null) {
            this.setupLogging();
            if (incLabels) {
                this._lblLogging.setEnabled(true);
            }
        } else {
            this._cmbLogging.setEnabled(boo);
            if (boo || incLabels) {
                this._lblLogging.setEnabled(boo);
            }
        }
        this.enableStorageComponents(boo, incLabels);
    }

    private void enableStorageComponents(boolean boo, boolean incLabels) {
        if (boo && this._siVerifier != null) {
            this._pnlSubLobStorage.enableAllComponents(this._siVerifier, incLabels);
        } else {
            this._pnlSubLobStorage.enableAllComponents(boo, incLabels);
        }
    }

    private void setupLogging() {
        if (this._cmbCache.isEnabled()) {
            if (this._cmbCache.getSelectedItem().equals("NOCACHE") || this._cmbCache.getSelectedItem().equals("CACHE READS")) {
                this._lblLogging.setEnabled(true);
                this._cmbLogging.setEnabled(true);
            } else {
                this._lblLogging.setEnabled(false);
                this._cmbLogging.setEnabled(false);
                this._cmbLogging.setSelectedIndex(0);
            }
        }
    }

    private String i2s(Integer i) {
        return i == null ? "" : i.toString();
    }

    private Integer s2i(String s) {
        return s == null || s.equals("") ? null : Integer.valueOf(s);
    }

    private String s2s(String s) {
        return ModelUtil.hasLength((String)s) ? s : null;
    }

    static DBObjectProvider ra$_prov(LobDescriptorPanel lobDescriptorPanel) {
        return lobDescriptorPanel._prov;
    }

    private class StoreAsLobInfo {
        private LOBDescriptor _lobDesc;
        private boolean _Varray;
        private boolean _storeAsLob;
        private boolean _newColumn;

        private StoreAsLobInfo(LOBDescriptor lobDescriptor, boolean Varray, boolean storeAsLob, boolean newColumn) {
            this._lobDesc = lobDescriptor;
            this._Varray = Varray;
            this._storeAsLob = storeAsLob;
            this._newColumn = newColumn;
        }

        private LOBDescriptor getLobDescriptor() {
            return this._lobDesc;
        }

        private boolean isVarray() {
            return this._Varray;
        }

        private boolean isStoreAsLob() {
            return this._storeAsLob;
        }

        private boolean showStoreAsLobCbx() {
            return !this._Varray || this._Varray && (!(LobDescriptorPanel.ra$_prov(LobDescriptorPanel.this) instanceof OracleDatabase) || this._newColumn);
        }

        private void setLobDescriptor(LOBDescriptor lobDescriptor) {
            this._lobDesc = lobDescriptor;
        }

        private void setVarray(boolean Varray) {
            this._Varray = Varray;
        }

        private void setStoreAsLob(boolean storeAsLob) {
            this._storeAsLob = storeAsLob;
        }

        static void mav$setStoreAsLob(StoreAsLobInfo storeAsLobInfo, boolean bl) {
            storeAsLobInfo.setStoreAsLob(bl);
        }

        static boolean mav$isVarray(StoreAsLobInfo storeAsLobInfo) {
            return storeAsLobInfo.isVarray();
        }

        static boolean mav$isStoreAsLob(StoreAsLobInfo storeAsLobInfo) {
            return storeAsLobInfo.isStoreAsLob();
        }

        static LOBDescriptor mav$getLobDescriptor(StoreAsLobInfo storeAsLobInfo) {
            return storeAsLobInfo.getLobDescriptor();
        }

        static boolean mav$showStoreAsLobCbx(StoreAsLobInfo storeAsLobInfo) {
            return storeAsLobInfo.showStoreAsLobCbx();
        }

        StoreAsLobInfo(LOBDescriptor lOBDescriptor, boolean bl, boolean bl2, boolean bl3, 1 var6_6) {
            this(lOBDescriptor, bl, bl2, bl3);
        }

        public final class 1 {
        }
    }
}

