/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.IOTInfoPanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleStorageProperties;

public class OracleTablePropertiesPanel
extends BaseInfoPanel
implements ActionListener {
    private JCheckBox m_compressCheckBox;
    private JCheckBox m_parallelCheckBox;
    private NumberTextField m_parallelField;
    private JButton m_storageButton;
    private DBObjectProvider m_prov;
    private Table m_table;
    private StorageInfoVerifier m_siVerifier;
    private String[] m_tablespaces;
    private DBUIResourceHelper m_resHelper;
    private boolean m_iot;
    private IOTInfoPanel m_iotPanel;

    private void $init$() {
        this.m_compressCheckBox = new JCheckBox();
        this.m_parallelCheckBox = new JCheckBox();
        this.m_parallelField = new NumberTextField();
        this.m_storageButton = new JButton();
        this.m_resHelper = new DBUIResourceHelper("OracleTablePropertiesPanel");
        this.m_iot = false;
        this.m_iotPanel = new IOTInfoPanel();
    }

    public OracleTablePropertiesPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_resHelper.resButton(this.m_compressCheckBox, UIArb.getString(608), "m_compressCheckBox");
        this.m_resHelper.resButton(this.m_parallelCheckBox, UIArb.getString(502), "m_parallelCheckBox");
        this.m_resHelper.resButton(this.m_storageButton, UIArb.getString(843), "m_storageButton");
        this.m_parallelCheckBox.addActionListener(this);
        this.m_storageButton.addActionListener(this);
        this.add(this.m_compressCheckBox, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_parallelCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_parallelField, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_storageButton, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)((Object)this.m_iotPanel), new GridBagConstraints(1, 4, 3, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 5, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        Table table = (Table)dataContext.find("NewObject");
        StorageInfoVerifier verifier = (StorageInfoVerifier)dataContext.find("StorageInfoVerifier");
        String[] tablespaces = this.getTablespaces(dataContext, prov);
        boolean editable = (Boolean)dataContext.find("DBObjectIsEditable");
        this.init(prov, table, verifier, tablespaces, editable);
        if (Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType")) {
            this.m_iotPanel.setVisible(true);
            this.m_iotPanel.onEntry(dataContext);
        } else {
            this.m_iotPanel.setVisible(false);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        Table table = (Table)dataContext.find("NewObject");
        this.commit();
        if (this.m_iot) {
            this.m_iotPanel.onExit(dataContext);
        }
    }

    protected void init(DBObjectProvider prov, Table tab, StorageInfoVerifier verifier, String[] tablespaces, boolean editable) {
        super.init(prov, verifier);
        this.m_prov = prov;
        this.m_table = tab;
        this.m_siVerifier = verifier;
        this.m_tablespaces = tablespaces;
        boolean bl = this.m_iot = Table.TableType.INDEX_ORGANIZED == this.m_table.getProperty("TableType");
        if (this.m_iot) {
            this.m_compressCheckBox.setEnabled(false);
            this.m_compressCheckBox.setSelected(false);
        } else {
            this.m_compressCheckBox.setEnabled(true);
            this.m_compressCheckBox.setSelected(this.getTableCompress());
        }
        int iParallel = this.getTableParallel();
        boolean bParallel = iParallel != 1;
        String sParallel = iParallel < 2 ? "" : Integer.toString(iParallel);
        this.m_parallelCheckBox.setSelected(bParallel);
        this.m_parallelField.setEnabled(bParallel);
        this.m_parallelField.setText(sParallel);
        if (!editable) {
            this.m_compressCheckBox.setEnabled(false);
            this.m_parallelCheckBox.setEnabled(false);
            this.m_parallelField.setEnabled(false);
            this.m_storageButton.setEnabled(false);
        }
    }

    private void commit() throws TraversalException {
        if (this.m_compressCheckBox.isEnabled()) {
            this.setTableCompress(this.m_compressCheckBox.isSelected());
        }
        if (this.m_parallelCheckBox.isSelected()) {
            Number n = this.m_parallelField.getNumber();
            int par = n == null ? 0 : n.intValue();
            this.setTableParallel(par);
        } else {
            this.setTableParallel(1);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_parallelCheckBox) {
            if (this.m_parallelCheckBox.isSelected()) {
                this.m_parallelField.setEnabled(true);
            } else {
                this.m_parallelField.setText("");
                this.m_parallelField.setEnabled(false);
            }
        } else if (source == this.m_storageButton) {
            OracleStorageProperties osp = (OracleStorageProperties)this.m_table.getProperty("OracleStorageProperties");
            if ((osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.TABLE, this.m_prov, (DBObject)this.m_table, null, this.m_siVerifier, this.m_tablespaces, (Component)((Object)this))) != null) {
                this.m_table.setProperty("OracleStorageProperties", (Object)osp);
            } else {
                this.m_table.getProperties().remove("OracleStorageProperties");
            }
        }
    }

    private boolean getTableCompress() {
        Boolean compress = (Boolean)this.m_table.getProperty("compression");
        if (compress == null) {
            compress = Boolean.FALSE;
        }
        return compress;
    }

    private void setTableCompress(boolean compress) {
        if (compress) {
            this.m_table.setProperty("compression", (Object)Boolean.TRUE);
        } else {
            this.m_table.getProperties().remove("compression");
        }
    }

    private int getTableParallel() {
        Integer iParallel = (Integer)this.m_table.getProperty("parallel");
        if (iParallel == null) {
            iParallel = 1;
        }
        return iParallel;
    }

    private void setTableParallel(int parallel) {
        if (parallel < 2 && parallel != 0) {
            this.m_table.getProperties().remove("parallel");
        } else {
            this.m_table.setProperty("parallel", (Object)parallel);
        }
    }
}

