/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.ColumnDialog;
import oracle.ide.db.panels.table.PKConstraintPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.dialogs.MessageDialog;

public class PKDialog
extends JPanel
implements VetoableChangeListener,
ActionListener,
ShuttleListener {
    public static final String PK_HELP_ID = "f1_offdbpkconstraint_html";
    private JEWTDialog m_dialog;
    private JWrappedLabel m_desc;
    private PKConstraintPanel m_pkPanel;
    private JButton m_btnAddCol;
    private DBObjectProvider m_prov;
    private Table m_table;
    private Namespace m_namespace;

    public PKDialog(Namespace namespace) {
        this.m_namespace = namespace;
        this.m_prov = (DBObjectProvider)this.m_namespace.get("DBObjectProvider");
        this.m_table = (Table)this.m_namespace.get("NewObject");
        this.createComponents(this.m_namespace);
        this.layoutComponents();
    }

    private void createComponents(Namespace namespace) {
        Table tbl = (Table)namespace.get("NewObject");
        String name = tbl.getName();
        String text = UIArb.format(378, name);
        this.m_desc = new JWrappedLabel(text);
        this.m_pkPanel = new PKConstraintPanel();
        this.m_pkPanel.initialize(namespace);
        String buttonText = UIArb.getString(879);
        this.m_btnAddCol = new JButton(buttonText);
        this.m_btnAddCol.setSize(new Dimension(90, 25));
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_desc, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)((Object)this.m_pkPanel), new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_btnAddCol, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_btnAddCol.addActionListener(this);
        this.m_pkPanel.addShuttleListener(this);
    }

    private void setDialog(JEWTDialog dialog) {
        this.m_dialog = dialog;
        this.m_dialog.addVetoableChangeListener((VetoableChangeListener)this);
        this.checkOKButton();
    }

    private void checkOKButton() {
        this.m_dialog.setOKButtonEnabled(this.m_pkPanel.canCommit());
    }

    public static boolean createOrEditPK(DBObjectProvider prv, Table sourceTable, Component parent) throws DBException {
        String TITLE = UIArb.getString(633);
        if (sourceTable == null || prv == null) {
            throw new IllegalArgumentException("Null information supplied to Edit Primary Key dialog");
        }
        int bit = 7;
        JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)TITLE, (int)bit);
        Namespace namespace = new Namespace();
        namespace.put("DBObjectProvider", (Object)prv);
        namespace.put("NewObject", (Object)sourceTable);
        namespace.put("Modifiable", (Object)true);
        namespace.put("ConstraintsInfoVerifier", null);
        PKDialog panel = new PKDialog(namespace);
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        dialog.setPreferredSize(500, 400);
        panel.setDialog(dialog);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, PK_HELP_ID);
        if (dialog.runDialog()) {
            return true;
        }
        dialog.dispose();
        return false;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
            try {
                this.m_pkPanel.commit();
            }
            catch (TraversalException e) {
                MessageDialog.error((Component)this, (Object)e.getMessage(), (String)UIArb.getString(82), null);
                throw new PropertyVetoException("invalid primary key", evt);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_btnAddCol) {
            try {
                if (ColumnDialog.createColumn(this.m_prov, this.m_table, this)) {
                    this.m_pkPanel.initialize(this.m_namespace);
                }
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
            }
        }
    }

    public void shuttleItemsMoved(ShuttleEvent event) {
        this.checkOKButton();
    }

    public void shuttleItemsRemoved(ShuttleEvent event) {
        this.checkOKButton();
    }

    public void shuttleItemsReordered(ShuttleEvent event) {
    }
}

